typedef BOOL (*_AML_Initializate) (HWND _video_window);
typedef BOOL (*_AML_Destroy) (void);
typedef BOOL (*_AML_Refresh) (void);
typedef BOOL (*_AML_LoadMediaFile) (int *_index, const char *_file_name, const bool &_only_audio_stream);
typedef BOOL (*_AML_UploadMediaFile) (const int &_index);
typedef BOOL (*_AML_Play) (const int &_index);
typedef BOOL (*_AML_Pause) (const int &_index);
typedef BOOL (*_AML_Stop) (const int &_index);
typedef BOOL (*_AML_SetStartPosition) (const int &_index, const float &_start_position);
typedef BOOL (*_AML_SetStopPosition) (const int &_index, const float &_stop_position);
typedef BOOL (*_AML_SetCurrentPosition) (const int &_index, const float &_current_position);
typedef BOOL (*_AML_SetRate) (const int &_index, const float &_rate);
typedef BOOL (*_AML_SetLoop) (const int &_index, const BOOL &_is_looped);
typedef BOOL (*_AML_SetMute) (const int &_index, const BOOL &_is_muted);
typedef BOOL (*_AML_SetVolume) (const int &_index, const float &_volume);
typedef BOOL (*_AML_SetBalance) (const int &_index, const float &_balance);
typedef BOOL (*_AML_SetVideoFullscreen) (const int &_index, const BOOL &_is_fullscreen);
typedef BOOL (*_AML_GetState) (const int &_index, int *_state);
typedef BOOL (*_AML_GetDuration) (const int &_index, float *_duration);
typedef BOOL (*_AML_GetStartPosition) (const int &_index, float *_start_position);
typedef BOOL (*_AML_GetStopPosition) (const int &_index, float *_stop_position);
typedef BOOL (*_AML_GetCurrentPosition) (const int &_index, float *_current_position);
typedef BOOL (*_AML_GetRate) (const int &_index, float *_rate);
typedef BOOL (*_AML_GetLoop) (const int &_index, BOOL *_is_looped);
typedef BOOL (*_AML_GetMute) (const int &_index, BOOL *_is_muted);
typedef BOOL (*_AML_GetVolume) (const int &_index, float *_volume);
typedef BOOL (*_AML_GetBalance) (const int &_index, float *_balance);
typedef BOOL (*_AML_GetVideoFullscreen) (const int &_index, BOOL *_is_fullscreen);
typedef BOOL (*_AML_HasMediaFileAudioStream) (const int &_index, BOOL *_has_media_source_audio_stream);
typedef BOOL (*_AML_HasMediaFileVideoStream) (const int &_index, BOOL *_has_media_source_video_stream);

_AML_Initializate				AML_Initializate;
_AML_Destroy					AML_Destroy;
_AML_Refresh					AML_Refresh;
_AML_LoadMediaFile				AML_LoadMediaFile;
_AML_UploadMediaFile			AML_UploadMediaFile;
_AML_Play						AML_Play;
_AML_Pause						AML_Pause;
_AML_Stop						AML_Stop;
_AML_SetStartPosition			AML_SetStartPosition;
_AML_SetStopPosition			AML_SetStopPosition;
_AML_SetCurrentPosition			AML_SetCurrentPosition;
_AML_SetRate					AML_SetRate;
_AML_SetLoop					AML_SetLoop;
_AML_SetMute					AML_SetMute;
_AML_SetVolume					AML_SetVolume;
_AML_SetBalance					AML_SetBalance;
_AML_SetVideoFullscreen			AML_SetVideoFullscreen;
_AML_GetState					AML_GetState;
_AML_GetDuration				AML_GetDuration;
_AML_GetStartPosition			AML_GetStartPosition;
_AML_GetStopPosition			AML_GetStopPosition;
_AML_GetCurrentPosition			AML_GetCurrentPosition;
_AML_GetRate					AML_GetRate;
_AML_GetLoop					AML_GetLoop;
_AML_GetMute					AML_GetMute;
_AML_GetVolume					AML_GetVolume;
_AML_GetBalance					AML_GetBalance;
_AML_GetVideoFullscreen			AML_GetVideoFullscreen;
_AML_HasMediaFileAudioStream	AML_HasMediaFileAudioStream;
_AML_HasMediaFileVideoStream	AML_HasMediaFileVideoStream;

HMODULE aml_kernel;
aml_kernel = LoadLibrary("aml.dll");

if (!aml_kernel)
{
	// ERROR!!!
}

AML_Initializate 			= (_AML_Initializate)GetProcAddress(aml_kernel, "AML_Initializate");
AML_Destroy					= (_AML_Destroy)GetProcAddress(aml_kernel, "AML_Destroy");
AML_Refresh					= (_AML_Refresh)GetProcAddress(aml_kernel, "AML_Refresh");
AML_LoadMediaFile			= (_AML_LoadMediaFile)GetProcAddress(aml_kernel, "AML_LoadMediaFile");
AML_UploadMediaFile			= (_AML_UploadMediaFile)GetProcAddress(aml_kernel, "AML_UploadMediaFile");
AML_Play					= (_AML_Play)GetProcAddress(aml_kernel, "AML_Play");
AML_Pause					= (_AML_Pause)GetProcAddress(aml_kernel, "AML_Pause");
AML_Stop					= (_AML_Stop)GetProcAddress(aml_kernel, "AML_Stop");
AML_SetStartPosition		= (_AML_SetStartPosition)GetProcAddress(aml_kernel, "AML_SetStartPosition");
AML_SetStopPosition			= (_AML_SetStopPosition)GetProcAddress(aml_kernel, "AML_SetStopPosition");
AML_SetCurrentPosition		= (_AML_SetCurrentPosition)GetProcAddress(aml_kernel, "AML_SetCurrentPosition");
AML_SetRate					= (_AML_SetRate)GetProcAddress(aml_kernel, "AML_SetRate");
AML_SetLoop					= (_AML_SetLoop)GetProcAddress(aml_kernel, "AML_SetLoop");
AML_SetMute					= (_AML_SetMute)GetProcAddress(aml_kernel, "AML_SetMute");
AML_SetVolume				= (_AML_SetVolume)GetProcAddress(aml_kernel, "AML_SetVolume");
AML_SetBalance				= (_AML_SetBalance)GetProcAddress(aml_kernel, "AML_SetBalance");
AML_SetVideoFullscreen		= (_AML_SetVideoFullscreen)GetProcAddress(aml_kernel, "AML_SetVideoFullscreen");
AML_GetState				= (_AML_GetState)GetProcAddress(aml_kernel, "AML_GetState");
AML_GetDuration				= (_AML_GetDuration)GetProcAddress(aml_kernel, "AML_GetDuration");
AML_GetStartPosition		= (_AML_GetStartPosition)GetProcAddress(aml_kernel, "AML_GetStartPosition");
AML_GetStopPosition			= (_AML_GetStopPosition)GetProcAddress(aml_kernel, "AML_GetStopPosition");
AML_GetCurrentPosition		= (_AML_GetCurrentPosition)GetProcAddress(aml_kernel, "AML_GetCurrentPosition");
AML_GetRate					= (_AML_GetRate)GetProcAddress(aml_kernel, "AML_GetRate");
AML_GetLoop					= (_AML_GetLoop)GetProcAddress(aml_kernel, "AML_GetLoop");
AML_GetMute					= (_AML_GetMute)GetProcAddress(aml_kernel, "AML_GetMute");
AML_GetVolume				= (_AML_GetVolume)GetProcAddress(aml_kernel, "AML_GetVolume");
AML_GetBalance				= (_AML_GetBalance)GetProcAddress(aml_kernel, "AML_GetBalance");
AML_GetVideoFullscreen		= (_AML_GetVideoFullscreen)GetProcAddress(aml_kernel, "AML_GetVideoFullscreen");
AML_HasMediaFileAudioStream	= (_AML_HasMediaFileAudioStream)GetProcAddress(aml_kernel, "AML_HasMediaFileAudioStream");
AML_HasMediaFileVideoStream	= (_AML_HasMediaFileVideoStream)GetProcAddress(aml_kernel, "AML_HasMediaFileVideoStream");

if (!AML_Initializate		|| !AML_Destroy					|| !AML_Refresh				||
	!AML_LoadMediaFile		|| !AML_UploadMediaFile			|| !AML_Play				||
	!AML_Pause				|| !AML_Stop					|| !AML_SetStartPosition	||
	!AML_SetStopPosition	|| !AML_SetCurrentPosition		|| !AML_SetRate				||
	!AML_SetLoop			|| !AML_SetMute					|| !AML_SetVolume			||
	!AML_SetBalance			|| !AML_SetVideoFullscreen		|| !AML_GetState			||
	!AML_GetDuration		|| !AML_GetStartPosition		|| !AML_GetStopPosition		||
	!AML_GetCurrentPosition	|| !AML_GetRate					|| !AML_GetLoop				||
	!AML_GetMute			|| !AML_GetVolume				|| !AML_GetBalance			||
	!AML_GetVideoFullscreen	|| !AML_HasMediaFileAudioStream	|| !AML_HasMediaFileVideoStream)
{
	// Error!
}
