#!/usr/bin/perl -w

use CGI;

open LOG, ">> /var/tmp/recv.log" or die;

$workDir = '/usr/local/apache/htdocs/voicefiles/';
$sendmail = '/usr/local/sbin/sendmail -t';
$filename = '';
$line = '';
$contentlength = $ENV{'CONTENT_LENGTH'};

print LOG "Starting script.\n";
print LOG "Method: ".$ENV{'REQUEST_METHOD'}."\n";
print LOG "Content length: ".$contentlength."\n";

$line = <STDIN>;
$contentlength = $contentlength - length $line;

if(!defined($line)){
	respon('Invalid request');
}

if(!($line =~ /^POST.*/i)){
	respon('Unsupported method');
}

do {
	$line = <STDIN>;
	$contentlength = $contentlength - length $line;
	chomp($line);
	print LOG "Skipped: ".$line."\n";
} until($line =~ /^ACTION.*/);

$line = <STDIN>;
$contentlength = $contentlength - length $line;
check_line();
$action = $line;
chomp($action);

print LOG "Action: ".$action."\n";

if($action =~ /^CREATE.*/){
	get_filename();
	a_create();
} elsif($action =~ /^APPEND.*/){
	get_filename();
	a_append();
} elsif($action =~ /^DELETE.*/){
	get_filename();
	a_delete();
} elsif($action =~ /^SENDMAIL.*/){
	a_sendmail();
} else {
	respon("Unsupported action: ".$action);
}

sub a_create
{
	print LOG "Creating file: ".$filename."\n";
	open(DATAFILE, "> ".$workDir.$filename) or respon("Unable to create file: $!");
	write_file();
	close DATAFILE;
	respon('ACCEPTED');
}

sub a_append
{
	print LOG "Appending file: ".$filename."\n";
	open(DATAFILE, ">> ".$workDir.$filename) or respon("Unable to open file: $!");
	write_file();
	close DATAFILE;
	respon('ACCEPTED');
}

sub a_delete
{
	print LOG "Deleting file: ".$filename."\n";
	system("rm $workDir.$filename") or respon("Unable to delete file: $!");
}

sub a_sendmail
{
	open(DATAFILE, "| ".$sendmail) or respon("Unable to open file: $!");
	write_file();
	close DATAFILE;
	respon('ACCEPTED');
}

sub write_file
{
	$res = read(STDIN, $line, $contentlength);
	print LOG "Data size of read: ".$res."\n";
	if($res != $contentlength){
		respon('Read error');
	}
	syswrite(DATAFILE, $line, $res) or respon('Write error');
}

sub get_filename
{
	$line = <STDIN>;
	$contentlength = $contentlength - length $line;
	check_line();
	$filename = $line;
	chomp($filename);
}

sub check_line
{
	if(!defined($line)){
		print LOG $line;
		respon('Invalid request content');
	}
}
 
sub respon
{
	my ($resptext) = @_;
	my ($cgi) = new CGI;

	print $cgi->header();
	print $resptext;

	print LOG "Resptext: ".$resptext."\n";
	print LOG "DONE.\n";

	exit();
}

