/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.gui;

import com.objectplanet.gui.TabbedEvent;
import com.objectplanet.gui.TabbedListener;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TabbedPanel
extends Panel
implements WindowListener {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    private int orientation;
    private Hashtable components;
    private Vector tabs;
    private int[] tabPosition;
    private BitSet tabEnabled;
    private boolean detachable;
    private String title;
    private Font titleFont;
    private Color tabColor;
    private Hashtable tabColors;
    private Color tabLabelColor;
    private Hashtable tabLabelColors;
    private Font tabFont;
    private Vector listeners;
    private Image offscreen;
    private int tabOffset;
    private String currentTab;
    private boolean leftButtonPushed;
    private boolean rightButtonPushed;
    private Rectangle leftButtonBounds;
    private Rectangle rightButtonBounds;
    private Hashtable detachedFrames;
    private static final int BORDER = 5;
    private static final int TAB_SPACE = 12;
    private static final int TAB_V_SPACE = 9;
    private static final int ARROW_WIDTH = 10;
    private static final int ARROW_HEIGHT = 14;
    private static final int ARROW_SKIP = 20;

    public Insets getInsets() {
        FontMetrics fontMetrics = this.getFontMetrics(this.titleFont);
        FontMetrics fontMetrics2 = this.getFontMetrics(this.tabFont);
        int n = TabbedEvent.evaluation ? 10 : 0;
        Insets insets = new Insets(5, 5, 5, 5);
        int n2 = fontMetrics2.getHeight() + 4;
        switch (this.orientation) {
            default: {
                insets.top = this.title != null && this.title.trim().length() > 0 ? (insets.top += Math.max(n2, fontMetrics.getHeight())) : (insets.top += n2);
                insets.bottom += n;
                break;
            }
            case 1: {
                insets.bottom = this.title != null && this.title.trim().length() > 0 ? (insets.bottom += Math.max(n2, fontMetrics.getHeight())) : (insets.bottom += n2);
                insets.top += n;
                break;
            }
            case 2: {
                insets.left = this.title != null && this.title.length() > 0 ? (insets.left += Math.max(this.getWidestTabWidth() + 10, fontMetrics.stringWidth(this.title) + 7)) : (insets.left += this.getWidestTabWidth() + 10);
                insets.bottom += n;
                break;
            }
            case 3: {
                insets.right = this.title != null && this.title.length() > 0 ? (insets.right += Math.max(this.getWidestTabWidth() + 10, fontMetrics.stringWidth(this.title) + 7)) : (insets.right += this.getWidestTabWidth() + 10);
                insets.bottom += n;
                break;
            }
        }
        return insets;
    }

    public boolean isDetached(String string) {
        if (string != null) {
            return this.detachedFrames.containsKey(string);
        }
        return false;
    }

    public static void main(String[] stringArray) {
        TabbedPanel tabbedPanel = new TabbedPanel();
        tabbedPanel.add("Version", new TextArea("ObjectPlanet's TabbedPanel 1.01"));
        Frame frame = new Frame();
        frame.add("Center", tabbedPanel);
        ((Component)frame).setSize(300, 200);
        frame.show();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void setTabLabelColor(Color color) {
        this.tabLabelColor = color;
        this.repaint();
    }

    public Color getTabLabelColor() {
        return this.tabLabelColor;
    }

    public void setTabLabelColor(String string, Color color) {
        if (this.contains(string)) {
            if (color != null) {
                this.tabLabelColors.put(string, color);
            } else {
                this.tabLabelColors.remove(string);
            }
        }
        this.repaint();
    }

    public Color getTabLabelColor(String string) {
        if (string != null) {
            Color color = (Color)this.tabLabelColors.get(string);
            if (color != null) {
                return color;
            }
            return this.tabLabelColor;
        }
        return this.getTabLabelColor();
    }

    private void paintLeftTab(Graphics graphics, int n, int n2, String string) {
        String string2 = string != null ? string : "";
        Insets insets = this.getInsets();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getHeight() + 9 - 1;
        int n4 = n2 + 5 + 1;
        int n5 = insets.left - n2 - 5 - 6;
        boolean bl = this.currentTab.equals(string2);
        if (bl) {
            n5 -= 4;
            n -= 2;
            n4 += 5;
            n3 += 4;
        }
        Color color = this.getTabColor(string2);
        graphics.setColor(color);
        graphics.fillRect(n5 + 1, n, n4 - 1, n3);
        graphics.setColor(color.brighter());
        graphics.drawLine(n5 + 2, n, n5 + n4 - 1, n);
        graphics.drawLine(n5 + 2, n, n5, n + 2);
        graphics.drawLine(n5, n + 2, n5, n + n3 - 2);
        graphics.setColor(Color.black);
        graphics.drawLine(n5 + 1, n + n3 - 1, n5 + 2, n + n3);
        graphics.drawLine(n5 + 2, n + n3, n5 + n4 - 1, n + n3);
        graphics.setColor(color.darker());
        graphics.drawLine(n5 + 2, n + n3 - 1, n5 + n4 - 1, n + n3 - 1);
        int n6 = n5 + n4 / 2 - fontMetrics.stringWidth(string) / 2;
        int n7 = n + n3 / 2 + fontMetrics.getHeight() / 2 - fontMetrics.getDescent() + 1;
        Color color2 = this.getTabLabelColor(string2);
        if (this.isEnabled(string2)) {
            graphics.setColor(color2);
            graphics.drawString(string2, n6, n7);
        } else {
            graphics.setColor(color.brighter());
            graphics.drawString(string2, n6 + 1, n7 + 1);
            graphics.setColor(color.darker());
            graphics.drawString(string2, n6, n7);
        }
    }

    private void paintRightTab(Graphics graphics, int n, int n2, String string) {
        String string2 = string != null ? string : "";
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        int n3 = fontMetrics.getHeight() + 9 - 1;
        int n4 = n2 + 5 + 2;
        int n5 = dimension.width - insets.right + 5 - 1;
        boolean bl = this.currentTab.equals(string2);
        if (bl) {
            n5 -= 2;
            n -= 2;
            n4 += 5;
            n3 += 4;
        }
        Color color = this.getTabColor(string2);
        graphics.setColor(color);
        graphics.fillRect(n5 + 1, n, n4 - 1, n3);
        graphics.setColor(color.brighter());
        graphics.drawLine(n5 + 1, n, n5 + n4 - 2, n);
        graphics.setColor(Color.black);
        graphics.drawLine(n5 + n4 - 1, n + 1, n5 + n4, n + 2);
        graphics.drawLine(n5 + n4, n + 2, n5 + n4, n + n3 - 2);
        graphics.drawLine(n5 + n4, n + n3 - 2, n5 + n4 - 2, n + n3);
        graphics.drawLine(n5 + n4 - 2, n + n3, n5 + 1, n + n3);
        graphics.setColor(color.darker());
        graphics.drawLine(n5 + n4 - 1, n + 2, n5 + n4 - 1, n + n3 - 2);
        graphics.drawLine(n5 + n4 - 2, n + n3 - 1, n5 + 1, n + n3 - 1);
        int n6 = n5 + n4 / 2 - fontMetrics.stringWidth(string2) / 2;
        int n7 = n + n3 / 2 + fontMetrics.getHeight() / 2 - fontMetrics.getDescent() + 1;
        if (bl) {
            ++n6;
        }
        Color color2 = this.getTabLabelColor(string2);
        if (this.isEnabled(string2)) {
            graphics.setColor(color2);
            graphics.drawString(string2, n6, n7);
        } else {
            graphics.setColor(color.brighter());
            graphics.drawString(string2, n6 + 1, n7 + 1);
            graphics.setColor(color.darker());
            graphics.drawString(string2, n6, n7);
        }
    }

    private String getFirstEnabledTab() {
        int n = this.tabs.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.tabs.elementAt(n2);
            if (this.isEnabled(string)) {
                return string;
            }
            ++n2;
        }
        if (this.tabs.size() > 0) {
            return (String)this.tabs.elementAt(0);
        }
        this.currentTab = null;
        return null;
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (component == null) continue;
            if (component.getName().equals(this.currentTab)) {
                int n = dimension.width - insets.left - insets.right;
                int n2 = dimension.height - insets.top - insets.bottom;
                component.setLocation(insets.left, insets.top);
                component.setSize(n, n2);
                component.validate();
                continue;
            }
            component.setSize(0, 0);
        }
        this.repaint();
    }

    public Component remove(String string) {
        Component component;
        if (string == null) {
            return null;
        }
        if (this.isDetached(string)) {
            this.retach(string);
        }
        if ((component = (Component)this.components.remove(string)) != null) {
            super.remove(component);
            int n = this.tabs.indexOf(string);
            if (n >= 0) {
                this.tabs.removeElementAt(n);
                int n2 = this.tabEnabled.size();
                int n3 = n;
                while (n3 < n2 - 1) {
                    if (this.tabEnabled.get(n3 + 1)) {
                        this.tabEnabled.set(n3);
                    } else {
                        this.tabEnabled.clear(n3);
                    }
                    ++n3;
                }
                this.tabEnabled.clear(n2 - 1);
            }
            this.notifyListeners(new TabbedEvent(5, this, string, component));
            if (this.currentTab.equals(string)) {
                this.show(this.getFirstEnabledTab());
            }
        }
        this.repaint();
        return component;
    }

    public void retach(String string) {
        if (string == null) {
            return;
        }
        Frame frame = (Frame)this.detachedFrames.get(string);
        if (frame == null) {
            return;
        }
        Component component = null;
        try {
            component = frame.getComponent(0);
            if (component == null) {
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        ((Component)frame).setVisible(false);
        frame.dispose();
        this.detachedFrames.remove(string);
        super.add(string, component);
        this.components.put(string, component);
        this.setEnabled(string, true);
        this.notifyListeners(new TabbedEvent(3, this, string, component));
        this.show(string);
    }

    public boolean isEnabled(String string) {
        int n = this.tabs.indexOf(string);
        if (n >= 0) {
            return this.tabEnabled.get(n);
        }
        return false;
    }

    public boolean isShowing(String string) {
        return string != null && string.equals(this.currentTab);
    }

    public void setTabFont(Font font) {
        this.tabFont = font != null ? font : this.getFont();
        this.doLayout();
    }

    public Font getTabFont() {
        return this.tabFont;
    }

    public boolean contains(String string) {
        return this.components.containsKey(string);
    }

    public String getTabName(int n) {
        try {
            return (String)this.tabs.elementAt(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void setTitleFont(Font font) {
        this.titleFont = font != null ? font : this.getFont();
        this.doLayout();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    private void processMousePressed(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        if (this.leftButtonBounds.contains(point)) {
            this.leftButtonPushed = true;
            this.repaint();
        } else if (this.rightButtonBounds.contains(point)) {
            this.rightButtonPushed = true;
            this.repaint();
        } else if (this.checkSelection(point) != null) {
            boolean bl;
            String string = this.checkSelection(point);
            boolean bl2 = bl = this.currentTab != null && this.currentTab.equals(string) && mouseEvent.isMetaDown();
            if (bl && this.detachable) {
                this.detach(string);
            } else {
                this.show(string);
            }
        }
    }

    public void removeTabbedListener(TabbedListener tabbedListener) {
        this.listeners.removeElement(tabbedListener);
    }

    public void render(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        this.paintPanelBorder(graphics, dimension);
        this.paintTitle(graphics, dimension);
        this.paintTabs(graphics, dimension);
        this.paintArrowButtons(graphics, dimension);
    }

    private void paintPanelBorder(Graphics graphics, Dimension dimension) {
        Insets insets = this.getInsets();
        Color color = this.getTabColor(this.currentTab);
        graphics.setColor(color);
        switch (this.orientation) {
            default: {
                graphics.fillRect(0, insets.top - 5, dimension.width - 1, dimension.height - 1 - insets.top + 5);
                this.paintRect(graphics, 0, insets.top - 5, dimension.width - 1, dimension.height - 1 - insets.top + 5);
                break;
            }
            case 1: {
                graphics.fillRect(0, 0, dimension.width - 1, dimension.height - 1 - insets.bottom + 5);
                this.paintRect(graphics, 0, 0, dimension.width - 1, dimension.height - 1 - insets.bottom + 5);
                break;
            }
            case 2: {
                graphics.fillRect(insets.left - 5, 0, dimension.width - 1 - insets.left + 5, dimension.height - 1);
                this.paintRect(graphics, insets.left - 5, 0, dimension.width - 1 - insets.left + 5, dimension.height - 1);
                break;
            }
            case 3: {
                graphics.fillRect(0, 0, dimension.width - 1 - insets.right + 5, dimension.height - 1);
                this.paintRect(graphics, 0, 0, dimension.width - 1 - insets.right + 5, dimension.height - 1);
                break;
            }
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    private void paintBottomTab(Graphics graphics, int n, String string) {
        int n2;
        boolean bl;
        String string2 = string != null ? string : "";
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        int n3 = fontMetrics.stringWidth(string2) + 12 - 1;
        int n4 = fontMetrics.getHeight();
        int n5 = n4 - 1;
        int n6 = dimension.height - insets.bottom + 5;
        boolean bl2 = this.currentTab.equals(string2);
        if (bl2) {
            n6 -= 2;
            n -= 2;
            n5 += 4;
            n3 += 4;
        }
        Color color = this.getTabColor(string2);
        graphics.setColor(color);
        graphics.fillRect(n, n6, n3, n5 + 1);
        int n7 = n + n3 / 2 - fontMetrics.stringWidth(string2) / 2;
        int n8 = dimension.height - insets.bottom + fontMetrics.getHeight() - fontMetrics.getDescent() + 5;
        if (bl2) {
            n8 += 2;
        }
        Color color2 = this.getTabLabelColor(string2);
        if (this.isEnabled(string2)) {
            graphics.setColor(color2);
            graphics.drawString(string2, n7, n8);
        } else {
            graphics.setColor(color.brighter());
            graphics.drawString(string2, n7 + 1, n8 + 1);
            graphics.setColor(color.darker());
            graphics.drawString(string2, n7, n8);
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n + 2, n6 + n5 + 2, n + n3 - 2, n6 + n5 + 2);
        graphics.drawLine(n + n3 - 1, n6 + n5 + 2, n + n3, n6 + n5 + 1);
        if (bl2) {
            graphics.drawLine(n + n3, n6 + n5, n + n3, n6 + 2);
        } else {
            graphics.drawLine(n + n3, n6 + n5, n + n3, n6);
        }
        graphics.setColor(color.darker());
        graphics.drawLine(n + 1, n6 + n5 + 1, n + n3 - 1, n6 + n5 + 1);
        if (bl2) {
            graphics.drawLine(n + n3 - 1, n6 + n5, n + n3 - 1, n6 + 1);
        } else {
            graphics.drawLine(n + n3 - 1, n6 + n5, n + n3 - 1, n6);
        }
        boolean bl3 = bl = this.needArrowButtons() && n + n3 > this.leftButtonBounds.x;
        if (bl) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(dimension.width - 20 - 6, n6, 26, n5 + 4);
            graphics.setColor(color);
            graphics.fillRect(dimension.width - 20 - 8, n6 + 3, 2, n5 - 2);
            n2 = this.leftButtonBounds.x - 3;
            graphics.setColor(color.darker());
            graphics.drawLine(n2, n6, n2 - 1, n6 + (int)((double)n5 * 0.3));
            graphics.drawLine(n2 - 1, n6 + (int)((double)n5 * 0.3), n2, n6 + (int)((double)n5 * 0.6));
            graphics.drawLine(n2, n6 + (int)((double)n5 * 0.6), n2 - 1, n6 + n5 + 1);
            graphics.setColor(Color.black);
            graphics.drawLine(n2 + 1, n6, n2, n6 + (int)((double)n5 * 0.3));
            graphics.drawLine(n2, n6 + (int)((double)n5 * 0.3), n2 + 1, n6 + (int)((double)n5 * 0.6));
            graphics.drawLine(n2 + 1, n6 + (int)((double)n5 * 0.6), n2 - 1, n6 + n5 + 1);
            if (bl2) {
                graphics.setColor(color.darker());
                graphics.drawLine(n2 + 1, n6, dimension.width - 1, n6);
                graphics.setColor(Color.black);
                graphics.drawLine(n2 + 1, n6 + 1, dimension.width - 1, n6 + 1);
            }
        }
        if (n >= 0) {
            graphics.setColor(color.brighter());
            graphics.drawLine(n, n6, n, n6 + n5);
            graphics.drawLine(n, n6 + n5, n + 1, n6 + n5 + 2);
        } else if (n >= -n3 && n < 0) {
            n2 = n5 / 3;
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, n6 + 2, 2, n5 + 2);
            graphics.fillRect(0, n6 + n5 + 2, 3, 2);
            graphics.setColor(color);
            graphics.fillRect(2, n6 + 2, 3, n5 - 2);
            graphics.setColor(color.darker());
            graphics.drawLine(0, n6, 2, n6 + n2);
            graphics.drawLine(2, n6 + n2, 0, n6 + n2 * 2);
            graphics.drawLine(0, n6 + n2 * 2, 3, n6 + n5 + 2);
            graphics.setColor(color.brighter());
            graphics.drawLine(1, n6, 3, n6 + n2);
            graphics.drawLine(3, n6 + n2, 1, n6 + n2 * 2);
            graphics.drawLine(1, n6 + n2 * 2, 4, n6 + n5 + 1);
        }
    }

    public Color getTabColor(String string) {
        if (string != null) {
            Color color = (Color)this.tabColors.get(string);
            if (color != null) {
                return color;
            }
            return this.tabColor;
        }
        return this.getTabColor();
    }

    public void setTabColor(Color color) {
        this.tabColor = color;
        this.repaint();
    }

    public Color getTabColor() {
        return this.tabColor;
    }

    public void setTabColor(String string, Color color) {
        if (this.contains(string)) {
            if (color != null) {
                this.tabColors.put(string, color);
            } else {
                this.tabColors.remove(string);
            }
        }
        this.repaint();
    }

    public void setOrientation(int n) {
        this.orientation = n;
        this.validate();
        this.doLayout();
        this.repaint();
    }

    private void paintLeftButton(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.draw3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, !this.leftButtonPushed);
        graphics.setColor(Color.black);
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        point.x = point.x + (this.leftButtonPushed ? 1 : 0);
        point.y = point.y + (this.leftButtonPushed ? 1 : 0);
        graphics.drawLine(point.x + 1, point.y - 3, point.x + 1, point.y + 3);
        graphics.drawLine(point.x, point.y - 2, point.x, point.y + 2);
        graphics.drawLine(point.x - 1, point.y - 1, point.x - 1, point.y + 1);
        graphics.drawLine(point.x - 2, point.y, point.x - 2, point.y);
    }

    private void paintRightButton(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.draw3DRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, !this.rightButtonPushed);
        graphics.setColor(Color.black);
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        point.x = point.x + (this.rightButtonPushed ? 1 : 0);
        point.y = point.y + (this.rightButtonPushed ? 1 : 0);
        graphics.drawLine(point.x - 1, point.y - 3, point.x - 1, point.y + 3);
        graphics.drawLine(point.x, point.y - 2, point.x, point.y + 2);
        graphics.drawLine(point.x + 1, point.y - 1, point.x + 1, point.y + 1);
        graphics.drawLine(point.x + 2, point.y, point.x + 2, point.y);
    }

    public void setDetachable(boolean bl) {
        this.detachable = bl;
    }

    public int getOrientation() {
        return this.orientation;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent) {
            switch (aWTEvent.getID()) {
                case 501: {
                    this.processMousePressed((MouseEvent)aWTEvent);
                    break;
                }
                case 502: {
                    this.processMouseReleased((MouseEvent)aWTEvent);
                    break;
                }
            }
        }
        super.processEvent(aWTEvent);
    }

    private void paintTopTab(Graphics graphics, int n, String string) {
        int n2;
        boolean bl;
        String string2 = string != null ? string : "";
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = this.getInsets();
        int n3 = fontMetrics.stringWidth(string2) + 12 - 1;
        int n4 = fontMetrics.getHeight();
        int n5 = n4 + 4;
        int n6 = insets.top - 5;
        this.getSize();
        boolean bl2 = bl = this.currentTab != null && this.currentTab.equals(string2);
        if (bl) {
            n5 += 2;
            n -= 2;
            n3 += 4;
        }
        Color color = this.getTabColor(string2);
        graphics.setColor(color);
        if (bl) {
            graphics.fillRect(n + 1, n6 - n5 + 3, n3 - 2, n5 - 2);
        } else {
            graphics.fillRect(n + 1, n6 - n5 + 3, n3 - 2, n5 - 3);
        }
        int n7 = n + n3 / 2 - fontMetrics.stringWidth(string2) / 2;
        int n8 = n6 - fontMetrics.getDescent();
        if (bl) {
            n8 -= 2;
        }
        Color color2 = this.getTabLabelColor(string2);
        if (this.isEnabled(string2)) {
            graphics.setColor(color2);
            graphics.drawString(string2, n7, n8);
        } else {
            graphics.setColor(color.brighter());
            graphics.drawString(string2, n7 + 1, n8 + 1);
            graphics.setColor(color.darker());
            graphics.drawString(string2, n7, n8);
        }
        graphics.setColor(color.brighter());
        graphics.drawLine(n + 2, n6 - n5 + 2, n + n3 - 2, n6 - n5 + 2);
        if (n >= 0) {
            graphics.drawLine(n, n6, n, n6 - n5 + 4);
            graphics.drawLine(n, n6 - n5 + 4, n + 2, n6 - n5 + 2);
        } else if (n > -n3 && n < 0) {
            n2 = insets.top - 5 - n5 + 2;
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, n2, 3, n5 - 2);
            graphics.fillRect(0, n2 + 1, 5, n5 - 4);
            graphics.setColor(color);
            graphics.fillRect(2, n2 + 1, 3, n5 - 4);
            graphics.setColor(color.darker());
            graphics.drawLine(2, n2 + 1, 0, n2 + (int)((double)n5 * 0.25));
            graphics.drawLine(0, n2 + (int)((double)n5 * 0.25), 2, n2 + (int)((double)n5 * 0.5));
            graphics.drawLine(2, n2 + (int)((double)n5 * 0.5), 0, n2 + (int)((double)n5 * 0.75));
            graphics.setColor(color.brighter());
            graphics.drawLine(0, n2 + (int)((double)n5 * 0.75), 0, n2 + n5 + 1);
            graphics.drawLine(4, n2, 1, n2 + (int)((double)n5 * 0.25));
            graphics.drawLine(1, n2 + (int)((double)n5 * 0.25), 3, n2 + (int)((double)n5 * 0.5));
            graphics.drawLine(3, n2 + (int)((double)n5 * 0.5), 1, n2 + (int)((double)n5 * 0.75));
        }
        int n9 = n2 = !this.needArrowButtons() || n + n3 <= this.leftButtonBounds.x ? 0 : 1;
        if (n2 == 0) {
            graphics.setColor(Color.black);
            graphics.drawLine(n + n3 - 1, n6 - n5 + 3, n + n3, n6 - n5 + 4);
            graphics.drawLine(n + n3, n6 - n5 + 4, n + n3, n6 - 1);
            graphics.setColor(color.darker());
            graphics.drawLine(n + n3 - 1, n6 - n5 + 3, n + n3 - 1, n6 - 1);
        } else {
            n = this.leftButtonBounds.x - 5;
            n6 = insets.top - 5 - n5 + 2;
            graphics.setColor(this.getBackground());
            graphics.fillRect(n, n6, n3, n5 - 2);
            graphics.setColor(color.darker());
            graphics.drawLine(n, n6, n + 1, n6 + (int)((double)n5 * 0.25));
            graphics.drawLine(n + 1, n6 + (int)((double)n5 * 0.25), n, n6 + (int)((double)n5 * 0.5));
            graphics.drawLine(n, n6 + (int)((double)n5 * 0.5), n + 1, n6 + (int)((double)n5 * 0.75));
            graphics.drawLine(n + 1, n6 + (int)((double)n5 * 0.75), n, n6 + n5 - 3);
            graphics.setColor(Color.black);
            graphics.drawLine(n + 1, n6 + 1, n + 2, n6 + (int)((double)n5 * 0.25));
            graphics.drawLine(n + 2, n6 + (int)((double)n5 * 0.25), n + 1, n6 + (int)((double)n5 * 0.5));
            graphics.drawLine(n + 1, n6 + (int)((double)n5 * 0.5), n + 2, n6 + (int)((double)n5 * 0.75));
            graphics.drawLine(n + 2, n6 + (int)((double)n5 * 0.75), n + 1, n6 + n5 - 3);
        }
    }

    public Component add(String string, Component component) {
        if (string == null || component == null) {
            return null;
        }
        component.setName(string);
        if (this.isDetached(string)) {
            Frame frame = (Frame)this.detachedFrames.get(string);
            if (frame != null) {
                frame.removeAll();
                frame.add("Center", component);
                frame.doLayout();
            }
        } else {
            if (this.components.containsKey(string)) {
                Component component2 = (Component)this.components.get(string);
                this.remove(component2);
                int n = this.tabs.indexOf(string);
                if (n > 0) {
                    this.tabs.removeElementAt(n);
                    this.tabs.insertElementAt(string, n);
                }
            } else {
                this.tabs.addElement(string);
            }
            this.add(component);
            this.components.put(string, component);
            this.tabEnabled.set(this.tabs.indexOf(string));
            if (this.currentTab == null) {
                this.currentTab = string;
            }
            this.doLayout();
            this.repaint();
        }
        this.notifyListeners(new TabbedEvent(4, this, string, component));
        return component;
    }

    public void windowClosing(WindowEvent windowEvent) {
        Window window;
        if (windowEvent.getID() == 201 && (window = windowEvent.getWindow()) instanceof Frame) {
            this.retach(((Frame)window).getTitle());
        }
    }

    private boolean needArrowButtons() {
        int n = this.tabs.size();
        return n > 0 && this.tabPosition[n - 1] > this.getSize().width - 2 || this.tabOffset > 0;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setTitle(String string) {
        this.title = string;
        this.doLayout();
    }

    public String getTitle() {
        return this.title;
    }

    public void addTabbedListener(TabbedListener tabbedListener) {
        this.listeners.addElement(tabbedListener);
    }

    private void processMouseReleased(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        if (this.leftButtonBounds.contains(point)) {
            this.tabOffset -= 20;
            this.tabOffset = Math.max(this.tabOffset, 0);
            this.leftButtonPushed = false;
        } else if (this.rightButtonBounds.contains(point)) {
            int n = this.components.size();
            if (n > 0 && this.tabPosition[n - 1] > this.leftButtonBounds.x) {
                this.tabOffset += 20;
            }
            this.rightButtonPushed = false;
        }
        this.repaint();
    }

    private int getWidestTabWidth() {
        int n = 0;
        FontMetrics fontMetrics = this.getFontMetrics(this.tabFont);
        if (fontMetrics != null) {
            Enumeration enumeration = this.tabs.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                n = Math.max(n, fontMetrics.stringWidth(string));
            }
        }
        return n;
    }

    private void paintTabs(Graphics graphics, Dimension dimension) {
        if (this.tabs.size() == 0) {
            return;
        }
        this.getInsets();
        int n = 2 - this.tabOffset;
        int n2 = 2;
        int n3 = 12;
        FontMetrics fontMetrics = this.getFontMetrics(this.tabFont);
        if (fontMetrics != null) {
            n3 = fontMetrics.getHeight();
        }
        int n4 = 0;
        int n5 = this.getWidestTabWidth();
        graphics.setFont(this.tabFont);
        Enumeration enumeration = this.tabs.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            switch (this.orientation) {
                default: {
                    this.paintTopTab(graphics, n, string);
                    this.tabPosition[n4] = n += fontMetrics.stringWidth(string) + 12;
                    break;
                }
                case 1: {
                    this.paintBottomTab(graphics, n, string);
                    this.tabPosition[n4] = n += fontMetrics.stringWidth(string) + 12;
                    break;
                }
                case 2: {
                    this.paintLeftTab(graphics, n2, n5, string);
                    this.tabPosition[n4] = n2 += fontMetrics.getHeight() + 9;
                    break;
                }
                case 3: {
                    this.paintRightTab(graphics, n2, n5, string);
                    this.tabPosition[n4] = n2 += fontMetrics.getHeight() + 9;
                    break;
                }
            }
            ++n4;
        }
        int n6 = this.tabs.indexOf(this.currentTab);
        n = 2 - this.tabOffset;
        n2 = 2;
        int n7 = 0;
        while (n7 < n6) {
            if (this.orientation == 0 || this.orientation == 1) {
                n += fontMetrics.stringWidth((String)this.tabs.elementAt(n7)) + 12;
            } else {
                n2 += fontMetrics.getHeight() + 9;
            }
            ++n7;
        }
        switch (this.orientation) {
            default: {
                this.paintTopTab(graphics, n, this.currentTab);
                break;
            }
            case 1: {
                this.paintBottomTab(graphics, n, this.currentTab);
                break;
            }
            case 2: {
                this.paintLeftTab(graphics, n2, n5, this.currentTab);
                break;
            }
            case 3: {
                this.paintRightTab(graphics, n2, n5, this.currentTab);
                break;
            }
        }
    }

    private void paintTitle(Graphics graphics, Dimension dimension) {
        graphics.setFont(this.titleFont);
        if (this.title != null && this.title.trim().length() > 0) {
            Insets insets = this.getInsets();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.setColor(this.getForeground());
            switch (this.orientation) {
                case 0: {
                    int n = dimension.width - fontMetrics.stringWidth(this.title) - 5;
                    graphics.drawString(this.title, n, insets.top - 5 - fontMetrics.getDescent());
                    break;
                }
                case 1: {
                    int n = dimension.width - fontMetrics.stringWidth(this.title) - 5;
                    graphics.drawString(this.title, n, dimension.height - insets.bottom + 5 + fontMetrics.getHeight() - fontMetrics.getDescent());
                    break;
                }
                case 2: {
                    int n = insets.left - 5 - fontMetrics.stringWidth(this.title) - 5;
                    graphics.drawString(this.title, n, dimension.height - fontMetrics.getDescent());
                    break;
                }
                case 3: {
                    int n = dimension.width - insets.right + 5 + 5;
                    graphics.drawString(this.title, n, dimension.height - fontMetrics.getDescent());
                    break;
                }
            }
        }
    }

    public boolean isDetachable() {
        return this.detachable;
    }

    private void paintRect(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = this.getTabColor(this.currentTab);
        graphics.setColor(color.brighter());
        graphics.drawLine(n, n2, n, n2 + n4);
        graphics.drawLine(n, n2, n + n3, n2);
        graphics.setColor(Color.black);
        graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
        graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
        graphics.setColor(color.darker());
        graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
    }

    private String checkSelection(Point point) {
        int n;
        int n2;
        String string = null;
        Dimension dimension = this.getSize();
        int n3 = Math.min(this.tabs.size(), this.tabPosition.length);
        int n4 = 0;
        Insets insets = this.getInsets();
        int n5 = 12;
        FontMetrics fontMetrics = this.getFontMetrics(this.tabFont);
        if (fontMetrics != null) {
            n5 = fontMetrics.getHeight();
        }
        switch (this.orientation) {
            default: {
                n2 = insets.top - 5;
                n = n2 - n5 - 5;
                break;
            }
            case 1: {
                n = dimension.height - insets.bottom + 5;
                n2 = n + n5 + 5;
                break;
            }
            case 2: {
                n2 = insets.left - 5;
                n = n2 - this.getWidestTabWidth() - 7;
                break;
            }
            case 3: {
                n = dimension.width - insets.right + 5;
                n2 = n + this.getWidestTabWidth() + 7;
                break;
            }
        }
        int n6 = 0;
        while (n6 < n3) {
            if (this.orientation == 0 || this.orientation == 1) {
                if (point.x >= n4 && point.x < this.tabPosition[n6] && point.y > n && point.y < n2) {
                    string = (String)this.tabs.elementAt(n6);
                    break;
                }
            } else if (point.y >= n4 && point.y < this.tabPosition[n6] && point.x > n && point.x < n2) {
                string = (String)this.tabs.elementAt(n6);
                break;
            }
            ++n6;
        }
        if (string != null && !this.isEnabled(string)) {
            string = null;
        }
        return string;
    }

    public Component get(String string) {
        return (Component)this.components.get(string);
    }

    public TabbedPanel() {
        this(0);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public TabbedPanel(int n) {
        this.setBackground(Color.lightGray);
        this.setLayout(null);
        this.orientation = n;
        this.tabColor = this.getBackground();
        this.tabColors = new Hashtable();
        this.tabLabelColor = Color.black;
        this.tabLabelColors = new Hashtable();
        this.detachable = true;
        this.titleFont = this.getFont();
        if (this.titleFont == null) {
            this.titleFont = new Font("Dialog", 0, 12);
        }
        this.tabFont = this.titleFont;
        this.components = new Hashtable();
        this.tabs = new Vector();
        this.tabPosition = new int[100];
        this.tabEnabled = new BitSet();
        this.leftButtonBounds = new Rectangle();
        this.rightButtonBounds = new Rectangle();
        this.listeners = new Vector();
        this.detachedFrames = new Hashtable();
        this.enableEvents(16L);
    }

    public int getComponentCount() {
        return this.tabs.size();
    }

    public final void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offscreen == null || this.offscreen.getWidth(this) < dimension.width || this.offscreen.getHeight(this) < dimension.height) {
            this.offscreen = this.createImage(dimension.width, dimension.height);
        }
        Graphics graphics2 = graphics;
        if (this.offscreen != null) {
            graphics2 = this.offscreen.getGraphics();
        }
        this.render(graphics2);
        if (graphics2 != graphics) {
            graphics.drawImage(this.offscreen, 0, 0, this);
            graphics2.dispose();
        }
        if (TabbedEvent.evaluation) {
            TabbedEvent.paintEvaluation(graphics, dimension, this.orientation, this.getInsets());
        }
        super.paint(graphics);
    }

    public Component show(String string) {
        if (string == null || !this.isEnabled(string)) {
            return null;
        }
        String string2 = this.currentTab;
        this.currentTab = string;
        this.doLayout();
        if (!string.equals(string2)) {
            this.notifyListeners(new TabbedEvent(1, this, string2, this.get(string2)));
            this.notifyListeners(new TabbedEvent(0, this, string, this.get(string)));
        }
        return this.get(string);
    }

    private void paintArrowButtons(Graphics graphics, Dimension dimension) {
        int n = 0;
        int n2 = 0;
        Insets insets = this.getInsets();
        switch (this.orientation) {
            case 0: {
                n = dimension.width - 20 - 2;
                n2 = insets.top - 14 - 5 - 1;
                break;
            }
            case 1: {
                n = dimension.width - 20 - 2;
                n2 = dimension.height - insets.bottom + 5;
                break;
            }
        }
        this.leftButtonBounds.setBounds(n, n2, 10, 14);
        this.rightButtonBounds.setBounds(n + 10 + 1, n2, 10, 14);
        if (this.needArrowButtons()) {
            this.paintLeftButton(graphics, this.leftButtonBounds);
            this.paintRightButton(graphics, this.rightButtonBounds);
        }
    }

    public void detach(String string) {
        if (string == null || !this.contains(string) || this.isDetached(string) || !this.detachable) {
            return;
        }
        this.setEnabled(string, false);
        this.show(this.getFirstEnabledTab());
        Component component = (Component)this.components.remove(string);
        Frame frame = new Frame(string);
        frame.setLayout(new BorderLayout());
        frame.addNotify();
        frame.add("Center", component);
        this.detachedFrames.put(string, frame);
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        Insets insets2 = frame.getInsets();
        int n = dimension.width - insets.left - insets.right + insets2.left + insets2.right;
        int n2 = dimension.height - insets.top - insets.bottom + insets2.top + insets2.bottom;
        ((Component)frame).setSize(n, n2);
        Point point = this.getLocationOnScreen();
        ((Component)frame).setLocation(point.x + 20, point.y + 20);
        ((Component)frame).setVisible(true);
        component.setVisible(true);
        this.notifyListeners(new TabbedEvent(2, this, string, component));
        frame.addWindowListener(this);
    }

    private void notifyListeners(TabbedEvent tabbedEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((TabbedListener)enumeration.nextElement()).tabEvent(tabbedEvent);
        }
    }

    public void setEnabled(String string, boolean bl) {
        int n = this.tabs.indexOf(string);
        if (bl && n >= 0) {
            this.tabEnabled.set(n);
        } else if (n >= 0) {
            this.tabEnabled.clear(n);
        }
        this.repaint();
    }
}

