.TH OPENPARAM 3L
.SH NAME
openparam, creatparam, fopenparam, funnyopenparam - open/create files/streams controlled
by command line parameters
.SH SYNOPSIS
.nf
#include "param.h"

int openparam(name,mode)
char *name;
int mode;

int creatparam(name,mode)
int creatparam(name,mode)
char *name;
int mode;

FILE *fopenparam(name,access)
char *name;
char *access;

int funnyopenparam(path,name,mode)
char *path;
char *name;
int mode;
.SH DESCRIPTION
.fi
.IP
Openparam, creatparam, and fopenparam open the file specified in the name
string.  The formats for the name string are:
.nf
	name			- open the file (stream) to the named file.
	pname=name    	- use name as a default if the parameter pname
				is absent, otherwise use the string after
				pname= on the program call.
	<			- open the file (stream) to stdin.
	pname=<		- use stdin as a default if the parameter
				pname is not found.
	>			- open the file (stream) to stdout.
	pname=>		- use stdout as a default if the parameter
				pname is not found.
	pname=		- open the file (stream) to the file specified
				in the parameter pname.
.fi

openparam (fopenparam) uses mode (access) the same way that
open (fopen) uses the equivalent argument.  
Creatparam uses mode the same way that creat(2) uses the equivalent arguement.
The first string in funnyopenparam is a colon (only) seperated list of path
prefixes that will be prepended onto the file name (if it is not stdin) in
order, until an existing file is found.  The null string is taken to be the
current directory.
.SH FILES
.nf
/usr/src/local/date/openp.c
/usr/local/lib/libdate.a
.SH SEE ALSO
.nf
open(2) and fopen(3).
param(3L).
.SH DIAGNOSTICS
openparam returns -1 if the requested mode is incompatible with
the file name requested (i.e. mode 0 with name ">").  fopenparam
returns NULL is this case.  Openparam (fopenparam) otherwise
return the same value as open (fopen).
.SH BUGS
never.  It may be that these will be changed to create for
all modes rather than for just writing.
