#charset "us-ascii"

/*
 *   Copyright (c) 2002 by Joao Mendes.
 *   ConvTopc.t: Conversation Library - Topic Definitions.
 */

#include <adv3.h>
#include <en_us.h>

#include <JmmmConv.h>

/******************************************************************************
 *
 *   ResolvedTopic Modification
 *   Provide higher priority to matched JmmmTopic objects in topic actions
 */

modify ResolvedTopic
    getBestMatch()
    {
        local t;

        if ( inScopeList == [me] && likelyList == [] && otherList == [] )
            return meTopic;

        if ((t = inScopeList.valWhich({x: x.ofKind(JmmmTopic)})) != nil)
            return t;
        if ((t = likelyList.valWhich({x: x.ofKind(JmmmTopic)})) != nil)
            return t;
        if ((t = otherList.valWhich({x: x.ofKind(JmmmTopic)})) != nil)
            return t;

        if (inScopeList.length() != 0 && inScopeList[1].ofKind(JmmmTopic))
            return inScopeList[1];
        if (likelyList.length() != 0 && likelyList[1].ofKind(JmmmTopic))
            return likelyList[1];
        if (otherList.length() != 0 && otherList[1].ofKind(JmmmTopic))
            return otherList[1];

        if (inScopeList.length() != 0)
            return inScopeList[1];
        if (likelyList.length() != 0)
            return likelyList[1];
        if (otherList.length() != 0)
            return otherList[1];
        return nil;
    }
;

/******************************************************************************
 *
 *   JmmmTopic
 *   Objects for conversation topics
 */

class JmmmTopic: Topic
    theName = name
;

/******************************************************************************
 *
 *   The 'No Topic Match' and 'Greetings' topic constants
 */

DeclareTopic(_, '', '')
;

DeclareTopic(_Greet, '', '')
;
