/**************************************
	Fichero de cabecera de
	GRFPCX.C
**************************************/

#if !defined (GRFPCX_H)
#define GRFPCX_H

/*** Macros ***/
#define RGB(r,g,b) (((long)((b) << 8 | (g)) << 8) | (r))

/*** Constantes ***/
#define GRF_ID	"JSJ GRF1"	/* cadena de identificacin */
#define LNG_GRF_ID	9   	/* longitud cadena identificacin */
#define TAMLINGRF16	80      /* tamao de 1 plano de lnea 16 colores */
#define TAMLINGRF256	320     /* tamao de lnea 256 colores */
#define TAMLINGRF256X	90      /* tamao de lnea modo extendido 256 colores */

/* cdigos de error de las funciones de decodificacin de ficheros GRF */
#define E_GRF_APER	1       /* error de apertura de fichero */
#define E_GRF_LECT	2       /* error de lectura de fichero */
#define E_GRF_FORM	3       /* formato de fichero no vlido */
#define E_GRF_IMG	4	/* formato de imagen no vlido */
#define E_GRF_MODO  	5       /* modo de pantalla incorrecto */
#define E_GRF_MEM   	6       /* no hay memoria suficiente para imagen */
#define E_GRF_NOEX  	7	/* no existe esa imagen en fichero */

/*** Tipos de datos y estructuras ***/
#if !defined (BYTE)
#define BYTE unsigned char
#endif

/* cabecera de fichero GRF */
typedef struct {
	char id[LNG_GRF_ID];	/* cadena identificativa */
	int n_img;		/* nmero de imgenes en fichero */
} STC_CABGRF;

/* cabecera de imagen en fichero GRF */
typedef struct {
	int num;		/* nmero de imagen */
	long tam_img;		/* tamao imagen (bytes) sin decodificar */
	BYTE bits_pixel;        /* nmero de bits por pixel */
	int ventana[4];         /* tamao dibujo (izq., arr., der., abajo) */
	BYTE paleta[256][3];    /* informacin de paleta para la imagen */
	BYTE num_planos;        /* nmero de planos de color */
	int bytes_scan;         /* nmero de bytes por plano de lnea scan */
} STC_CABIMG;

/* imagen decodificada */
typedef struct {
	int ancho, alto;        /* dimensiones en pixels */
	int num_colores;        /* nmero de colores (mx. 256) */
	BYTE paleta[256][3];    /* paleta RGB de colores */
	BYTE far *(*lineas);	/* punteros a lneas de imagen */
} STC_IMGRF;

/*** Prototipos ***/
int grf_decodifica(char *nombre_grf, int n_img, STC_IMGRF *imagen);
void grf_libera_mem(STC_IMGRF *imagen);
int grf_dibuja(STC_IMGRF *imagen, int x, int y, int anchura, int altura,
  int paleta);
int grf_visualiza(char *nombre_grf, int n_img, int x, int y, int anchura,
  int altura, int paleta);

#endif  /* GRFPCX_H */
