/**************************************
      Fichero de cabecera con los
      cdigos de error del compilador
**************************************/

#if !defined (CSERR_H)
#define CSERR_H

/* cdigos de error del compilador */
typedef enum {
	_E_NERR=0,      /* cdigo de no error */
	_E_CIND,        /* cdigo de indireccin */
	_E_TABC,        /* TABLA DE CONDACTOS ERRONEA */
	_E_FTMP,        /* error apertura fichero temporal */
	_E_ETMP,        /* error de escritura fichero temporal */
	_E_LTMP,        /* error de lectura fichero temporal */
	_E_AFIN,        /* error apertura fichero de entrada */
	_E_LFIN,        /* error de lectura fichero de entrada */
	_E_EOFI,        /* fin de fichero de entrada */
	_E_AFOU,        /* error de apertura de fichero de salida */
	_E_EFOU,        /* error de escritura en fichero de salida */
	_E_MMEM,        /* no hay suficiente memoria para ejecutar programa */
	_E_SCCI,        /* seccin no vlida */
	_E_SCRP,        /* seccin repetida */
	_E_MSCC,        /* marca de seccin no encontrada */
	_E_MEND,        /* marca \END no encontrada */
	_E_NOSC,        /* faltan secciones */
	_E_MXXX,        /* INDICA QUE QUEDAN TABLAS DE MENSAJES POR COMPILAR */
	_E_CVOC,        /* carcter no vlido en palabra */
	_E_FCAM,        /* faltan campos */
	_E_NPAL,        /* nmero de palabra no vlido */
	_E_CNUM,        /* campo numrico no vlido */
	_E_TPAL,        /* tipo de palabra no vlido */
	_E_PREP,        /* palabra repetida */
	_E_MVOC,        /* vocabulario lleno */
	_E_FALT,        /* falta '@' */
	_E_NFSC,        /* nmero fuera de secuencia */
	_E_FMEM,        /* rebasada memoria reservada para seccin actual */
	_E_NVAL,        /* nmero no vlido */
	_E_NPVC,        /* palabra no est en vocabulario */
	_E_NNVC,        /* nombre no est en vocabulario */
	_E_NAVC,        /* adjetivo no est en vocabulario */
	_E_NMOV,        /* la palabra no es verbo de movimiento */
	_E_NNOM,        /* el primer campo debe ser un nombre */
	_E_NADJ,        /* el segundo campo debe ser un adjetivo */
	_E_LINC,        /* localidad inicial no vlida */
	_E_BAND,        /* banderas de objeto no vlidas */
	_E_OTEX,        /* falta texto de objeto */
	_E_NENT,        /* comienzo de entrada no vlido */
	_E_RBTL,        /* tabla de etiquetas llena */
	_E_EREP,        /* etiqueta repetida */
	_E_ENVL,        /* nombre de etiqueta no vlido */
	_E_NVNC,        /* primera palabra entrada no es verbo ni nomb.conv. */
	_E_NNNN,        /* segunda palabra entrada no es nombre */
	_E_NCND,        /* condacto no vlido */
	_E_PRPR,        /* un proceso no puede llamarse a s mismo */
	_E_PRRB,        /* rebasado mximo nmero de llamadas 'forward' */
	_E_WPNW,        /* nmero de ventana no vlido */
	_E_TMSG,	/* nmero de tabla de mensajes no vlido */
	_E_MPNM,        /* nmero de mensaje no vlido */
	_E_MPNL,        /* nmero de localidad no vlido */
	_E_OPNV,        /* nmero de objeto no vlido */
	_E_NLAB,        /* campo de etiqueta no vlido */
	_E_RBTS,        /* rebasado mximo num. saltos 'forward' SKIP */
	_E_LBFR,        /* salto fuera de rango */
	_E_NCAD,        /* adjetivo no vlido */
	_E_NNMB,        /* nombre no vlido */
	_E_NVHT,        /* bandera de usuario no vlida */
	_E_CHNV,        /* parmetro CHANCE debe estar entre 0 y 100 */
	_E_RBNV,        /* banco de memoria no vlido */
	_E_MPNP,        /* nmero de 1er mensaje del sistema no vlido */
	_E_MPNS,        /* nmero de 2 mensaje del sistema no vlido */
	_E_NO01,        /* parmetro debe ser 0 o 1 */
	_E_COLR,        /* color incorrecto */
	_E_CLOC,        /* conexin a localidad no vlida */
	_E_RFFW,        /* etiqueta no definida */
	_E_LFFR,        /* salto 'forward' fuera de rango */
	_E_PRLL,        /* llamada a proceso inexistente */
	_E_TCCN,        /* tabla de constantes llena */
	_E_PCCN,        /* primer carcter de nombre de constante no vlido */
	_E_FVCN,        /* falta valor de constante */
	_E_CTND,        /* constante no definida */
	_E_NNCT,        /* nombre de constante no vlido */
	_E_VNCT,        /* error en valor de constante */
	_E_NBWN,        /* nmero de borde de ventana no vlido */
	_E_SP01,        /* segundo parmetro debe ser 0 o 1 */
	_E_CRGB,        /* componente RGB debe estar entre 0 y 63 */
	_E_NOTA,	/* nmero de nota no vlido */
} COD_ERR;

#endif  /* CSERR_H */
