/* alaiff.c: Allegro aiff loader
    Converts AIFF audio data into the SAMPLE format used by allegro
    By L. Ross Raszewski <lraszewski@justice.loyola.edu>

    Uses IEEE extended to double converter by Malcolm Slaney and
    Ken Turkowski.
*/

#include <stdio.h>
#include <allegro.h>
#include <math.h>
/*
 * C O N V E R T   F R O M   I E E E   E X T E N D E D  
 */

/* 
 * Copyright (C) 1988-1991 Apple Computer, Inc.
 * All rights reserved.
 *
 * Machine-independent I/O routines for IEEE floating-point numbers.
 *
 * NaN's and infinities are converted to HUGE_VAL or HUGE, which
 * happens to be infinity on IEEE machines.  Unfortunately, it is
 * impossible to preserve NaN's in a machine-independent way.
 * Infinities are, however, preserved on IEEE machines.
 *
 * These routines have been tested on the following machines:
 *    Apple Macintosh, MPW 3.1 C compiler
 *    Apple Macintosh, THINK C compiler
 *    Silicon Graphics IRIS, MIPS compiler
 *    Cray X/MP and Y/MP
 *    Digital Equipment VAX
 *
 *
 * Implemented by Malcolm Slaney and Ken Turkowski.
 *
 * Malcolm Slaney contributions during 1988-1990 include big- and little-
 * endian file I/O, conversion to and from Motorola's extended 80-bit
 * floating-point format, and conversions to and from IEEE single-
 * precision floating-point format.
 *
 * In 1991, Ken Turkowski implemented the conversions to and from
 * IEEE double-precision format, added more precision to the extended
 * conversions, and accommodated conversions involving +/- infinity,
 * NaN's, and denormalized numbers.
 */

# define UnsignedToFloat(u)  (((double)((long)(u - 2147483647L - 1))) + 2147483648.0)
static double ConvertFromIeeeExtended(bytes)
unsigned char *bytes;	/* LCN */
{
    double    f;
    int    expon;
    unsigned long hiMant, loMant;
    
    expon = ((bytes[0] & 0x7F) << 8) | (bytes[1] & 0xFF);
    hiMant    =    ((unsigned long)(bytes[2] & 0xFF) << 24)
            |    ((unsigned long)(bytes[3] & 0xFF) << 16)
            |    ((unsigned long)(bytes[4] & 0xFF) << 8)
            |    ((unsigned long)(bytes[5] & 0xFF));
    loMant    =    ((unsigned long)(bytes[6] & 0xFF) << 24)
            |    ((unsigned long)(bytes[7] & 0xFF) << 16)
            |    ((unsigned long)(bytes[8] & 0xFF) << 8)
            |    ((unsigned long)(bytes[9] & 0xFF));

    if (expon == 0 && hiMant == 0 && loMant == 0) {
        f = 0;
    }
    else {
        if (expon == 0x7FFF) {    /* Infinity or NaN */
            f = -1;
        }
        else {
            expon -= 16383;
            f  = ldexp(UnsignedToFloat(hiMant), expon-=31);
            f += ldexp(UnsignedToFloat(loMant), expon-=32);
        }
    }

    if (bytes[0] & 0x80)
        return -f;
    else
        return f;
}
SAMPLE *AIFFtoSAMPLE(unsigned char *data)
{
   SAMPLE *Music;
   unsigned long fptr=0;
   int i;
   unsigned long totalsize;
   unsigned long channels;
   unsigned long nsamples;
   unsigned long bits;
   double rate;
   unsigned char buffer[10];
   for(i=0;i<4;i++) fptr++; // FORM
   totalsize=((unsigned) data[fptr++]) << 24;
   totalsize|=((unsigned) data[fptr++]) << 16;
   totalsize|=((unsigned) data[fptr++]) << 8;
   totalsize|=(unsigned) data[fptr++];
   for(i=0;i<12;i++) fptr++;  //AIFF
   channels=(unsigned) data[fptr++] << 8;
   channels|=(unsigned) data[fptr++];
   nsamples=((unsigned) data[fptr++]) << 24;
   nsamples|=((unsigned) data[fptr++]) << 16;
   nsamples|=((unsigned) data[fptr++]) << 8;
   nsamples|=(unsigned) data[fptr++];
   bits= ((unsigned) data[fptr++])<< 8;
   bits |= data[fptr++];
   for(i=0;i<10;i++) buffer[i]=data[fptr++];   
   rate=ConvertFromIeeeExtended(buffer);
   for(i=0;i<16;i++) fptr++;
   Music=create_sample(bits,channels-1,rate,nsamples);
   if (bits==8)
   for (i=0;i<nsamples;i++)
   { int c=data[fptr++];
    ((signed char *)Music->data)[i]=c-127;
   }
   else
   for (i=0;i<nsamples;i++)
   { int c=data[fptr++] << 8 | data[fptr++];
     ((signed short *)Music->data)[i]=c-32768;
   }
   return Music;
}




