"""
t3MHLS.py

Provides a class representing a method header list block in a t3 image file.
"""

import struct
from t3Block import *

class MHLS_Block(Block):
	"""
	A method header list block. This will normally only be included if the
	image was compiled for debugging.
	"""
	name = "Method Header List Block"
	debug = True

	def __init__(self, datastream, image, attribs):
		Block.__init__(self, datastream, image, attribs)
		self.read_block()
		
	def read_block(self):
		"""
		Reads the data included in the block.
		"""
		n = struct.unpack("<I", self.datastream.read(4))[0]
		entries = []
		for i in xrange(n):
			entries.append(int(struct.unpack("<I", self.datastream.read(4))[0]))
		self.data["l_codePoolAddresses"] = entries

	def report_data(self):
		sl = []
		sl.append("list of code pool addresses for method headers: ")
		sl.append(str(self.data["l_codePoolAddresses"]) + "\n")
		return "".join(sl)