/*
 *   mru_dis.t - most-recently-used disambiguation mechanism
 *   
 *   This file implements a supplemental disambiguation that, when faced
 *   with a choice of several objects, tries to pick one that has been
 *   used recently in a command, if possible. 
 */

modify global
    globalMRU = [nil nil nil nil nil nil nil nil nil nil nil nil]
;

modify deepverb
    verbAction(actor, dobj, prep, iobj) =
    {
        /* add the dobj and iobj to the most-recently-used object list */
        self.addGlobalMRU(iobj);
        self.addGlobalMRU(dobj);
    }

    addGlobalMRU(obj) =
    {
        /* if the object is non-nil, add it to the list */
        if (obj != nil)
        {
            /* if the object is already in the list, remove it */
            if (find(global.globalMRU, obj))
            {
                /* remove the old instance */
                global.globalMRU -= obj;
            }
            else
            {
                /* remove the last element of the list */
                global.globalMRU -=
                    global.globalMRU[length(global.globalMRU)];
            }

            /* add the new object at the start of the list */
            global.globalMRU := [obj] + global.globalMRU;
        }
    }

    disambigDobj(actor, prep, iobj, verprop, wordlist, objlist, flaglist,
                 numWanted, isAmbig, silent) =
    {
        /* if it's not ambiguous, do nothing */
        if (!isAmbig)
            return DISAMBIG_CONTINUE;

        /* use the most-recently-used algorithm */
        return self.disambigGenObj(actor, objlist);
    }

    disambigIobj(actor, prep, dobj, verprop, wordlist, objlist, flaglist,
                 numWanted, isAmbig, silent) =
    {
        /* if it's not ambiguous, do nothing */
        if (!isAmbig)
            return DISAMBIG_CONTINUE;

        /* use the most-recently-used algorithm */
        return self.disambigGenObj(actor, objlist);
    }

    disambigGenObj(actor, objlist) =
    {
        local ret;
        local i;
        
        /* 
         *   Scan the object list to build a list of objects that are in
         *   the global MRU list. 
         */
        ret := [];
        for (i := 1 ; i <= length(objlist) ; ++i)
        {
            /* if this object is in the MRU list, add it to our list */
            if (find(global.globalMRU, objlist[i]))
                ret += objlist[i];
        }

        /* if the result list has only one element, use it */
        if (length(ret) = 1)
        {
            "(<<ret[1].thedesc>>)\n";
            return ret;
        }

        /* we didn't find any useful answer; use the default processing */
        return DISAMBIG_CONTINUE;
    }
;

