#charset "us-ascii"

//----------------------------------------------------------------------
// QTALKVERBS.T
// Part of a set of files including:
//   Qtalk.t, Qtalkverbs.t, Qtalk.h, & Qtalkdemo.t
// A set of files for conversation menus in TADS 3
// Version 2
// by Greg Boettcher
// This set of files is freeware. You may use them for any purpose 
// without permission, but please credit me.
//----------------------------------------------------------------------

#include <adv3.h>
#include <en_us.h>


////////////////////
// Ask
////////////////////

VerbRule(Ask) ('ask' | 'a') (miscWordList | ) : IAction
  execAction() { mainReport(&useTalkToMsg); }
;

replace VerbRule(AskFor)
    ' '
    : BasicProd
;
replace VerbRule(AskWhomFor)
    ' '
    : BasicProd
;
replace VerbRule(AskAbout)
    ' '
    : BasicProd
;

replace VerbRule(AskAboutImplicit)
    ' '
    : BasicProd
;

replace VerbRule(AskAboutWhat)
    ' '
    : BasicProd
;


////////////////////
// Tell
////////////////////

VerbRule(Tell) ('tell') (miscWordList | ) : IAction
  execAction() { mainReport(&useTalkToMsg); }
;

replace VerbRule(TellAbout)
    ' '
    : BasicProd
;
replace VerbRule(TellAboutImplicit)
    ' '
    : BasicProd
;
replace VerbRule(TellAboutWhat)
    ' '
    : BasicProd
;

////////////////////
// TalkTo
////////////////////

modify VerbRule(TalkTo)
    ('greet' | 'say' 'hello' 'to' | 'talk' 'to' | 't' 'to'
      | 't') singleDobj
    : //TalkToAction
    //verbPhrase = 'talk/talking (to whom)'
    //askDobjResponseProd = singleNoun
    construct()
    {
        // set up the empty direct object phrase
        dobjMatch = new EmptyNounPhraseProd();
        dobjMatch.responseProd = singleNoun;
    }
;

////////////////////
// Hello
////////////////////

modify HelloAction
  execAction() {
    mainReport(&useTalkToMsg);
  }
;

////////////////////
// Goodbye
////////////////////

modify GoodbyeAction
  execAction() {
    mainReport(&useTalkToMsg);
  }
;

////////////////////
// Yes
////////////////////

modify YesAction
  execAction() {
    mainReport(&useTalkToMsg);
  }
;

////////////////////
// No
////////////////////

modify NoAction
  execAction() {
    mainReport(&useTalkToMsg);
  }
;

////////////////////
// Topics
////////////////////

modify TopicsAction
  execSystemAction() {
    mainReport(&useTalkToMsg);
  }
;

////////////////////
// NPC commands (e.g., "BOB, GO NORTH")
////////////////////

modify Actor 
  obeyCommand(fromActor, action) { 
    //"It is not necessary to give orders to other 
    //  characters in this game. ";
    mainReport(&doNotGiveCommandMsg);
    return nil; 
  }
; 

////////////////////
// Thing/Actor modifications due to Qtalkverbs.t verb modifications.
// These should be unnecessary, as the verb rules have been modified
// so that these situations should never arise. But they're here
// just for good measure.
////////////////////

modify Thing
  dobjFor(Tell) {
    verify() { illogical(&notAddressableMsg, self); }
  }
  dobjFor(TellAbout) {
    verify() { illogical(&notAddressableMsg, self); }
  }
  dobjFor(Ask) {
    verify() { illogical(&notAddressableMsg, self); }
  }
  dobjFor(AskFor) {
    verify() { illogical(&notAddressableMsg, self); }
  }
  dobjFor(AskAbout) {
    verify() { illogical(&notAddressableMsg, self); }
  }
  //dobjFor(TalkTo) {
  //  verify() { illogical(&notAddressableMsg, self); }
  //}
;

modify Actor
  dobjFor(Tell) {
    verify() { illogical(&useTalkToMsg); }
  }
  dobjFor(TellAbout) {
    verify() { illogical(&useTalkToMsg); }
  }
  dobjFor(Ask) {
    verify() { illogical(&useTalkToMsg); }
  }
  dobjFor(AskFor) {
    verify() { illogical(&useTalkToMsg); }
  }
  dobjFor(AskAbout) {
    verify() { illogical(&useTalkToMsg); }
  }
  dobjFor(TalkTo) {
    //verify() {}
    action() { say(&canSayNoQuip); }
  }
;



