#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// DEBUG STUFF
// OTHER STUFF

// -------------------------------------------------------------------
// DEBUG STUFF
// -------------------------------------------------------------------

#ifdef __DEBUG
fmObj: Decoration 'fm' 'fm' @floorMazeStart;

#endif // __DEBUG

// -------------------------------------------------------------------
// OTHER STUFF
// -------------------------------------------------------------------

class FloorMazeRoom: Room
  bannerValue = floor
  //floorMazeAdj = 'gigantic'
  floorMazeAdjCaps = 'Sprawling Mega-'
  enteringRoom(traveler) {
    nbmBanner.updateMe();
  }
  firstRoomInThisMazeSet = floorMazeStart
  potentialScoreProp = &potentialScoreFloor
  initialPsp = &initialPotentialScoreFloor
  holeSound = 'the sound of wheels rolling across a barren floor'
  roomDesc {
    "Your bot is in a maze that seems to go on forever.
      Lines are painted on the floor as far as the eye can
      see. It is an overwhelming sight. 
      Paths here lead <<pathDirs>>. ";
  }
  resetThisMazeSet {
    // Believe it or not, there is only one variable to change here.
    glob.floorHintState = 0;
    inherited();
  }
  giveHint {
    glob.floorHintState++;
    switch (glob.floorHintState) {
      case 1:
        "Sheila says, <.q>This maze is easier than it looks. 
          First of all, read the room description carefully. 
          Also, feel free to explore.<./q> ";
        if (glob.(potentialScoreProp) > (glob.(initialPsp) - 20))
          glob.(potentialScoreProp) = glob.(initialPsp) - 20;
        break;
      case 2:
        "Sheila says, <.q>If you read the room description, 
          you<./s>ll see something odd about the walls 
          of the maze.<./q> ";
        if (glob.(potentialScoreProp) > (glob.(initialPsp) - 40))
          glob.(potentialScoreProp) = glob.(initialPsp) - 40;
        break;
      case 3:
        "Sheila says, <.q>I<./s>ve given you all the hints I can.
          All I can do now is give you the complete solution.
          Is that what you want?<./q> ";
        if (!sayYesOrNo()) {
          "<.q>No problem,<./q> says Sheila. <.q>Back to the game, 
            then!<./q> ";
          glob.floorHintState--;
        }
        else {
          giveCompleteSolution();
        }
        break;
      default:
        giveCompleteSolution();
        break;
    }
  }
  giveCompleteSolution {
    "<.q>Okay, here<./s>s the solution,<./q> says Sheila.
      <.q>Just go north. That<./s>s it. The walls of the maze 
      aren<./s>t actually walls. They<./s>re just lines 
      on the floor, so I can wheel right over them, 
      no problem.<./q> ";
    glob.(potentialScoreProp) = 0;
  }
;

linesOnFloor: MultiLoc, Fixture
  'line lines path paths on the floor -'
  'lines on the floor'
  "Looking closer at the lines that make up the maze,
    your bot becomes all the more conscious that they
    are just painted on the floor and do not represent
    any barrier that your bot couldn<./s>t simply
    wheel right across if she wanted to. "
  isPlural = true
  locationList = [
     floorMazeStart
    ,floorMazeW
    ,floorMazeE
    ,floorMazeNW
    ,floorMazeNE
  ]
;

modify glob
  floorHintState = 0
;

class FloorMazeExitRoom: FloorMazeRoom
  roomName = (floorMazeAdjCaps + 'Maze, 43 Across, 85 Up')
;

class FloorConnAlreadyNear: NoTravelMessage
  travelDesc =
    "<.q>I<./s>m already near the <<dirStr>> of the maze,<./q> 
      says Sheila. <.q>I can see from here that 
      there<./s>s no cause to go further in that direction.<./q> "
  dirStr = 'boundary' // override
;

class FloorConnBacktrack: NoTravelMessage
  travelDesc =
    "<.q>What, go back <<dirStr>>? No way!<./q> cries Sheila. 
      <.q>I just spent several minutes getting out of there. 
      Anyway, I<./s>m sure the exit is to the north. 
      That<./s>s how it always is in these mazes.<./q> "
  dirStr = 'in that direction' // override
;

class ApparentConn: object
  isConnectorApparent(origin, actor) { return true; }
;
class NonapparentConn: object
  isConnectorApparent(origin, actor) { return nil; }
;

class FloorConnToRoom: TravelMessage
  travelDesc {
    if (dirStr == 'east' || dirStr == 'west')
      "Sheila starts off <<dirStr>> along the path. 
        After going some distance, she says, 
        <.q>Hey, wait a minute! These lines are just painted 
        on the floor! I could go right over them!<./q> ";
    else
      "Sheila looks to the <<dirStr>>, then says, 
        <.q>Hey, I could do that, couldn<./s>t I? 
        These lines are just painted on the floor. 
        I can go right over them!<./q> ";
    "And with that, she happily wheels along further <<dirStr>>, 
      across the lines of the maze. ";
    "In a few minutes, she has come more or less to the ";
    if (dirStr == 'east' || dirStr == 'west')
      "south<<dirStr>> corner. ";
    else
      "<<dirStr.substr(6)>>ern edge. ";
  }
  dirStr = 'in that direction' // override
;
class FloorConnToOutside: FakeConnector
  travelDesc {
    if (bot.getOutermostRoom == floorMazeStart) {
      "Sheila looks to the <<dirStr>>, then says, 
        <.q>Hey, I could do that, couldn<./s>t I? 
        These lines are just painted on the floor. 
        I can go right over them!<./q> ";
      "And with that, she happily wheels along to the <<dirStr>>, 
        across the lines of the maze. ";
    }
    else {
      "Sheila wheels off to the <<dirStr>>, over the lines 
        of the maze. ";
    }
    "<p>After several long minutes of travel, Sheila cries, 
        <.q>Hey, there it is! I think I see the exit from here!<./q> ";
    if ((bot.getOutermostRoom == floorMazeStart && dirStr == 'north') ||
        (bot.getOutermostRoom == floorMazeNW    && dirStr == 'northeast') ||
        (bot.getOutermostRoom == floorMazeNE    && dirStr == 'northwest')) {
      "<p>With that, she chugs off ever faster to the <<dirStr>>. ";
    }
    else {
      "<p>With that, she picks up her speed and angles off 
        to the ";
      if (dirStr != 'north')
        "north. ";
      else switch (bot.getOutermostRoom) {
        case floorMazeW : "northeast. "; break;
        case floorMazeE : "northwest. "; break;
        case floorMazeNW: "east. ";      break;
        case floorMazeNE: "west. ";      break;
      }
    }
    "After several more minutes, she speeds through the exit, 
        as if through a finish line. <.q>Woo hoo! I did it!<./q> 
        she cries. 
      <p>Unfortunately, just at that moment, a trap door 
        opens up beneath her feet. She sails through the trap door 
        and falls down and down . . . ";
    
    bot.moveIntoForTravel(destination);
    nbmBanner.updateMe;
    returnToCaveVictoriously('Oof. Well, so much for that maze.');
  }
  dirStr = 'in that direction' // override
;

floorMazeStart: FloorMazeRoom
  roomName = (floorMazeAdjCaps + 'Maze, 43 Across, 1 Up')
  pathDirs = "west and east"
  north     : FloorConnToOutside { destination = floorMazeN  dirStr = 'north' }
  west      : ApparentConn, FloorConnToRoom { destination = floorMazeW  dirStr = 'west' }
  east      : ApparentConn, FloorConnToRoom { destination = floorMazeE  dirStr = 'east' }
  northwest : FloorConnToRoom { destination = floorMazeNW dirStr = 'northwest' }
  northeast : FloorConnToRoom { destination = floorMazeNE dirStr = 'northeast' }
;
floorMazeW: FloorMazeRoom
  roomName = (floorMazeAdjCaps + 'Maze, 3 Across, 3 Up')
  pathDirs = "north and south"
  north     : ApparentConn, FloorConnToOutside { destination = floorMazeW_N  dirStr = 'north' }
  northeast : FloorConnToOutside { destination = floorMazeW_NE dirStr = 'northeast' }
  northwest : FloorConnAlreadyNear { dirStr = 'western edge' }
  west      : FloorConnAlreadyNear { dirStr = 'western edge' }
  southwest : FloorConnAlreadyNear { dirStr = 'southwest corner' }
  south     : ApparentConn, FloorConnAlreadyNear { dirStr = 'southern edge' }
  southeast : FloorConnAlreadyNear { dirStr = 'southern edge' }
  east      : FloorConnBacktrack { dirStr = 'east' }
;
floorMazeE: FloorMazeRoom
  roomName = (floorMazeAdjCaps + 'Maze, 83 Across, 3 Up')
  pathDirs = "north and south"
  north     : ApparentConn, FloorConnToOutside { destination = floorMazeE_N  dirStr = 'north' }
  northwest : FloorConnToOutside { destination = floorMazeE_NW dirStr = 'northwest' }
  northeast : FloorConnAlreadyNear { dirStr = 'eastern edge' }
  east      : FloorConnAlreadyNear { dirStr = 'eastern edge' }
  southeast : FloorConnAlreadyNear { dirStr = 'southeast corner' }
  south     : ApparentConn, FloorConnAlreadyNear { dirStr = 'southern edge' }
  southwest : FloorConnAlreadyNear { dirStr = 'southern edge' }
  west      : FloorConnBacktrack { dirStr = 'west' }
;
floorMazeNW: FloorMazeRoom
  roomName = (floorMazeAdjCaps + 'Maze, 4 Across, 42 Up')
  pathDirs = "north and south"
  north     : ApparentConn, FloorConnToOutside { destination = floorMazeNW_N  dirStr = 'north' }
  northeast : FloorConnToOutside { destination = floorMazeNW_NE dirStr = 'northeast' }
  east      : FloorConnToOutside { destination = floorMazeNW_E  dirStr = 'east' }
  northwest : FloorConnAlreadyNear { dirStr = 'western edge' }
  west      : FloorConnAlreadyNear { dirStr = 'western edge' }
  southwest : FloorConnAlreadyNear { dirStr = 'western edge' }
  south     : ApparentConn, FloorConnBacktrack { dirStr = 'south' }
  southeast : FloorConnBacktrack { dirStr = 'southeast' }
;
floorMazeNE: FloorMazeRoom
  roomName = (floorMazeAdjCaps + 'Maze, 82 Across, 42 Up')
  pathDirs = "west and east"
  north     : FloorConnToOutside { destination = floorMazeNE_N  dirStr = 'north' }
  northwest : FloorConnToOutside { destination = floorMazeNE_NW dirStr = 'northwest' }
  west      : ApparentConn, FloorConnToOutside { destination = floorMazeNE_W  dirStr = 'west' }
  northeast : FloorConnAlreadyNear { dirStr = 'eastern edge' }
  east      : ApparentConn, FloorConnAlreadyNear { dirStr = 'eastern edge' }
  southeast : FloorConnAlreadyNear { dirStr = 'eastern edge' }
  south     : FloorConnBacktrack { dirStr = 'south' }
  southwest : FloorConnBacktrack { dirStr = 'southwest' }
;

floorMazeN    : FloorMazeExitRoom;
floorMazeW_N  : FloorMazeExitRoom;
floorMazeW_NE : FloorMazeExitRoom;
floorMazeE_N  : FloorMazeExitRoom;
floorMazeE_NW : FloorMazeExitRoom;
floorMazeNW_N : FloorMazeExitRoom;
floorMazeNW_NE: FloorMazeExitRoom;
floorMazeNW_E : FloorMazeExitRoom;
floorMazeNE_N : FloorMazeExitRoom;
floorMazeNE_NW: FloorMazeExitRoom;
floorMazeNE_W : FloorMazeExitRoom;

floorMapPrint() {
  local str;
  str = '<img src="floor/';
  switch (gPlayerChar.getOutermostRoom()) {
    case floorMazeW:     str=str+'floorW';     break;
    case floorMazeE:     str=str+'floorE';     break;
    case floorMazeNW:    str=str+'floorNW';    break;
    case floorMazeNE:    str=str+'floorNE';    break;
    case floorMazeN:     str=str+'floorN';     break;
    case floorMazeW_N:   str=str+'floorW_N';   break;
    case floorMazeW_NE:  str=str+'floorW_NE';  break;
    case floorMazeE_N:   str=str+'floorE_N';   break;
    case floorMazeE_NW:  str=str+'floorE_NW';  break;
    case floorMazeNW_N:  str=str+'floorNW_N';  break;
    case floorMazeNW_NE: str=str+'floorNW_NE'; break;
    case floorMazeNW_E:  str=str+'floorNW_E';  break;
    case floorMazeNE_N:  str=str+'floorNE_N';  break;
    case floorMazeNE_NW: str=str+'floorNE_NW'; break;
    case floorMazeNE_W:  str=str+'floorNE_W';  break;
    case floorMazeStart: 
    default:             str=str+'floorstart'; break;
    //case xxxxxxxxxxxxxxx: str=str+'xxxxxxxxxxxxxxx'; break;
    //case xxxxxxxxxxxxxxx: str=str+'xxxxxxxxxxxxxxx'; break;
    //case xxxxxxxxxxxxxxx: str=str+'xxxxxxxxxxxxxxx'; break;
    //case xxxxxxxxxxxxxxx: str=str+'xxxxxxxxxxxxxxx'; break;
    //case xxxxxxxxxxxxxxx: str=str+'xxxxxxxxxxxxxxx'; break;
    //case xxxxxxxxxxxxxxx: str=str+'xxxxxxxxxxxxxxx'; break;
    //case xxxxxxxxxxxxxxx: str=str+'xxxxxxxxxxxxxxx'; break;
    //case xxxxxxxxxxxxxxx: str=str+'xxxxxxxxxxxxxxx'; break;
    //case xxxxxxxxxxxxxxx: str=str+'xxxxxxxxxxxxxxx'; break;
    //case xxxxxxxxxxxxxxx: str=str+'xxxxxxxxxxxxxxx'; break;
    //case xxxxxxxxxxxxxxx: str=str+'xxxxxxxxxxxxxxx'; break;
    //case xxxxxxxxxxxxxxx: str=str+'xxxxxxxxxxxxxxx'; break;
    //case xxxxxxxxxxxxxxx: str=str+'xxxxxxxxxxxxxxx'; break;
    //case xxxxxxxxxxxxxxx: str=str+'xxxxxxxxxxxxxxx'; break;
    //case xxxxxxxxxxxxxxx: str=str+'xxxxxxxxxxxxxxx'; break;
    //case xxxxxxxxxxxxxxx: str=str+'xxxxxxxxxxxxxxx'; break;
  }
  str = str + '.png" width="361" height="368" border="0">';
  str = str + doCompass(true);
  return str;
}

