/* animate.t, v1.0
	An animation library for HTML TADS by Gabriel McKean
	created 4-16-00

	This library is intended to give HTML TADS some limited animation ability.
	At present HTML TADS has no built-in animation capabilities, but this is
	likely to change in the near future, with the support of MNG or something
	similar.  Hopefully this library will help some people add animation to
	their games in the meantime.

	This library is public-domain, so feel free to use and modify it however
	you want.  Of course, if you use it in a game, it's only polite to mention
	me somewhere in it :)

	How to use:
	This library uses banners to display animations.  A banner in which the
	animation is to take place must be created and given a unique ID (see
	the HTML TADS notes on banners).  Then the function 'animation' may be
	called to display an animation within that banner.  The function takes
	the following arguments:

	banner_id: this is a string containing the unique id you gave to the banner.

	anim_list: this is a list of strings which contain the file names of
	the images you wish to animate, in the order you want to animate them in.
	These images will be aligned with the top of the banner and centered from
	left to right, so take this into account.

	delay: the delay, in milliseconds, between 'frames' of animation.

	banner_attribs: a string containing the HTML attributes of the banner.
	Each time a banner is accessed, it's attributes are reset, so if your banner
	has non-default attributes you have to specify them here or in body_attribs.

	body_attribs: similar to banner_attribs, this string contains the HTML
	attributes of the body of your banner.  Useful for setting the background
	color of the banner.


	Limitaions of this library:
	No input can be accepted during an animation, and only one banner can be
	animated at a time.  Also, an image which is output on the default text
	stream can't be animated.  There may or may not be ways around these
	limitations given the current capabilities of HTML TADS, but I can't
	think of any right now.

	Thanks to:
	Michael Roberts, for putting so much work into the variations incarnations
	of TADS, and for hopefully making this library obsolete in the
	not-to-distant future :)

	Neil K. Guy, for providing so much info on TADS on his website
	(www.tela.bc.ca/tela/tads), and for proving that this was possible in his
	game Six Stories.

	timsim, for badgering the raif newsgroup with good questions, thus inspiring
	me to create this libary.  Hope you'll find it useful!
*/

#pragma C+

animate: function(banner_id, anim_list, delay, banner_attribs, body_attribs)
{
	local i, n;
	i = 1; // animation list index
	n = length(anim_list); // length of the animation list

	// display each 'frame' of animation by displaying it in the banner,
	// waiting, and then displaying the next frame in the same banner
	for ( ; i <= n ; i++ )
	{
		"<BANNER ID=";
		say(banner_id);
		" ";
		say(banner_attribs);
		">";

		"<BODY ";
		say(body_attribs);
		">";

		"<CENTER><IMG SRC=\"";
		say(anim_list[i]);
		"\"></CENTER>";

		"</BANNER>";

		// output an HTML comment to the text stream after each frame to force
		// the text window to refresh
		"<!-- -->";

		timeDelay(delay);
	}
}

#pragma C-
