! Main Functions

IFNDEF VERSION5;
Include "V6.h";
ENDIF;

IFNDEF PARAGRAPH_INDENT;
 Constant PARAGRAPH_INDENT = 3;
ENDIF;

!-----------------------------
!  Default TitlePage
!-----------------------------

#ifndef TitlePage;

[ TitlePage i;
#ifdef DEBUG;
 Centre(33);
 Bold("-- THIS IS A DEBUGGING VERSION --");
#endif;
Fmt_(6);

MainGameWin.SetFontStyle(ST_BOLD | ST_ITALIC | ST_FIXED); 

Centre(STORY);
MainGameWin.SetFontStyle(ST_ROMAN); 

print (Fmt_) 8, "-- This game has two display options: Normal, and Novel. This can be changed at any time using the LAYOUT command.", (Fmt_) 2;

MainGameWin.SetFontStyle(ST_BOLD | ST_FIXED); 

print " Start Game - in Novel Mode  :   [SPACE]   -  with Alternate off", (Fmt_) 1;
print "                             :     A       -  with Alternate on", (Fmt_) 1;
print "            - in Normal Mode :     N", (Fmt_) 1;
print "            - from Saved     :     R", (Fmt_) 1;
print " Exit Game                   :     Q", (Fmt_) 1;

upperprompt = 1;
MainGameWin.SetFontStyle(ST_ROMAN); 

@read_char 1 1 Randomise i; 
#ifndef VERSION5;
MainGameWin.HideCursor();
#endif;
if (i=='q' or 'Q') { new_line; quit;  }
if (i=='a' or 'A') boldflag = 1;
if (i=='n' or 'N') upperprompt = 0;

MainGameWin.Erase();

if (i=='r' or 'R') RestoreSub();

];
#endif;

[ Randomise k;
 k = random(100); rfalse;
];
!-----------------------
! The Summary verb
!------------------------

#ifndef SUMMARY_ON;
Verb meta 'summary' 'status' 
*	-> Summary;
#endif;

#ifndef SummarySub;
[CoreSum x;
	x = parent(player);
	if (x~=location) 
	{ print "- ";
	  if (x has supporter) print "on "; else print "in ";
	  print (the) x, " ";
	}
	if (location provides status) location.status();
];

ifdef SUMMARY_ON;

 [ SummarySub win;
    	SummaryWin.Activate(); SummaryWin.Erase();
	@output_stream 3 centre_text;
	print (name) location, " ";
	CoreSum();
	@output_stream -3;
	Centre(centre_text-->0);
	print (name) location, " "; 
	CoreSum();
	win.Activate();
 ];

ifnot;

[ SummarySub;
 StatFont(1);
 print " Location: ", (name) location, " ";
 CoreSum();
 StatFont(2);
 if (~~upperprompt) new_line;
 else @read_char 1 0 0 keypressed;
 StatFont(1); StatFont(2); StatFont(-1);
];

endif;
#endif;

!-------------------------------------
!	Input-line functions
!-------------------------------------

[ DrawStatusLine k i j; 
k = k; i = ActiveZWindow.GetXCursor(); j = ActiveZWindow.GetYCursor();
#ifdef SUMMARY_ON;
 k = ActiveZWindow; SummarySub(k);
 j = j - SUMMARY_ON;
#endif;
#ifdef VERSION5;
 if (ActiveZWindow == InputWin)  InputWin.SetCursor(j, i);
 if (~~upperprompt) style roman;
#endif;
 rtrue; 
];

[ ManualBuffer i j fk letct indent;
! return -1 if parser should take over as per usual.

if (keypressed~=0) fk=keypressed; else @read_char 1 0 0 fk; keypressed=0;
    needapress = 5;
    StatFont(1);
    L__M(##Prompt);
    AfterPrompt();
    if (~~(fk > 32 && fk < 127))
!    if (~~((fk > 96 && fk < 123) || (fk >64 && fk < 91))) 
	{  StatFont(-1, 1);
 	   return -1;
 	}
    print (char) fk;
    if (fk > 64 && fk < 91) fk = fk + 32;
    (buffer -> 2) = fk; letct=1;
     if (player==selfobj) indent=1; else indent=2;   !spaces taken up by prompt

!letct counts the letters in the word
!KeyboardPrimitive(a_buffer, a_table);
! Instead we have something to read it all in with.
! 13 - return, 8 - backspace, characters lie 97-122 inc (lower) & 65-90

	do
{ @read_char 1 0 0 i;
  switch(i)
  { 
13:   StatFont(2); StatFont(-1,1); 
	buffer->1=letct; Tokenise__ (buffer, parse); rtrue;
8:    j=indent+letct;
	InputWin.SetCursor(1, (j-1) * InputWin.GetCharWidth());
      print "   "; 
	InputWin.SetCursor(1, (j-1) * InputWin.GetCharWidth());
	letct--;
 
!65 to 90, 97 to 122, 32,44,46,39:
32 to 126:
      print (char) i; letct++; 
      if (i > 64 && i < 91) i = i + 32;
	buffer->(letct+1) = i; 
  }
} until (letct==0);

return -1;

];

[ BeforeParsing;
 needapress=parse->( (parse->1) * 4 + 1) + WordLength(parse->1) + 2;
#ifdef BeforeParse;
 return BeforeParse();
#endif;
 rfalse;
];

!-------------------------------------
!	Alternate & novel/normal mode functions
!------------------------------------

ifdef LMode1;
Extend only 'normal' replace
* -> Form;
endif;

Verb meta 'layout' 'novel' *	-> Form;

[ FormSub k; 
  if ((verb_word=='normal' && ~~upperprompt) || (verb_word=='novel' && upperprompt)) 
		return Stat("The game is currently in that mode already.",1);
  upperprompt=1 - upperprompt; 
  if (~~upperprompt) 
	{ CR(); InputWin.Erase(); 
	  #ifdef VERSION5; #ifdef SUMMARY_ON; k = SUMMARY_ON; #endif; @split_window k; #ENDIF;
	}
  else 
	{	  #ifdef VERSION5; #ifdef SUMMARY_ON; k = SUMMARY_ON + 2; #endif; @split_window k; #ENDIF;
		k = k;
		
	}
  FlipBold(); FlipBold();
];

[ FlipBold;
 if (~~upperprompt) boldflag = -1;
#ifdef VERSION5;
 style roman;
 if (boldflag==-1) rtrue;
#IFNOT;
 if (boldflag==-1) { MainGameWin.SetFontStyle(ST_ROMAN); rtrue; }
#ENDIF;
 if (boldflag==0)
 { boldflag = 1; MainGameWin.SetFontStyle(ST_BOLD);
 }  else  {
   boldflag = 0; MainGameWin.SetFontStyle(ST_ROMAN);
 }
];

Verb meta 'alternate'
* 	-> Alternate;

[ AlternateSub;
 if (~~upperprompt) print_ret "-- Alternating is not available in ", (Bold) "NORMAL", " mode.";
 if (boldflag > -1) { boldflag=-1; return Stat("[ALTERNATE now off.]"); }
 boldflag = 1; 
 return Stat("[ALTERNATE now on.]"); 
];

!-------------------------------------
! 	Paragraphing Functions
!-------------------------------------

[ Convert flag;
 if (flag==1)
 { if (Margin has general) rtrue;
   give Margin general;  
 }
 else give Margin ~general;
 FlipBold();
];

! Store the cursor position that the carriage return left us in. Then, in Start, if we're already there, don't print a 
!carriage return. Simple! And no Conversion!

[ OnMargin;
 if (Margin.px == MainGameWin.GetXCursor() && Margin.py == MainGameWin.GetYCursor()) 
 {  give Margin on;  rtrue;
 }
 give Margin ~on;
 rfalse;
];

Object Margin with px 0, py 0, kflag 0;
!Has on if OnMargin found text at the margin on the last call
!Has general for tracking Conversions.

[ Fmt_ k; 
 for (:k--:k~=0) new_line;
];

[ CR i; i = 1; CR_(); ];

[ CR_ ;
 if (OnMargin()) rtrue;
 new_line;
#ifdef PARAGRAPH_SYMBOL;
 if (upperprompt) 
 {    style roman;
	print (string) PARAGRAPH_SYMBOL; 
	FlipBold(); FlipBold();
      SetMargin();
	rtrue; 
 }
#endif;
 spaces(PARAGRAPH_INDENT); 
 SetMargin();
 rtrue;
];

[ SetMargin;
 Margin.px = MainGameWin.GetXCursor();
 Margin.py = MainGameWin.GetYCursor();
];

[ PF txt;  print (string) txt; rtrue; ]; 

!-------------------------------------
!	Status-line formatting functions
!-------------------------------------

[ StatFont y flag x;
! flag=0 and y=-1 -> DeConvert

if (~~upperprompt) 
{ if (y == -1) CR();
  rtrue;
}

if (y==-1) 
{ if (flag==0)
  { Convert(1); lastref = pre_noun; 
  }
  MainGameWin.Activate(); rtrue;
}

if (x==0) x=2;
#ifdef VERSION5;
 #ifdef SUMMARY_ON;
   if (y==0) y = 1;
   !else y = y + SUMMARY_ON; 
 #endif;
#endif;

InputWin.Activate();

if (flag~=35)
 { if (y == 1) flag = 0; else flag=1;
   InputWin.SetCursor(((y-1) * InputWin.GetCharHeight()) + 1, 1);
   spaces 0->33;
 }
else 
 { flag=needapress%100;
   if (needapress < 100) needapress=100 + needapress;
 }
InputWin.SetCursor(((y-1) * InputWin.GetCharHeight()) + 1, ( (flag) * InputWin.GetCharWidth()) + 1);

];

[ Stat txt flag x z;
 ! A routine for printing messages into the status line
 ! flag, if one, suppresses resetting of the Convert buffer 
 ! -- that is, if the line is treated as an error by the parser, flag = 1
 ! x is optional, gives line message is on; assumes line 2.
 ! z is optional, gives how deep the statusline should be made. 2 is default.
 ! Inserts an automatic --  inlay for formatting.
if (x==0) x=2;
StatFont(x, 0, z);
print (string) txt;
StatFont(-1, flag);
rtrue;
];

!-------------------------
! Statline Verbs
!-------------------------

[ LMode1Sub; lookmode=1; StatFont(2); print (string) Story; L__M(##LMode1); ];  ! Brief

[ LMode2Sub; lookmode=2; StatFont(2); print (string) Story; L__M(##LMode2); ];  ! Verbose

[ LMode3Sub; lookmode=3; StatFont(2); print (string) Story; L__M(##LMode3); ];  ! Superbrief

#ifndef LookSub;

[ LookSub allow_abbrev  visibility_levels i j k;
  if (parent(player)==0) return RunTimeError(10);

  .MovedByInitial;
  if (location == thedark) { visibility_ceiling = thedark; NoteArrival(); }
  else
  {   visibility_levels = FindVisibilityLevels();
      if (visibility_ceiling == location)
      {   NoteArrival();
          if (visibility_ceiling ~= location) jump MovedByInitial;
      }
  }

  !   Printing the top line: e.g.
  !   Octagonal Room (on the table) (as Frodo)

!  new_line;
!  style bold;
!  if (visibility_levels == 0) print (name) thedark;
!  else
!  {   if (visibility_ceiling ~= location) print (The) visibility_ceiling;
!      else print (name) visibility_ceiling;
!  }
!  style roman;

!  for (j=1, i=parent(player):j<visibility_levels:j++, i=parent(i))
!      if (i has supporter) L__M(##Look,1,i);
!                      else L__M(##Look,2,i);

!  if (print_player_flag==1) L__M(##Look,3,player);
!  new_line;

  !   The room description (if visible)

  if (lookmode<3 && visibility_ceiling==location)
  {   if ((allow_abbrev~=1) || (lookmode==2) || (location hasnt visited))
      {   if (location.describe~=NULL) RunRoutines(location,describe);
          else
          {   if (location.description==0) RunTimeError(11,location);
              else PrintOrRun(location,description);
          }
      }
  }

  if (visibility_levels == 0) Locale(thedark);
  else
  {   for (i=player, j=visibility_levels: j>0: j--, i=parent(i))
          give i workflag;
      
      for (j=visibility_levels: j>0: j--)
      {   for (i=player, k=0: k<j: k++) i=parent(i);
          if (i.inside_description~=0)
          {   new_line; PrintOrRun(i,inside_description); }
          Locale(i);
      }
  }

  LookRoutine();
  ScoreArrival();

  action=##Look;
  if (AfterRoutines()==1) rtrue;
];

#endif;

#ifndef InvSub;
[ InvSub x k;
  if (child(player)==0) return L__M(##Inv,1);

  if (inventory_style==0) return InvWideSub();

  if ((inventory_style == FULLINV_BIT + INDENT_BIT + NEWLINE_BIT + RECURSE_BIT) && upperprompt==1)
 	  k = FULLINV_BIT + ENGLISH_BIT + RECURSE_BIT;	
  else k = inventory_style;

  L__M(##Inv,2);
  if (k & NEWLINE_BIT ~= 0) print ":^"; else print " ";

  WriteListFrom(child(player), k, 1);
  if (k & ENGLISH_BIT ~= 0) print ".^";

#IFNDEF MANUAL_PRONOUNS;
  objectloop(x in player) PronounNotice(x);
#ENDIF;
  x = 0; ! To prevent a "not used" error
  AfterRoutines();
];
#endif;

[ YesOrNo txt i;
  for (::)
  {   if (txt~=0) 
      { StatFont(1); print (string) txt;
      }
	if (location == nothing || parent(player) == nothing) read buffer parse;
      else read buffer parse DrawStatusLine;
      i=parse-->1;
	if (~~upperprompt) MainGameWin.Activate(); 
      if (i==YES1__WD or YES2__WD or YES3__WD) rtrue;
      if (i==NO1__WD or NO2__WD or NO3__WD) rfalse;
      L__M(##Quit,1); !print "> ";
  }
];

[ ItorName obj;
 if (obj == player) print "yourself";
 else if (obj ~= pre_noun) print (the) obj;
 else if (obj has pluralname) print "them";
 else if (obj has animate && obj hasnt neuter)
	{  if (obj has female) print "her"; else print "him";
	}
 else print "it";
];

[ CItorName obj; 
 if (obj == player) print " You";
 else if (obj ~= pre_noun) print " ", (The) obj;
 else if (obj has pluralname) print " They";
 else if (obj has animate && obj hasnt neuter)
	{  if (obj has female) print " She"; else print " He";
	}
 else print " It";
];

[ QuitSub i;
 if (i==1 || YesOrNo("Are you sure you want to quit? ")~=0) 
 { StatFont(2); print "--  "; quit;
 }
 StatFont(2); StatFont(-1); 
];

[ RestartSub; 
  if (YesOrNo("Are you sure you want to restart? ")~=0) 
  { @restart; 
    Stat("-- Restart failed."); 
  }
  StatFont(2); StatFont(-1); 
];

[ RestoreSub;
  StatFont(1); 
  restore Rmaybe;
  return L__M(##Restore,1);
  .RMaybe; L__M(##Restore,2);
];

[ SaveSub flag;
  StatFont(1);
  @save -> flag;
  switch (flag) {
      0: L__M(##Save,1);
      1: L__M(##Save,2);
      2: L__M(##Restore,2);
  }
];

[ Banner i;
StatFont(1);
   if (Story ~= 0)
   {
#IFV5; style bold; #ENDIF;
   print (string) Story, " -- ";
#IFV5; style roman; #ENDIF;
   }
   if (Headline ~= 0)
       print (string) Headline;
if (upperprompt) StatFont(2); else new_line;
   print "Release ", (0-->1) & $03ff, " / Serial number ";
   for (i=18:i<24:i++) print (char) 0->i;
   print " / Inform v"; inversion;
   print " Library ", (string) LibRelease, " ";
#ifdef STRICT_MODE;
   print "S";
#endif;
#ifdef INFIX;
   print "X";
#ifnot;
#ifdef DEBUG;
   print "D";
#endif;
#endif;
if (upperprompt) @read_char 1 0 0 i; else  new_line;

];

[ VersionSub k x;

Banner();
if (k==0) { StatFont(2); StatFont(1); }
  if (standard_interpreter > 0)
      print "Standard interpreter ",
          standard_interpreter/256, ".", standard_interpreter%256,
          " (", 0->$1e, (char) 0->$1f, ") / ";
  else print "Interpreter ", 0->$1e, " Version ", (char) 0->$1f, " / ";
  print "Library serial number ", (string) LibSerial, "^";
if (upperprompt && k==0) 
{  StatFont(2); print "-- [Press any key]";
   @read_char 1 0 0 x;
}
#IFDEF LanguageVersion;
  print (string) LanguageVersion, "^";
#ENDIF;
if (k==0) { StatFont(2); StatFont(-1); }
];

[ ScriptOnSub;
  transcript_mode = ((0-->8) & 1);
  if (transcript_mode) return L__M(##ScriptOn,1);
  @output_stream 2;
  if (((0-->8) & 1) == 0) return L__M(##ScriptOn,3);
  L__M(##ScriptOn,2); VersionSub(1);
  transcript_mode = true;
];

!-----------------------------
! NovelInit - I think so
!-----------------------------

[ NovelInit;
 lookmode = 2;
#ifdef VERSION5;
 scry = 0->$20; scrx = 0->$21;
 MainGameWin = MainWin;
 PreZWinStyle.Activate();
#ifnot;
 scrx = $22-->0; scry = $22-->1;
if ($1e->0 == MT_Amiga)
MainGameWin = MainWin; 
else MainGameWin = ZWin3;
 V6Init(PreZWinStyle);
#endif;
 MainGameWin.Activate();
 MainGameWin.Erase();
 TitlePage();
 MyZWinStyle.Activate();
 StatFont(1); StatFont(2); StatFont(-1);
 rfalse;
];

[ Centre k i j;
 if (metaclass(k)==String)
 { @output_stream 3 centre_text;
   print (string) k;
   @output_stream -3;
   i = centre_text-->0; 
 }
 else i = k;
 ! i = num of characters in the line of text to be indented for
 ! scrx = width in units of screen
 ! so 2C + (i * fontwidth) = scrx 

 #ifdef VERSION5;
  if (ActiveZWindow == MainWin)
	{ spaces((scrx- i) / 2); jump ptext;
	}
 #endif;

 j = (scrx - (i * ActiveZWindow.GetCharWidth()))/2;  
 ActiveZWindow.SetCursor(0, j); 
.ptext;
 if (metaclass(k)==String) print (string) k;
];


#ifndef STORY;
 Constant STORY = "A NOVEL-mode game";
#endif;

Include "NovelPar.h";
Include "NovelEng.h";

[ Italic txt;
MainGameWin.SetFontStyle(ST_ITALIC);
print (string) txt; 
MainGameWin.SetFontStyle(ST_ROMAN);
FlipBold(); FlipBold();
];

[ Bold txt;
MainGameWin.SetFontStyle(ST_BOLD);
print (string) txt; 
MainGameWin.SetFontStyle(ST_ROMAN);
FlipBold();FlipBold();
];


