/*
 * Decompiled with CFR 0.152.
 */
package zpplet.system;

import zpplet.machine.ZMachine;
import zpplet.misc.ZError;
import zpplet.system.ZFont;
import zpplet.system.ZScreen;

public class ZWindow {
    protected ZMachine zm;
    protected ZScreen screen;
    public int id;
    public int top;
    public int left;
    public int width;
    public int height;
    int xpos;
    int ypos;
    protected boolean wrap;
    protected boolean scroll;
    protected boolean transcript;
    protected boolean buffer;
    int leftmargin;
    int rightmargin;
    public ZFont font;
    private ZFont morefont;
    private StringBuilder linebuffer;
    private boolean time_for_more;
    protected int line_counter;
    protected int interrupt_routine;
    protected int interrupt_count;
    protected boolean pausing;

    public ZWindow(ZMachine zm, int id) {
        this.zm = zm;
        this.screen = zm.s;
        this.id = id;
        this.width = 1;
        this.height = 1;
        this.resetLineCount();
        this.buffer = true;
        this.wrap = true;
        this.scroll = true;
        this.transcript = true;
        this.linebuffer = new StringBuilder();
        this.font = new ZFont(this.screen);
        this.morefont = new ZFont(this.screen);
        this.morefont.set(4);
        this.morefont.setStyle(1);
    }

    public void resetLineCount() {
        if (this.line_counter != -999) {
            this.line_counter = this.getLines() - 1;
        }
        this.time_for_more = false;
    }

    protected void drawMore() {
        ZFont f = this.font;
        this.font = this.morefont;
        this.screen.drawText(this.left + this.xpos + this.leftmargin, this.top + this.ypos, "[MORE]", this);
        this.font = f;
    }

    protected void promptForMore() {
        this.resetLineCount();
        if (this.zm.input == null) {
            this.pausing = true;
            this.drawMore();
            this.screen.repaint();
            this.screen.readKeyCode(0, 0);
            this.pausing = false;
            this.eraseLine();
        }
    }

    protected boolean inBounds(int x) {
        return x >= this.leftmargin && x < this.width - this.rightmargin;
    }

    public void eraseLine() {
        this.screen.eraseRegion(this.left + this.xpos, this.top + this.ypos, this.width - this.xpos, this.screen.getLineHeight(), this.font.getBack());
    }

    public void eraseLineTo(int right) {
        if (right > this.width - this.rightmargin - this.xpos) {
            right = this.width - this.rightmargin - this.xpos;
        }
        this.screen.eraseRegion(this.left + this.xpos, this.top + this.ypos, right, this.screen.getLineHeight(), this.font.getBack());
    }

    public void setWrapMode(boolean value) {
        this.flush();
        this.wrap = value;
    }

    public void setBufferMode(boolean value) {
        this.flush();
        this.buffer = value;
    }

    public void setTranscripting(boolean value) {
        this.transcript = value;
    }

    public void setScroll(boolean value) {
        this.scroll = value;
        this.resetLineCount();
    }

    public void moveTo(int left, int top) {
        this.flush();
        left = left != 0 ? (left - 1) * this.screen.unitx : this.left;
        top = top != 0 ? (top - 1) * this.screen.unity : this.top;
        this.xpos += this.left - left;
        this.ypos += this.top - top;
        this.left = left;
        this.top = top;
        if (!this.inBounds(this.xpos) || this.ypos < 0) {
            this.xpos = this.leftmargin;
            this.ypos = 0;
        }
    }

    public int getTextWidth() {
        return this.width - this.leftmargin - this.rightmargin;
    }

    public void resize(int width, int height) {
        this.flush();
        this.width = width * this.screen.unitx;
        this.height = height * this.screen.unity;
        if (!this.inBounds(this.xpos) || this.ypos >= this.height) {
            this.xpos = this.leftmargin;
            this.ypos = 0;
        }
        this.resetLineCount();
    }

    public int getLines() {
        return this.height / this.screen.getLineHeight();
    }

    public int getCursorX() {
        return this.xpos / this.screen.unitx + 1;
    }

    public int getCursorY() {
        return this.ypos / this.screen.unity + 1;
    }

    public int getPosX() {
        return this.left + this.xpos;
    }

    public int getPosY() {
        return this.top + this.ypos;
    }

    public void moveCursor(int x, int y) {
        this.flush();
        this.xpos = x == 0 ? this.xpos : (x - 1) * this.screen.unitx;
        int n = this.ypos = y == 0 ? this.ypos : (y - 1) * this.screen.unity;
        if (!this.inBounds(this.xpos)) {
            this.xpos = this.leftmargin;
        }
        this.resetLineCount();
    }

    public void printZAscii(int zascii) {
        char unicode = this.zm.zc.toOutput(zascii);
        if (unicode == '\u0000') {
            return;
        }
        if (this.buffer) {
            this.bufferChar(unicode);
        } else {
            if (this.wrap && !this.inBounds(this.xpos + this.screen.charWidth(unicode))) {
                this.newLineNoFlush();
            }
            this.drawString(String.valueOf(unicode));
        }
    }

    public void flush() {
        if (this.buffer) {
            this.drawString(this.linebuffer.toString());
            this.linebuffer.setLength(0);
        }
    }

    public void newLine() {
        this.flush();
        this.newLineNoFlush();
    }

    void countdown() {
        if (this.interrupt_count != 0 && --this.interrupt_count == 0) {
            this.zm.zi.interrupt(this.interrupt_routine);
        }
    }

    protected void newLineNoFlush() {
        if (this.zm.hd.newlineatstart) {
            this.countdown();
        }
        this.xpos = this.leftmargin;
        if (this.ypos < this.height - this.screen.getLineHeight() * 2 + 1) {
            this.ypos += this.screen.getLineHeight();
        } else if (this.scroll) {
            this.screen.scrollUp(this, this.screen.getLineHeight());
        } else {
            this.ypos = 0;
        }
        if (this.scroll && this.line_counter != -999 && this.time_for_more) {
            this.promptForMore();
        }
        if (this.line_counter != -999) {
            boolean bl = this.time_for_more = --this.line_counter == 0 || this.time_for_more;
        }
        if (!this.zm.hd.newlineatstart) {
            this.countdown();
        }
    }

    public int getStringWidth(String s) {
        return this.screen.getStringWidth(s, this.font);
    }

    /*
     * Unable to fully structure code
     */
    public int splitText(String s, int maxwidth) {
        if (this.screen.getStringWidth(s, this.font) <= maxwidth) {
            return 0;
        }
        last = s.length();
        while (true) {
            if ((space = s.lastIndexOf(32, last)) != -1) ** GOTO lbl11
            while (last > 1 && this.screen.getStringWidth(s.substring(0, last), this.font) > maxwidth) {
                --last;
            }
            return last;
lbl-1000:
            // 1 sources

            {
                --space;
lbl11:
                // 2 sources

                ** while (space > 0 && s.charAt((int)(space - 1)) == ' ')
            }
lbl12:
            // 1 sources

            if (this.screen.getStringWidth(s.substring(0, space), this.font) <= maxwidth) {
                return space;
            }
            last = space - 1;
        }
    }

    protected synchronized void bufferChar(int ch) {
        int split;
        this.linebuffer.append((char)ch);
        if (this.wrap && (split = this.splitText(this.linebuffer.toString(), this.width - this.rightmargin - this.xpos)) > 0) {
            this.drawString(this.linebuffer.substring(0, split));
            while (split < this.linebuffer.length() && this.linebuffer.charAt(split) == ' ') {
                ++split;
            }
            this.linebuffer.delete(0, split);
            this.newLineNoFlush();
        }
    }

    public void clear() {
        this.screen.eraseRegion(this.left, this.top, this.width, this.height, this.font.getBack());
    }

    public void setColor(int fg, int bg) {
        this.flush();
        if (fg == -1) {
            fg = 0;
            this.font.color.fg = this.screen.getColorAt(this.getPosX(), this.getPosY());
        }
        if (bg == -1) {
            bg = 0;
            this.font.color.bg = this.screen.getColorAt(this.getPosX(), this.getPosY());
        }
        this.font.color.setZColor(fg, bg);
    }

    public void setStyle(int style) {
        this.flush();
        this.font.setStyle(style);
    }

    public int setFont(int zfont) {
        this.flush();
        return this.font.set(zfont);
    }

    private void drawString(String s) {
        if (this.scroll && this.time_for_more) {
            this.promptForMore();
        }
        if (s.length() != 0) {
            this.xpos += this.screen.drawText(this.left + this.xpos, this.top + this.ypos, s, this);
        }
    }

    public void setMargins(int left, int right) {
        this.flush();
        this.leftmargin = left;
        this.rightmargin = right;
        if (!this.inBounds(this.xpos)) {
            this.xpos = this.leftmargin;
        }
    }

    public int getWindowStyle() {
        int curflags = 0;
        if (this.wrap) {
            curflags |= 1;
        }
        if (this.scroll) {
            curflags |= 2;
        }
        if (this.transcript) {
            curflags |= 4;
        }
        if (this.buffer) {
            curflags |= 8;
        }
        return curflags;
    }

    public void setWindowStyle(int flags, int op) throws ZError {
        int curflags = this.getWindowStyle();
        switch (op) {
            case 0: {
                curflags = flags;
                break;
            }
            case 1: {
                curflags |= flags;
                break;
            }
            case 2: {
                curflags &= ~flags;
                break;
            }
            case 3: {
                curflags ^= flags;
                break;
            }
            default: {
                throw new ZError("Invalid window setStyle operator");
            }
        }
        if (this.id == 0 && this.zm.hd.story == 3 && this.zm.hd.getRelease() == 366) {
            curflags |= 1;
        }
        if (this.id == 0 && this.zm.hd.story == 4 && this.zm.hd.getRelease() <= 295) {
            curflags |= 1;
        }
        this.setWrapMode((curflags & 1) != 0);
        this.setScroll((curflags & 2) != 0);
        this.setTranscripting((curflags & 4) != 0);
        this.setBufferMode((curflags & 8) != 0);
    }

    public int getProp(int prop) throws ZError {
        switch (prop) {
            case 0: {
                return this.top + 1;
            }
            case 1: {
                return this.left + 1;
            }
            case 2: {
                return this.height;
            }
            case 3: {
                return this.width;
            }
            case 4: {
                this.flush();
                return this.ypos + 1;
            }
            case 5: {
                this.flush();
                return this.xpos + 1;
            }
            case 6: {
                return this.leftmargin;
            }
            case 7: {
                return this.rightmargin;
            }
            case 8: {
                return this.interrupt_routine;
            }
            case 9: {
                return this.interrupt_count;
            }
            case 10: {
                return this.font.getZStyle();
            }
            case 11: {
                return this.font.getColorBytes();
            }
            case 12: {
                return this.font.getZFont();
            }
            case 13: {
                return (this.screen.getCharWidth() & 0xFF) + ((this.screen.getLineHeight() & 0xFF) << 8);
            }
            case 14: {
                return this.getWindowStyle();
            }
            case 15: {
                return this.line_counter;
            }
        }
        throw new ZError("Unknown window property " + prop);
    }

    public void setProp(int prop, int value) throws ZError {
        switch (prop) {
            case 8: {
                this.interrupt_routine = value;
                break;
            }
            case 9: {
                this.interrupt_count = (short)value;
                break;
            }
            case 10: {
                this.setStyle(value);
                break;
            }
            case 15: {
                this.line_counter = (short)value;
                break;
            }
            default: {
                throw new ZError("Tried to set window property " + prop);
            }
        }
    }

    public void postInputLine(String s) {
    }
}

