/*
 * Decompiled with CFR 0.152.
 */
package zpplet.system;

import java.awt.AWTError;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.JPanel;
import zpplet.ZUserConfig;
import zpplet.header.ZHeader5;
import zpplet.machine.ZMachine;
import zpplet.machine.ZMachine6;
import zpplet.misc.ZChars;
import zpplet.system.ZColor;
import zpplet.system.ZCursor;
import zpplet.system.ZFont;
import zpplet.system.ZWindow;

public class ZScreen
extends JPanel
implements KeyListener,
MouseListener {
    private BufferedImage backimage;
    private Graphics gback;
    private BlockingQueue inputcodes = new ArrayBlockingQueue(16);
    private StringBuilder inputline = new StringBuilder();
    private String previnput = null;
    private ZCursor cursor = new ZCursor(this);
    private ZMachine zm;
    private int lines;
    private int chars;
    private int lineheight;
    private int charwidth;
    private int mousewindow;
    int unity;
    int unitx;
    private boolean scaled = false;
    private int mousebuttons;
    private int curwidth;
    private int curheight;

    public ZScreen() {
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    public void attach(ZMachine zm) {
        this.zm = zm;
        this.inputline.setLength(0);
        this.mousewindow = -1;
        this.mousebuttons = 0;
        this.setScaling(zm instanceof ZMachine6);
    }

    public void detach() {
        this.cursor.setVisible(false);
        this.zm = null;
        try {
            this.inputcodes.put(new Integer(-1));
        }
        catch (InterruptedException interruptedException) {}
        this.inputcodes.clear();
        this.clear();
    }

    public int getChars() {
        return this.chars;
    }

    public int getLines() {
        return this.lines;
    }

    public int getCharWidth() {
        return this.charwidth;
    }

    public int getLineHeight() {
        return this.lineheight;
    }

    public void setMouseWindow(int value) {
        this.mousewindow = value;
    }

    public int getMouseButtons() {
        return this.mousebuttons;
    }

    public int getBoundsHeight() {
        return this.backimage.getHeight();
    }

    public int getBoundsWidth() {
        return this.backimage.getWidth();
    }

    public boolean isScaled() {
        return this.scaled;
    }

    public void keyPressed(KeyEvent e) {
        int result;
        if (this.zm != null && e.isActionKey() && (result = ZChars.fromActionKeyToZAscii(e.getKeyCode())) != -2) {
            this.inputcodes.add(new Integer(result));
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (this.zm == null) {
            return;
        }
        int code = this.zm.zc.fromUnicodeToZAscii(e.getKeyChar());
        if (code != -2) {
            this.inputcodes.add(new Integer(code));
        }
    }

    private int buttonMask(int b) {
        switch (b) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    public void mouseClicked(MouseEvent e) {
        if (!this.isFocusOwner()) {
            this.requestFocus();
        }
        if (this.zm == null) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        if (this.mousewindow >= 0) {
            ZWindow mw = this.zm.w[this.mousewindow];
            if (x < mw.left || y < mw.top || x >= mw.left + mw.width || y >= mw.top + mw.height) {
                return;
            }
        }
        if (this.zm.hd instanceof ZHeader5) {
            ((ZHeader5)this.zm.hd).setMouseClick(x, y);
            if (this.zm.hd.getVersion() == 5 || e.getClickCount() == 1) {
                this.inputcodes.add(new Integer(254));
            } else {
                this.inputcodes.add(new Integer(253));
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.mousebuttons |= this.buttonMask(e.getButton());
    }

    public void mouseReleased(MouseEvent e) {
        this.mousebuttons &= ~this.buttonMask(e.getButton());
    }

    public int readKeyCode(int timeout, int timeoutroutine) {
        try {
            Integer result;
            if (this.zm.input != null) {
                try {
                    int r = this.zm.input.read();
                    if (r >= 0) {
                        return r;
                    }
                    this.zm.setInputStream(0);
                }
                catch (IOException iOException) {}
            }
            if (timeout != 0) {
                do {
                    if ((result = (Integer)this.inputcodes.poll(timeout * 100, TimeUnit.MILLISECONDS)) != null || this.zm.zi.interrupt(timeoutroutine) == 0) continue;
                    return 0;
                } while (result == null);
            } else {
                result = (Integer)this.inputcodes.take();
            }
            return result;
        }
        catch (InterruptedException interruptedException) {
            return -1;
        }
    }

    public void primeInput() {
        try {
            int r = this.zm.input.read();
            if (r >= 0) {
                this.inputcodes.add(new Integer(r));
            } else {
                this.zm.setInputStream(0);
            }
        }
        catch (IOException iOException) {}
    }

    public int readBufferedCode(int timeout, int timeoutroutine) {
        if (this.inputline.length() > 0) {
            char x = this.inputline.charAt(0);
            this.inputline.deleteCharAt(0);
            return x;
        }
        ZWindow inputwindow = this.zm.curw;
        inputwindow.flush();
        this.cursor.setColor(inputwindow.font.getForeground());
        int index = 0;
        block12: while (true) {
            int x = inputwindow.getPosX();
            int y = inputwindow.getPosY();
            this.gback.setColor(inputwindow.font.getBack());
            this.gback.fillRect(x, y, inputwindow.width - x, this.lineheight);
            this.drawText(x, y, this.inputline.toString(), inputwindow);
            int w = this.gback.getFontMetrics().stringWidth(this.inputline.substring(0, index));
            this.cursor.setBounds(inputwindow.getPosX() + w, inputwindow.getPosY(), index >= this.inputline.length() ? this.charwidth : this.charwidth / 3, this.lineheight);
            this.repaint();
            this.cursor.setVisible(true);
            int incode = this.readKeyCode(timeout, timeoutroutine);
            switch (incode) {
                case -1: {
                    this.cursor.setVisible(false);
                    return incode;
                }
                case 8: {
                    if (index > 0) {
                        this.inputline.deleteCharAt(--index);
                        continue block12;
                    }
                    Toolkit.getDefaultToolkit().beep();
                    continue block12;
                }
                case 127: {
                    if (index < this.inputline.length()) {
                        this.inputline.deleteCharAt(index);
                        continue block12;
                    }
                    Toolkit.getDefaultToolkit().beep();
                    continue block12;
                }
                case 131: 
                case 149: {
                    if (index > 0) {
                        --index;
                        continue block12;
                    }
                    Toolkit.getDefaultToolkit().beep();
                    continue block12;
                }
                case 132: 
                case 151: {
                    if (index < this.inputline.length()) {
                        ++index;
                        continue block12;
                    }
                    Toolkit.getDefaultToolkit().beep();
                    continue block12;
                }
                case 146: {
                    index = this.inputline.length();
                    continue block12;
                }
                case 152: {
                    index = 0;
                    continue block12;
                }
                case 253: 
                case 254: {
                    this.inputline.append((char)incode);
                    this.inputline.append('\r');
                    this.cursor.setVisible(false);
                    return this.readBufferedCode(0, 0);
                }
                case 0: {
                    this.inputline.delete(0, this.inputline.length());
                    return 0;
                }
                case 129: {
                    if (this.previnput == null) continue block12;
                    this.inputline.delete(0, this.inputline.length());
                    this.inputline.append(this.previnput);
                    index = this.inputline.length();
                    continue block12;
                }
            }
            if (incode == 13) {
                this.previnput = this.inputline.toString();
                this.inputline.append((char)incode);
                inputwindow.resetLineCount();
                inputwindow.postInputLine(this.inputline.toString());
                inputwindow.newLine();
                this.cursor.setVisible(false);
                return this.readBufferedCode(0, 0);
            }
            if (!this.zm.zc.isStorable(incode)) continue;
            this.inputline.insert(index++, (char)incode);
        }
    }

    public void redoMetrics() {
        if (this.scaled) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(new Font(ZUserConfig.fixedfont, 0, ZUserConfig.fontsize));
        this.unitx = this.charwidth = fm.charWidth('0');
        this.unity = this.lineheight = fm.getHeight();
        this.chars = this.curwidth / this.charwidth;
        this.lines = this.curheight / this.lineheight;
    }

    public void setSize(int width, int height) {
        if (this.zm != null && this.zm.running) {
            this.zm.resize0(height);
        }
        this.curwidth = width;
        this.curheight = height;
        this.redoMetrics();
        BufferedImage oldimage = this.backimage;
        this.backimage = new BufferedImage(width, height, 1);
        this.gback = this.backimage.getGraphics();
        this.gback.setColor(ZColor.def.bg);
        this.gback.fillRect(0, 0, width, height);
        if (oldimage != null) {
            this.gback.drawImage(oldimage, 0, 0, null);
        }
        oldimage = null;
        if (this.zm != null && this.zm.running) {
            this.zm.resize();
        }
        if (this.cursor.isVisible()) {
            this.cursor.move(this.zm.curw.getPosX(), this.zm.curw.getPosY());
        }
    }

    public synchronized void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.scaled) {
            return;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this.backimage != null && width == this.curwidth && height == this.curheight) {
            return;
        }
        this.setSize(width, height);
    }

    protected synchronized int drawText(int x, int y, String text, ZWindow w) {
        this.gback.setFont(w.font.getFont());
        int width = this.gback.getFontMetrics().stringWidth(text);
        this.gback.setClip(w.left + w.leftmargin, w.top, w.getTextWidth(), w.height);
        Color bg = w.font.getBack();
        if (bg != null) {
            this.gback.setColor(bg);
            this.gback.fillRect(x, y, width, this.lineheight);
        }
        this.gback.setColor(w.font.getForeground());
        this.gback.drawString(text, x, y + this.gback.getFontMetrics().getAscent());
        this.gback.setClip(0, 0, this.backimage.getWidth(), this.backimage.getHeight());
        return width;
    }

    public synchronized void drawImage(Image img, int x, int y, ZWindow w) {
        this.gback.setClip(w.left, w.top, w.width, w.height);
        this.gback.drawImage(img, x, y, null);
        this.gback.setClip(0, 0, this.backimage.getWidth(), this.backimage.getHeight());
    }

    public synchronized void scrollUp(ZWindow w, int pixels) {
        this.gback.copyArea(w.left, w.top + pixels, w.width, w.height - pixels, 0, -pixels);
        this.gback.setColor(w.font.getBack());
        this.gback.fillRect(w.left, w.top + w.height - pixels, w.width, pixels);
    }

    public synchronized void scrollDown(ZWindow w, int pixels) {
        this.gback.copyArea(w.left, w.top, w.width, w.height - pixels, 0, pixels);
        this.gback.setColor(w.font.getBack());
        this.gback.fillRect(w.left, w.top, w.width, pixels);
    }

    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.backimage, 0, 0, null);
        this.cursor.paint(g);
    }

    public void clear() {
        this.gback.setColor(ZColor.def.bg);
        this.gback.fillRect(0, 0, this.getBoundsWidth(), this.getBoundsHeight());
    }

    public void eraseRegion(int left, int top, int width, int height, Color bg) {
        this.gback.setColor(bg);
        this.gback.fillRect(left, top, width, height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public int charWidth(char ch) {
        return this.gback.getFontMetrics().charWidth(ch);
    }

    public int getStringWidth(String s, ZFont font) {
        return this.gback.getFontMetrics(font.getFont()).stringWidth(s);
    }

    Frame getFrame() {
        Container cursor = this;
        while (!(cursor instanceof Frame)) {
            cursor = cursor.getParent();
        }
        return (Frame)cursor;
    }

    public String getFileName(String title, boolean save) {
        try {
            FileDialog fd = new FileDialog(this.getFrame(), title, save ? 1 : 0);
            fd.setVisible(true);
            if (!this.isFocusOwner()) {
                this.requestFocus();
            }
            if (fd.getFile() != null) {
                return String.valueOf(fd.getDirectory()) + fd.getFile();
            }
        }
        catch (AWTError aWTError) {}
        return null;
    }

    public Color getColorAt(int x, int y) {
        if (x >= 0 && y >= 0 && x < this.backimage.getWidth() & y < this.backimage.getHeight()) {
            return new Color(this.backimage.getRGB(x, y));
        }
        return ZColor.def.bg;
    }

    private void setScaling(boolean scale) {
        this.scaled = scale;
        if (this.scaled) {
            this.backimage = new BufferedImage(320 * ZUserConfig.v6scale, 200 * ZUserConfig.v6scale, 1);
            this.gback = this.backimage.getGraphics();
            ZColor.def = new ZColor(2, 9);
            FontMetrics fm = this.getFontMetrics(new Font(ZUserConfig.fixedfont, 0, ZUserConfig.fontsize));
            this.charwidth = fm.charWidth('0');
            this.lineheight = fm.getHeight();
            this.lines = this.backimage.getHeight() / this.lineheight;
            this.chars = this.backimage.getWidth() / this.charwidth;
            this.unitx = 1;
            this.unity = 1;
            this.clear();
            return;
        }
        ZColor.def = new ZColor(10, 2);
        this.setSize(this.getWidth(), this.getHeight());
    }

    void debugShowWindowBounds(ZWindow w) {
        this.gback.setColor(Color.RED);
        this.gback.drawRect(w.left, w.top, w.width, w.height);
        this.gback.setFont(new Font("Sans", 1, 24));
        this.gback.drawString(Integer.toString(w.id), w.left + 2, w.top + this.gback.getFontMetrics().getAscent());
    }
}

