/*
 * Decompiled with CFR 0.152.
 */
package zpplet.ops;

import zpplet.machine.ZMachine;

public class ZStackFrame {
    public int[] l;
    public int args;
    public int pc;
    public int store;
    public boolean interrupt;

    public ZStackFrame() {
    }

    public ZStackFrame(ZMachine zm, boolean stores) {
        this.store = stores ? zm.getCodeByte() : -1;
        this.interrupt = zm.zi.interrupting;
        this.pc = zm.pc;
        this.l = zm.l;
        zm.pc = zm.unpackRAddr(zm.zi.o[0]);
        int nlocals = zm.getCodeByte();
        this.args = nlocals < zm.zi.noperands - 1 ? nlocals : zm.zi.noperands - 1;
        zm.l = new int[nlocals];
        zm.zi.nargs = this.args;
        zm.zi.loadParameters(nlocals);
    }

    public void restore(ZMachine zm, int retval) {
        zm.l = this.l;
        zm.pc = this.pc;
        zm.zi.nargs = this.args;
        if (this.store > -1) {
            zm.setVariable(this.store, retval);
        } else if (zm.zi.interrupting && !this.interrupt) {
            zm.zi.interrupting = false;
            zm.setVariable(0, retval);
        }
    }
}

