! ===========================================================================
!   Inform Language Definition File: Lojban 25 Oct 2002
!
!   Given to the Public Domain by Robin Lee Powell, 2002
!
!   Original Translation by Robin Lee Powell, October 2002
!   Most of the actual Inform code by Martin Bays, November 2002
!
! ---------------------------------------------------------------------------

! ***NOTE*** on Lojbanic Stories!  MUST READ if you are writing Lojbanic Inform
! 
! There are a number of routines in the standard library that must be
! replaced because, for example, they assume that the " character is
! appropriate for quoting or that , should be used in lists.  Also,
! there are no variables to change the layout of the status line.
!
! See the bottom of this file for instructions.
!
! ***END OF NOTE***

System_file;

Constant LOJBAN; !***MDB*** So other libraries can configure themselves

! ---------------------------------------------------------------------------
!   Part I.   Preliminaries
! ---------------------------------------------------------------------------

Class  CompassDirection
  with article "lo", number 0
  has  scenery;
Object Compass "makfartci" has concealed;
IFNDEF WITHOUT_DIRECTIONS;
CompassDirection -> n_obj "be'a bitmu"
                    with name 'b//' 'berti' 'bitmu' 'be^a' 'berkla',    door_dir n_to;
CompassDirection -> s_obj "ne'u bitmu"
                    with name 'n//' 'snanu' 'bitmu' 'ne^u' 'nankla',    door_dir s_to;
CompassDirection -> e_obj "du'a bitmu"
                    with name 'd//' 'stuna' 'bitmu' 'du^a' 'sunkla',     door_dir e_to;
CompassDirection -> w_obj "vu'a bitmu"
                    with name 'v//' 'stici' 'bitmu' 'vu^a' 'sickla',     door_dir w_to;
CompassDirection -> ne_obj "berstuna bitmu"
                    with name 'bd' 'berstuna' 'bitmu' 'be^adu^a', door_dir ne_to;
CompassDirection -> nw_obj "berstici bitmu"
                    with name 'bv' 'berstici' 'bitmu' 'be^avu^a', door_dir nw_to;
CompassDirection -> se_obj "nanstuna bitmu"
                    with name 'nd' 'nanstuna' 'bitmu' 'ne^udu^a', door_dir se_to;
CompassDirection -> sw_obj "nanstici bitmu"
                    with name 'nv' 'nanstici' 'bitmu' 'ne^uvu^a', door_dir sw_to;
CompassDirection -> u_obj "drudi"
                    with name 'ga^u' 'gapru' 'drudi',    door_dir u_to;
CompassDirection -> d_obj "loldi"
                    with name 'ni^a' 'cnita' 'loldi',    door_dir d_to;
ENDIF;
CompassDirection -> out_obj "bartu"
                    with name 'ze^o' 'ne^inai' 'bartu',      door_dir out_to;
CompassDirection -> in_obj "nenri"
                    with name 'ne^i' 'zo^i' 'nenri',        door_dir in_to;
! ---------------------------------------------------------------------------
!   Part II.   Vocabulary
! ---------------------------------------------------------------------------
Constant AGAIN1__WD   = 'go^i';
Constant AGAIN2__WD   = 'g//';
Constant AGAIN3__WD   = 'krefu';
Constant OOPS1__WD    = 'basti';
Constant OOPS2__WD    = 'si';
Constant OOPS3__WD    = 'sa';
Constant UNDO1__WD    = 'su';
Constant UNDO2__WD    = 'srera';
Constant UNDO3__WD    = 'srera';

Constant ALL1__WD     = 'ro';
Constant ALL2__WD     = 'rodo';
Constant ALL3__WD     = 'roti';
Constant ALL4__WD     = 'roda';
Constant ALL5__WD     = 'romei';
Constant AND1__WD     = '_e';
Constant AND2__WD     = 'gi^e';
Constant AND3__WD     = 'je';
Constant BUT1__WD     = '_enai';
Constant BUT2__WD     = 'gi^enai';
Constant BUT3__WD     = '_enai';
Constant ME1__WD      = 'mi';
Constant ME2__WD      = 'mi';
Constant ME3__WD      = 'sevzi';
Constant OF1__WD      = 'sa^e';
Constant OF2__WD      = 'ji^i';
Constant OF3__WD      = 'sa^e';
Constant OF4__WD      = 'sa^e';
Constant OTHER1__WD   = 'drata';
Constant OTHER2__WD   = 'drata';
Constant OTHER3__WD   = 'drata';
Constant THEN1__WD    = '_ije';
Constant THEN2__WD    = '_ibabo';
Constant THEN3__WD    = '_iji^a';

Constant NO1__WD      = 'n//';
Constant NO2__WD      = 'na';
Constant NO3__WD      = 'nago^i';
Constant YES1__WD     = 'g//';
Constant YES2__WD     = 'go^i';
Constant YES3__WD     = 'go^i';

Constant AMUSING__WD  = 'zdile';
Constant FULLSCORE1__WD = 'mulnilji^a';
Constant FULLSCORE2__WD = 'mulno';
Constant QUIT1__WD    = 's//';
Constant QUIT2__WD    = 'sisti';
Constant RESTART__WD  = 'refcfa';
Constant RESTORE__WD  = 'veipli';

Array LanguagePronouns table

   !  word       possible GNAs                   connected
   !             to follow:                      to:
   !             a     i
   !             s  p  s  p
   !             mfnmfnmfnmfn                 

      'do'     $$111000000000                    NULL
      'ri'     $$111111111111                    NULL
      'ra'     $$111111111111                    NULL 
      'ru'     $$111111111111                    NULL
      'ti'     $$111111111111                    NULL
      'ta'     $$111111111111                    NULL
      'ko^a'   $$111111111111                    NULL
      'le-go^i'   $$111111111111                    NULL
      'le-se-go^i'   $$111111111111                    NULL
      'le-te-go^i'   $$111111111111                    NULL
      'do^o'   $$000111000000                    NULL;

Array LanguageDescriptors table

   !  word       possible GNAs   descriptor      connected
   !             to follow:      type:           to:
   !             a     i
   !             s  p  s  p
   !             mfnmfnmfnmfn                 

      'le-mi'  $$111111111111    POSSESS_PK      0
      'le-do'  $$111111111111    POSSESS_PK      'do'
      'le-do^o'  $$111111111111    POSSESS_PK      'do^o'
      'le-ri'  $$111111111111    POSSESS_PK      'ri'
      'le-ra'  $$111111111111    POSSESS_PK      'ra'
      'le-ko^a'    $$111111111111    POSSESS_PK      'ko^a'
      'le'     $$111111111111    DEFART_PK       NULL
      'la'     $$111111111111    DEFART_PK       NULL 
      'lo'     $$111111111111    INDEFART_PK     NULL

      ! pluralname is used only for sets and masses.
      'lei'    $$000111000111    DEFART_PK       NULL
      'le^i'   $$000111000111    DEFART_PK       NULL
      'loi'    $$000111000111    INDEFART_PK       NULL
      'lo^i'   $$000111000111    INDEFART_PK       NULL;

!***MDB*** used in LanguageToInformese
[ IsALanguageDescriptor dict i;
for (i=0:i<=((LanguageDescriptors-->0)/4)-1:i++)
	if (dict==LanguageDescriptors-->(4*i+1))
		rtrue;
rfalse;
];

Array LanguageNumbers table
!    'pa' 1 're' 2 'ci' 3 'vo' 4 'mu' 5
!    'xa' 6 'ze' 7 'bi' 8 'so' 9 'pano' 10
!    'papa' 11 'pare' 12 'paci' 13 'pavo' 14 'pamu' 15
!    'paxa' 16 'paze' 17 'paci' 18 'paso' 19 'reno' 20;
2; !***MDB*** Handled with a ParseNumber entry point in LojbanR.h

! ---------------------------------------------------------------------------
!   Part III.   Translation
! ---------------------------------------------------------------------------

!Used by LTI routines to keep track of whether the command appears to be an order
Global LTI_is_order;
[ LanguageToInformese x stage verb_start; 
	LTI_is_order=0;
	!Cleanest method seems to be to make a few passes
	for (stage=1:stage<=3:stage++) 
	{
		for (x=1:x<=parse->1:x++)
		{
			switch (stage) 
			{
				1: LTI_Substitutions(x);
				2: LTI_Hyphenations(x);
				3: LTI_Orders(x);
			}
		}
		Tokenise__(buffer, parse);
	}
	!Some post-pass text mangling -
	!Stripping the elided mi, kei and vau if included by a
	!grammatically precise player - 
	!
	!Don't strip mi for an order, so ".i do gasnu le nu mi gasnu le
	!nu mi catlu le cukta" is still just a ludicrously prolix (and
	!highly funky) way of saying ">Examine book", (annoyingly,
	!Inform disallows further nesting)
	!
	!TODO - Note however that ".i do gasnu le nu le prenu cu gasnu
	!le nu *le prenu* cu catlu le cukta" and its ilk won't work. Not
	!sure what to do about that without messing with the parser.
	verb_start = 1;
	if ((~~LTI_is_order) && LTI_GetWord(1) == 'mi')
	{
	    LTI_WipeWord(1);
	    verb_start = 2;
	}
	!Strip any combination of vau and kei from the end, since
	!abstractions such as for orders might introduce more possible
	!terminators.
	for (x=parse->1:LTI_GetWord(x) == 'kei' or 'vau':x--)
		LTI_WipeWord(x);
	
	!Inform only allows one word verbs, which is a bit annoying
	!given Lojban's conversion facilities. So allow stuff to be
	!contracted (in a seperate routine for ease of "Replace"ment). 
	if (LTI_is_order) !Need to find where verb starts (just after comma)
		for (x=1:x<=parse->1:x++) 
			if (buffer->LTI_GetPos(x) == ',')
				verb_start = x + 1;
	!Remove any cu
	if (LTI_GetWord(verb_start) == 'cu') LTI_WipeWord(verb_start++);
	LTI_Verb_Contractions(verb_start); 
	
    ! This code would print out the modified text, for testing purposes,
    ! if it were not commented out:
    ! 
    ! print "[";
    ! for (x=2:x<2+buffer->1:x++)
    ! 	print (char) buffer->x;
    ! print "]^";
];
	! Word printout.
	! print "2[";
	! if (word) print (address) word, "--";
	! print (char) buffer->at, "--";
	! if (word2) print (address) word2;
	! print "]^";

	!***MDB*** Uncontracting contractions, and other simple substitutions
[ LTI_Substitutions x  word word2 at;
	word = LTI_GetWord(x); word2 = LTI_GetWord(x+1); at = LTI_GetPos(x);
	switch (word) {
		'lemi' : LTI_Replace(x, "le mi");
		'lego^i' : LTI_Replace(x, "le go'i");
		'sego^i' : LTI_Replace(x, "se go'i");
		'tego^i' : LTI_Replace(x, "te go'i");
		'lesego^i' : LTI_Replace(x, "le se go'i");
		'letego^i' : LTI_Replace(x, "le te go'i");
		'ledo' : LTI_Replace(x, "le do");
		'ledo^o' : LTI_Replace(x, "le do'o");
		'leri' : LTI_Replace(x, "le ri");
		'lera' : LTI_Replace(x, "le ra");
		'leko^a' : LTI_Replace(x, "le ko'a");
		'lenu' : LTI_Replace(x, "le nu");
		'gi^e' : LTI_Replace(x, "_ije"); !Because we've run out of THEN__WDs
	}
	! Deal with ro le denpabu
	if (buffer->at == '.' )
	{   
	    ! New sentence.
	    if ( word2 == 'i//' )
	    {
		!LTI_Insert(at, ' ');          
		buffer->at     = '.';
		buffer->(at+1) = ' ';
		buffer->(at+2) = ' ';
	    }  else {
		buffer->at     = '_';
	    }
	}
	!***MDB*** Removing commas. Note - can't simply replace all
	!commas, since using oops on an order sentence feeds the comma
	!back into this routine, where it should stay. This also means
	!the savvy player can carry on using commas to issue horribly
	!ungrammatical, but concise, orders. However, an order comma is
	!always followed by a space, so replace any commas which aren't
 	if (buffer->at == ',' && (at+1>(buffer->1)+1 || buffer->(at+1) ~= ' '))
		buffer->at = '='; 
];

	! Possession and le go'i
[ LTI_Hyphenations x   word word2 at;
	word = LTI_GetWord(x); word2 = LTI_GetWord(x+1); at = LTI_GetPos(x);
	if (word == 'le' && (
		word2 == 'mi' ||
		word2 == 'do' ||
		word2 == 'do^o' ||
		word2 == 'ri' ||
		word2 == 'ra' ||
		word2 == 'ru' ||
		word2 == 'ko^a' ||
		word2 == 'go^i'
		)
	    )
	{   
	    !LTI_Insert(at, ' ');          
	    buffer->at     = 'l';
	    buffer->(at+1) = 'e';
	    buffer->(at+2) = '-';
	}
	! na go'i
	if (word == 'na' && word2 == 'go^i')
	{   
	    !LTI_Insert(at, ' ');          
	    buffer->at     = 'n';
	    buffer->(at+1) = 'a';
	    buffer->(at+2) = '-';
	}
	! le se/te go'i
	if (LTI_Match(x, 'le', 'se', 'go^i'))
	{
		LTI_WipeWords(x+1, x+2);
		LTI_Replace(x, "le-se-go'i");
	}
	if (LTI_Match(x, 'le', 'te', 'go^i'))
	{
		LTI_WipeWords(x+1, x+2);
		LTI_Replace(x, "le-te-go'i");
	}
];


	!***MDB*** Orders - convert "[cu] gasnu le nu"  or "[doi ...]
	!ko" or "[doi ...] ko [cu] gasnu le nu" to ","
[ LTI_Orders x  word at pos;
	word = LTI_GetWord(x); at = LTI_GetPos(x);
	if ((~~LTI_is_order) && ((LTI_GetWord(1) ~= 'doi' && (LTI_Match(x, 'gasnu', 'le', 'nu') || LTI_Match(x, 'cu', 'gasnu', 'le', 'nu'))) || (LTI_GetWord(1) == 'doi' && word == 'ko')))
	{
		!Blank out the words and replace with a comma
		pos = x;
		if (word == 'ko')
		{
			pos++;
			LTI_WipeWord(x);
			LTI_WipeWord(1); !Initial "doi"
		}
		if (LTI_Match(pos, 'gasnu', 'le', 'nu'))
			LTI_WipeWords(pos, pos+2);
		if (LTI_Match(pos, 'cu', 'gasnu', 'le', 'nu'))
			LTI_WipeWords(pos, pos+3);
	 	buffer->at = ',';
		!Inform doesn't like you using articles to address
		!someone, but we want to allow it. So just wipe out the
		!first word (after any "doi") if it's an article.
		if (LTI_GetWord(1) ~= 'doi' && IsALanguageDescriptor(LTI_GetWord(1)))
			LTI_WipeWord(1);
		if (LTI_GetWord(1) == 'doi' && IsALanguageDescriptor(LTI_GetWord(2)))
			LTI_WipeWord(2);
	}
	!want to know for stripping leading mi, and preventing multiple
	!commas, and contracting multiple-word verbs
	if (buffer->at == ',') LTI_is_order=1; 
];

!Of course, could just have seperate grammer lines for te and se and so
!on, with the main selbri a preposition. But I prefer this.
!
!This routine can safely be "Replace"d by the author to add new
!contractions.
[ LTI_Verb_Contractions x;
if (LTI_Match(x, 'te', 'preti')) {
	LTI_WipeWord(x+1);
	LTI_Replace(x, "teryrei");
}
if (LTI_Match(x, 'se', 'beiste')) {
	LTI_WipeWord(x+1);
	LTI_Replace(x, "selbeiste");
}
];

!***MDB*** Miscellaneous routines used by LanguageToInformese
!Replace a word with spaces 
[ LTI_WipeWord wordnum   start offset;
    start=LTI_GetPos(wordnum);
    for (offset=0:offset<LTI_GetLen(wordnum):offset++)
		buffer->(start+offset) = ' ';
];

!Wipe range
[ LTI_WipeWords from to   n;
	for (n=from:n<=to:n++)
		LTI_WipeWord(n);
];

!Replace word with string
[ LTI_Replace wordnum text   start k;
  	lojban_printed_text-->0 = 49; @output_stream 3 lojban_printed_text; 
  	print (string) text; @output_stream -3;
	start = LTI_GetPos(wordnum);
	LTI_WipeWord(wordnum);
	for (k=0 : k<LTI_GetLen(wordnum) : k++)
		{ !Overwrite
		if (k>=(lojban_printed_text-->0)) rtrue;
		buffer->(start+k) = lojban_printed_text->(k+2);
		}
	for (:k<lojban_printed_text-->0 : k++) !Insert
		LTI_Insert(start+k, lojban_printed_text->(k+2));
	rtrue;
];

!Matches a sequence of words
[ LTI_Match x w1 w2 w3 w4 w5 w6;
if (w1 && LTI_GetWord(x) ~= w1) rfalse;
if (w2 && LTI_GetWord(x+1) ~= w2) rfalse;
if (w3 && LTI_GetWord(x+2) ~= w3) rfalse;
if (w4 && LTI_GetWord(x+3) ~= w4) rfalse;
if (w5 && LTI_GetWord(x+4) ~= w5) rfalse;
if (w6 && LTI_GetWord(x+5) ~= w6) rfalse;
rtrue;
];

!Returns dictionary word
[ LTI_GetWord wordnum;
	if (wordnum>parse->1) rfalse;
	return parse-->(wordnum*2 - 1);
];
!Returns length in chars
[ LTI_GetLen wordnum;
	if (wordnum>parse->1) "***ERROR*** LanguageToInformese: tried to find length of non-existent word";
	return parse->(wordnum*4);
];
!Returns position of start of word in buffer array
[ LTI_GetPos wordnum;
	if (wordnum>parse->1) "***ERROR*** LanguageToInformese: tried to find position of non-existent word";
	return parse->(wordnum*4 + 1);
];

! ---------------------------------------------------------------------------
!   Part IV.   Printing
! ---------------------------------------------------------------------------

Constant LanguageAnimateGender   = neuter;
Constant LanguageInanimateGender = neuter;

! We could use this for the mandatory pauses in front of vowels and
! such, but the code would probably get *heavy*, so we simply insist
! that people enter words with the stops already in.
Constant LanguageContractionForms = 1;     ! lojban has none

[ LanguageContraction;
  return 0;
];

Array LanguageArticles -->

 !   Contraction form 0:
 !   Cdef   Def    Indef

     "le " "le " "lo ";

                   !             a           i
                   !             s     p     s     p
                   !             m f n m f n m f n m f n                 

Array LanguageGNAsToArticles --> 0 0 0 0 0 0 0 0 0 0 0 0;

[ LanguageDirection d;
   switch(d)
   {   n_to: print "be'a";
       s_to: print "ne'u";
       e_to: print "du'a";
       w_to: print "vu'a";
       ne_to: print "be'a du'a";
       nw_to: print "be'a vu'a";
       se_to: print "ne'u du'a";
       sw_to: print "ne'u vu'a";
       u_to: print "gapru";
       d_to: print "cnita";
       in_to: print "bartu";
       out_to: print "nenri";
       default: return RunTimeError(9,d);
   }
];

[ LanguageNumber n;
    if (n==0)    { print "no"; rfalse; }
    if (n<0)     { print "ni'u "; n=-n; }
!  if (n>=1000) { print (LanguageNumber) n/1000, " ki'o "; n=n%1000; f=1; }
!  if (n==0) rfalse;
    
    switch(n%10)
    {   
	0:  if (n/10 ~= 0) { LanguageNumber(n/10); }
	    print "no";

	1:  if (n/10 ~= 0) { LanguageNumber(n/10); }
	    print "pa";

	2:  if (n/10 ~= 0) { LanguageNumber(n/10); }
	    print "re";

	3:  if (n/10 ~= 0) { LanguageNumber(n/10); }
	    print "ci";

	4:  if (n/10 ~= 0) { LanguageNumber(n/10); }
	    print "vo";

	5:  if (n/10 ~= 0) { LanguageNumber(n/10); }
	    print "mu";

	6:  if (n/10 ~= 0) { LanguageNumber(n/10); }
	    print "xa";

	7:  if (n/10 ~= 0) { LanguageNumber(n/10); }
	    print "ze";

	8:  if (n/10 ~= 0) { LanguageNumber(n/10); }
	    print "bi";

	9:  if (n/10 ~= 0) { LanguageNumber(n/10); }
	    print "so";
    }
];

[ LanguageTimeOfDay hours mins;
!    print "li ";
    LanguageNumber(hours);
    print " pi'e ";
    LanguageNumber(mins);
    print " tcika^";
];

[ LanguageVerb i;
   if (i==#n$z)        { print "zgana";              rtrue; }
   if (i==#n$c)        { print "catlu";           rtrue; }
   if (i==#n$s or 'inv' or 'inventory')
                       { print "selbei";         rtrue; }
   rfalse;
];

!  ***ENGLISH*** Constant NKEY__TX     = "N = next subject";
!  ***ENGLISH*** Constant PKEY__TX     = "P = previous";
!  ***ENGLISH*** Constant QKEY1__TX    = "  Q = resume game";
!  ***ENGLISH*** Constant QKEY2__TX    = "Q = previous menu";
!  ***ENGLISH*** Constant RKEY__TX     = "RETURN = read subject";

Constant NKEY__TX     = "sy.bu cu selyli'e";
Constant PKEY__TX     = "ly.bu cu lidne";
Constant QKEY1__TX    = "xy.bu cu nu xruti";
Constant QKEY2__TX    = "xy.bu cu lidne liste";
Constant RKEY__TX     = "ni'o.bu cu nu tcidu";

!  ***ENGLISH*** Constant NKEY1__KY    = 'N';
!  ***ENGLISH*** Constant NKEY2__KY    = 'n';
!  ***ENGLISH*** Constant PKEY1__KY    = 'P';
!  ***ENGLISH*** Constant PKEY2__KY    = 'p';
!  ***ENGLISH*** Constant QKEY1__KY    = 'Q';
!  ***ENGLISH*** Constant QKEY2__KY    = 'q';

Constant NKEY1__KY    = 's';
Constant NKEY2__KY    = 's';
Constant PKEY1__KY    = 'l';
Constant PKEY2__KY    = 'l';
Constant QKEY1__KY    = 'x';
Constant QKEY2__KY    = 'x';

Constant SCORE__TX    = ".i nilji'a li ";
Constant MOVES__TX    = ".i krefu fi li ";
Constant TIME__TX     = ".i li ";
Constant CANTGO__TX   = ".i do na kanke le nu klama fo la'e di'u";
Constant FORMER__TX   = ".i lo do purci sevzi";
Constant YOURSELF__TX = "do";
Constant DARKNESS__TX = ".i ka manku";
Constant NOTHING__TX  = "noda";

Constant THOSET__TX   = "loi dacti";
Constant THAT__TX     = "la'e di'u";
!***MDB*** this is a bit of a hack, but as far as I can tell OR__TX is
!only used once, by the parser in disambiguation (did you mean X or Y),
!so need this to fit in with LM45/46
Constant OR__TX	      = " jikau "; 
Constant AND__TX      = " gi'e ";

Constant WHOM__TX     = "***ERROR*** ENGLISH_BIT set, makes no sense in lojban!";
Constant WHICH__TX    = "***ERROR*** ENGLISH_BIT set, makes no sense in lojban!";
Constant IS2__TX      = "***ERROR*** ENGLISH_BIT set, makes no sense in lojban!";
Constant ARE2__TX     = "***ERROR*** ENGLISH_BIT set, makes no sense in lojban!";

! Never used.
Constant IS__TX       = "***ERROR*** ISARE_BIT set, makes no sense in lojban!";
Constant ARE__TX      = "***ERROR*** ISARE_BIT set, makes no sense in lojban!";

!***MDB*** Used for listing and in various other places in parserm and
!verblibm 
Constant LIST_COLON__TX = " zo'u"; !Was ":"
Constant LIST_COMMA__TX = " .e"; !Was ",", meaning "and" as it almost always does
Constant LIST_COMMA_OR__TX = " jikau"; !Was ",", used only in disambiguation (did you mean X, Y or Z)
Constant LIST_O_PARENTH__TX = "to "; !Was "("
Constant LIST_C_PARENTH__TX = " toi"; !Was ")"
Constant LIST_PERIOD_NEWLINE__TX = "^"; !Was ".^"
Constant LIST_QUESTION__TX = ""; !Was "?"
Constant LIST_END_QUOTE__TX = " le'u"; 
!Was nothing - used to finish the "I only understood you as far as..."
!sentence, since Lojban puts the ... in error quotes (see Library
!Message 28)

!***MDB*** for painless changing of the prompt - some suggested
!alternatives:
!	"^mi'ecpe le nu " ([I] demand that)
!	"^>" (the classic)
!	Also used to change the disambiguation prompt to plain "^>" (in
!	parserm)
Global prompt_text = "^.i do gasnu le nu ";

[ LanguageLM n x1;
    Prompt:  print (string) prompt_text;
    Miscellany:
	switch(n)
	{   
!  ***ENGLISH***  1: "(considering the first sixteen objects only)^";
	    1: "to srana bi'o pamoi po'o paxasi'e lo dacti toi^";
!  ***ENGLISH***  2: "Nothing to do!";
	    2: ".i ca'a gasnu noda";
!  ***ENGLISH***  3: print " You have died ";
	    3: print " .i do ca'a morsi ";
!  ***ENGLISH***  4: print " You have won ";
	    4: print " .i do ca'a jinga ";
!  ***ENGLISH***  5: print "^Would you like to RESTART, RESTORE a saved game";
!  ***ENGLISH***  #IFDEF DEATH_MENTION_UNDO;
!  ***ENGLISH***  print ", UNDO your last move";
!  ***ENGLISH***  #ENDIF;
!  ***ENGLISH***  if (TASKS_PROVIDED==0)
!  ***ENGLISH***  print ", give the FULL score for that game";
!  ***ENGLISH***  if (deadflag==2 && AMUSING_PROVIDED==0)
!  ***ENGLISH***  print ", see some suggestions for AMUSING things to do";
!  ***ENGLISH***  " or QUIT?";
	    5: print "^.i xu do djica le nu ba'e refcfa gi'onai ba'e veipli lo se kelci";
                  #IFDEF DEATH_MENTION_UNDO;
                  print "gi'onai ba'e vimcu ni'upamoi se gasnu be do";
                  #ENDIF;
                  if (TASKS_PROVIDED==0)
                      print "gi'onai viska lo ba'e mulno nilji'a po lo co'u se kelci";
                  if (deadflag==2 && AMUSING_PROVIDED==0)
                      print "gi'onai viska lo se stidi tezu'e lo nu ba'e zdile";
                  " gi'onai sisti";
!  ***ENGLISH***  6: "[Your interpreter does not provide ~undo~.  Sorry!]";
	    6: "to le skami selmi'e cu na curmi le nu do ba'e vimcu le romoi be le nu do pu zukte .i .u'usai toi";
!  ***ENGLISH***  7: "~Undo~ failed.  [Not all interpreters provide it.]";
	    7: ".i le nu gasnu vimcu cu fliba to roda poi le skami selmi'e cu na curmi le go'i toi";
!  ***ENGLISH***  8: "Please give one of the answers above.";
	    8: ".i pe'u ko sabji pa lo gapru danfu";
!  ***ENGLISH***  9: "^It is now pitch dark in here!";
	    9: "^.i co'a prane lo ka manku";
!  ***ENGLISH***  10: "I beg your pardon?";
	    10: ".i ki'a";
!  ***ENGLISH***  11: "[You can't ~undo~ what hasn't been done!]";
	    11: "to na kakne le nu vimcu da poi na ca zasti toi";
!  ***ENGLISH***  12: "[Can't ~undo~ twice in succession. Sorry!]";
	    12: "to na kakne le nu vimcu kei vo'a lamji toi";
!  ***ENGLISH***  13: "[Previous turn undone.]";
	    13: "to le romoi be le nu do pu zukte cu vimcu toi";
!  ***ENGLISH***  14: "Sorry, that can't be corrected.";
	    14: ".i .u'u na kakne le nu cikre";
!  ***ENGLISH***  15: "Think nothing of it.";
	    15: ".i .a'inai";
!  ***ENGLISH***  16: "~Oops~ can only correct a single word.";
	    16: ".i zo srera jai kakne le nu cikre pa lo valsi po'o";
!  ***ENGLISH***  17: "It is pitch dark, and you can't see a thing.";
	    17: ".i prane le ka manku .iseri'a do na kakne le nu viska";
!  ***ENGLISH***  18: print "yourself";
	    18: print ".i do";
!  ***ENGLISH***  19: "As good-looking as ever.";           
	    19: ".i le za'i melbi cu ranji";           
!  ***ENGLISH***  20: "To repeat a command like ~frog, jump~, just say
!  ***ENGLISH***  ~again~, not ~frog, again~.";
	    20: ".i ganai da'i do djica lenu za'ure'u minde da noi simsa
		      lu doi pipybanfi ko plipe li'u gi ko cusku lu
		      krefu li'u .enai lu doi pipybanfi do'u krefu li'u";
!  ***ENGLISH***  21: "You can hardly repeat that.";
	    21: ".i do na kakne le nu krefu le nu go'i";
!  ***ENGLISH***  22: "You can't begin with a comma.";
	    22: ".i na curmi le nu ciska le jufra poi pamoi vasru slakabu";
!  ***ENGLISH***  23: "You seem to want to talk to someone, but I can't see whom.";
	    23: ".i pe'i do djica le nu cusku fi da .iku'i mi na viska da";
!  ***ENGLISH***  24: "You can't talk to ", (the) x1, ".";
	    24: ".i do na kakne le nu cusku fi ", (the) x1;
!  ***ENGLISH***  25: "To talk to someone, try ~someone, hello~ or some such.";
	    25: ".i le nu do djica le nu tavla da kei mukti le nu do troci tu'a lo simsa be lu coi da li'u";
!  ***ENGLISH***  26: "(first taking ", (the) not_holding, ")";
	    26: "to pamai do cpacu ", (the) not_holding, " toi";
!  ***ENGLISH***  27: "I didn't understand that sentence.";
	    27: ".i mi na jimpe le pu jufra";
!  ***ENGLISH***  28: print "I only understood you as far as wanting to ";
	    28: print ".i na'e jimpe lei valsi poi se lidne lo'u "; 
!  ***ENGLISH***  29: "I didn't understand that number.";
	    29: ".i na jimpe le namcu";
!  ***ENGLISH***  30: "You can't see any such thing.";
	    30: ".i do na viska ri";
!  ***ENGLISH***  31: "You seem to have said too little!";
	    31: ".i le do se cuske cu na banzu";
!  ***ENGLISH***  32: "You aren't holding that!";
	    32: ".i do na bevri ri";
!  ***ENGLISH***  33: "You can't use multiple objects with that verb.";
	    33: ".i pe'u do na pilno su'ore dacti tu'a le bridi po di'u";
!  ***ENGLISH***  34: "You can only use multiple objects once on a line.";
	    34: ".i curmi le nu paroi po'o pilno le su'ore dacti tu'a le jufra";
!  ***ENGLISH***  35: "I'm not sure what ~", (address) pronoun_word,
!  ***ENGLISH***  "~ refers to.";
	    35: ".i na jimpe le se srana be zo ", (address) pronoun_word;
!  ***ENGLISH***  36: "You excepted something not included anyway!";
	    36: ".i pe'u do na pilno lu .enai da li'u va'o le du'u da na srana";
!  ***ENGLISH***  37: "You can only do that to something animate.";
	    37: ".i pe'u do na gasnu le nu go'i sepi'o lo na danlu";
!  ***ENGLISH***  38: "That's not a verb I recognize.";
	    38: ".i le bridi po di'u na slabu mi";
!  ***ENGLISH***  39: "That's not something you need to refer to
!  ***ENGLISH***  in the course of this game.";
	    39: ".i do na nitcu tu'a la'e di'u le dei se kelci";
!  ***ENGLISH***  40: "You can't see ~", (address) pronoun_word,
!  ***ENGLISH***  "~ (", (the) pronoun_obj, ") at the moment.";
	    40: ".i do na kakne le nu viska ", (address) pronoun_word,
                  "to ", (the) pronoun_obj, " toi caku";
!  ***ENGLISH***  41: "I didn't understand the way that finished.";
	    41: ".i na jimpe le tarmi be le di'u fanmo";
!  ***ENGLISH***  42: if (x1==0) print "None";
!  ***ENGLISH***  else print "Only ", (number) x1;
!  ***ENGLISH***  print " of those ";
!  ***ENGLISH***  if (x1==1) print "is"; else print "are";
!  ***ENGLISH***  " available.";
	    42: if (x1==0) print ".i no ";
		else print ".i po'o ", (number) x1;
		" ri cu zasti";
!  ***ENGLISH***  43: "Nothing to do!";
	    43: ".i .ue noda se gasnu";
!  ***ENGLISH***  44: "There are none at all available!";
	    44: ".i no ri cu zasti";
!  ***ENGLISH***  45: print "Who do you mean, ";
	    45: print ".i ko ciski le du'u le do se cusku cu srana ";
!  ***ENGLISH***  46: print "Which do you mean, ";
	    46: print ".i ko ciski le du'u le do se cusku cu srana ";
!  ***ENGLISH***  47: "Sorry, you can only have one item here. Which exactly?";
	    47: ".i .u'u do po'o ka'e cpacu pa dacti le vi stuzi .i ma sa'e dacti";
!  ***ENGLISH***  48: print "Whom do you want";
!  ***ENGLISH***  if (actor~=player) print " ", (the) actor; print " to ";
!  ***ENGLISH***  PrintCommand(); print "?^";
	    48: print ".i pau do djica le nu";
		if (actor~=player) print " ", (the) actor; print " gasnu le nu ";
		PrintCommand(); print " kei sepi'o ma^";
!  ***ENGLISH***  49: print "What do you want";
!  ***ENGLISH***  if (actor~=player) print " ", (the) actor; print " to ";
!  ***ENGLISH***  PrintCommand(); print "?^";
	    49: print ".i pei do djica le nu";
		if (actor~=player) print " ", (the) actor; print " gasnu le nu ";
		PrintCommand(); print " kei sepi'o ma^";
!  ***ENGLISH***  50: print "Your score has just gone ";
!  ***ENGLISH***  if (x1 > 0) print "up"; else { x1 = -x1; print "down"; }
!  ***ENGLISH***  print " by ", (number) x1, " point";
!  ***ENGLISH***  if (x1 > 1) print "s";
	    50: print ".i le do nilji'a cu ";
		if (x1 > 0) print "te jmina "; else { x1 = -x1; print "te vimcu "; }
		print (number) x1;
!  ***ENGLISH***  51: "(Since something dramatic has happened,
!  ***ENGLISH***  your list of commands has been cut short.)";
	    51: "to mu'i le ralju fasnu le minde liste poi do ka'e pilno cu traji cmalu toi";
!  ***ENGLISH***  52: "^Type a number from 1 to ", x1,
!  ***ENGLISH***  ", 0 to redisplay or press ENTER.";
	    52: "^.i ko ciska lo namcu poi kuspe li pa bi'o ", x1,
		" ku'o .a li no noi rinka le krefu be le nu jarco ku'o .a le xrutibu";
!  ***ENGLISH***  53: "^[Please press SPACE.]";
	    53: "^to pe'u ko ciska le kuntibu toi";
	}

    ListMiscellany:
	switch(n)
	{
!  ***ENGLISH***  1: print " (providing light)";
	    1: print " to sabji lo gusni toi";
!  ***ENGLISH***  2: print " (which ", " is", " closed)";
	    2: print " to poi ganlo toi";
!  ***ENGLISH***  3: print " (closed and providing light)";
	    3: print " to ganlo gi'e sabji lo gusni toi";
!  ***ENGLISH***  4: print " (which ", " is", " empty)";
	    4: print " to poi kunti toi";
!  ***ENGLISH***  5: print " (empty and providing light)";
	    5: print " to kunti gi'e sabji lo gusni toi";
!  ***ENGLISH***  6: print " (which ", " is", " closed and empty)";
	    6: print " to poi kunti gi'e ganlo toi";
!  ***ENGLISH***  7: print " (closed, empty and providing light)";
	    7: print " to ganlo gi'e kunti gi'e sabji lo gusni toi";
!  ***ENGLISH***  8: print " (providing light and being worn";
	    8: print " to sabji lo gusni gi'e se dasni";
!  ***ENGLISH***  9: print " (providing light";
	    9: print " to sabji lo gusni";
!  ***ENGLISH***  10: print " (being worn";
	    10: print " to se dasni";
!  ***ENGLISH***  11: print " (which ", " is", " ";
	    11: print " to poi ";
!  ***ENGLISH***  12: print "open";
	    12: print "kalri";
!  ***ENGLISH***  13: print "open but empty";
	    13: print "kalri gi'e ku'i kunti";
!  ***ENGLISH***  14: print "closed";
	    14: print "ganlo";
!  ***ENGLISH***  15: print "closed and locked";
	    15: print "ganlo gi'e se kikla'a";
!  ***ENGLISH***  16: print " and empty";
	    16: print " gi'e kunti";
!  ***ENGLISH***  17: print " (which ", " is", " empty)";
	    17: print " to poi kunti toi";
!  ***ENGLISH***  18: print " containing ";
	    18: print " cu vasru ";
!  ***ENGLISH***  19: print " (on ";
	    19: print " to cpana ";
!  ***ENGLISH***  20: print ", on top of ";
	    20: print " cu cpana ";
!  ***ENGLISH***  21: print " (in ";
	    21: print " to nenri ";
!  ***ENGLISH***  22: print ", inside ";
	    22: print " cu nenri ";
	}

    Pronouns: 
	switch(n)
	{   
!  ***ENGLISH***  1: print "At the moment, ";
	    1: print ".i ca le ca mokca ";
!  ***ENGLISH***  2: print "means ";
	    2: print " tcini ";
!  ***ENGLISH***  3: print "is unset";
	    3: print " tcini noda";
!  ***ENGLISH***  4: "no pronouns are known to the game.";
	    4: "no sumti gadri cu se djuno le dei se kelci";
           }

    Order:
!  ***ENGLISH***  print (The) x1;
!  ***ENGLISH***  if (x1 has pluralname) print " have"; else print " has";
!  ***ENGLISH***  " better things to do.";
	print ".i ", (The) x1, " cu na djica^";

    Quit:
	switch(n)
	{
!  ***ENGLISH***  1: print "Please answer yes or no.";
	    1: print ".i ko ciska zo go'i .onai lu na go'i li'u";
!  ***ENGLISH***  2: print "Are you sure you want to quit? ";
	    2: print ".i xu birti le du'u do djica le nu sisti^";
	}

    Restart:
	switch(n)
	{
!  ***ENGLISH***  1: print "Are you sure you want to restart? ";
	    1: print ".i xu do birti le du'u do djica le nu refcfa^";
!  ***ENGLISH***  2: "Failed.";
	    2: ".i fliba";
	}

    Restore:
	switch(n)
	{
!  ***ENGLISH***  1: "Restore failed.";
	    1: ".i le nu xruti lo vreji be lo se kelci cu fliba";
!  ***ENGLISH***  2: "Ok.";
	    2: ".i vi'o";
	}

    Save:
	switch(n)
	{
!  ***ENGLISH***  1: "Save failed.";
	    1: ".i le nu vreji cu fliba";
!  ***ENGLISH***  2: "Ok.";
	    2: ".i vi'o";
	}

    Verify:
	switch(n)
	{
!  ***ENGLISH***  1: "The game file has verified as intact.";
	    1: ".i ju'o le se kelci vreji cu tolpo'u";
!  ***ENGLISH***  2: "The game file did not verify as intact,
!  ***ENGLISH***  and may be corrupt.";
	    2: ".i pe'i le se kelci vreji cu spofu";
	}

    ScriptOn:
	switch(n)
	{
!  ***ENGLISH***  1: "Transcripting is already on.";
	    1: ".i le nu se tcidu vreji cu pu ca'a cfari";
!  ***ENGLISH***  2: "Start of a transcript of";
	    2: ".i cfari fa le nu se tcidu vreji lo'u"; 
!***MDB*** Technically, ought to end the quote with a le'u. But that
!would look really, really ugly, and be annoying to code. So I haven't.
!  ***ENGLISH***  3: "Attempt to begin transcript failed.";
	    3: ".i le troci be le nu cfari fa le nu se tcidu vreji cu fliba";
	}

    ScriptOff:
	switch(n)
	{
!  ***ENGLISH***  1: "Transcripting is already off.";
	    1: ".i le nu se tcidu vreji cu pu ca'a sisti";
!  ***ENGLISH***  2: "^End of transcript.";
	    2: "^.i fanmo le nu se tcidu vreji";
!  ***ENGLISH***  3: "Attempt to end transcript failed.";
	    3: ".i le troci be le nu fanmo le nu se tcidu vreji cu fliba";
	}

    NotifyOn:
!  ***ENGLISH***  "Score notification on.";
	    ".i le pu'u jarco le nilji'a se galfi cu cfari";

    NotifyOff:
!  ***ENGLISH***  "Score notification off.";
	    ".i le pu'u jarco le nilji'a se galfi cu se fanmo";

    Places:
	print ".i do pu zvati ";

    Objects:
	switch(n)
	{
!  ***ENGLISH***  1: "Objects you have handled:^";
	    1: ".i do pu ponse ^";
!  ***ENGLISH***  2: "None.";
	    2: "noda";
!  ***ENGLISH***  3: print "   (worn)";
	    3: print "      to se dasni toi";
!  ***ENGLISH***  4: print "   (held)";
	    4: print "      to se jgari toi";
!  ***ENGLISH***  5: print "   (given away)";
	    5: print "      to do pu dunda toi";
!  ***ENGLISH***  6: print "   (in ", (name) x1, ")";
	    6: print "      to nenri ", (name) x1, " toi";
!  ***ENGLISH***  7: print "   (in ", (the) x1, ")";
	    7: print "      to nenri ", (the) x1, " toi";
!  ***ENGLISH***  8: print "   (inside ", (the) x1, ")";
	    8: print "      to nenri ", (the) x1, " toi";
!  ***ENGLISH***  9: print "   (on ", (the) x1, ")";
	    9: print "      to cpana ", (the) x1, " toi";
!  ***ENGLISH***  10: print "   (lost)";
	    10: print "      to se cirko toi";
	}

    Score:
!  ***ENGLISH***  if (deadflag) print "In that game you scored ";
!  ***ENGLISH***  else print "You have so far scored ";
!  ***ENGLISH***  print score, " out of a possible ", MAX_SCORE,
!  ***ENGLISH***  ", in ", turns, " turn";
!  ***ENGLISH***  if (turns~=1) print "s"; return;
	    if (deadflag) print ".i ca le pu se kelci do nilji'a ";
	    else print ".i do ca'a nilji'a li ";
	    print score, " fi'u ", MAX_SCORE,
	    " ca'o le ", turns, "roi nu zukte";

    FullScore:
	switch(n)
	{
!  ***ENGLISH***  1: if (deadflag) print "The score was ";
!  ***ENGLISH***  else          print "The score is ";
!  ***ENGLISH***  "made up as follows:^";
	    1: ".i le nilji'a cu ciste ^^";
!  ***ENGLISH***  2: "finding sundry items";
	    2: ".i le nu facki le vrici dacti";
!  ***ENGLISH***  3: "visiting various places";
	    3: ".i le nu klama le vrici stuzi";
!  ***ENGLISH***  4: print "total (out of ", MAX_SCORE; ")";
	    4: print "mulno nilji'a to fi'u ", MAX_SCORE; " toi";
	}

    Inv:
	switch(n)
	{
!  ***ENGLISH***  1: "You are carrying nothing.";
	    1: ".i do bevri noda";
!  ***ENGLISH***  2: print "You are carrying";
	    2: print ".i do bevri";
	}

    Take:
	switch(n)
	{
!  ***ENGLISH***  1: "Taken.";
	    1: ".i ca'a lebna";
!  ***ENGLISH***  2: "You are always self-possessed.";
	    2: ".i do ze'e ponse do";
!  ***ENGLISH***  3: "I don't suppose ", (the) x1, " would care for that.";
	    3: ".i mi na jimpe le du'u ", (the) x1, " cu nelci la'e di'u";
!  ***ENGLISH***  4: print "You'd have to get ";
!  ***ENGLISH***  if (x1 has supporter) print "off "; else print "out of ";
!  ***ENGLISH***  print_ret (the) x1, " first.";
	    4: print ".i ko pu'o se bilga le nu ";
	    if (x1 has supporter) print "klama le tolcpana be "; else print "klama le bartu be ";
	    print_ret (the) x1;
!  ***ENGLISH***  5: "You already have ", " ri", ".";
	    5: ".i ko pu ca'a ponse ri";
!  ***ENGLISH***  6: if (noun has pluralname) print "Those seem ";
!  ***ENGLISH***  else print "That seems ";
!  ***ENGLISH***  "to belong to ", (the) x1, ".";
	    6: ".i za'a ri se ponse ", (the) x1;
!  ***ENGLISH***  7: if (noun has pluralname) print "Those seem ";
!  ***ENGLISH***  else print "That seems ";
!  ***ENGLISH***  "to be a part of ", (the) x1, ".";
	    7: ".i za'a ri pagbu ", (the) x1;
!  ***ENGLISH***  8: print_ret (Cthatorthose) x1, " ", (isorare) x1,
!  ***ENGLISH***  "n't available.";
	    8: print_ret ".i ri na vi zvati";
!  ***ENGLISH***  9: print_ret (The) x1, " ", " cu", "n't open.";
	    9: print_ret ".i ", (The) x1, " ganlo";
!  ***ENGLISH***  10: if (x1 has pluralname) print "They're ";
!  ***ENGLISH***  else print "That's ";
!  ***ENGLISH***  "hardly portable.";
	    10: print " .i ri to'e se bevri^";
!  ***ENGLISH***  11: if (x1 has pluralname) print "They're ";
!  ***ENGLISH***  else print "That's ";
!  ***ENGLISH***  "fixed in place.";
	    11: ".i ri stali";
!  ***ENGLISH***  12: "You're carrying too many things already.";
	    12: ".i do ca'a bevri du'e dacti";
!  ***ENGLISH***  13: "(putting ", (the) x1, " into ", (the) SACK_OBJECT,
!  ***ENGLISH***  " to make room)";
	    13: ".i to punji ", (the) x1, (the) SACK_OBJECT,
	    " tezu'e le nu cupra le kunti canlu toi";
	}

    Drop:
	switch(n)
	{
!  ***ENGLISH***  1: if (x1 has pluralname) print (The) x1, " are ";
!  ***ENGLISH***  else print (The) x1, " is ";
!  ***ENGLISH***  "already here.";
	    1: print_ret ".i ", (The) x1, " cu ca'a diklo le vi stuzi^";
!  ***ENGLISH***  2: "You haven't got ", " ri", ".";
	    2: ".i do na ponse ri";
!  ***ENGLISH***  3: "(first taking ", (the) x1, " off)";
	    3: "to pamai do dasni vimcu ", (the) x1, " toi";
!  ***ENGLISH***  4: "Dropped.";
	    4: ".i ca'a falcru";
	}

    Remove:
	switch(n)
	{
!  ***ENGLISH***  1: if (x1 has pluralname) print "They are"; else print "It is";
!  ***ENGLISH***  " unfortunately closed.";
	    1: ".i ri .u'u galno";
!  ***ENGLISH***  2: if (x1 has pluralname)
!  ***ENGLISH***  print "But they aren't";
!  ***ENGLISH***  else print "But it isn't";
!  ***ENGLISH***  " there now.";
	    2: ".i .ua ri na zvati le vi stuzi";
!  ***ENGLISH***  3: "Removed.";
	    3: ".i ca'a vimcu";
	}

    PutOn:
	switch(n)
	{
!  ***ENGLISH***  1: "You need to be holding ", (the) x1,
!  ***ENGLISH***  " before you can put ", " ri",
!  ***ENGLISH***  " on top of something else.";
	    1: ".i ko bilga le nu jgari ", (the) x1,
	    " pu le nu do kakne le nu punji ", (the) x1,
	    " le cpana";
!  ***ENGLISH***  2: "You can't put something on top of itself.";
	    2: ".i na kakne le nu punji da le cpana be da";
!  ***ENGLISH***  3: "Putting things on ", (the) x1, " would achieve nothing.";
	    3: ".i le nu punji da le cpana be ", (the) x1, " cu se zukte fi zi'o zi'o";
!  ***ENGLISH***  4: "You lack the dexterity.";
	    4: ".i do na banzu stati";
!  ***ENGLISH***  5: "(first taking ", " ri", " off)^";
	    5: ".i to pamai vimcu ri le cpana toi";
!  ***ENGLISH***  6: "There is no more room on ", (the) x1, ".";
	    6: ".i mo'a kunti canlu cu cpana ", (the) x1;
!  ***ENGLISH***  7: "Done.";
	    7: ".i snada";
!  ***ENGLISH***  8: "You put ", (the) x1, " on ", (the) second, ".";
	    8: ".i do punji ", (the) x1, " le cpana be ", (the) second;
	}

    Insert:
	switch(n)
	{
!  ***ENGLISH***  1: "You need to be holding ", (the) x1,
!  ***ENGLISH***  " before you can put ", " ri",
!  ***ENGLISH***  " into something else.";
	    1: ".i bilga le nu ponse ", (the) x1,
	    " kei pu le nu do setca ri";
!  ***ENGLISH***  2: print_ret " ri", " can't contain things.";
	    2: print_ret ".i ri na kakne le na vasru";
!  ***ENGLISH***  3: print_ret ".i ", (The) x1, " ", " cu", " closed.";
	    3: print_ret ".i ", (The) x1, " cu ganlo";
!  ***ENGLISH***  4: "You'll need to take ", " ri", " off first.";
	    4: ".i ko pu'o nitcu le nu go'i kei fa le nu dasni vimcu ri";
!  ***ENGLISH***  5: "You can't put something inside itself.";
	    5: ".i na kakne le nu punji da le nenri be da";
!  ***ENGLISH***  6: "(first taking ", " ri", " off)^";
	    6: "to pamai dasni vimcu ri"; 
!  ***ENGLISH***  7: "There is no more room in ", (the) x1, ".";
	    7: ".i mo'a kunti canlu cu nenri ", (the) x1;
!  ***ENGLISH***  8: "Done.";
	    8: ".i snada";
!  ***ENGLISH***  9: "You put ", (the) x1, " into ", (the) second, ".";
	    9: ".i do punji ", (the) x1, " le nenri be ", (the) second;
	}

    EmptyT:
	switch(n)
	{
!  ***ENGLISH***  1: print_ret (The) x1, " can't contain things.";
	    1: print_ret ".i ", (The) x1, " cu na vasru";
!  ***ENGLISH***  2: print_ret (The) x1, " ", " cu", " closed.";
	    2: print_ret ".i ", (The) x1, " cu ganlo";
!  ***ENGLISH***  3: print_ret (The) x1, " ", " cu", " empty already.";
	    3: print_ret ".i ", (The) x1, " cu ca ca'a kunti";
!  ***ENGLISH***  4: "That would scarcely empty anything.";
	    4: ".i la'e di'u na rinka le nu kunti";
	}

    Give:
	switch(n)
	{
!  ***ENGLISH***  1: "You aren't holding ", (the) x1, ".";
	    1: ".i do na ponse ", (the) x1;
!  ***ENGLISH***  2: "You juggle ", (the) x1,
!  ***ENGLISH***  " for a while, but don't achieve much.";
	    2: ".i do kelci ", (the) x1,
	    " .iku'i rinka noda poi vajni";
!  ***ENGLISH***  3: print (The) x1;
!  ***ENGLISH***  if (x1 has pluralname) print " don't";
!  ***ENGLISH***  else print " doesn't";
!  ***ENGLISH***  " seem interested.";
	    3: print_ret ".i ", (The) x1, " na se cinri";
	}

    Show:
	switch(n)
	{
!  ***ENGLISH***  1: "You aren't holding ", (the) x1, ".";
	    1: ".i do na ponse ", (the) x1;
!  ***ENGLISH***  2: print_ret ".i", (The) x1, " ", " cu", " unimpressed.";
	    2: print_ret ".i ", (The) x1, " na se xlura fo ra";
	}

    Enter:
	switch(n)
	{
!  ***ENGLISH***  1: print "But you're already ";
!  ***ENGLISH***  if (x1 has supporter) print "on "; else print "in ";
!  ***ENGLISH***  print_ret (the) x1, ".";
	    1: print ".i ku'i do pu ca'a ";
	    if (x1 has supporter) print "cpana "; else print "nenri ";
	    print_ret (the) x1;
!  ***ENGLISH***  2: if (x1 has pluralname) print "They're"; else print "That's";
!  ***ENGLISH***  " not something you can enter.";
	    2: ".i ri na se nerkla";
!  ***ENGLISH***  3: "You can't get into the closed ", (name) x1, ".";
	    3: ".i do na kakne le nu nerkla le ganlo po'u ", (name) x1;
!  ***ENGLISH***  4: "You can only get into something freestanding.";
	    4: ".i ka'e nerkla da po'o poi na muvdu";
!  ***ENGLISH***  5: print "You get ";
!  ***ENGLISH***  if (x1 has supporter) print "onto "; else print "into ";
!  ***ENGLISH***  print_ret (the) x1, ".";
	    5: print ".i do klama ";
	    if (x1 has supporter) print "le cpana be "; else print "le nenri be ";
	    print_ret (the) x1;
!  ***ENGLISH***  6: print "(getting ";
!  ***ENGLISH***  if (x1 has supporter) print "off "; else print "out of ";
!  ***ENGLISH***  print (the) x1; ")";
	    6: print "to klama ";
	    if (x1 has supporter) print "le to'e cpana be "; else print "le to'e nenri be ";
	    print (the) x1; " toi";
!  ***ENGLISH***  7: if (x1 has supporter) "(getting onto ", (the) x1, ")^";
!  ***ENGLISH***  if (x1 has container) "(getting into ", (the) x1, ")^";
!  ***ENGLISH***  "(entering ", (the) x1, ")^";
	    7: if (x1 has supporter) "to do klama le cpana be ", (the) x1, " toi^";
	    if (x1 has container) "to do klama le nenri be ", (the) x1, " toi^";
	    "to do nerkla ", (the) x1, " toi^";
	}

    GetOff:
!  ***ENGLISH***  "But you aren't on ", (the) x1, " at the moment.";
	    ".i ku'i do na cpana ", (the) x1, " ca le ca mokca";

    Exit:
	switch(n)
	{
!  ***ENGLISH***  1: "But you aren't in anything at the moment.";
	    1: ".i ku'i do na nenri ca le ca mokca";
!  ***ENGLISH***  2: "You can't get out of the closed ", (name) x1, ".";
	    2: ".i do na ka'e barklu le ganlo po'i ", (name) x1;
!  ***ENGLISH***  3: print "You get ";
!  ***ENGLISH***  if (x1 has supporter) print "off "; else print "out of ";
!  ***ENGLISH***  print_ret (the) x1, ".";
	    3: print ".i do klama ";
	    if (x1 has supporter) print "le to'e cpana be "; else print "le to'e nenri be ";
	    print_ret (the) x1;
	}

    VagueGo:
!  ***ENGLISH***  "You'll have to say which compass direction to go in.";
	    ".i ko nitcu le nu cusku le farna poi do djica";

    Go:
	switch(n)
	{
!  ***ENGLISH***  1: print "You'll have to get ";
!  ***ENGLISH***  if (x1 has supporter) print "off "; else print "out of ";
!  ***ENGLISH***  print_ret (the) x1, " first.";
	    1: print ".i .ei do pu'o klama ";
	    if (x1 has supporter) print "le to'e cpana be "; else print "le to'e nenri be ";
	    print_ret (the) x1;
!  ***ENGLISH***  2: "You can't go that way.";
	    2: ".i do na ka'e klama le farne po la'e di'u";
!  ***ENGLISH***  3: "You are unable to climb ", (the) x1, ".";
	    3: ".i do na ka'e cpare ", (the) x1;
!  ***ENGLISH***  4: "You are unable to descend by ", (the) x1, ".";
	    4: ".i do na kakne le nu mo'ini'a cpare ", (the) x1;
!  ***ENGLISH***  5: "You can't, since ", (the) x1, " ", " cu",
!  ***ENGLISH***  " in the way.";
	    5: ".i do na kanke le nu klama kei mu'i le du'u ", (the) x1, " cu te ganlo";
!  ***ENGLISH***  6: print "You can't, since ", (the) x1;
!  ***ENGLISH***  if (x1 has pluralname) " lead nowhere.";
!  ***ENGLISH***  " leads nowhere.";
	    6: print_ret ".i do na kakne le nu go'i mu'i le du'u ", (the) x1, " cu na se pluta";
	}


    LMode1:
!  ***ENGLISH***  " is now in its normal ~brief~ printing mode, which gives long descriptions of places never before visited and short descriptions otherwise.";
	" ca se tcini le cmalu skicu noi kampu tcini zi'e poi cupra le
	barda skicu be mu'i le nu do na pu viska be'o .e le cmalu skicu
	be mu'i le nu do pu viska";

    LMode2:
!  ***ENGLISH***  " is now in its ~verbose~ mode, which always gives long descriptions of locations (even if you've been there before).";
	" ca se tcini le cmalu skicu noi kampu tcini zi'e poi roroi cupra le
	barda skicu be da to mu'inai le du'u do pu viska da toi";

    LMode3:
!  ***ENGLISH***  " is now in its ~superbrief~ mode, which always gives short descriptions of locations (even if you haven't been there before).";
	" ca se tcini le traji cmalu skicu noi kampu tcini zi'e poi cupra le
	cmalu skicu be da to mu'inai le du'u do na pu viska da";

    Look:
	switch(n)
	{
!  ***ENGLISH***  1: print " (on ", (the) x1, ")";
	    1: print " to cpana ", (the) x1, " toi";
!  ***ENGLISH***  2: print " (in ", (the) x1, ")";
	    2: print " to nenri ", (the) x1, " toi";
!  ***ENGLISH***  3: print " (as "; @print_obj x1; print ")";
	    3: print " to dunli "; @print_obj x1; print " toi";
!  ***ENGLISH***  4: print "^On ", (the) x1;
!  ***ENGLISH***  WriteListFrom(child(x1),
!  ***ENGLISH***      RECURSE_BIT + PARTINV_BIT
!  ***ENGLISH***  + TERSE_BIT + ISARE_BIT + CONCEAL_BIT);
!  ***ENGLISH***  ".";
	    4: print "^.i cpana ", (the) x1, " zo'u";
		WriteListFrom(child(x1),
	        RECURSE_BIT + PARTINV_BIT
		+ CONCEAL_BIT + NEWLINE_BIT + INDENT_BIT );
		"";
!  ***ENGLISH***  default: if (x1~=location) 
!  ***ENGLISH***  {
!  ***ENGLISH***  if (x1 has supporter) print "^On "; else print "^In ";
!  ***ENGLISH***  print (the) x1, " you";
!  ***ENGLISH***  }
!  ***ENGLISH***  else print "^You";
!  ***ENGLISH***  print " can ";
!  ***ENGLISH***  if (n==5) print "also "; print "see ";
!  ***ENGLISH***  WriteListFrom(child(x1),
!  ***ENGLISH***  WORKFLAG_BIT + RECURSE_BIT
!  ***ENGLISH***  + PARTINV_BIT + TERSE_BIT + CONCEAL_BIT);
!  ***ENGLISH***  if (x1~=location) ".";
!  ***ENGLISH***  " here.";
	    default: 
		if (x1~=location) 
		{
		    if (x1 has supporter)
			print "^.i cpana ";
		    else print "^.i nenri ";

		    print (the) x1, " zo'u do";

		}
		else print "^.i do";
		print " kakne le nu ";
		if (n==5) print "ji'a "; print "viska^";
		WriteListFrom(child(x1), WORKFLAG_BIT + RECURSE_BIT +
			PARTINV_BIT + CONCEAL_BIT + NEWLINE_BIT +
			INDENT_BIT );
		if (x1~=location) "";
		"vi le vi diklo";
	    }


    Examine:
	switch(n)
	{
!  ***ENGLISH***  1: "Darkness, noun.  An absence of light to see by.";
	    1: ".i zo manku cu se bridi .i se smuni le du'u lo gusni poi se pilno fi le nu viska cu na zasti";
!  ***ENGLISH***  2: "You see nothing special about ", (the) x1, ".";
	    2: ".i do na viska da poi vajni zi'e po ", (the) x1;
!  ***ENGLISH***  3: print (The) x1, " ", " cu", " currently switched ";
!  ***ENGLISH***  if (x1 has on) "on."; else "off.";
	    3: print ".i ", (The) x1, " cu ";
	    if (x1 has on) " tolcando"; else " cando";
	}

    LookUnder:
	switch(n)
	{
!  ***ENGLISH***  1: "But it's dark.";
	    1: ".i ku'i manku";
!  ***ENGLISH***  2: "You find nothing of interest.";
	    2: ".i do facki noda poi jai cinri";
	}


    Search:
	switch(n)
	{
!  ***ENGLISH***  1: "But it's dark.";
	    1: ".i ku'i manku";
!  ***ENGLISH***  2: "There is nothing on ", (the) x1, ".";
	    2: ".i noda cpana ", (the) x1;
!  ***ENGLISH***  3: print "On ", (the) x1;
!  ***ENGLISH***  WriteListFrom(child(x1),
!  ***ENGLISH***  TERSE_BIT + ENGLISH_BIT + ISARE_BIT + CONCEAL_BIT);
!  ***ENGLISH***  ".";
	    3: print ".i cpana ", (the) x1, " zo'u^";
	    WriteListFrom(child(x1),
	    CONCEAL_BIT + NEWLINE_BIT + INDENT_BIT );
		"";
!  ***ENGLISH***  4: "You find nothing of interest.";
	    4: ".i do facki noda poi jai cinri";
!  ***ENGLISH***  5: "You can't see inside, since ", (the) x1, " ",
!  ***ENGLISH***  " cu", " closed.";
	    5: ".i do na ka'e viska le nenri be ", (the) x1,
	    " ri'a le du'u ganlo";
!  ***ENGLISH***  6: print_ret (The) x1, " ", " cu", " empty.";
	    6: print_ret ".i ", (The) x1, " cu kunti";
!  ***ENGLISH***  7: print "In ", (the) x1;
!  ***ENGLISH***  WriteListFrom(child(x1),
!  ***ENGLISH***  TERSE_BIT + ENGLISH_BIT + ISARE_BIT + CONCEAL_BIT);
!  ***ENGLISH***  ".";
	    7: print ".i nenri ", (the) x1, " zo'u^";
	    WriteListFrom(child(x1),
	    CONCEAL_BIT + NEWLINE_BIT + INDENT_BIT );
		"";
	}


    Unlock:
	switch(n)
	{
!  ***ENGLISH***  1: if (x1 has pluralname) print "They don't ";
!  ***ENGLISH***  else print "That doesn't ";
!  ***ENGLISH***  "seem to be something you can unlock.";
	    1: print_ret ".i za'a ri na kakne le nu kikykalri";
!  ***ENGLISH***  2: print_ret " ri",
!  ***ENGLISH***  " unlocked at the moment.";
	    2: print_ret ".i ri cu ca ca'a kikykalri";
!  ***ENGLISH***  3: if (x1 has pluralname) print "Those don't ";
!  ***ENGLISH***  else print "That doesn't ";
!  ***ENGLISH***  "seem to fit the lock.";
	    3: print_ret ".i ri na ckiku le vi se ckiku";
!  ***ENGLISH***  4: "You unlock ", (the) x1, ".";
	    4: ".i do gasnu le nu ", (the) x1, " cu kikykalri";
	}

    Lock:
	switch(n)
	{
!  ***ENGLISH***  1: if (x1 has pluralname) print "They don't ";
!  ***ENGLISH***  else print "That doesn't ";
!  ***ENGLISH***  "seem to be something you can lock.";
	    1: print_ret ".i za'a ri na kakne le nu kikla'a";
!  ***ENGLISH***  2: print_ret " ri", " locked at the moment.";
	    2: print_ret ".i ri cu ca ca'a se kikla'a";
!  ***ENGLISH***  3: "First you'll have to close ", (the) x1, ".";
	    3: ".i pamai bilga le nu do gasnu le nu ", (the) x1, " cu ganlo";
!  ***ENGLISH***  4: if (x1 has pluralname) print "Those don't ";
!  ***ENGLISH***  else print "That doesn't ";
!  ***ENGLISH***  "seem to fit the lock.";
	    4: print_ret ".i ri na ckiku le vi se ckiku";
!  ***ENGLISH***  5: "You lock ", (the) x1, ".";
	    5: ".i do gasnu le nu ", (the) x1, " cu kikla'a";
	}


    SwitchOn:
	switch(n)
	{
!  ***ENGLISH***  1: print_ret " ri",
!  ***ENGLISH***  " not something you can switch.";
	    1: print_ret ".i do na ka'e kragau ri";
!  ***ENGLISH***  2: print_ret " ri",
!  ***ENGLISH***  " already on.";
	    2: print_ret ".i ri ca ca'a tolcando";
!  ***ENGLISH***  3: "You switch ", (the) x1, " on.";
	    3: ".i do kragau ", (the) x1;
	}

    SwitchOff:
	switch(n)
	{
!  ***ENGLISH***  1: print_ret " ri",
!  ***ENGLISH***  " not something you can switch.";
	    1: print_ret ".i do na ka'e famgau ri";
!  ***ENGLISH***  2: print_ret " ri",
!  ***ENGLISH***  " already off.";
	    2: print_ret ".i ri ca ca'a cando";
!  ***ENGLISH***  3: "You switch ", (the) x1, " off.";
	    3: ".i do famgau ", (the) x1;
	}


    Open:
	switch(n)
	{
!  ***ENGLISH***  1: print_ret " ri",
!  ***ENGLISH***  " not something you can open.";
	    1: print_ret ".i ri na ka'e binxo le ka kalri";
!  ***ENGLISH***  2: if (x1 has pluralname) print "They seem ";
!  ***ENGLISH***  else print "It seems ";
!  ***ENGLISH***  "to be locked.";
	    2: ".i ri cu se kikla'a";
!  ***ENGLISH***  3: print_ret " ri",
!  ***ENGLISH***  " already open.";
	    3: ".i ri ca ca'a kalri";
!  ***ENGLISH***  4: print "You open ", (the) x1, ", revealing ";
!  ***ENGLISH***  if (WriteListFrom(child(x1),
!  ***ENGLISH***  ENGLISH_BIT + TERSE_BIT + CONCEAL_BIT)==0) "nothing.";
!  ***ENGLISH***  ".";
	    4: print ".i do kargau ", (the) x1, " .iseri'abo jarco^";
	    if (WriteListFrom(child(x1),
	    CONCEAL_BIT + NEWLINE_BIT + INDENT_BIT )==0) "noda";
	    "";
!  ***ENGLISH***  5: "You open ", (the) x1, ".";
	    5: ".i do kargau ", (the) x1;
	}


    Close:
	switch(n)
	{
!  ***ENGLISH***  1: print_ret " ri",
!  ***ENGLISH***  " not something you can close.";
	    1: print_ret ".i ri na ka'e binxo le ka ganlo";
!  ***ENGLISH***  2: print_ret " ri",
!  ***ENGLISH***  " already closed.";
	    2: ".i ri ca ca'a ganlo";
!  ***ENGLISH***  3: "You close ", (the) x1, ".";
	    3: ".i do ga'orgau ", (the) x1;
	}

    Disrobe:
	switch(n)
	{
!  ***ENGLISH***  1: "You're not wearing ", " ri", ".";
	    1: ".i do na ca dasni ri";
!  ***ENGLISH***  2: "You take off ", (the) x1, ".";
	    2: ".i do dasni vimcu ", (the) x1;
	}

    Wear:
	switch(n)
	{
!  ***ENGLISH***  1: "You can't wear ", " ri", "!";
	    1: ".i do na kakne le nu dasni ri";
!  ***ENGLISH***  2: "You're not holding ", " ri", "!";
	    2: ".i do na ponse ri";
!  ***ENGLISH***  3: "You're already wearing ", " ri", "!";
	    3: ".i do ca ca'a dasni ri";
!  ***ENGLISH***  4: "You put on ", (the) x1, ".";
	    4: ".i do dasygau ", (the) x1;
	}

    Eat:
	switch(n)
	{
!  ***ENGLISH***  1: print_ret " ri",
!  ***ENGLISH***  " plainly inedible.";
	    1: print_ret ".i za'a ju'osai ri na cidja";
!  ***ENGLISH***  2: "You eat ", (the) x1, ". Not bad.";
	    2: ".i do cika ", (the) x1, " .i na xlali";
	}

    Yes, No:
!  ***ENGLISH***  "That was a rhetorical question.";
	    ".i di'u na preti";
    Burn:
!  ***ENGLISH***  "This dangerous act would achieve little.";
	    ".i la'e di'u cu ckape je bebna";
    Pray:
!  ***ENGLISH***  "Nothing practical results from your prayer.";
	    ".i rinka noda";
    Wake:
!  ***ENGLISH***  "The dreadful truth is, this is not a dream.";
	    ".i .iisai do na senva";

    WakeOther:
!  ***ENGLISH***  "That seems unnecessary.";
	    ".i na sarcu";

    Kiss:
!  ***ENGLISH***  "Keep your mind on the game.";
	    ".i ko jundi le dei se kelci";

    Think:
!  ***ENGLISH***  "What a good idea.";
	    ".i la'e di'u cu xamgu sidbo";

    Smell:
!  ***ENGLISH***  "You smell nothing unexpected.";
	    ".i do sumne noda poi spaji";

    Listen:
!  ***ENGLISH***  "You hear nothing unexpected.";
	    ".i do tirna noda poi spaji";

    Taste:
!  ***ENGLISH***  "You taste nothing unexpected.";
	    ".i do vusygau noda poi spaji";

    Touch:
	switch(n)
	{
!  ***ENGLISH***  1: "Keep your hands to yourself!";
	    1: ".i ko na pencu ri .oiro'a";
!  ***ENGLISH***  2: "You feel nothing unexpected.";
	    2: ".i do pencu ganse noda poi spaji";
!  ***ENGLISH***  3: "If you think that'll help.";
	    3: ".i mukti le nu do krici le du'u la'e di'u cu sidju to ju'onai toi";
	}

    Dig:
!  ***ENGLISH***  "Digging would achieve nothing here.";
	    ".i le nu kakpa te snada noda vi le vi stuzi";

    Cut:
!  ***ENGLISH***  "Cutting ", " ri", " up would achieve little.";
	    ".i le nu katna ri cu te snada noda";

    Jump:
!  ***ENGLISH***  "You jump on the spot, fruitlessly.";
	    ".i do plipe le vi mokca le vi mokca to .oiro'asai toi";

    JumpOver, Tie:
!  ***ENGLISH***  "You would achieve nothing by this.";
	    ".i do snada noda la'e di'u";

    Drink:
!  ***ENGLISH***  "There's nothing suitable to drink here.";
	    ".i noda se pinxe vi le vi stuzi";

    Fill:
!  ***ENGLISH***  "But there's no water here to carry.";
	    ".i no djacu cu vi zasti tepi'o le nu se bevri";

    Sorry:
!  ***ENGLISH***  "Oh, don't apologize.";
	    ".i ko na xenru";

    Strong:
!  ***ENGLISH***  "Real adventurers do not use such language.";
	    ".i bebna";

    Mild:
!  ***ENGLISH***  "Quite.";
	    ".i go'i";

    Attack:
!  ***ENGLISH***  "Violence isn't the answer to this one.";
	    ".i le nu vlile cu te snada noda";

    Swim:
!  ***ENGLISH***  "There's not enough water to swim in.";
	    ".i lei djacu cu na banzu le nu limna";

    Swing:
!  ***ENGLISH***  "There's nothing sensible to swing here.";
	    ".i noda poi se sligau cu zvati le vi stuzi";

    Blow:
!  ***ENGLISH***  "You can't usefully blow ", " ri", ".";
	    ".i le nu gacyse'a ri cu te snada noda";

    Rub:
!  ***ENGLISH***  "You achieve nothing by this.";
	    ".i do snada noda";

    Set:
!  ***ENGLISH***  "No, you can't set ", " ri", ".";
	    ".i do na ka'e tikygau ri";

    SetTo:
!  ***ENGLISH***  "No, you can't set ", " ri", " to anything.";
	    ".i do ka'e tikygau ri noda";

    WaveHands:
!  ***ENGLISH***  "You wave, feeling foolish.";
	    ".i do sligau le do xance to .oiro'a toi";

    Wave:
	switch(n)
	{
!  ***ENGLISH***  1: "But you aren't holding ", " ri", ".";
	    1: ".i ku'i do na ponse ri";
!  ***ENGLISH***  2: "You look ridiculous waving ", (the) x1, ".";
	    2: ".i do simlu le ka bebna fo le nu do sligau ", (the) x1;
	}

    Pull, Push, Turn:
	switch(n)
	{
!  ***ENGLISH***  1: if (x1 has pluralname) print "Those are ";
!  ***ENGLISH***  else print "It is ";
!  ***ENGLISH***  "fixed in place.";
	    1: print_ret ".i ri stali";
!  ***ENGLISH***  2: "You are unable to.";
	    2: ".i do na kakne";
!  ***ENGLISH***  3: "Nothing obvious happens.";
	    3: ".i rinka noda poi do ganse";
!  ***ENGLISH***  4: "That would be less than courteous.";
	    4: ".i do pu na ca'a gasnu le nu go'i mu'i le du'u le nu go'i cu tolclite";
	}

    PushDir:
	switch(n)
	{
!  ***ENGLISH***  1: "Is that the best you can think of?";
	    1: ".i ko zenba le ka xamgu pensi";
!  ***ENGLISH***  2: "That's not a direction.";
	    2: ".i na farna";
!  ***ENGLISH***  3: "Not that way you can't.";
	    3: ".i na kakne le nu catke le farnu po di'u";
	}

    Squeeze:
	switch(n)
	{
!  ***ENGLISH***  1: "Keep your hands to yourself.";
	    1: ".i ko na pencu ri .oiro'a";
!  ***ENGLISH***  2: "You achieve nothing by this.";
	    2: ".i do snada fi noda";
	}

    ThrowAt:
	switch(n)
	{
!  ***ENGLISH***  1: "Futile.";
	    1: ".i do snada noda";
!  ***ENGLISH***  2: "You lack the nerve when it comes to the crucial moment.";
	    2: ".i le ka do virnu cu na banzu";
	}

    Tell:
	switch(n)
	{
!  ***ENGLISH***  1: "You talk to yourself a while.";
	    1: ".i do ze'a tavla do";
!  ***ENGLISH***  2: "This provokes no reaction.";
	    2: ".i na frati";
	}

    Answer, Ask:
!  ***ENGLISH***  "There is no reply.";
	    ".i na spuda";

    Buy:
!  ***ENGLISH***  "Nothing is on sale.";
	    ".i noda se vecnu";

    Sing:
!  ***ENGLISH***  "Your singing is abominable.";
	    ".i le nu do sanga cu mutce melbi";

    Climb:
!  ***ENGLISH***  "I don't think much is to be achieved by that.";
	    ".i le nu cparu cu te snada noda";

    Wait:
!  ***ENGLISH***  "Time passes.";
	    ".i ze'a niltei";

    Sleep:
!  ***ENGLISH***  "You aren't feeling especially drowsy.";
	    ".i do na tatpi";

    Consult:
!  ***ENGLISH***  "You discover nothing of interest in ", (the) x1, ".";
	    ".i do facki noda poi cinri ku'o sepi'o ", (the) x1;
];

! ---------------------------------------------------------------------------

!***MDB*** Further notes to prospective authors - 
! See the note at the top of this file to learn what this stuff is for.
!
! To make things work, replace the library Includes in your story with
! the following
!
! Replace DrawStatusLine;
! Replace PronounsSub;
! Replace DoMenu; 
! Replace SetPronoun;
! Replace PronounNotice;
! 
! Include "ParserL";
! Include "VerbLibL";
! Include "LojbanR"; !***MDB*** - the standard header file
!
! Then you need to copy *.h from this tar to your Inform library
! location (on my machine that's /usr/lib/inform).
!
! All "."s in the player's commands are converted to "_"s and all ","s to "="s
! before they reach the parser. This means that when you want to match
! dictionary words to input, such as in a name property, you should use these
! substitutions. In other words, you should use "," and "." between double
! quotes (""""), and ! "=" and "_" between single quotes ("''"). So you might
! have - 
!
! Object Katherine "kat,r,in."
! with article "la",
! name 'kat=r=in_', 
! description ".i la kat,r,in. cizra"
! ;
!
! As usual, "'" becomes "^" for dictionary words. If for any reason you want to
! perform the reverse substutions, see LojSub in LojbanR.h. 
! Lastly, if you want to define multi-word verbs (using SE selma'o, say, or
! tenses) LTI_Verb_Contractions in Lojban.h might be useful. 
