
Object sc_3
  class Scene,
  with
	number 3,
	init_scene [;
		SetQuestion(q3_1);
	],
	begin_scene [ rock;
		tossguards.startup();
		baitguards.work_target = 0; ! ensure this is true until they come out
		equiptalker.number = 0;
		give equiptalker ~general;
		StartDaemon(equiptalker);
		give tossmetaldoor ~open;
		switch (rock) {
			1: ! first time in
				move activeplayer to TossJunction;
				SaveToolPositions();
				move equiptalker to SouthFrontier;
				give equiptalker ~general;
			2, -1, -2: ! all subsequent times (including boom/splat)
				move activeplayer to TossJunction;
				RestoreToolPositions();
		}
	],
	end_scene [ rock subrock   wasbait;
		wasbait = (baitguards in TossJunction);
		tossguards.shutdown();
		baitguards.shutdown();
		dooropenguards.shutdown();
		StopDaemon(equiptalker);
		switch (rock) {
			-1:
				if (wasbait && anywherein(acidpack, DeadEndHall)) {
					SetQuestion(q3_d10);
					rtrue;
				}
				SetAcidQuestions(subrock);
			-2:
				if (wasbait && anywherein(blasttab, DeadEndHall)) {
					SetQuestion(q3_d9);
					rtrue;
				}
				SetBlastQuestions(subrock);
			-3: ! security door open
				"The door opens, only it's ajar. Ha! Ha! Ha! [BUG]";
			1: ! guards stumble across you in the hall
				if (q3_d1 hasnt general) {
					give q3_d1 general;
					SetQuestion(q3_d1);
				}
				else if (q3_d1r hasnt general) {
					give q3_d1r general;
					SetQuestion(q3_d1r);
				}
				else {
					SetQuestion(q3_d1rr);
				}
			2: ! guards are baited, then see you.
				! subrock: 1 = threw a second item; 2 = junction door opened
				if (q3_d2 hasnt general) {
					give q3_d2 general;
					SetQuestion(q3_d2, subrock);
				}
				else {
					SetQuestion(q3_d2r, subrock);
				}
			3: ! woman sees you
				if (q3_d3 hasnt general) {
					give q3_d3 general;
					SetQuestion(q3_d3);
				}
				else {
					SetQuestion(q3_d3r);
				}
			4: ! back across red line
				if (q3_d4 hasnt general) {
					give q3_d4 general;
					SetQuestion(q3_d4);
				}
				else {
					SetQuestion(q3_d4r);
				}
			5: ! guards see open door, then you
				if (q3_d5 hasnt general) {
					give q3_d5 general;
					SetQuestion(q3_d5);
				}
				else {
					SetQuestion(q3_d5r);
				}
			6: ! hide in closet
				if (q3_d6 hasnt general) {
					give q3_d6 general;
					SetQuestion(q3_d6);
				}
				else {
					SetQuestion(q3_d6r);
				}
			7: ! left tools behind
				SetQuestion(q3_d7, subrock);
			8: ! baited with wrong item
				if (q3_d8 hasnt general) {
					give q3_d8 general;
					SetQuestion(q3_d8, subrock);
				}
				else if (q3_d8r hasnt general) {
					give q3_d8r general;
					SetQuestion(q3_d8r, subrock);
				}
				else {
					SetQuestion(q3_d8rr, subrock);
				}
			9: ! blew up baited guards
				SetQuestion(q3_d9);
			10: ! sprayed baited guards
				SetQuestion(q3_d10);
			20: ! success
				SetScene(sc_4);
		}
	];

! Emotional status to date:
! Minimum: 2 helpful, nothing else.
! Maximum: 2 blatant lies, 2 sneaky lies, 3 stubborns, 3 angries, 2 stupid.
!   Probably a little more, actually.
! (That's not counting acid/blast queries, which are 1 sneaky, 3 blatant,
! 3 stubborn, 1 angry; or 1 helpful.)

Object q3_1
  class Question,
  with
	query [;
		print "^The man nods with consideration. ~And off you went, through our
			secure zone like a scalpel through cheese. A plastic scalpel,~ he
			adds, smiling";
		if (num_helpfuls >= num_stubborns)
			print " at you";
		else
			print " distantly";
		if (scrambler has general) {
			print ", ~so I don't know why you turned on";
			if (q2_d3 hasnt general)
				print " that charming countermeasure device. Even if you ",
					(emphstring) "had", " been carrying metal, your orange
					miracle could only have hidden it for a few minutes.
					Thus -- you had none. At";
			else
				print " that charming device. As I said, it couldn't have
					hidden metal for any length of time. Thus -- you had
					none. At";
		}
		else {
			print ". ~At";
		}
		print " least our scan-web keeps spies from carrying guns with them
			when they stroll through our bases.~ He pauses a moment. 
			~Or does your side have nonmetallic guns now?~^";
	],
	time_limit 6,
	daemon [;
		if (self.number == 3) {
			print "^~We've been working on an optical pulse gun core for
				years, of course. But no luck, and we'd be very surprised
				if you'd beaten us to it. I don't suppose you have?~^";
		}
	],
	answer_yes [; 
		if (num_blatant_lies + num_sneaky_lies >= 2) 
			print "~Now you're lying again.";
		else
			print "~No, don't start lying now.";
		num_sneaky_lies++;
		print " We would know if you had such things, and you would know
			that we would...~";
		SetQuestion(q3_2);
	],
	answer_no [;
		num_helpfuls++;
		print "~No. We would know, and you would know that we would...~";
		SetQuestion(q3_2);
	],
	answer_wait [;
		if (num_wait_answers > num_yes_answers + num_no_answers)
			print "~No, I didn't think you'd answer. But you don't.";
		else
			print "~Come, you don't have to freeze up over such a simple matter.";
		num_stubborns++;
		print " We would know if you had such things, and you would know
			that we would...~";
		SetQuestion(q3_2);
	];

Object q3_2
  class Question,
  with
	query " A silence draws out, and you look to find the man staring at a
		far wall, as if you and your chair had dissolved away.
		Then, thoughtfully,
		~For all the effort we put into secrets, my people and yours,
		do we ever manage to keep any?~ His eyes are on you again.",
	time_limit 5,
	answer_yes [;
		num_stubborns++;
		print "~Yes, and here you are. Because you don't have ", 
			(emphstring) "this", " one. And this is the secret that matters.
			You didn't get it, and we can keep it just a little longer.~^";
		SetQuestion(q3_3, 1);
	],
	answer_no [;
		num_cosmos++;
		print "~No, and here you are. Because you don't have ", 
			(emphstring) "this", " one. And this is the secret that matters.
			You didn't get it, and we can keep it just a little longer.~^";
		SetQuestion(q3_3, 0);
	],
	answer_wait [;
		if (num_helpfuls >= 1 && num_got_angry == 0)
			print "His smile is open now. ~Point taken. But";
		else
			print "His smile is chilly. ~Point taken... for now.~ His eyes shift
				up to your temples. ~But";
		print " here you are. Because you don't have ", 
			(emphstring) "this", " secret. And this is the one that matters.
			You didn't get it, and we can keep it just a little longer.~^";
		SetQuestion(q3_3, 2);
	];

Object q3_3
  class Question,
  with
	query [; rtrue; ],
	time_limit 3,
	answer_general [;
		print "~A little longer is all we need.~^^He shakes his head sharply.
			~A bit more time here, as well.";
		if (num_blatant_lies + num_sneaky_lies >= 3) 
			print " And please don't waste any more of it with fantasy.";
		else if (num_stubborns >= 3)
			print " And I hope you'll be a little more forthcoming; I ",
				(emphstring) "will", " eventually get bored.";
		else
			print " I hope you'll continue to cooperate.";
		print " Your next move must have been...~^";
		BeginScene(1);
	],
	answer_yes [;
		num_helpfuls++;
		self.answer_general();
	],
	answer_no [;
		num_jingos++;
		self.answer_general();
	],
	answer_wait [;
		num_sneaky_lies++;
		self.answer_general();
	];

Object q3_d1
  class Question,
  with
	query "^~The squad on Mobile Three, the ones you say stumbled into you.
		You do have their images right; I know you saw them. But they say they
		never saw you. Did they lie?~",
	time_limit 3,
	answer_yes [;
		if (num_sneaky_lies + num_blatant_lies >= 3)
			print "~And you're the expert,~ he says, scowling. ~";
		else
			print "~Ah. They'll be hurt to hear so. ";
		print "But for right now, I'm talking to you. So try it again.~^";
		num_blatant_lies++;
		BeginScene(2);
	],
	answer_no [;
		print "~";
		if (num_helpfuls <= 1)
			print "A helpful answer at last! ";
		print "Thank you. Now let's have it again.~^";
		num_helpfuls++;
		BeginScene(2);
	],
	answer_wait [;
		print "The man taps the desk absently. ~I don't know what you think to
			gain. This is the part of the story that I ", (emphstring) "can",
			" verify; Mobile Three was there, even if you slipped by them.
			The sooner you run through it, the sooner we can leave.";
		if (num_got_angry >= 2 || num_stubborns >= 4)
			print " Or rather,~ he adds, ~the sooner I can leave. You can
				sit there all night.";
		else
			print " I doubt you're enjoying this either.";
		print "~^";
		num_stubborns++;
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q3_d1r
  class Question,
  with
	query "^~No, understand, this isn't in question. The guards did not see
		you, not toenail or eyebrow. They heard a noise, 
		something clattering across the floor,
		in the eastern dead-end corridor. That's what they investigated.
		That's what you're trying to explain here. Clear?~",
	time_limit 3,
	answer_yes [;
		print "~Good.~^";
		BeginScene(2);
	],
	answer_no [;
		print "The man stares at you. ~Enough. I don't need your cooperation.~
			He touches a sequence of controls.^";
		BrainDrain();
	],
	answer_wait [;
		num_got_angry++;
		print "The man stares at you. ~Do you have ", (emphstring) "any", 
			" sense of self-preservation? I'm doing this the long way because
			I don't like shredding people. If you play stubborn enough, I'll
			stop.~ He punches a control, harder than necessary.^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked
	
Object q3_d1rr
  class Question,
  with
	query [;
		print "^~Except they didn't see you there.~
			The man touches a control before you can respond.^";
		BeginScene(2);
	];

Object q3_d2
  class Question,
  with
	query [;
		print "^~So, most of the story. The guards heard a noise where nothing should
			have moved; they ran to investigate. But they did not report seeing ",
			(emphstring) "you.";
		if (self.variant == 1) 
			print " Nor a further rain of mysterious tools on their backs.";
		if (self.variant == 2) 
			print " Much less a security door opening behind their backs.";
		" I don't think we need to make things any more complicated.~";
	],
	time_limit 2,
	answer_yes [;
		print "Curiosity raises a brow. ~We do? By all means, go on.~^";
		BeginScene(2);
	],
	answer_no [;
		print "~Good. Finish it, then.~^";
		BeginScene(2);
	],
	answer_wait [;
		num_stubborns++;
		print "Impatience sparks in his eye. ~Now, please.~^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q3_d2r
  class Question,
  with
	query [;
		print "^~The point of distracting the guards, I assume, is so that they ",
			(emphstring) "wouldn't", " see you.";
		if (self.variant == 2) 
			print " And they said nothing about a suddenly-open door, either.";
		print "~ The man touches a control before you can respond.^";
		BeginScene(2);
	];

Object q3_d3
  class Question,
  with
	query [;
		new_line;
		if (num_sneaky_lies >= 2)
			print "~You can't think I'm stupid.";
		else if (num_blatant_lies >= 2)
			print "~Look now, I ", (emphstring) "am", " still paying attention.";
		else
			print "~Eh? That's not right.";
		print " The professor didn't see you";
		if (q3_d1 has general || q3_d2 has general)
			print " either";
		else
			print " at all";
		print ".~ The man touches a control.^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q3_d3r
  class Question,
  with
	query [;
		print "^~Well, except she says she had no idea you existed.~
			The man touches a control.^";
		BeginScene(2);
	];

Object q3_d4
  class Question,
  with
	query "^~I don't think so. There were people up and down the west corridor
		during that interval. You weren't seen back there.
		Besides, it would hardly be elegant,~ and he smiles
		very suddenly. ~We've had that part of the story. Repeating it would
		be redundant, yes? Bad art.~",
	time_limit 4,
	answer_yes [;
		num_cosmos++;
		num_helpfuls++;
		print "~Yes!~";
		SetQuestion(q3_d41);
	],
	answer_no [;
		num_cosmos++;
		print "~You don't think so? You must not have had my fiction tutor.~";
		SetQuestion(q3_d41);
	],
	answer_wait [;
		num_jingos++;
		if (num_got_angry == 0) {
			print "~Well, I suppose art isn't the nearest thing to your mind
				right now.~ The man's eyes drop reflectively for a few seconds.
				~It wouldn't be. I'm sorry.~ He touches a control before you can
				think of a thing to say.^";
		}
		else {
			print "~Well, I suppose art isn't something you care about much,~
				the man says shortly. He touches a control.^";
		}
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q3_d41
  class Question,
  with
	query " You did not expect to hear a chuckle in this room. ~For
		all the stakes, it comes down to you telling stories, doesn't
		it? You spin me a story, and I listen.~",
	time_limit 4,
	answer_yes [;
		print "He nods. ~The oldest profession.";
		if (num_helpfuls >= 1 && num_stubborns <= 2) 
			print " And you've been telling it well.";
		else {
			print " Although you've been reluctant";
			if (num_got_angry)
				print " -- I can't expect better, I suppose.";
			else
				print " -- I can't blame you, I suppose.";
		}
		print " Anyway.~ He blinks. ~This verse isn't yet right.~
			He touches a control.^";
		num_cosmos++;
		BeginScene(2);
	],
	answer_no [;
		print "~Ah, a pity. Under that banner, this might almost have been
			a pleasant process...~ He gazes somewhere for a moment. 
			~But I suppose this is too serious, for you, to be a story.~
			He shakes his head, and touches a control.^";
		BeginScene(2);
	],
	answer_wait [;
		print "~Surprised? Or just stage fright?";
		if (num_helpfuls >= 1 && num_stubborns <= 2) 
			print " Don't fear -- you've been telling it well.";
		else 
			print " You've been reluctant enough, yes. Well, I'm still listening
				regardless.";
		print "~ He reaches for his controls.^";
		BeginScene(2);
	];

Object q3_d4r
  class Question,
  with
	query [;
		print "^~Stories or none, I know you haven't been back to the
			west corridor.~
			The man touches a control.^";
		BeginScene(2);
	];

Object q3_d5
  class Question,
  with
	query [;
		new_line;
		if (num_blatant_lies >= 2)
			print "~That's a little much even for you.";
		else if (num_sneaky_lies >= 2)
			print "~You're usually more subtle than this.";
		else
			print "~Not exactly.";
		print " The guards never reported seeing any open doors, much less
			your clever shadow.~^";
		num_dumb_recall++;
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q3_d5r
  class Question,
  with
	query [;
		print "^~Stalling isn't going to help. No open doors, no getting caught.~^";
		BeginScene(2);
	];

Object q3_d6
  class Question,
  with
	query [;
		print "^Impatience is plain between his eyes, now. ~Yes, you had time to
			get inside. But the door, did you notice, would have come open in
			full view of Mobile Three? You ", (emphstring) "did", " notice, in
			truth, that's what you showed me.~^^He shakes his head. ~But Three
			says they didn't see you at all, and they certainly didn't see you
			fooling around with that door, and they ", (emphstring) "certainly", 
			" didn't enact that tableau at the end. With the guns.~ He seems
			particularly disgusted with that touch, for some reason. ~Is it,
			what, you just enjoy a dramatic scene?~^";
	],
	time_limit 2,
	answer_yes [;
		num_stubborns++;
		print "~Spare me.~ He touches a control.^";
		BeginScene(2);
	],
	answer_no [;
		num_got_angry++;
		num_stubborns++;
		print "~Then what? You promised your mother six blatant lies every
			day before luncheon? No, don't answer that.~ He touches a control.^";
		BeginScene(2);
	],
	answer_wait [;
		num_stubborns++;
		print "~Oh, I see. A dramatic pause. I ", (emphstring) "am", " sorry
			I asked.~ He reaches for his controls.^";
		BeginScene(2);
	];

Object q3_d6r
  class Question,
  with
	query [;
		print "^~No, no. The guards didn't see the door open; they didn't see
			you duck inside; and they didn't see that lockpick fall on the --~^^
			The man's face goes entirely blank for a moment, and then he's
			playing controls faster than you can follow. ~Mobile Six? Get back
			there and check the closet again -- no, ", (emphstring) "inside,", 
			" he ", (emphstring) "did", " --~ Confused noises come from the
			desk. ~Assume there's no time at all!~ the man says, and it's not
			a shout only because his voice is so low. And then he turns his
			gaze back to you.^";
		BrainDrain();
	];

Object q3_d7
  class Question,
  with
	query [;
		print "^~Now, I know you're not that careless.";
		if (self.variant == 1)
			print " We didn't find anything";
		else
			print " We didn't find ", (the) self.variant, " or anything else";
		print " left behind";
		print ". It's a small matter but I can't let it slip.~^";
		BeginScene(2);
	];

Object q3_d8
  class Question,
  with
	query [;
		print "^~A streetcorner dazzler would be proud. You distract Mobile
			Three with ",
			(the) self.variant, "; when they follow the noise, you
			walk up the corridor. Yes?~^";
	],
	time_limit 4,
	answer_yes [;
		print "~...and then they bring ", (the) self.variant, " to Security's
			attention.~ He turns a palm out, displaying the silver rod in his hand.
			~And it looks, instead, a great deal like your lockpick. Not that
			they knew what it was at the time, of course. But we may as well correct
			the detail of which object you threw.~
			He touches a control.^";
		BeginScene(2);
	],
	answer_no [;
		print "~...no, because what the guards found looked a great deal more
			like your lockpick.~ He turns a palm out, displaying the silver rod
			in his hand.
			~Not that they knew what it was at the time, of course. But we may
			as well correct the detail of which object you threw.~
			He touches a control.^";
		BeginScene(2);
	],
	answer_wait [;
		print "The man turns a palm out, displaying the silver rod in his hand.
			~The '", (name) self.variant, "' looked a great deal like your
			lockpick. Or at
			least it did when the guards brought it to Security's attention.
			It hardly matters, as they didn't know what it was at the time; 
			but we may as well correct the detail.~
			He touches a control.^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q3_d8r
  class Question,
  with
	query [;
		num_dumb_recall++;
		print "^~The object that the guards heard was this
			rod. You aren't going to convince anyone that it was ",
			(the) self.variant, "; they brought it straight to me, you
			understand, to my hand. Well,~ -- he flicks fingers -- ~to
			my hand, after Security had scanned it seven ways. Naturally.
			But here it is.~
			He touches a control before you can reply.^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked

Object q3_d8rr
  class Question,
  with
	query [;
		print "^~The '", (name) self.variant, "' that the guards heard was the
			lockpick.";
		if (self.variant == acidpack)
			print "~ He sounds somewhat acid himself.";
		else
			print "~ His tone is acid.";
		print " ~I realize you're enjoying your story, but there must be
			other details you can embellish.~ He touches a control before you can
			reply.^";
		BeginScene(2);
	];

Object q3_d9
  class Question,
  with
	query [;
		print "^~Very dramatic -- a play worthy of a storytale spy.
			But somehow, I think the guards would have noticed being 
			blown apart.~
			The man touches a control before you can respond.^";
		BeginScene(2);
	];

Object q3_d10
  class Question,
  with
	query [;
		print "^~A play worthy of a storytale spy.
			But somehow, I think the guards would have noticed being 
			sprayed with a chemical that would melt their guns, scar the
			door beside them, and -- what was it? -- make them itch
			miserably.~
			The man touches a control before you can respond.^";
		BeginScene(2);
	];


! ------------- The pick-throwing scene

Object tossguards "guards"
  with
	name 'trio' 'guard' 'guards' 'footstep' 'footsteps' 'step' 'steps',
	short_name [;
		if (self.work_target == location)
			print "guards";
		else
			print "footsteps";
		rtrue;
	],
	found_in [; rtrue; ], ! they're everywhere!
	! ok, not exactly everywhere. This is where they're visible. 
	work_target 0, 
	dir_name [;
		! switch on where you are, not on where the guards are.
		switch (location) {
			TossJunction: print "north";
			SouthFrontier: print "east";
			DeadEndHall: print "west";
			default: print "(away from ", (the) location, ") [BUG]";
		}
		rtrue;
	],
	description [;
		if (self.work_target == location)
			"There are three guards around the corner, coming towards you. You'd
				rather not stick your head out to look more closely.";
		else
			print_ret "Footsteps are approaching, from somewhere up the corridor,
				to the ", (nop) self.dir_name(), ".";
	],
	react_before [;
		Listen:
			if (noun == 0) {
				print "(to ", (the) self, ")^";
				<<Listen self>>;	
			}
		Hide:
			if (self.work_target == location)
				return L__M(##Hide, 2);
			else
				return L__M(##Hide, 4);
	],
	before [ ix;
		Examine:
			rfalse;
		Listen:
			if (self.work_target == location) {
				print "The guards to the ", (nop) self.dir_name(), 
					" are";
				if (self.number2 == -1) {
					ix = 0;
				}
				else {
					ix = random(7) - 1;
					if (ix == self.number2)
						ix = random(7) - 1;
				}
				self.number2 = ix;
				switch (ix) {
					0: print " talking quietly, something about the mysterious
						lab they're protecting.";
					1: print " talking quietly, something about the terrible
						pay.";
					2: print " talking quietly, something about blind-eyed
						scientists.";
					3: print " talking quietly, something about the same old
						white walls.";
					default: print " not speaking.";
				}
				" Their footfalls are quiet and steady.";
			}
			else if (self.work_target == SecurityBranch 
				&& location == SouthFrontier or DeadEndHall)
				print_ret "The footfalls are far to the ", (nop) self.dir_name(),
					", barely audible.";
			else {
				print "The footfalls to the ", (nop) self.dir_name(), 
					" are quiet and steady.";
				if (self.number2 == -1) {
					ix = 0;
				}
				else {
					ix = random(5) - 1;
					if (ix == self.number2)
						ix = random(5) - 1;
				}
				self.number2 = ix;
				switch (ix) {
					0: print " You catch soft murmuring, some laughing remark about
						the mysterious lab.";
					1: print " You catch soft murmuring, some wry remark about
						boredom.";
					2: print " You catch soft murmuring, some remark about uniforms.";
				}
				new_line;
				rtrue;
			}
		default:
			if (self.work_target == location)
				print_ret "The guards are up the corridor to the ", 
					(nop) self.dir_name(), ".";
			else
				"Whoever is making the noise is not visible.";
	],
	life [;
		<<Touch self>>;
	],
	startup [;
		tossguards.number = 0;
		tossguards.number2 = -1;
		tossguards.work_target = SecurityBranch;
		give tossguards ~absent;
		give tossguards ~general; ! no see warning
		StartDaemon(tossguards);
	],
	shutdown [;
		StopDaemon(self);
		give self absent;
		self.work_target = 0;
		remove self;
	],
	number 0, ! daemon counter
	number2 0, ! talking counter
	daemon [;
		self.number++;
		
		! Do
		switch (self.number) {
			5:
				self.work_target = TossJunction;
				if (location == TossJunction)
					print_ret "^The footsteps move out of a branch corridor to the 
						north -- a trio of guards, still heading this way. You
						dodge back out of their line of view, flattening yourself
						inside the west side of the tee.";
			11:
				self.work_target = SouthFrontier;
				if (location == SouthFrontier) {
					print_ret "^You duck back into the northwest hall as the
						guards come around the corner. A quick glance reveals that
						they are heading west now, towards you.";
				}
				else if (location == DeadEndHall or TossJunction) {
					print "^The guards come around the corner. Well-trained guards,
						of course, look both ways when they enter an intersection.
						For a moment you stare at them
						staring at you. Then they draw their weapons.^";
					EndScene(1);
					rtrue;
				}
			17:
				print "^The guards come around the corner. One glances south,
					and begins to wave to the woman at the end of the hall. The
					other two do not, and find themselves looking right at you. They
					hesitate only for the barest fraction of a second.^";
				EndScene(1);
				rtrue;
		}
		
		! See
		if (self.work_target == SouthFrontier 
			&& location == TossJunction or DeadEndHall) {
			print "^You see the puppetteers working the guards. [BUG]^";
		}
		else if (self.work_target == SecurityBranch 
			&& location == SouthFrontier or DeadEndHall) {
			! very far
			if (self.number % 2 == 0)
				print "^Distant footsteps sound somewhere to the ", 
					(nop) self.dir_name(), ".^";
		}
		else if (self.work_target ~= location) {
			! far
			switch (self.number) {
				1:
					print "^You hear footsteps somewhere to the ", 
						(nop) self.dir_name(), ".^";
				2:
					print "^The footsteps seem to be approaching.^";
				5:
					if (location == DeadEndHall)
						print "^The footsteps are clearer now.^";
				10:
					if (location == DeadEndHall)
						print "^The footsteps to the ", (nop) self.dir_name(), 
							" are very clear now.^";
					else
						print "^The footsteps to the ", (nop) self.dir_name(), 
							" grow louder.^";
				default:
					if (self.number % 2 == 0)
						print "^The footsteps to the ", (nop) self.dir_name(), 
							" grow louder.^";
			}
		}
		else {
			! near
			if (self.number == 4 or 10 or 16)
				print "^The guards have nearly reached the corner that
					conceals you.^";
			else
				print "^You hear the guards coming closer.^";
		}
	],
  has scenery animate pluralname absent; ! general means you've gotten some see-warning

Object baitguards "guards"
  with
	name 'trio' 'three' 'guard' 'guards',
	description "Three guards are at the end of the hall, to the east.
		They are inspecting something on the ground -- two are kneeling,
		the third standing over them. Their backs are towards you
		at the moment.",
	react_before [;
		Listen:
			if (noun == 0) {
				print "(to ", (the) self, ")^";
				<<Listen self>>;	
			}
		Hide:
			return L__M(##Hide, 2);
	],
	before [;
		Examine:
			rfalse;
		Listen:
			"They are speaking too softly for you to hear.";
		default:
			"The guards are off to the east.";
	],
	life [;
		<<Touch self>>;
	],
	work_target 0, ! the thing that got their attention
	startup [ targ;
		move self to TossJunction;
		self.work_target = targ;
		StartDaemon(self);
		self.number = 0;
		if (targ == 0)
			print "The guards develop an obsession with nothing. [BUG]^";
	],
	shutdown [;
		remove self;
		StopDaemon(self);
	],
	number 0,
	daemon [;
		self.number++;
		switch (self.number) {
			! number==1 happens the same turn as the startup
			2:
				print "^One of the guards pulls out a comm and begins speaking
					into it.^";
			4:
				print "^One of the guards stands up; in the movement she turns,
					and sees you. Without pausing she draws her gun and
					shouts for you to freeze.^";
				EndScene(2);
				rtrue;
		}
	],
  has scenery animate pluralname; 

Object dooropenguards "guards"
  with
	name 'trio' 'three' 'guard' 'guards',
	description "There are three guards around the corner, hurrying towards you --
		or rather towards the door that just opened in front of them.",
	react_before [;
		Listen:
			if (noun == 0) {
				print "(to ", (the) self, ")^";
				<<Listen self>>;	
			}
		Hide:
			return L__M(##Hide, 2);
	],
	before [;
		Examine:
			rfalse;
		Listen:
			"The guards are not speaking.";
		default:
			"The guards are off to the north.";
	],
	life [;
		<<Touch self>>;
	],
	startup [;
		move self to TossJunction;
		StartDaemon(self);
		self.number = 0;
	],
	shutdown [;
		remove self;
		StopDaemon(self);
	],
	number 0,
	daemon [;
		self.number++;
		switch (self.number) {
			! number==1 happens the same turn as the startup
			2:
				print "^The guards charge into the junction, looking in every
					direction at once.";
				if (player in TossJunction or DeadEndHall)
					print " You have no cover at all.^";
				else
					print " You dodge for the northwest corridor, but not fast
						enough; shouts rise behind you, and the guards give
						chase.^";
				EndScene(5);
				rtrue;
		}
	],
  has scenery animate pluralname; 

Object TossJunction "Tee Junction"
  with
	description [;
		print "The white corridor runs east to west here, with a branch leading
			off to the north, and a";
		if (tossmetaldoor has open)
			print " open";
		else
			print " closed";
		print " metal door to the south.";
		if (tossguards.work_target == self || dooropenguards in self)
			print " You are poised against the wall, just inside the western
				hallway, out of sight of the guards to the north.";
		if (powercut == 0)
			print " You can see that the east hall reaches a dead end a
				short distance away.";
		if (baitguards in self)
			print " Three guards stand in the dead end, their backs to you.";
		new_line;
		rtrue;
	],
	e_to [;
		if (tossguards.work_target == self) {
			if (tossguards hasnt general) {
				give tossguards general;
				"If you cross the north hallway in front of the guards, they'll
					certainly see you.";
			}
			print "You leap across the intersection, into the dead end. Behind
				you, the guards begin to shout.^";
			EndScene(1);
			rtrue;
		}
		if (dooropenguards in self) {
			print "You leap across the intersection, into the dead end. Behind
				you, the guards begin to shout.^";
			EndScene(5);
			rtrue;
		}
		if (baitguards in self) {
			print "You stroll down the dead end to where the guards are. They turn,
				look you up and down, and all simultaneously pile on top of you.^";
			EndScene(2);
			rtrue;
		}
		return DeadEndHall;
	],
	n_to [;
		if (tossguards.work_target == SecurityBranch) {
			PlayerTo(SecurityBranch, 2);
			print "^As you step into the intersection, three guards walk out of the
				northeast branch. For a moment they stare at you staring at them.
				Then they draw their weapons.^";
			EndScene(1);
			rtrue;
		}
		else if (tossguards.work_target == self) {
			if (tossguards hasnt general) {
				give tossguards general;
				"You consider the possible results of walking right up to three
					armed guards.";
			}
			else {
				print "You step out into the intersection and casually walk up to 
					the guards. They casually draw their pulse guns and point
					them at you.^";
				EndScene(1);
				rtrue;
			}
		}
		else if (tossguards.work_target ~= 0) {
			"That area of the dungeon isn't built yet. [BUG]";
		}
		if (dooropenguards in self) {
			print "You step out into the intersection, into the guards' faces.
				They converge and roll over you without any hesitation at all.^";
			EndScene(5);
			rtrue;
		}
		if (baitguards in self) {
			print "You hold your breath and slip around the corner, out of the
				guards' line of sight. And pause... and there is no cry of alarm.
				You exhale -- silently -- and stroll off to the north.^";
			TryPassGuards();
			rtrue;
		}
		return SecurityBranch;
	],
	w_to [;
		if (dooropenguards in self) {
			print "You dash down the west corridor, as quickly as you can.^";
			return SouthFrontier;
		}
		if (baitguards in self) {
			print "You begin edging down the west corridor, away from the guards.
				But quiet as you are, you're no more than halfway to the
				next junction when one of them turns around.^";
			EndScene(2);
			rtrue;
		}
		if (escaping) {
			if (powercut == 0) { 
				"You move down the west corridor; but as you approach the
					junction, you hear voices. The corridor where you were
					captured sounds like it's still being searched. You
					don't dare even look; you slide back to the tee intersection,
					as quietly as you can.";
			}
		}
		return SouthFrontier;
	],
	s_to tossmetaldoor,
	cant_go "Hallways lead west, east, and north.";

Object -> tossend "dead end"
  with
	name 'short' 'hall' 'hallway' 'east' 'eastern' 'e//' 'dead' 'end',
	description [;
		if (powercut == 0)
			"From here, you can only see a short hallway which ends by a
				metal door.";
		else
			"The dead end is shadowed and dark.";
	],
	react_before [;
		ThrowDir:
			if (second == e_obj)
				<<ThrowAt noun self>>;
	],
	before [;
		Examine:
			rfalse;
		Enter:
			<<Go e_obj>>;
		ThrownAt:
			if (escaping) {
				print (The) noun, " clatters down the hall into the dead end.^";
				move noun to DeadEndHall;
				rtrue;
			}
			if (baitguards in TossJunction) {
				multi_interrupt = 1;
				print (The) noun, " clatters down the hall into the dead end. The
					guards whirl around, of course, and see you instantly.^";
				EndScene(2, 1);
				rtrue;
			}
			if (dooropenguards in TossJunction) {
				print (The) noun, " clatters down the hall into the dead end. The
					guards, intent on the open door, do not seem to notice.^";
				move noun to DeadEndHall;
				rtrue;
			}
			switch (tossguards.work_target) {
				SecurityBranch:
					print (The) noun, " clatters down the hall into the dead end.^";
					move noun to DeadEndHall;
					rtrue;
				TossJunction:
					print (The) noun, " clatters down the hall into the dead end.^";
					move noun to DeadEndHall;
					print "^~Did you hear that?~ comes a voice from the north.
						~Sounded like it was coming from the wiring closet,~
						another guard says, a frown in his tone.^^The footsteps
						begin to hurry. The three guards round the corner, and
						run down the east hall -- without a glance at where you
						huddle in the western branch.^";
					tossguards.shutdown();
					baitguards.startup(noun);
					multi_interrupt = "(Because of the guards, your list of commands
						has been cut short.)";
					rtrue;
				default: 
					print_ret (The) noun, " falls down a mousehole. [BUG]";
			}
		Receive:
			<<ThrowAt noun self>>;
		default:
			"The dead end is off to the east.";
	],
  has scenery;

Object -> tossmetaldoor "metal door"
  class InteriorDoor,
  with
	name 's//' 'south' 'southern',
	description [;
		print "The door to the south is metal. As usual, it has a black 
			sensor plate beside it.";
		if (self has open)
			" The door is open.";
		else
			" The door is closed.";
	],
	door_dir s_to,
	door_try [;
		if (tossguards.work_target == TossJunction)
			<<Touch self>>;
		if (self hasnt open)
			return self.InteriorDoor::door_try();
		print "You hurl yourself towards the open door, snatching at the lockpick
			as you go by. Nearly -- but your fingers close wrong, and the silver
			rod clatters to the floor behind you
			as you dive over the threshold. The door slides
			closed; you are left in quiet dark.^";
		print "^A moment later, the door slides open again. A surprising number of
			pulse guns are aimed through it, all at you.^";
		EndScene(6);
		rtrue;
	],
	react_before [;
		Take:
			if (noun == lockpick && lockpick in TossJunction 
				&& lockpick.work_target) {
				if (tossguards.work_target == TossJunction)
					<<Touch self>>;
			}
	],
	before [;
		ActivateTool:
			if (escaping) {
				if (location == TossJunction) {
					print "^The door snaps open. You have a brief glimpse of
						frightened-looking technicians, surrounded by obscure
						equipment, before someone hits an override and the door
						snaps shut again.^^Someone must have hit an alarm,
						as well, because a sharp buzzer sounds.^";
				}
				else if (location == SecurityBranch or NortheastCorner or
					DeadEndHall or SouthFrontier) {
					print "^The door";
					switch (location) {
						SecurityBranch: print " to the south";
						NortheastCorner: print " at the far end of the corridor,
							to the south,";
						DeadEndHall: print " to the west";
						SouthFrontier: print " to the east";
					}
					print " snaps open -- and closed again. Someone must have
						hit an override.^^Someone must have hit an alarm,
						as well, because a sharp buzzer sounds.^";
				}
				else {
					print "^A sharp buzzer sounds somewhere.^";
				}
				SummonEsguardsSecurity();
				rtrue;
			}
			give self open;
			if (baitguards in TossJunction) {
				! we know player is in TossJunction too
				print "^The metal door hisses open. The guards to the east spin,
					at the noise. They stare at the door and at you.^";
				EndScene(2, 2);
				rtrue;
			}
			else {
				if (location == TossJunction) {
					print "^The metal door slides open. To the north, the footfalls
						of the guards cease, startled by this apparition. Then they 
						begin again -- hurrying.^";
				}
				else {
					print "^The footsteps suddenly freeze. Then they begin
						again -- hurrying.^";
				}
				tossguards.shutdown();
				dooropenguards.startup();
			}
			rtrue;
		Examine:
			rfalse;
		default:
			if (tossguards.work_target == TossJunction) {
				"If you move within reach of the door, you'll be in full view
					of the guards.";
			}
	];

Object -> tossmetaldoorplate
  class InteriorPlate,
  with
	work_target tossmetaldoor,
	startup [;
		if (tossguards.work_target == TossJunction) {
			"You do a lockpick dance in front of the guards. [BUG]";
		}
	],
	before [;
		Examine:
			rfalse;
		default:
			if (tossguards.work_target == TossJunction) {
				"If you move within reach of the plate, you'll be in full view
					of the guards.";
			}
	];

Object SouthFrontier "Diagonal Branch"
  with
	description "This bare stretch of hallway angles from the northwest to
		the east; another short hall leads south.",
	e_to [;
		if (tossguards.work_target == SecurityBranch) {
			return TossJunction;
		}
		else if (tossguards.work_target == TossJunction) {
			print "You move back to the junction, but duck hastily
				as you glimpse movement up the north corridor. Three
				guards, heading towards you -- fortunately they didn't
				seem to see you. You flatten yourself
				inside the west side of the tee, out of their line of view.^";
			return TossJunction;
		}
		else if (tossguards.work_target == self) {
			if (tossguards hasnt general) {
				give tossguards general;
				"You consider the possible results of walking right up to three
					armed guards.";
			}
			else {
				print "You step out into the intersection and calmly walk up to 
					the guards. They calmly draw their pulse guns and point
					them at you.^";
				EndScene(1);
				rtrue;
			}
		}
		else if (tossguards.work_target ~= 0) {
			"That area of the maze isn't built yet. [BUG]";
		}
		return TossJunction;
	],
	nw_to [;
		if (escaping) {
			return SouthBoundary;
		}
		print "You return up the corridor, across the red line.^";
		EndScene(4);
		rtrue; 
	],
	s_to [;
		if (escaping) {
			return FinalEnd;
		}
		if (equiptalker in self) {
			if (equiptalker hasnt general) {
				give equiptalker general;
				PronounNotice(equiptalker);
				"You take half a step and nearly trip as you turn. A woman is
					standing to the south, at the end of the hall. She leans
					on the frame of an open door, talking to someone in the
					room beyond. If you continue, she will certainly notice
					you.";
			}
			print "You move south, light on your feet as you can be. But luck
				isn't up to hope. Before you are halfway down the hall, the woman
				catches your movement from the corner of her eye. She glances
				over, and then frowns, and then shouts and ducks inside the door.
				A buzzer sounds loudly.^";
			EndScene(3);
			rtrue;
		}
		"Wrong scene, pal. [BUG]";
	],
	cant_go "Hallways run northwest, east, and south.";

Object equiptalker "woman to the south"
  with
	name 'woman' 'south' 'southern' 's//' 'frame' 'door' 'short' 'hall' 'hallway',
	description [;
		give self general;
		"To the south, at the end of the hall, a woman is leaning on the frame
			of an open door. She is facing into the door, talking with someone
			inside; she has not noticed you.";
	],
	react_before [;
		ThrowDir:
			if (second == s_obj)
				<<ThrowAt noun self>>;
		Hide:
			if (self has general)
				return L__M(##Hide, 2);
	],
	before [;
		Examine:
			rfalse;
		Listen:
			"You can't quite hear over the distance and the hiss of ventilation.
				From the few words you can catch, she's arguing over how to structure
				the translation database, or something of that sort. It means
				nothing to you.";
		Enter:
			<<Go s_obj>>;
		ThrownAt:
			print (The) noun, " clatters down the hall towards the woman. She
				looks down at it; then up the hall, as you dodge back behind
				the corner. You hold yourself motionless...^^And a moment later,
				a guard comes around the corner, pulse gun drawn.^";
			EndScene(3);
			rtrue;
		Receive:
			<<ThrowAt noun self>>;
		default:
			"The woman is off to the south.";
	],
	life [;
		Answer, Order:
			print "She glances up the hall at the sound of your voice. She frowns
				slightly, and then shouts, and ducks inside the door.
				A buzzer sounds loudly.^";
			EndScene(3);
			rtrue;
		default:
			"The woman is off to the south.";
	],
	number 0, ! counter for daemon
	daemon_priority -2,
	daemon [;
		if (escaping || player == passiveplayer) {
			StopDaemon(self);
			print_ret "^The woman begins singing ", (emphstring) "The Highwayman", 
				" in Loreena McKennitt's voice. [BUG]";
		}
		if (player notin SouthFrontier) {
			if (self.number > 3)
				self.number = 3;
		}
		else {
			self.number++;
			switch (self.number) {
				3:
					if (self hasnt general) {
						give self general;
						print "^You catch a movement to the south.
							At the end of the hall, a woman is leaning on the
							frame of an open door. She is facing into the door,
							talking with someone
							inside; she has not noticed you.^";
					}
					else {
						print "^The woman nods and leans back.^";
					}
				5:
					print "^The woman shakes her head.^";
				7:
					print "^The woman shakes her head again, and you barely
						duck behind the junction corner as she glances around.^";
				9, 10:
					self.number = random(3); ! 0, 1, or 2
			}
		}
	],
  has scenery animate female; ! general means player has seen

Object DeadEndHall "Dead End South"
  with
	description [;
		print "The corridor ends here, blank, with a single steel door on the
			north wall. The door is";
		if (deadendmetaldoor hasnt open)
			print " closed";
		else
			print " open";
		".";
	],
	w_to [;
		if (tossguards.work_target == TossJunction) {
			if (tossguards hasnt general) {
				give tossguards general;
				"You move back to the junction, but backpedal hastily
					as you glimpse movement up the north corridor. Three
					guards, heading towards you -- fortunately they didn't
					seem to see you. You drift back into the cover of the east
					hallway.";
			}
			print "You leap across the intersection into the west corridor. 
				But there really was no
				hope that the guards would overlook you. Behind you, they begin
				shouting.^";
			EndScene(1);
			rtrue;
		}
		return TossJunction;
	],
	n_to deadendmetaldoor,
	cant_go "The hallway only returns to the west.";

Object -> deadendmetaldoor "metal door"
  class InteriorDoor,
  with
	name 'n//' 'north' 'northern',
	description [;
		print "The door to the north is metal. As usual, it has a black 
			sensor plate beside it.";
		if (self has open)
			" The door is open.";
		else
			" The door is closed.";
	],
	door_dir n_to,
	door_to WiringCloset,
	door_try [;
		if (self hasnt open) {
			self.InteriorDoor::door_try();
			rtrue;
		}
		if (self.number2)
			print "You slide hastily through the closing door. This time, you
				are careful to keep a firm grip on your lockpick.^";
		rfalse;
	],
	before [;
		ActivateTool:
			if (~~escaping)
				"^The door opens, revealing a Mafia den. [BUG]";
			if (self has open)
				rtrue;
			give self open;
			StartDaemon(self);
			if (location == DeadEndHall)
				"^The door snaps open.";
			if (location == TossJunction)
				"^You see the door to the east, in the dead end, slide open.";
			rtrue;
	],
	daemon_priority -25, ! very low and very late
	number2 0, ! for daemon; means closing automatically
	daemon [;
		if ((escaping == 0) || (powercut ~= 0)) {
			StopDaemon(self);
			"^The wiring closet takes exception to your demand. [BUG]";
		}
		if (self.number2 > 0) {
			give self ~open;
			StopDaemon(self);
			self.number2 = 0;
			if (location == WiringCloset or DeadEndHall)
				print "^The door closes completely.^";
			else if (location == TossJunction)
				print "^The door to the east closes completely.^";
			return;
		}
		if (lockpick.work_target ~= deadendmetaldoorplate) {
			self.number2 = 1;
			print "^The door begins to slide shut as soon as the pick
				loses its link.^";
		}
	];

Object -> deadendmetaldoorplate
  class InteriorPlate,
  with
	work_target deadendmetaldoor,
	startup [ fn;
		if (escaping == 0) {
			if (self hasnt general) {
				give self general;
				fn = emphstring;
			}
			else {
				fn = normstring;
			}
			fn("The metal door to the north isn't important.");
			new_line;
			rtrue;
		}
		rfalse;
	],
  has ~general; ! general means did italic warning


[ TryPassGuards   ix;

	if (anywherein(blasttab, DeadEndHall)) {
		if (blasttab.work_target == timerswitch && timerswitch.number) {
			EndScene(9);
			rtrue;
		}
	}

	if (anywherein(acidpack, DeadEndHall)) {
		if (acidpack.work_target == timerswitch && timerswitch.number) {
			EndScene(10);
			rtrue;
		}
	}

	if (baitguards.work_target ~= lockpick) {
		EndScene(8, baitguards.work_target);
		rtrue;
	}

	ix = LeftToolsBehind(3);
	if (ix) {
		EndScene(7, ix);
		rtrue;
	}
		
	EndScene(20);
	rtrue;
];

