
Global cur_question = nothing;

Class Question
  with
	query "^What is your favorite color? [BUG]",
	answer_wait [; "You say nothing, which is dull city. [BUG]"; ],
	answer_yes [; "You say ~Yes,~ nodding vigorously. [BUG]"; ],
	answer_no [; "You say ~No,~ rolling your eyes. [BUG]"; ],
	variant 0,	! useful value, usually from last question
	number 0, 	! turn counter
	daemon 0,	! called every turn after counter updates
	time_limit -1;	! if non-negative, the amount of time before a wait-answer

[ SetQuestion qx var;
	cur_question = qx;
	if (cur_question) {
		cur_question.number = 0;
		cur_question.variant = var;
	}
];

[ QuestionAnswerWait   qx;
	qx = cur_question;
	if (qx == nothing) {
		"You fail to answer the question which has not been asked. How Zen. [BUG]";
	}
	cur_question = nothing;
	num_wait_answers++;
	qx.answer_wait();
];

[ QuestionAnswerYes   qx;
	qx = cur_question;
	if (qx == nothing) {
		"The man says, ~That was a rhetorical question.~ [BUG]";
	}
	cur_question = nothing;
	num_yes_answers++;
	qx.answer_yes();
];

[ QuestionAnswerNo   qx;
	qx = cur_question;
	if (qx == nothing) {
		"The man says, ~Don't be so negative.~ [BUG]";
	}
	cur_question = nothing;
	num_no_answers++;
	qx.answer_no();
];

Object InterrogRoom "Interrogation Chamber"
  with
	description [;
		if (self.just_in) {
			! just came from EndScene.
			self.just_in = 0;
			if (self.first_time) {
				self.first_time = 0;
				print "You blink away sharp edges of memory, and the dim walls slowly
					emerge into your sight once again. Dark metal walls and air
					uncomfortably cool. And cool metal bands around your wrists
					and feet and forehead.^^";
				print "He leans forward over his desk, through the glow of his
					monitors and controls. Impatience tightens his face.^";
			}
			else {
				print "You blink away memory. The dim room comes again into
					focus, and the man behind the desk.^";
			}
		}
		else {
			! plain Look
			print "You are in a dim room, bounded by metal walls, and you sit
				restrained in a steel chair. Across from you is a desk covered
				with panels of instrumentation. The man faces you from behind it.^";
		}
	],
	just_in 0, 	! set true if we've just come from EndScene.
	first_time 1;	! set true if this is the first time ever.

Object -> interrogdesk "desk"
  with
	name 'panel' 'panels' 'instrument' 'monitors' 'controls' 'desk',
	description [;
		print "The desk is panelled with ranks of controls and instruments.
			All, of course, are angled just too low for you to read.^";
		if (child(self)) {
			print "^You see ";
			WriteListFrom(child(self), ENGLISH_BIT);
			print " on the desk.^";
		}
		rtrue;
	],
  has scenery transparent;

Object -> interrogwalls "walls"
  with
	name 'metal' 'wall' 'walls',
	description "The walls are naked metal, unadorned. They give your eyes nowhere
		to rest.",
  has scenery pluralname;

Object -> interrogdoor "doorway"
  with
	name 'door' 'doorway',
	door_dir s_to,
	door_to InterrogRoom,
	description [;
		print "There is a doorway off to the side, to the south.^";
		self.number2();
		rtrue;
	],
	number 0,	! counter for the man noticing you.
	number2 [;
		switch (self.number) {
			1:
				print "^The man follows your gaze, and raises an eyebrow.^";
			3:
				print "^The man follows your gaze, and shakes his head.^";
			5:
				self.number = 4;
		}
		self.number++;
	],
	before [;
		Search:
			print "The doorway is too far to the side of your vision. You
				cannot clearly see what lies in the whiteness beyond it.^";
			self.number2();
			rtrue;
	],
  has scenery door;

Object -> boundchair "chair"
  with
	name 'metal' 'steel' 'slat' 'slats' 'chair',
	description "The chair is every bit as uncomfortable as its designers
		must have intended. Metal slats dig into your thighs and shoulders. 
		Your head is strapped back, with too many cold itches where the
		leads are pasted on.
		And, of course, the steel bands that bind your hands and feet.
		You can hardly forget those.",
	vehicle_name " (imprisoned in the chair)",
	react_before [;
		Exit:
			"Your hands and feet are locked in place.";
		Go:
			"You're not going anywhere.";
		Jump, JumpOver:
			"You're kidding.";
		Hide:
			return L__M(##Hide, 3);
		WaveHands:
			"Not likely. You might wiggle a finger or two.";
		Open, Close, Push, Pull, Turn, Attack, AttackWith, Cut, Touch, 
			Rub, Take, Taste, SwitchOn, SwitchOff:
			if (noun ~= self or interrogleads or interrogbands)
				"You can hardly move at all.";
		LookUnder:
			if (noun ~= self)
				"You can hardly move at all.";
	],
	before [;
		Attack:
			"The chair is far stronger than you.";
		LookUnder:
			"You can't do that while sitting in it.";
		Open:
			"You can't imagine how.";
		Touch, Rub:
			"The metal under your fingers is chill and slick with sweat.";
	],
  has static container open;

Object -> interrogleads "leads"
  with
	name 'cold' 'paste' 'itch' 'itches' 'lead' 'leads' 'head' 'forehead'
		'temple' 'temples' 'contacts',
	description "You can't see your temples, nor reach with your hands,
		but the itch has never quite faded
		where the sensor leads are pasted on. The contacts are cold, too. And
		behind the cold is an echo of the blinding light.",
	before [;
		Touch:
			<<Examine self>>;
		Disrobe, Pull:
			"You hold no wish dearer. But while your hands are restrained, 
				it won't happen.";
		Wear:
			"You already are.";
		Rub:
			"If you could move your hands, you would have scratched hours ago.";
		Attack, Cut, Taste, Take:
			"You can hardly move.";
	],
  has scenery pluralname;

Object -> interrogbands "metal bands"
  with
	name 'steel' 'cool' 'metal' 'band' 'bands' 'cuff' 'cuffs' 'strap' 'straps' 
		'wrist' 'ankle' 'wrists' 'ankles' 'feet',
	description "Steel cuffs encircle your wrists and ankles, locking 
		you to the chair. The heft of the bands leaves nothing to chance.",
	before [;
		Touch, Rub:
			"The metal is cool, slick with sweat, and utterly immobile.";
		Disrobe, Pull, Push, Attack:
			print "You twist your limbs against the metal bands.";
			if (self.number < 7)
				print " It does as much good as you expected.^";
			else
				print " You succeed only in scraping your raw wrists further.^";
			self.number++;
			switch (self.number) {
				2: print "^The man smiles faintly at your efforts.^";
				4: print "^Noticing your movements, the man begins to speak. Then
						he cuts himself off and waves the words away.^";
				6: print "^The man shakes his head.^";
				9: print "^The man winces.^";
				11: self.number = 8;
			}
			rtrue;
		Wear:
			"You already are.";
		Take:
			"They're fixed in place.";
	],
	number 0,	! counter for the man noticing you.
  has scenery pluralname;

Object -> Himself "man at the desk"
  with
	name 'man' 'interrogator',
	description [;
		print "He is greying of hair and lined, lined hard, not wrinkled. His
			pale uniform fits as comfortably as skin. It is immaculate;
			it bears no insignia but the emblem of his nation.";
		if (child(self)) {
			print "^^The man is holding ";
			WriteListFrom(child(self), ENGLISH_BIT);
			print ".";
		}
		if (child(interrogdesk)) {
			if (child(self)) 
				print " ";
			else
				print "^^";
			print "On the desk in front of him, you see ";
			WriteListFrom(child(interrogdesk), ENGLISH_BIT);
			print ".";
		}
		new_line;
		rtrue;
	],
	react_before [ ix;
		Yes:
			QuestionAnswerYes();
			rtrue;
		No:
			QuestionAnswerNo();
			rtrue;
		VagueSay:
			! allow keywords to fall through so that a device can react_before
			if (consult_words >= 1) {
				wn = consult_from;
				ix = NextWord();
				if (ix == '~//' && consult_words >= 2) {
					ix = NextWord();
				}
				if (ix == 'tango') {
					rfalse;
				}
				if (ix == 'waltz') {
					rfalse;
				}
			}
			<<Answer noun self>>;
		Wait:
			print "You remain silent.^^";
			QuestionAnswerWait();
			rtrue;
	],
	before [;
		Search:
			print_ret "Maybe if ", (emphstring) "he", " were the one cuffed
				to a chair.";
	],
	life [ ix;
		Answer:
			if (consult_words == 1) {
				wn = consult_from;
				ix = NextWord();
				switch (ix) {
					'yes', 'y//':
						QuestionAnswerYes();
						rtrue;
					'no', 'n//', 'never':
						QuestionAnswerNo();
						rtrue;
					'nothing':
						QuestionAnswerWait();
						rtrue;
				}
			}
	],
	orders [;
		Yes:
			QuestionAnswerYes();
			rtrue;
		No:
			QuestionAnswerNo();
			rtrue;
		Tango:
			<<Tango>>;
		Waltz:
			<<Waltz>>;
		default:
			self.orders_counter++;
			switch (self.orders_counter) {
				1: "~What?~";
				2: "~Perhaps you don't understand who's in charge here.~";
				3: "~Don't tell me what to do.~";
				4: "~Don't be absurd.~";
				5: 
					self.orders_counter = 3;
					"The man ignores this.";
			}
	],
	orders_counter 0,
	daemon [ doneflag;
		doneflag = 0;
		
		if (self hasnt general) {
			print "^The man performs some western swing music. [BUG]^";
			return;
		}
		
		while (doneflag == 0 && self has general) {
			doneflag = 1;
			
			if (cur_question == nothing) {
				print "^The man smokes a doobie. [BUG]^";
				return;
			}
			
			if (cur_question.number == 0) {
				cur_question.query();
			}
			
			if (cur_question.daemon ~= 0) {
				cur_question.daemon();
			}
			cur_question.number++;

			if (cur_question.time_limit >= 0) {
				if (cur_question.number > cur_question.time_limit) {
					new_line;
					QuestionAnswerWait();
					! repeat the loop, since a wait answer is an action
					doneflag = 0; 
				}
			}
		}
	],
  has scenery animate transparent; ! general means daemon-active

Object -> himself_uniform "uniform"
  with
	name 'pale' 'immaculate' 'uniform' 'emblem',
	description "The man wears the light tan uniform of his nation, and its
		emblem on his breast.",
  has scenery;

