
#include <metadv.t>
#include <metstd.t>
#include <tadsnotes.t>

replace scoreStatus: function(points, kills, percentage, health)
{
	setscore(scoreFormat(points, kills, percentage, health));
}
;

replace scoreFormat: function(points, kills, percentage, health)
{
	return 'Score:' + cvtstr(points) + ' / Kills:' + cvtstr(kills) +
				 ' / Kill Average:' + cvtstr(percentage) + '% / Health:' + cvtstr(health);
}
;

replace incscore: function(amount)
{
  if (amount <> 0)
    global.kills := global.kills + 1;
  if (global.misses = 0 and global.kills = 0)
    global.shotavg := 0;
  else if (global.hits = 1)
  {
    if (global.shots < 10)
      global.shotavg := (100 / global.shots);
    else 
      global.shotavg := (1000 / global.shots);
  }
  else
    global.shotavg := (global.kills * 100) / global.shots;
    global.score := global.score + amount;	
    scoreStatus(global.score, global.kills, global.shotavg, global.health);
}
;

replace scoreRank: function
{
	local loss := 100 - global.health;
	"You have a score of <<global.score>> and have lost <<loss>> 
  point<<loss = 1 ? "" : "s">> of health. 
  \nYour hit percentage is <<global.shotavg>>% (achieved by missing
  <<global.misses>> out of <<global.shots>> shot<<global.kills = 1 ? "" : "s">>) ";
}
;

healthcount: function(amount)	
{
	global.health := global.health - amount;
	if (global.health < 0)
	  global.health := 0;
	scoreStatus(global.score, global.kills, global.shotavg, global.health);
	if (global.health <= 0)
	{
		"That last shot was the doozy. ";
		die();
	}
}

inst: function
{
  "\b\bIntructions for Metroid(TM):\bYou can shoot your gun at the Metroids(TM). Do this by typing
  'shoot metroid'. You can shoot at Mother Brain(TM) when she shows herself. Type 'shoot mother
  brain' or 'shoot brain' or even 'shoot mother' <<note(infoot)>>. \n\tThat thing above is a
  footnote. You can read footnotes by typing 'note x' where x is equal to the number of the
  footnote. \n\tYou can also check your inventory by typing 'i'. That's about it. Have fun!\b\b ";
  Me.location.lookAround(true);
}

infoot: object
  footnote = {"There, you're getting it. ";}
;

modify global
	health = 100
	kills = 0
	misses = 0
	shots = 0
	shotavg = 0
	metstart = 20 
	metante = 30
	metmother = 30
	momhere = nil
;

shootVerb: deepverb
	verb = 'shoot'
	sdesc = "shoot"
	doAction = 'Shoot'
;

useVerb: deepverb
  verb = 'use'
  sdesc= "use"
  doAction = 'Use'
;

helpVerb: deepverb
  verb = 'help' 'instructions' 'instruction'
  sdesc = "instructions"
  action(actor) =
  {
    inst();
  }
;

fight: function	
{
	local r := _rand(10);
	local hp := _rand(10);
	if (r <= 6)
	{
		"\bYou hit the metroid, killing it! ";
		incscore(_rand(20));
		if (hp <= 1)
		{
		  "\bYou have found a health pack! ";
		  if (hpack.isIn(Me))
		  {
		    hpack.multi := true;
		    hpack.number := ++hpack.number;
		  }
		  else
		    hpack.moveInto(Me);
		    if (hpack.know = nil)
		    {
		      hpack.know := true;
		      "\n[You may heal yourself if you have a healthpack by typing 'use healthpack'] ";
		    }
		}
		if (Me.location = startroom)
		{
		  global.metstart := --global.metstart;
		  if (global.metstart = 0)
		  {
		    Me.moveInto(antechamber);
		    metroid.moveInto(antechamber);
		    "\b\(You have made it into the antechamber of Mother Brain(TM)!\) ";
		  }
		}
		else if (Me.location = antechamber)
		{
		  global.metante := --global.metante;
		  if (global.metante = 0)
		  {
		    Me.moveInto(mother);
		    metroid.moveInto(mother);
		    "\b\(You have entered the chamber of Mother Brain(TM)!\) ";
		  }
		}
		else
		{
		  global.metmother := --global.metmother;
		  if (global.metmother = 0)
		  {
		    metroid.moveInto(nil);
		    mb.moveInto(Me.location);
		    global.momhere := true;
		  }
		}
		if (global.momhere = nil)  
		  "\bYou see another Metroid(TM). ";
		else
		  "\bYou see Mother Brain(TM)! ";
	}
	else
	{
		"\bYou miss the metroid! ";
		global.misses := ++global.misses;
		metroid.attack;
		incscore(0);
	}
}

momfight: function
{
  local r := _rand(10);
  local momhp := mb.health;
  local momdam := _rand(10);
  if (r <= 6)
  {
    momhp := momhp - momdam;
    if (momhp > 0)
    {
      "\bYou hit Mother Brain(TM) for <<momdam>> point<<momdam = 1 ? "" : "s">> of damage,
      leaving her with <<momhp>> hit point<<momhp = 1 ? "" : "s">>. ";
      mb.health := mb.health - momdam;
      incscore(20);
    }
    else
    {
      "\bYou have killed Mother Brain! The world thanks you! ";
      incscore(100);
      "\b\b\b\b\b";
      scoreRank();
      quit();
    }
  }
  else
  {
    "\b You miss her! ";
    mb.momattack;
  }
}
; 

startroom: room
	sdesc = "\(Zebes\)"
	ldesc = ""
;

antechamber: room
  sdesc = "\(Antechamber of Mother Brain(TM)\)"
  ldesc = ""
;

mother: room
  sdesc = "\(Lair of Mother Brain(TM)\)"
  ldesc = ""
;

gun: item
  sdesc = "standard issue repeating Gallium-Arsenide laser gun (with B-1 mod <<note(self)>>)"
  noun = 'gun' 'laser'
  adjective = 'laser'
  ldesc = "It's just a <<self.sdesc>>"
  location = Me
  verDoDrop(actor) =
  {
    "\nBut then you would be defenseless. ";
  }
  footnote = {"When fired it leaves behind the fresh smell of Brut (TM of Faberge) cologne. ";}
;

hpack: item
  adesc = 
  {
    if (self.multi = true)
      "(<<self.number>>) health packs";
    else
      "a health pack";
  }
  noun = 'pack' 'healthpack' 'health'
  adjective = 'health'
  ldesc = "It's a health pack. It will heal 10 points of damage. "
  know = nil
  multi = nil
  number = 1
  verDoUse(actor) =
  {
    if (self.isIn(Me) = nil)
      "\bYou do not have a health pack! ";
  }
  doUse(actor) =
  {
    "You apply the health pack, healing 10 points of damage! ";
    if (self.multi = true)
    {
      if (self.number = 2)
      {
        self.multi := nil;
      }
      self.number := --self.number;
    }
    else if (self.number = 1)
      self.moveInto(nil);
    global.health := global.health + 10;
    scoreStatus(global.score, global.kills, global.shotavg, global.health);
  }
;    

metroid: item
	sdesc = "Metroid(TM)"
	noun = 'metroid'
	ldesc = "Ugly little bugger, isn't he? "
	location = startroom
	verDoShoot(actor) = {}
	doShoot(actor) = 
	{
		global.shots := ++global.shots;
		fight();
	}
	attack =
	{
		local r := _rand(10);
		local damage := _rand(15);
		"\bThe metroid attacks back! ";
		if (r <= 4)
		{
			while(damage <= 5)
			{
				damage := _rand(15);
			}
			"\bThe metroid attacks doing <<damage>> point<<damage = 1 ? "" : "s">> of damage! ";
			healthcount(damage);
		}
		else
		{
			"\bThe metroid misses you! ";
		}
	}
;

mb: item
  sdesc = "Mother Brain(TM)"
  noun = 'mother' 'brain'
  ldesc = "Big, slimy, and ugly. "
  adjective = 'mother'
  health = 50
  verDoShoot(actor) = {}
  doShoot(actor) = 
  {
   momfight();
  }
  momattack =
  {
    local r := _rand(10);
    local damage := _rand(20);
    "\bMother Brain(TM) strikes back! ";
    if (r <= 7)
    {
      while(damage <= 10)
      {
        damage := _rand(20);
      }
      "\bMother brain hits you for <<damage>> point<<damage = 1 ? "" : "s">> of damage! ";
      healthcount(damage);
    }
    else
      "\bShe misses you! ";
  }
;
  
