Object Carpet "plush carpet" Lounge
  with 
    name "plush" "carpet", 
    description
    [;if (carpet.stained == TRUE)
        "", (The) carpet, " contrasts sharply to the normal steel decks 
         you spend most of your life staring at - on whichever space station
         or starship you happen to be inspecting. It seems to be slightly 
         stained - that's 10 demerits if anyone finds out.";
      else
        "", (The) carpet, " contrasts sharply to the normal steel decks 
         you spend most of your life staring at - on whichever space station
         or starship you happen to be inspecting.";
    ],
    stained FALSE,
    has scenery;

Object Dispenser "AstroCola dispenser" Lounge
  with
    name "astrocola" "dispenser" "vending" "machine" "label",
    description
    [;print 
    "The AstroCola dispenser includes a display, slot, some buttons, and a 
     tray where
     the drink is delivered. The buttons are labelled Classic, Caffeine Free,
     Quad-o-Caff, Diet Caffeine Free, Diet, and Standard. There is also a
     refund button. Not surprisingly 
     you can't get any CosmoCola from this machine. There appears to be some
     kind of jerry-rigged device next to the buttons. The display reads ";
     <<EXAMINE DISPLAY>>;
    ],
    before
    [; puthandin: <<PUTHANDIN TRAY>>;
       push, pull, shake: 
         "The machine is securely fastened to the wall, to prevent
          people breaking into it."; 

       attack, kick: 
       if (DietCola.state == stuck)
       {
         move DietCola to tray;
         DietCola.state = other;
         Achieved(3);
         "A can drops into the tray. Amazing! The oldest trick in the 
          book, and it actually worked; didn't need the Ostrich after
          all.";
       }
      ThrownAt:
      if (noun has worn)
        "You will have to remove ", (the) noun, " first.";
      move noun to Lounge;
      if ((noun has big) || (noun has huge)) 
      {
        if (DietCola.state == stuck)
        {
          move DietCola to tray;
          DietCola.state = other;
          Achieved(3);
          "A can drops into the tray. Amazing! The oldest trick in the 
           book, and it actually worked; didn't need the Ostrich after
           all.";
        }
        "Yeh, like the designers are total morons! You really think you're 
         going to get a free cola by throwing stuff at ", (the) Dispenser,
        ". ",  (The) Noun, " bounces off ", (the) Dispenser, 
        " and drops uselessly on the deck.";    
      }
      "", (The) Noun, " is too small to have any effect, bounces off ",
       (the) Dispenser, " and drops uselessly on the deck.";    
    ],
    has scenery;

Object ColaMonitor "monitoring device" Lounge
  with 
    name "device" "monitor" "monitoring" "jerry" "rig" "rigged" 
         "jerry-rigged" "jerry-rig" "sensor" "sensors",
    description
    [;
    "Attached to ", (the) Dispenser, " is a device that appears to be 
     monitoring the lights next to the six buttons. You guess that this is 
     one of those techno-junkie rigs that monitors how many colas are sold 
     remotely, using sensors that monitor the lights. A cable snakes away
     from the device and disappears into the deck. You recall talking to
     someone who told you how they work. Apparently ", (the) Dispenser, " has
     six columns holding cans, one for each button. Every time someone buys a
     can the corresponding light illuminates for three seconds; when the
     column becomes empty the light is permanently on. This allows the amount
     of cans sold and the most popular sale times to be calculated. Also how
     often the machine is empty can be worked out, as can the most popular
     brands.", (note) 1; 
    ],
    before
    [;take: "But the people have GOT TO know how many colas are sold!"; ],
    has scenery;

Object Cable "snaking cable" Lounge
  with
    name "wire" "snake" "snakes" "snaking" "cable" "cables",
    description
    "It snakes away from the AstroCola monitoring device and disappears into
     the deck.",
    before
    [;take, pull, push: "It is securly attached to ", (the) dispenser, ".";
  
      cut: 
      if (Hacksaw in Player)
        {
          Second = Hacksaw;
          print "(with ", (the) Hacksaw, ")^";
          <<CUTWITH CABLE HACKSAW>>;
        }
        if ( (hacksaw in Location) ||
        ( (hacksaw in toolbox) && (toolbox has open) && 
        ((toolbox in location) || (toolbox in player)) ) )
        {
          Second = Hacksaw;
          move Hacksaw to Player;
          print "(first taking ", (the) Hacksaw, ")^";
          <<CUTWITH CABLE HACKSAW>>;
        }
        else
          "You have nothing to cut with.";

       breakwith, cutwith: 
         if (second==Hacksaw)
           "But the people have GOT TO know how many colas are sold!";
    ],
    has scenery;

Object Lights "lights next to buttons" Lounge
  with
    name "light" "lights",
    description
    [; font off;
       print "Classic AstroCola Light:            ON^
              Caffeine Free AstroCola Light:      ON^
              Quad-o-Caff AstroCola Light:        OFF^  
              Diet Caffeine Free AstroCola Light: OFF^
              Diet AstroCola Light:               OFF^
              Standard AstroCola Light:           OFF^";
       font on;
    ],
    before
    [; take: "That's part of ", (the) Dispenser, "."; ],
    has scenery;

Object Display "credit display" Lounge
  with
    name "credit" "monitor" "display" "screen" "vdu" "LED",
    description 
    [credits;
     credits=0;
     if (Zorkmid in CoinStore)    credits=credits+ 25;
     if (LittleCoin in CoinStore) credits=credits+ 50;
     if (Coin in CoinStore)       credits=credits+100;
     print "~Credit = ", credits/100, ".", (credits%100)/10, credits%10;
     "~.";
    ],
    before
    [; take: "That's part of ", (the) Dispenser, "."; ],
    has scenery;

Object Slot "slot" Lounge
  with
    name "slot",
    description "A label next to the slot says ~1 Galakmid.~",
    before
    [; take: "That's part of ", (the) Dispenser, "."; 
       receive: 
       if (noun has worn)
         "You'll have to remove ", (the) noun, " first.";
       "", (The) noun, " is too big to fit in the slot.";
    ],
    has scenery;   

Object CoinStore;

Object -> Zorkmid "1 zorkmid coin" 
  with
    name "1" "coin" "zork" "zorkmid" "zorkmids",
    description
    [;if (Zorkmid hasnt General)
        "It looks like someone suckered the AstroCola dispenser into 
         accepting some strange foreign coin, and now you're stuck with it.
         It bears the name ~One Zorkmid~.";
      "It looks like some fool exchanged this priceless treasure for a cheap
       cola but now it's yours. It bears the name ~One Zorkmid~.";
    ],
    before
    [;examine: 
      if (self in Tray)
      {
         print "(taking ", (the) Self, " from ", (the) Tray, 
               " first)^";
         move self to Player;
      }
      insert: 
      if ((second == Slot) || (second == Dispenser))
      {
        if (self in pocket) 
          print "(taking ", (the) Self, " from your ", (name) pocket, 
                " first)^";
        if (self in table)
          print "(taking ", (the) Self, " from your ", (name) table, 
                " first)^";
        if (self in tray)
          print "(taking ", (the) Self, " from your ", (name) tray, 
                " first)^";
        move Self to CoinStore;
        print "Click.^The dispenser display now reads "; <<EXAMINE DISPLAY>>;
      }   
    ];

Class Button
  with
    name "astrocola" "button" "buttons",
    before
    [; push, use: "The light next to the button is permanently lit 
                   indicating that selection is Sold Out."; 
       take: "That's part of ", (the) Dispenser, "."; 
    ],
    has scenery;

Button Refund "refund button" Lounge
  with
    name "refund" "return",
    before
    [; push, use:
       if ((Zorkmid notin CoinStore) && (LittleCoin notin CoinStore)
       && (Coin notin CoinStore)) 
         "Nothing appears in ", (the) Tray, ".";
       if (Zorkmid in CoinStore)    
       { print "Clunk. "; move Zorkmid to Tray; }
       if (LittleCoin in CoinStore) 
       { print "Clunk. "; move LittleCoin to Tray; }
       if (Coin in CoinStore)       
       { print "Clunk. "; move Coin to Tray; }
       print "^The dispenser display now reads "; <EXAMINE DISPLAY>;
       <<SEARCH TRAY>>;
    ];

Button Classic "classic AstroCola button" Lounge
  with name "classic";

Button CF "caffeine free AstroCola button" Lounge
  with name "caffeine" "free";

Button QOC "quad-o-caff AstroCola button" Lounge
  with 
    name "quad" "o" "caff" "quad-o-caff",
    before
    [; push, use: "That stuff is dangerous to your health, only hard-core 
                   Hackers drink that."; ];

Button DCF "diet-caffeine-free AstroCola button" Lounge
  with 
    name "diet-caffeine-free",
    before
    [; push, use: "Give me a break, you might as well drink water and save 
                   yourself some money, that variety is the biggest con 
                   ever.";
    ];

Button Diet "diet AstroCola button" Lounge
  with
    name "diet",
    description
    "It's the diet AstroCola button, or hydraulic fluid as it is more
     commonly referred to.",
    before
    [; push, use: 
       if (Coin in CoinStore) 
       {
         remove Coin;
         DietCola.state = stuck;
         "You hear a rumbling noise in the dispenser, but nothing appears in 
          the tray. Cor blimey, what a swiz!!! Better see if you can find an 
          Ostrich!", (note) 2;
       }
       "Nothing happens.";
    ];

Button Standard "standard AstroCola button" Lounge
  with
    name "standard",
    before
    [; push, use: 
       if (Coin in CoinStore) 
       {
         remove Coin;
         move StandardCola to Tray;
         "A can drops into the tray.";
       }
       "Nothing happens.";
    ];

Object Tray "dispenser tray" Lounge
  with
    name "tray",    
    before
    [; puthandin: "You reach as far into ", (the) Dispenser, 
                  " as you can, but feel nothing.";
       receive: if (noun has huge)
                  "That is too big to put in ", (the) Tray, "."; 
       take: "That's part of ", (the) Dispenser, "."; 
    ],
    has open container scenery;

Class Can
  with
    name "tin" "can" "of" "cola" "astrocola",
    before
    [;Taste: "You'll have to open it first.";
      Crush: "You can't crush that, it's full.";
      Close: "That's already closed.";
      Eat: "You can't eat the cola, but I bet you can drink it.";
      Shake: if (self notin player) 
               print "(taking ", (the) self, " first)^";
             move self to player;
             self.state = shaken;
             shaketime=spacetime+100;
             "You hear the liquid swishing about.";
    ],
    state other,
    has big edible;

Can StandardCola "can of standard AstroCola"
  with
    name "standard",
    description
      "It's one of those drinks from the cola wars. An advertising jingle
       passes through your mind.",
    before
    [;Drink: if (StandardCola notin player) 
               print "(taking ", (the) StandardCola, " first)^";
             move StandardCola to player;
             if (hungry == 0)
               "Thanks, but you're not thirsty.";
             else
             {
               if (StandardCola.state == shaken)
               { 
                 if (OpenShakenCan() )
                 {
                   if ((Fussbudget has awake) && (Fussbudget in Location)) 
                     "", (The) Fussbudget, " rushes in and hoovers up the 
                      liquid, but manages to leave a stain twice as big, as
                      it would otherwise have been.";
                   rtrue;
                 }
               }
               hungry = 0;
               mt = spacetime + NEXT_MEAL;
               remove StandardCola;
               move EmptyStandard to Player;
               "Mmmm... one of your favourites... Standard Cola. That stuff 
                tastes really good. It's very addictive, perhaps it's the 
                cocaine - but they don't use that anymore do they?
                You empty the entire can, and your thirst dissipates.";
             }
      Open: 
      if (StandardCola notin player) 
      {
        print "(taking ", (the) StandardCola, " first)^"; 
        move StandardCola to player;
      }      
      move EmptyStandard to player;
      remove self;
      if (StandardCola.state == shaken)
      {
        if (OpenShakenCan() )
        { 
          if ((Fussbudget has awake) && (Fussbudget in Location)) 
            "", (The) Fussbudget, " rushes in and hoovers up the liquid, but
             manages to leave a stain twice as big, as it would otherwise  
             have been.";
          rtrue;
        }
      }
      hungry = 0;
      mt = spacetime + NEXT_MEAL;
      "You open the can and drink all the cola, before it gets a chance to 
      lose its fizz.";
    ];

Can DietCola "can of diet AstroCola"
  with
    name "diet",
    description
      "It's one of those drinks from the cola wars (the hydraulic fluid
       flavour one). An advertising jingle passes through your mind.",
    before
    [;Taste: "You'll have to open it first but I bet is tastes like hydraulic
              fluid.";
      Drink: if (DietCola notin player) 
               print "(taking ", (the) DietCola, " first)^";
             move DietCola to player;
             if (hungry == 0)
               "Thanks, but you're not thirsty.";
             else
             {
               if (DietCola.state == shaken)
               {
                 if (OpenShakenCan() )
                 { 
                   if ((Fussbudget has awake) && (Fussbudget in Location))
                     "", (The) Fussbudget, " sniffs at the liquid, but
                      doesn't seem interested.";
                   rtrue;
                 }
               }
               hungry = 0;
               mt = spacetime + NEXT_MEAL;
               remove DietCola;
               move EmptyDiet to Player;
               "Arghhh... this stuff tastes like hydraulic fluid.
                You empty the entire can, and your thirst dissipates.";
             }
      Open: 
      if (DietCola notin player) 
      {
        print "(taking ", (the) DietCola, " first)^"; 
        move DietCola to player;
      }      
      move EmptyDiet to player;
      remove self;
      if (DietCola.state == shaken)  
      {
        if (OpenShakenCan() )
        {
          if ((Fussbudget has awake) && (Fussbudget in Location))
            "", (The) Fussbudget, " sniffs at the liquid, but doesn't seem 
             interested.";
          rtrue;
        }
      } 
      hungry = 0;
      mt = spacetime + NEXT_MEAL;
      "You open the can and drink all the cola, before it gets a chance to 
      lose its fizz.";
    ];

[ OpenShakenCan;
  if (spacetime >= shaketime)
  {
    print "You judge that the can has had time to settle after you shaked it
           so the cola shouldn't spill everywhere. ";
    rfalse;
  }
  print "You shouldn't have shaken the can. As you open it the liquid
         gushes out, leaving an empty can.^"; 
  if ((Location == Lounge) || (Location == Lounge_Chair))
  {
    carpet.stained = TRUE;
    print "The liquid soaks into the plush carpet.^";
  }
  else
    print "The liquid leaves a stain on the deck, but as there are so many 
           other stains, I don't think anyone's going to notice. It looks 
           like some Ensign has got his work cut out for him.^"; 
  rtrue;
];

Class EmptyCan 
  with 
    name "tin" "can" "cola" "astrocola" "empty", article "an",
    before
    [;Drink: "The can is empty."; 
      Crush: remove self;
             move CrushedCan to player;
             "Faster than a flying bullet, more powerful than a speeding
              locomotive, able to crush tin cans in a single go... it's
              super adventurer. Well one out of three isn't bad!";
      Shake: if (self notin player) 
               print "(taking ", (the) self, " first)^";
             move self to player;
             "Nothing happens, as it's empty.";
      Open:  "That's already open.";
      Close: "Once open, cans can't be reclosed.";
    ],
    state other,
    has big;     

EmptyCan EmptyStandard "empty can of standard AstroCola"
  with
    name "standard",
    description
    [;if (self has general)
        "It's empty. You're 'friend' ", (the) Fussbudget, " seems to have
         scoffed all the cola.";
      "You've finished it, and can't help wondering whether it was worth 1
       Galakmid.";
    ];

EmptyCan EmptyDiet "empty can of diet AstroCola"
  with 
    name "diet",
    description
      "You've finished it, and can't help wondering whether it was worth 1
       Galakmid, especially as it tasted like hydraulic fluid.";

Object CrushedCan "crushed can"
  with
    name "tin" "can" "crushed",
    description
      "This can has been crushed flat, it is impossible to determine what is
       held.",
    before
    [;pull, open: "You can't uncrush it, you're not strong enough."; 
      drink: "This can's drinking days are long gone."; 
      crush: "It's already crushed!";
      Shake: if (CrushedCan notin player) 
               print "(taking ", (the) CrushedCan, " first)^";
             move CrushedCan to player;
             "Nothing happens, as it's empty, and crushed.";
      Close: "Once open, cans can't be reclosed.";
    ],
    state other;
    
