DEFINT A-Z

DECLARE FUNCTION VerbScore% (b$)
DECLARE FUNCTION JudgingPeriod ()
DECLARE FUNCTION VariFile (b$)
DECLARE SUB AddProName (b$, x%)
DECLARE FUNCTION VerbWear% (b$)
DECLARE FUNCTION VerbInventory% (a$)
DECLARE FUNCTION VerbLookAtItems% (a$)
DECLARE FUNCTION GetUo$ (x, y)
DECLARE SUB SetDirections (lo%)
DECLARE FUNCTION VerbOpen% (b$)
DECLARE SUB EndScreen ()
DECLARE SUB DisplayRoom (lo%)
DECLARE FUNCTION VerbTalk% (b$)
DECLARE FUNCTION VerbHypnotize% (b$)
DECLARE SUB SetRoomPic (lo%)
DECLARE SUB PicLoad (a$, Whichtype%)
DECLARE FUNCTION AskYesNo (a$, Whichtype)
DECLARE SUB AddPronoun (b$)
DECLARE FUNCTION IsNoun2% (b$, noun$)
DECLARE FUNCTION VerbMiscel% (b$)
DECLARE SUB AskExitGame (b$, whicht)
DECLARE FUNCTION VerbClose% (b$)
DECLARE FUNCTION GetWireSeq% (b$)
DECLARE FUNCTION VerbCut% (b$)
DECLARE SUB AddLine (WhichArray%, text$, ResetColors%)
DECLARE SUB SetSpecial (x1%, y1!)
DECLARE SUB SetObject (x1%, y1%)
DECLARE FUNCTION VerbLook% (b$)
DECLARE FUNCTION IsVerb (a$, b$)
DECLARE FUNCTION IsColor% (a$)
DECLARE FUNCTION IsPrep% (b$, prep$)
DECLARE FUNCTION IsNoun% (b$, noun$)
DECLARE FUNCTION IsItem% (a$, Itemno%)
DECLARE FUNCTION HasDirection (b$)
DECLARE FUNCTION GetResource$ (lo, b$)
DECLARE FUNCTION GetMaxItems% ()
DECLARE FUNCTION GetOc$ (x%)
DECLARE FUNCTION GetObject% (x%)
DECLARE FUNCTION GetSpecial! (x%)
DECLARE SUB SetObject (x%, y%)
DECLARE SUB SetSpecial (x%, y!)

CONST MAXARRAYSIZE = 60

COMMON SHARED TextMode
COMMON SHARED BwMode   'configurable
COMMON SHARED MusicOn
COMMON SHARED SoundOn
COMMON SHARED AllUpper 'configurable
COMMON SHARED Box1Size 'This is set by code, not configurable
COMMON SHARED Box2Size 'This is set by code, not configurable
COMMON SHARED a$
COMMON SHARED lo AS INTEGER
COMMON SHARED Fbuff AS STRING * 8960 'For Fonts
COMMON SHARED ScrollArray() AS STRING * 96
COMMON SHARED bs1$, bs2$, bs3$, bs4$, bs5$, bs6$, bs0$, bsb$

DIM SHARED ScrollArray(MAXARRAYSIZE, 1 TO 2) AS STRING * 96

FUNCTION GetWireSeq (b$)

'*** check to see if our Wiring Sequence was correct!
DIM a(6)

a(1) = INSTR(a$, "BLUE")
a(2) = INSTR(a$, "RED")
a(3) = INSTR(a$, "GREEN")
a(4) = INSTR(a$, "BROWN")
a(5) = INSTR(a$, "GRAY"): IF a(5) = 0 THEN a(5) = INSTR(a$, "GREY")
a(6) = INSTR(a$, "BLACK")

IF a(1) = 0 AND a(2) = 0 AND a(3) = 0 AND a(4) = 0 AND a(5) = 0 AND a(6) = 0 THEN
    'Didn't cut ANY of the wires!
    GetWireSeq = 0: EXIT FUNCTION
END IF
IF a(1) = 0 OR a(2) = 0 OR a(3) = 0 OR a(4) = 0 OR a(5) = 0 OR a(6) = 0 THEN
    'Didn't cut all of the wires!
    GetWireSeq = 1: EXIT FUNCTION
END IF

c$ = LTRIM$(STR$(GetSpecial(33)))
j = 0: FOR x = 1 TO 6
    IF a(VAL(MID$(c$, x, 1))) < j THEN
        '** Wrong Order
        GetWireSeq = 2: EXIT FUNCTION
    END IF
    j = a(VAL(MID$(c$, x, 1)))
NEXT x

GetWireSeq = 3 'All is well
END FUNCTION

FUNCTION IsNoun2 (b$, noun$)

'*** This list of nouns contains things that aren't commonly used or aren't
'*** really necessary to beat the game but are here for the looks.

a$ = UCASE$(b$): noun$ = UCASE$(noun$)

IF noun$ = "HEYWOOD" THEN
    IF INSTR(a$, " HEYWOOD") OR INSTR(a$, " DJABUZ") OR INSTR(a$, " MAN") OR INSTR(a$, " GUY") THEN
        AddProName noun$, 1: AddPronoun (noun$): IsNoun2 = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "ELLA" THEN
    IF INSTR(a$, " ELLA") OR INSTR(a$, " MENTARRY") OR INSTR(a$, " MENTERRY") OR INSTR(a$, " WOMAN") OR INSTR(a$, " GIRL") OR INSTR(a$, " FEMALE") OR INSTR(a$, " MISS") OR INSTR(a$, " LASS") OR INSTR(a$, " LADY") THEN
        AddProName noun$, 2: AddPronoun (noun$): IsNoun2 = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "COMPUTER" THEN
    IF INSTR(a$, " COMPU") OR INSTR(a$, " MONIT") OR INSTR(a$, " SCREEN") THEN
        AddPronoun (noun$): IsNoun2 = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "TRASH" THEN
    IF INSTR(a$, " TRASH") OR INSTR(a$, " CAN") OR INSTR(a$, " GARBAGE") OR INSTR(a$, " WASTE") OR INSTR(a$, " BASKET") THEN
        AddPronoun (noun$): IsNoun2 = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "BEDPOST" THEN
    IF INSTR(a$, " BEDPOST") OR INSTR(a$, " HEADBO") THEN
        AddPronoun (noun$): IsNoun2 = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "GRASS" THEN
    IF INSTR(a$, " GRASS") OR INSTR(a$, " WEED") THEN
        AddPronoun (noun$): IsNoun2 = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "TUB" THEN
    IF INSTR(a$, " TUB") OR INSTR(a$, " WATER") OR INSTR(a$, " WHIRL") OR INSTR(a$, " HOT ") OR INSTR(a$, " HOTTUB") THEN
        AddPronoun (noun$): IsNoun2 = 1: EXIT FUNCTION
    END IF
END IF

END FUNCTION

FUNCTION VerbClose (b$)

IF IsVerb(b$, "CLOSE") = 0 THEN EXIT FUNCTION 'Wasn't trying to talk after all
a$ = UCASE$(b$)

IF GetObject(23) = 0 AND IsItem(a$, 23) THEN
    IF GetSpecial(38) = 0 THEN
        AddLine 2, GetResource$(0, "CLOSEUM1"), 1
    ELSE
        AddLine 2, GetResource$(0, "CLOSEUM2"), 1
        SetSpecial 38, 0
    END IF
    VerbClose = 1: EXIT FUNCTION
END IF

END FUNCTION

FUNCTION VerbCut (b$)

IF IsVerb(b$, "CUT") = 0 THEN EXIT FUNCTION 'Wasn't trying to talk after all

a$ = UCASE$(b$)

IF lo = 1 THEN
    IF IsNoun(a$, "WIRE") AND GetSpecial(36) > 0 THEN
        IF GetSpecial(36) = 2 THEN
            AddLine 2, GetResource$(lo, "NOCUT1"), 1
        ELSE
            IF GetObject(13) <> 0 THEN
                AddLine 2, GetResource$(lo, "NOCUT2"), 1
            ELSE
                '*** Otherwise bomb is here, we've got the glass knife
                '*** So let's see if we got the sequence correct!
                z = GetWireSeq(a$)
                IF z = 0 THEN
                    AddLine 2, GetResource$(lo, "CUT0"), 1
                END IF
                IF z = 1 THEN
                    AddLine 2, GetResource$(lo, "CUT1"), 1
                    AskExitGame b$, 1
                END IF
                IF z = 2 THEN
                    AddLine 2, GetResource$(lo, "CUT2"), 1
                    AskExitGame b$, 1
                END IF
                IF z = 3 THEN
                    SetSpecial 36, 2
                    AddLine 2, GetResource$(lo, "CUT3"), 1
                END IF
            END IF
        END IF
        VerbCut = 1: EXIT FUNCTION
    END IF
END IF

END FUNCTION

FUNCTION VerbHypnotize (b$)

IF IsVerb(b$, "HYPNOTIZE") = 0 THEN EXIT FUNCTION 'Wasn't trying to talk after all
a$ = UCASE$(b$)

IF GetSpecial(40) = 1 THEN
    IF IsNoun(b$, "GOAT") AND lo = 26 AND GetSpecial(37) = 0 THEN
        IF GetSpecial(41) <> 0 THEN
            AddLine 2, GetResource$(lo, "HYPNO1"), 1
        ELSE
            IF IsItem(a$, 23) AND GetObject(23) = 0 AND GetSpecial(38) = 1 THEN
                SetSpecial 41, 1'You've hypnotized them!
                AddLine 2, GetResource$(lo, "HYPNO2"), 1
            ELSE
                x = IsItem(a$, 0)
                IF x = 0 THEN
                    AddLine 2, GetResource$(lo, "HYPNO3"), 1
                ELSE
                    AddLine 2, GetResource$(lo, "HYPNO4") + " " + GetOc$(x) + " " + GetResource$(lo, "HYPNO5"), 1
                END IF
            END IF
        END IF
        VerbHypnotize = 1: EXIT FUNCTION
    END IF
ELSE
    AddLine 2, GetResource$(39, "NOHYPNO1"), 1
    VerbHypnotize = 1: EXIT FUNCTION
END IF

END FUNCTION

FUNCTION VerbInventory (a$)

IF IsVerb(a$, "I") = 0 THEN VerbInventory = 0: EXIT FUNCTION

a$ = ""
g = 0 'How MANY items were here!!!
a$ = "`2You're carrying: "
FOR x = 1 TO GetMaxItems
    IF GetObject(x) = 0 THEN 'The item *IS* at this location!
        IF g > 0 THEN
            a$ = a$ + "`6, "
        END IF
        g = g + 1
        b$ = UCASE$(LEFT$(GetOc$(x), 1))
        IF b$ = "A" OR b$ = "E" OR b$ = "I" OR b$ = "O" OR b$ = "U" THEN
            a$ = a$ + "`0an " + GetOc$(x)
        ELSE
            a$ = a$ + "`0a " + GetOc$(x)
        END IF
        IF x = 1 THEN
            IF GetSpecial(1) = 0 THEN a$ = a$ + " (empty)"
            IF GetSpecial(1) = 1 THEN a$ = a$ + " (filled with hot water)"
            IF GetSpecial(1) = 2 THEN a$ = a$ + " (filled with cold water)"
            IF GetSpecial(1) = 3 THEN a$ = a$ + " (filled with ice)"
            IF GetSpecial(1) = 4 THEN a$ = a$ + " (filled with salt water)"
        END IF
        IF x = 5 THEN
            a$ = a$ + " ($" + LTRIM$(STR$(GetSpecial(10))) + ")"
        END IF
        IF x = 8 AND GetSpecial(12) > 0 THEN
            a$ = a$ + " (being worn)"
        END IF
        IF x = 10 AND GetSpecial(13) > 0 THEN
            a$ = a$ + " (being worn under your shirt)"
        END IF
        IF x = 12 THEN
            IF GetSpecial(15) = 0 THEN a$ = a$ + " (empty)"
            IF GetSpecial(15) = 1 THEN a$ = a$ + " (full)"
        END IF
        IF x = 23 AND GetSpecial(38) > 0 THEN
            a$ = a$ + " (opened)"
        END IF
    END IF
NEXT x
IF g = 0 THEN
    a$ = a$ + "`9Nothing!"
ELSE
    a$ = a$ + "."
END IF

AddLine 2, a$, 1
VerbInventory = 1

END FUNCTION

FUNCTION VerbLook (b$)

IF IsVerb(b$, "LOOK") = 0 THEN EXIT FUNCTION 'Wasn't trying to talk after all

a$ = UCASE$(b$)
x = HasDirection(a$)

IF lo = 8 THEN
    IF IsNoun(a$, "TRUNK") THEN
        IF IsPrep(a$, "INSIDE") THEN
            IF GetSpecial(34) = 0 THEN
                AddLine 2, GetResource$(lo, "LOOKCAR4"), 1
            ELSE
                IF GetObject(23) = 100 THEN
                    SetObject 23, lo
                   AddLine 2, GetResource$(lo, "LOOKTRUNK1"), 1
                ELSE
                    AddLine 2, GetResource$(lo, "LOOKTRUNK2"), 1
                END IF
            END IF
            VerbLook = 1: EXIT FUNCTION
        END IF
        AddLine 2, GetResource$(lo, "LOOKTRUNK3"), 1
        VerbLook = 1: EXIT FUNCTION
    END IF
    IF IsNoun(a$, "CAR") THEN
        IF IsPrep(a$, "UNDER") THEN
            IF GetObject(22) = 100 THEN
                SetObject 22, lo
                AddLine 2, GetResource$(lo, "LOOKCAR1"), 1
            ELSE
                AddLine 2, GetResource$(lo, "LOOKCAR2"), 1
            END IF
            VerbLook = 1: EXIT FUNCTION
        END IF
        AddLine 2, GetResource$(lo, "LOOKCAR3"), 1
        VerbLook = 1: EXIT FUNCTION
    END IF
END IF

IF lo = 12 THEN
   IF IsNoun(a$, "TABLE") THEN
       IF IsPrep(a$, "UNDER") THEN
           IF GetObject(24) = 100 THEN
               SetObject 24, lo
               AddLine 2, GetResource$(lo, "LOOKTABLE1"), 1
           ELSE
               AddLine 2, GetResource$(lo, "LOOKTABLE2"), 1
           END IF
           VerbLook = 1: EXIT FUNCTION
       END IF
   END IF
END IF

IF lo = 16 THEN
    IF IsNoun2(a$, "GRASS") THEN
        EndScreen
    END IF
END IF

IF lo = 17 THEN
   IF IsNoun(a$, "DUFFEL") AND IsPrep(a$, "INSIDE") = 0 THEN
       AddLine 2, GetResource$(lo, "LOOKBAG1") + " " + LTRIM$(STR$(GetSpecial(20))) + ". " + GetResource$(lo, "LOOKBAG2"), 1
       VerbLook = 1: EXIT FUNCTION
   END IF
END IF

IF lo = 21 THEN
    IF IsNoun(a$, "JESUS") AND GetSpecial(17) = 0 THEN
        AddLine 2, GetResource$(lo, "LOOKMAN"), 1
        VerbLook = 1: EXIT FUNCTION
    END IF
    IF IsNoun(a$, "CHAIR") THEN
        IF x = 0 THEN
            AddLine 2, GetResource$(lo, "LOOKCHAIRS"), 1
            VerbLook = 1: EXIT FUNCTION
        END IF
        IF x <> 3 AND x <> 4 THEN
            AddLine 2, GetResource$(lo, "NOCHAIR"), 1
            VerbLook = 1: EXIT FUNCTION
        END IF
        IF x = 3 THEN
            AddLine 2, GetResource$(lo, "LOOKCHAIR2"), 1
            VerbLook = 1: EXIT FUNCTION
        END IF
        '*** Otherwise they must be looking at the west one.
        AddLine 2, GetResource$(lo, "LOOKCHAIR1"), 1
        IF GetObject(10) = 100 THEN SetObject 10, lo 'Find the cafeteria tray
        VerbLook = 1: EXIT FUNCTION
    END IF
END IF

IF lo = 22 THEN
    IF IsNoun(a$, "DESK") THEN
        IF GetObject(1) = 100 AND IsPrep(a$, "UNDER") = 0 THEN
            AddLine 2, GetResource$(lo, "FINDCUPCIG"), 1
            SetObject 1, lo: SetObject 2, lo
            VerbLook = 1: EXIT FUNCTION
        END IF
    END IF
    IF IsNoun(a$, "DOOR") THEN
        IF x <> 3 THEN
            AddLine 2, GetResource$(lo, "LOOKDOOR1"), 1
            VerbLook = 1: EXIT FUNCTION
        END IF
        AddLine 2, GetResource$(lo, "LOOKDOOR2"), 1
        VerbLook = 1: EXIT FUNCTION
    END IF
END IF

IF lo = 26 THEN
    IF GetSpecial(37) = 0 AND IsNoun(a$, "GOAT") THEN
        AddLine 2, GetResource$(lo, "LOOKGOATS"), 1
        VerbLook = 1: EXIT FUNCTION
    END IF
END IF

IF lo = 28 THEN
    IF IsNoun(a$, "CELLDOOR") THEN
        IF x = 0 THEN
            AddLine 2, GetResource$(lo, "WHICHDOOR"), 1
            VerbLook = 1: EXIT FUNCTION
        END IF
        IF x <> 3 AND x <> 8 AND x <> 2 AND x <> 9 THEN
            AddLine 2, GetResource$(22, "NOUNLOCK2"), 1
            VerbLook = 1: EXIT FUNCTION
        END IF
        IF (x = 8 AND GetSpecial(7) < 2) OR (x = 9 AND GetSpecial(5) < 2) OR (x = 2 AND GetSpecial(6) < 2) OR (x = 3 AND GetSpecial(9) < 1) THEN
            AddLine 2, GetResource$(lo, "LOOKDOOR1"), 1
            VerbLook = 1: EXIT FUNCTION
        END IF
        '** otherwise if we make it this far, the door MUST be open.
        AddLine 2, GetResource$(lo, "LOOKDOOR2"), 1
        VerbLook = 1: EXIT FUNCTION
    END IF
END IF

IF lo = 29 THEN
    IF IsNoun(a$, "BED") THEN
        IF IsPrep(a$, "UNDER") THEN
            IF GetObject(12) = 100 THEN
                SetObject 12, lo: SetSpecial 15, 1
                AddLine 2, GetResource$(lo, "LOOKBED1"), 1
                VerbLook = 1: EXIT FUNCTION
            END IF
        END IF
    END IF
END IF

IF lo = 32 THEN
    IF IsNoun(a$, "BED") THEN
        IF IsPrep(a$, "UNDER") = 0 THEN
            AddLine 2, GetResource$(lo, "LOOKBED1"), 1
            VerbLook = 1: EXIT FUNCTION
        END IF
    END IF
    IF IsNoun(a$, "MATTRESS") THEN
        IF IsPrep(a$, "UNDER") THEN
            IF GetObject(5) = 100 THEN
                SetObject 5, lo: SetSpecial 10, 100
                AddLine 2, GetResource$(lo, "LOOKUNDERMAT1"), 1
                VerbLook = 1: EXIT FUNCTION
            END IF
        END IF
    END IF
END IF

IF lo = 33 THEN
    IF IsNoun(a$, "BED") THEN
        IF IsPrep(a$, "UNDER") THEN
            AddLine 2, GetResource$(32, "LOOKBED2"), 1
            VerbLook = 1: EXIT FUNCTION
        END IF
    END IF
    IF IsNoun(a$, "MATTRESS") THEN
        IF IsPrep(a$, "UNDER") THEN
            IF GetObject(7) = 100 THEN
                SetObject 7, lo
                AddLine 2, GetResource$(lo, "UNDERMAT2"), 1
                VerbLook = 1: EXIT FUNCTION
            END IF
        END IF
    END IF
    IF IsNoun(a$, "RUG") THEN
        IF IsPrep(a$, "UNDER") THEN
            IF GetSpecial(10) < 200 AND GetObject(5) = 101 THEN
                SetSpecial 10, 200: SetObject 5, lo
                AddLine 2, GetResource$(lo, "LOOKRUG1"), 1
                VerbLook = 1: EXIT FUNCTION
            END IF
            AddLine 2, GetResource$(lo, "LOOKRUG2"), 1
            VerbLook = 1: EXIT FUNCTION
        END IF
        AddLine 2, GetResource$(lo, "LOOKRUG3"), 1
        VerbLook = 1: EXIT FUNCTION
    END IF
END IF

IF lo = 34 THEN
    IF IsNoun(a$, "CHUCK") THEN
        AddLine 2, GetResource$(lo, "LOOKMAN1"), 1
        IF GetObject(13) = 100 AND GetSpecial(14) = 1 THEN SetObject 13, lo
        VerbLook = 1: EXIT FUNCTION
    END IF
    IF IsNoun(a$, "BED") THEN
        IF IsPrep(a$, "UNDER") THEN
            IF GetObject(8) = 100 THEN
                SetObject 8, lo
                AddLine 2, GetResource$(lo, "UNDERBED"), 1
                VerbLook = 1: EXIT FUNCTION
            END IF
        END IF
    END IF
END IF

'*** Looking at the bed handler
IF lo = 32 OR lo = 33 OR lo = 34 OR lo = 29 OR lo = 2 OR lo = 3 OR lo = 4 THEN
    IF IsNoun2(a$, "BEDPOST") THEN
        AddLine 2, GetResource$(39, "LOOKPOST"), 1
        VerbLook = 1: EXIT FUNCTION
    END IF
    IF IsNoun(a$, "BED") THEN
        IF IsPrep(a$, "UNDER") THEN
            AddLine 2, GetResource$(32, "LOOKBED2"), 1
            VerbLook = 1: EXIT FUNCTION
        END IF
        IF lo = 2 OR lo = 3 OR lo = 4 THEN
            AddLine 2, GetResource$(lo, "LOOKBED2"), 1
        ELSE
            AddLine 2, GetResource$(29, "LOOKBED2"), 1
        END IF
        VerbLook = 1: EXIT FUNCTION
    END IF
    IF IsNoun(a$, "MATTRESS") THEN
        IF IsPrep(a$, "UNDER") THEN
            AddLine 2, GetResource$(33, "UNDERMAT1"), 1
            VerbLook = 1: EXIT FUNCTION
        END IF
        IF lo = 2 OR lo = 3 OR lo = 4 THEN
            AddLine 2, GetResource$(lo, "LOOKMATTR"), 1
        ELSE
            AddLine 2, GetResource$(33, "LOOKMATTR"), 1
        END IF
        VerbLook = 1: EXIT FUNCTION
    END IF
END IF

IF lo = 36 THEN
   IF IsNoun(a$, "PLANT") THEN
       AddLine 2, GetResource$(lo, "LOOKPLANT"), 1
       IF GetObject(14) = 100 THEN SetObject 14, lo
       VerbLook = 1: EXIT FUNCTION
   END IF
END IF

END FUNCTION

FUNCTION VerbLookAtItems (a$)

g = 0
IF IsVerb(a$, "LOOK") THEN
    FOR x = 1 TO GetMaxItems
        FOR y = 1 TO 4
            IF (GetObject(x) = 0 OR GetObject(x) = lo) AND INSTR(a$, GetUo$(x, y)) AND g = 0 THEN g = x
            '*** Special cases.... so that we don't get object conflicts
            IF INSTR(UCASE$(a$), "BAG") AND lo = 17 AND g = 11 THEN g = 0
        NEXT y
    NEXT x
END IF

IF g > 0 THEN AddPronoun (GetUo$(g, 1))

IF g = 6 THEN
    a$ = ""
    FOR x = 1 TO 6
        y = VAL(MID$(LTRIM$(RTRIM$(STR$(GetSpecial(11)))), x, 1))
        GOSUB GetWord
        'One then two then three you'll press. Four then five then six, no less.
    NEXT x
    AddLine 2, GetResource$(39, "ITEM6") + " " + a$ + "", 1
END IF

IF g = 20 THEN
    AddLine 2, GetResource(39, "ITEM20") + STR$(GetSpecial(26)) + ".", 1
    SetSpecial 43, 1: 'Has read the napkin!
END IF

IF g <> 6 AND g <> 20 AND g <> 0 THEN
    AddLine 2, GetResource$(39, "ITEM" + LTRIM$(STR$(g))), 1
END IF

IF g > 0 THEN VerbLookAtItems = 1 ELSE VerbLookAtItems = 0
EXIT FUNCTION

GetWord: '******** special function for building our "puzzle" text.
IF y = 1 THEN IF x = 1 OR x = 4 THEN a$ = a$ + "One" ELSE a$ = a$ + "one"
IF y = 2 THEN IF x = 1 OR x = 4 THEN a$ = a$ + "Two" ELSE a$ = a$ + "two"
IF y = 3 THEN IF x = 1 OR x = 4 THEN a$ = a$ + "Three" ELSE a$ = a$ + "three"
IF y = 4 THEN IF x = 1 OR x = 4 THEN a$ = a$ + "Four" ELSE a$ = a$ + "four"
IF y = 5 THEN IF x = 1 OR x = 4 THEN a$ = a$ + "Five" ELSE a$ = a$ + "five"
IF y = 6 THEN IF x = 1 OR x = 4 THEN a$ = a$ + "Six" ELSE a$ = a$ + "six"
IF x = 1 OR x = 2 OR x = 4 OR x = 5 THEN a$ = a$ + " then "
IF x = 3 THEN a$ = a$ + " you'll press. "
IF x = 6 THEN a$ = a$ + ", no less."
RETURN

END FUNCTION

FUNCTION VerbMiscel (b$)
'**** This function is for miscellaneos things... verbs that are only used
'**** once, etc.

a$ = UCASE$(b$)

'*** Check for secret command
IF INSTR(a$, "P" + "L" + "U" + "G" + "H") THEN x = 1
IF INSTR(a$, "X" + "Y" + "Z" + "Z" + "Y") THEN y = 1
IF x = 1 AND y = 1 THEN
    PicLoad "AUTHOR", 1
    AddLine 2, GetResource$(38, "AUTHOR"), 1
    IF TextMode = 0 THEN nul = AskYesNo(GetResource$(38, "GAR"), 4)
    SetRoomPic lo
    VerbMiscel = 1: EXIT FUNCTION
END IF
IF x = 1 OR y = 1 THEN
    AddLine 2, GetResource$(38, "NOAUTHOR"), 1
    VerbMiscel = 1: EXIT FUNCTION
END IF

IF IsVerb(b$, "ENTER") THEN
    IF (lo = 27 OR lo = 36) AND IsNoun2(b$, "TUB") THEN
        AddLine 2, GetResource$(lo, "ENTERTUB"), 1
        VerbMiscel = 1: EXIT FUNCTION
    END IF
END IF

IF LEFT$(b$, 6) = "SMOKE " OR LEFT$(b$, 6) = "LIGHT " THEN
    IF IsItem(b$, 2) AND GetObject(2) = 0 THEN
        AddLine 2, GetResource$(39, "SMOKECIGS"), 1
        VerbMiscel = 1: EXIT FUNCTION
    END IF
END IF

IF (LEFT$(a$, 6) = "STUDY " OR LEFT$(a$, 6) = "LEARN ") AND (IsItem(a$, 24) OR INSTR(a$, " HYPNO")) AND GetObject(24) = 0 THEN
    AddLine 2, GetResource$(39, "STUDYBOOK"), 1
    IF GetSpecial(40) = 0 THEN SetSpecial 40, 1
    VerbMiscel = 1: EXIT FUNCTION
END IF

IF lo = 21 OR lo = 12 OR lo = 22 OR lo = 14 OR lo = 17 THEN
   IF IsVerb(a$, "SIT") AND (IsNoun(a$, "CHAIR") OR INSTR(a$, " DOWN") > 0) THEN
        AddLine 2, GetResource$(39, "SITDOWN"), 1
        VerbMiscel = 1: EXIT FUNCTION
   END IF
END IF

IF a$ = "HINT" OR a$ = "HINTS" OR a$ = "HELP" OR a$ = "CLUE" THEN
    IF JudgingPeriod > 0 THEN
        IF VariFile("LUNATIX.SOL") THEN
            AddLine 2, GetResource$(0, "HINT1"), 1
        ELSE
            AddLine 2, GetResource$(0, "HINT2"), 1
        END IF
    ELSE
        AddLine 2, GetResource$(0, "HINT3"), 1
    END IF
    VerbMiscel = 1: EXIT FUNCTION
END IF

IF a$ = "POINTS" OR a$ = "SCOR" OR a$ = "SCORE" THEN
    AddLine 2, GetResource$(0, "NOSCORE"), 1
    VerbMiscel = 1: EXIT FUNCTION
END IF

IF a$ = "RESTART" THEN
    AskExitGame b$, 2
    VerbMiscel = 1: EXIT FUNCTION
END IF

VerbMiscel = 0
END FUNCTION

FUNCTION VerbOpen (b$)

IF IsVerb(b$, "OPEN") = 0 THEN EXIT FUNCTION 'Wasn't trying to talk after all

a$ = UCASE$(b$)
x = HasDirection(b$)

IF lo = 1 THEN
    IF IsNoun(b$, "CABINET") THEN
        IF GetSpecial(36) = 0 THEN
            SetSpecial 36, 1
            AddLine 2, GetResource$(lo, "OPEN1"), 1
        ELSE
            AddLine 2, GetResource$(lo, "NOOPEN1"), 1
        END IF
        VerbOpen = 1: EXIT FUNCTION
    END IF
END IF

IF lo = 8 THEN
    IF IsNoun(a$, "TRUNK") THEN
        IF GetSpecial(34) = 0 THEN
            AddLine 2, GetResource$(lo, "LOOKCAR4"), 1
        ELSE
            IF GetObject(23) = 100 THEN
                SetObject 23, lo
                AddLine 2, GetResource$(lo, "LOOKTRUNK1"), 1
            ELSE
                AddLine 2, GetResource$(lo, "LOOKTRUNK2"), 1
            END IF
        END IF
        VerbOpen = 1: EXIT FUNCTION
    END IF
    IF IsNoun(b$, "CELLDOOR") AND IsNoun(b$, "CAR") = 0 THEN
        IF x = 0 THEN
            AddLine 2, GetResource$(22, "NOOPEN1"), 1
            VerbOpen = 1: EXIT FUNCTION
        END IF
        IF x <> 1 AND x <> 7 AND x <> 10 THEN
            AddLine 2, GetResource$(22, "NOUNLOCK2"), 1
            VerbOpen = 1: EXIT FUNCTION
        END IF
        IF (x = 1 AND GetSpecial(31) > 0) OR (x = 10 AND GetSpecial(30) > 0) OR (x = 7 AND GetSpecial(32) > 0) THEN
            AddLine 2, GetResource$(lo, "OPEN2"), 1
            VerbOpen = 1: EXIT FUNCTION
        END IF
        '*** check to see if there are bugs!
        IF GetSpecial(34) = 0 THEN
            AddLine 2, GetResource$(lo, "OPEN3"), 1
            VerbOpen = 1: EXIT FUNCTION
        END IF
        '*** Otherwise, we can open this door!
        IF x = 10 THEN SetSpecial 30, 1
        IF x = 1 THEN SetSpecial 31, 1
        IF x = 7 THEN SetSpecial 32, 1
        SetDirections (lo)
        AddLine 2, GetResource$(lo, "OPEN1"), 1
        VerbOpen = 1: EXIT FUNCTION
    END IF
END IF

IF lo = 13 THEN
    IF IsNoun(b$, "DOOR") OR INSTR(b$, " CONF") THEN
        IF GetSpecial(23) = 2 THEN
            AddLine 2, GetResource$(lo, "NOOPEN1"), 1
        ELSE
            IF GetSpecial(23) = 0 THEN
                AddLine 2, GetResource$(lo, "NOOPEN2"), 1
            ELSE
                SetSpecial 23, 2: SetDirections lo
                AddLine 2, GetResource$(lo, "OPENDOOR"), 1
            END IF
        END IF
        VerbOpen = 1: EXIT FUNCTION
    END IF
END IF

IF lo = 16 THEN
    IF IsNoun(a$, "CAR") THEN
        AddLine 2, GetResource$(lo, "ENTERCAR1"), 1
        VerbOpen = 1: EXIT FUNCTION
    END IF
END IF

IF lo = 18 THEN
    IF IsNoun(b$, "DOOR") THEN
        IF INSTR(a$, " LAB") THEN x = 4
        IF x = 0 THEN
            AddLine 2, GetResource$(22, "NOOPEN1"), 1
            VerbOpen = 1: EXIT FUNCTION
        END IF
        IF x <> 3 AND x <> 4 AND x <> 1 THEN
            AddLine 2, GetResource$(22, "NOUNLOCK2"), 1
            VerbOpen = 1: EXIT FUNCTION
        END IF
        IF x <> 4 OR GetSpecial(19) > 1 THEN
            AddLine 2, GetResource$(22, "NOOPEN3"), 1
            VerbOpen = 1: EXIT FUNCTION
        END IF
        '** otherwise, we are indeed trying to open the West door.
        IF GetSpecial(8) = 0 THEN
            AddLine 2, GetResource$(lo, "NOPT1"), 1
            VerbOpen = 1: EXIT FUNCTION
        END IF
        IF GetSpecial(19) < 1 THEN
            AddLine 2, GetResource$(22, "NOOPEN4"), 1
            VerbOpen = 1: EXIT FUNCTION
        END IF
        '*** Otherwise, we can open this door!
        SetSpecial 19, 2: SetDirections (lo)
        AddLine 2, GetResource$(lo, "OPEN1"), 1
        VerbOpen = 1: EXIT FUNCTION
    END IF
END IF

IF lo = 21 THEN
    IF IsNoun(b$, "DOOR") OR INSTR(b$, " OFFICE") OR INSTR(b$, " ENTRAN") OR INSTR(b$, " EXIT") THEN
        IF INSTR(b$, " OFFICE") THEN x = 3
        IF INSTR(b$, " EXIT") OR INSTR(b$, " ENTRAN") THEN x = 1
        IF x = 0 THEN
            AddLine 2, GetResource$(22, "NOOPEN1"), 1
        ELSE
            IF x = 3 THEN
                AddLine 2, GetResource$(lo, "NOOPEN3"), 1
            ELSE
                IF x = 1 THEN
                    IF GetSpecial(42) = 2 THEN
                        AddLine 2, GetResource$(lo, "NOOPEN1"), 1
                    ELSE
                       IF GetSpecial(42) = 0 THEN
                           AddLine 2, GetResource$(lo, "NOOPEN2"), 1
                       ELSE
                           SetSpecial 42, 2: SetDirections lo: SetRoomPic lo
                           AddLine 2, GetResource$(lo, "OPENDOOR"), 1
                       END IF
                    END IF
                ELSE
                    AddLine 2, GetResource$(lo, "NOOPEN4"), 1
                END IF
            END IF
        END IF
        VerbOpen = 1: EXIT FUNCTION
    END IF
END IF


IF lo = 22 THEN
    'IF IsNoun(a$, "FRIDGE") THEN
    '    AddLine 2, GetResource$(lo, "LOOKINFRIDGE"), 1
    '    VerbOpen = 1: EXIT FUNCTION
    'END IF
    IF IsNoun(b$, "DOOR") THEN
        x = HasDirection(b$)
        IF x = 0 THEN
            AddLine 2, GetResource$(lo, "NOOPEN1"), 1
            VerbOpen = 1: EXIT FUNCTION
        END IF
        IF x <> 3 AND x <> 4 AND x <> 2 THEN
            AddLine 2, GetResource$(lo, "NOUNLOCK2"), 1
            VerbOpen = 1: EXIT FUNCTION
        END IF
        IF x <> 3 OR GetSpecial(4) > 1 THEN
            AddLine 2, GetResource$(lo, "NOOPEN3"), 1
            VerbOpen = 1: EXIT FUNCTION
        END IF
        '** otherwise, we are indeed trying to unlock the East door.
        IF GetSpecial(4) < 1 THEN
            AddLine 2, GetResource$(lo, "NOOPEN4"), 1
            VerbOpen = 1: EXIT FUNCTION
        END IF
        '*** Otherwise, we can open this door!
        SetSpecial 4, 2: SetDirections (lo)
        AddLine 2, GetResource$(lo, "OPEN1"), 1
        VerbOpen = 1: EXIT FUNCTION
    END IF
END IF

IF lo = 24 THEN
    IF IsNoun(b$, "DOOR") THEN
        IF GetSpecial(27) = 0 THEN
            AddLine 2, GetResource$(lo, "NOOPEN1"), 1
        ELSE
            AddLine 2, GetResource$(lo, "NOOPEN2"), 1
        END IF
        VerbOpen = 1: EXIT FUNCTION
    END IF
END IF

IF lo = 28 THEN
    IF IsNoun(b$, "CELLDOOR") THEN
        IF x = 0 THEN
            AddLine 2, GetResource$(22, "NOOPEN1"), 1
            VerbOpen = 1: EXIT FUNCTION
        END IF
        IF x <> 3 AND x <> 8 AND x <> 9 AND x <> 2 THEN
            AddLine 2, GetResource$(22, "NOUNLOCK2"), 1
            VerbOpen = 1: EXIT FUNCTION
        END IF
        IF (x = 9 AND GetSpecial(5) > 1) OR (x = 2 AND GetSpecial(6) > 1) OR (x = 8 AND GetSpecial(7) > 1) OR (x = 3 AND GetSpecial(9) > 0) THEN
            AddLine 2, GetResource$(22, "NOOPEN3"), 1
            VerbOpen = 1: EXIT FUNCTION
        END IF
        IF (x = 9 AND GetSpecial(5) = 0) OR (x = 2 AND GetSpecial(6) = 0) OR (x = 8 AND GetSpecial(7) = 0) THEN
            AddLine 2, GetResource$(lo, "NOOPEN1"), 1
            VerbOpen = 1: EXIT FUNCTION
        END IF
        '*** Otherwise, we can open this door!
        IF x = 9 THEN SetSpecial 5, 2
        IF x = 2 THEN SetSpecial 6, 2
        IF x = 8 THEN SetSpecial 7, 2
        IF x = 3 THEN SetSpecial 9, 1
        SetDirections (lo)
        AddLine 2, GetResource$(lo, "OPEN1"), 1
        VerbOpen = 1: EXIT FUNCTION
    END IF
END IF

IF GetObject(23) = 0 AND IsItem(a$, 23) THEN
    IF NOT (lo = 16 OR (lo = 26 AND GetSpecial(37) = 0)) THEN
        AddLine 2, GetResource$(0, "UMBRELLA1") + " " + GetResource$(0, "UMBRELLA2"), 1
        AskExitGame b$, 1
        VerbOpen = 1: EXIT FUNCTION
    END IF
    '** Otherwise we ARE able to open the umbrella!
    IF GetSpecial(38) = 1 THEN
        AddLine 2, GetResource$(0, "UMBRELLA4"), 1
    ELSE
        AddLine 2, GetResource$(0, "UMBRELLA3"), 1
        SetSpecial 38, 1
    END IF
    VerbOpen = 1: EXIT FUNCTION
END IF

END FUNCTION

FUNCTION VerbTalk (b$)

IF IsVerb(b$, "TALK") = 0 THEN EXIT FUNCTION 'Wasn't trying to talk after all

a$ = UCASE$(b$)

IF lo = 3 AND IsNoun(a$, "XAVIER") THEN
    IF INSTR(a$, " BMOOB") THEN
        a1$ = " "
        FOR y = 1 TO 6
            IF y > 1 THEN a1$ = a1$ + ", "
            x = VAL(MID$(LTRIM$(STR$(GetSpecial(33))), y, 1))
            GOSUB GetCol1
        NEXT y
        a1$ = a1$ + ". "
        AddLine 2, GetResource$(lo, "TALKMAN2A") + a1$ + GetResource$(lo, "TALKMAN2B"), 1
        VerbTalk = 1: EXIT FUNCTION
    END IF
    IF INSTR(a$, " EELCRIIC") THEN
        AddLine 2, GetResource$(lo, "ASKCIRCLE"), 1
        VerbTalk = 1: EXIT FUNCTION
    END IF
    AddLine 2, GetResource$(lo, "TALKMAN1"), 1
    VerbTalk = 1: EXIT FUNCTION
END IF

IF lo = 5 AND IsNoun(a$, "KANDI") THEN
    IF IsItem(a$, 18) OR INSTR(a$, " KEY") THEN
        IF GetObject(7) = 102 THEN
            IF GetObject(18) = 100 THEN
                SetObject 18, 0 'Give passcard to the player
                AddLine 2, GetResource$(lo, "ASKPASS2"), 1
                VerbTalk = 1: EXIT FUNCTION
            END IF
            AddLine 2, GetResource$(lo, "ASKPASS3"), 1
            VerbTalk = 1: EXIT FUNCTION
        END IF
        AddLine 2, GetResource$(lo, "ASKPASS1"), 1
        VerbTalk = 1: EXIT FUNCTION
    END IF
END IF

IF lo = 7 AND IsNoun(a$, "TODD") THEN
    IF IsItem(a$, 18) OR INSTR(a$, " KEY") THEN
        IF GetObject(7) = 101 THEN
            IF GetObject(18) = 100 THEN
                SetObject 18, 0 'Give passcard to the player
                AddLine 2, GetResource$(lo, "ASKPASS2"), 1
                VerbTalk = 1: EXIT FUNCTION
            END IF
            AddLine 2, GetResource$(lo, "ASKPASS3"), 1
            VerbTalk = 1: EXIT FUNCTION
        END IF
        AddLine 2, GetResource$(lo, "ASKPASS1"), 1
        VerbTalk = 1: EXIT FUNCTION
    END IF
END IF

IF lo = 11 AND IsNoun(a$, "ROB") THEN
    IF GetObject(21) = 100 AND (INSTR(a$, " SI" + "STER") OR INSTR(a$, "GRU" + "DGE")) THEN
        SetObject 21, lo
        AddLine 2, GetResource$(lo, "NOTALK1"), 1
        VerbTalk = 1: EXIT FUNCTION
    END IF
END IF

IF lo = 15 AND IsNoun(a$, "SANDY") THEN
    IF IsNoun(a$, "ARSENIC") THEN
        IF GetObject(15) = 100 THEN
            AddLine 2, GetResource$(lo, "ARSENIC1"), 1
        ELSE
            AddLine 2, GetResource$(lo, "ARSENIC2"), 1
        END IF
        VerbTalk = 1: EXIT FUNCTION
    END IF
    IF IsItem(a$, 15) THEN
        IF GetObject(15) = 100 THEN
            a1$ = "": a2$ = "": a3$ = "": x1 = 0
            IF (GetSpecial(25) AND 1) > 0 THEN
                a1$ = "butter": x1 = x1 + 1
            END IF
            IF (GetSpecial(25) AND 2) > 0 THEN
                IF LEN(a1$) > 0 THEN a1$ = a1$ + " and "
                a1$ = a1$ + "salt": x1 = x1 + 1
            END IF
            IF (GetSpecial(25) AND 4) > 0 THEN
                IF LEN(a1$) > 0 THEN a1$ = a1$ + " and "
                a1$ = a1$ + "a potato": x1 = x1 + 1
            END IF
            IF (GetSpecial(25) AND 8) > 0 THEN
                IF LEN(a1$) > 0 THEN a1$ = a1$ + " and "
                a1$ = a1$ + "$300 crazy bucks"
            ELSE
                a3$ = " " + GetResource$(lo, "GETSOUP5")
            END IF
            IF LEN(a1$) > 0 THEN a1$ = " You have already brought me " + a1$ + "."
            IF x1 = 0 THEN a2$ = " " + GetResource$(lo, "GETSOUP1")
            IF x1 = 1 THEN a2$ = " " + GetResource$(lo, "GETSOUP2")
            IF x1 = 2 THEN a2$ = " " + GetResource$(lo, "GETSOUP3")
            IF x1 = 3 AND LEN(a3$) > 0 THEN a3$ = " " + GetResource$(lo, "GETSOUP4")
            AddLine 2, GetResource$(lo, "SOUP1") + a1$ + a2$ + a3$, 1
            VerbTalk = 1: EXIT FUNCTION
        ELSE
            AddLine 2, GetResource$(lo, "SOUP2"), 1
            VerbTalk = 1: EXIT FUNCTION
        END IF
    END IF
END IF

IF lo = 26 AND IsNoun(a$, "GOAT") AND GetSpecial(37) = 0 THEN
    IF GetSpecial(41) = 0 THEN
        AddLine 2, GetResource$(lo, "GOATKILL"), 1
        AskExitGame b$, 1
        VerbTalk = 1: EXIT FUNCTION
    ELSE
        IF IsItem(a$, 25) AND GetObject(25) = 100 THEN
            SetObject 25, lo 'Drop the Key
            SetSpecial 37, 1 'Goats are Gone
            AddLine 2, GetResource$(lo, "GETKEY1"), 1
            IF TextMode = 0 THEN DisplayRoom lo
            VerbTalk = 1: EXIT FUNCTION
        END IF
    END IF
END IF

IF lo = 21 AND IsNoun(a$, "JESUS") AND GetSpecial(17) = 0 THEN
    IF GetSpecial(2) = 0 THEN
        AddLine 2, GetResource$(lo, "TALK0"), 1
        SetSpecial 2, 1
        VerbTalk = 1: EXIT FUNCTION
    END IF
    IF GetSpecial(2) = 1 THEN
        AddLine 2, GetResource$(lo, "TALK1"), 1
        SetSpecial 2, 2
        VerbTalk = 1: EXIT FUNCTION
    END IF
    IF IsItem(a$, 4) THEN
        AddLine 2, GetResource$(lo, "TALK2A"), 1
        IF GetObject(3) = 100 THEN SetObject 3, lo
        VerbTalk = 1: EXIT FUNCTION
    END IF
    IF IsItem(a$, 3) AND GetObject(3) = 0 THEN
        AddLine 2, GetResource$(lo, "TALK2C"), 1
        VerbTalk = 1: EXIT FUNCTION
    END IF
    IF INSTR(a$, " CIRCL") THEN
        AddLine 2, GetResource$(lo, "TALK2D"), 1
        VerbTalk = 1: EXIT FUNCTION
    END IF
    IF IsNoun(a$, "SQUID") THEN
        AddLine 2, GetResource$(lo, "SQUID"), 1
        VerbTalk = 1: EXIT FUNCTION
    END IF
    AddLine 2, GetResource$(lo, "NOTALK"), 1
    VerbTalk = 1: EXIT FUNCTION
END IF

'IF lo = 28 THEN
    'IF IsNoun(a$, "GORDON") THEN
    '    IF IsNoun(a$, "SQUID") THEN
    '        AddLine 2, GetResource$(lo, "SQUID2"), 1
    '        VerbTalk = 1: EXIT FUNCTION
    '    END IF
    '    AddLine 2, GetResource$(lo, "TALKMAN1"), 1
    '    VerbTalk = 1: EXIT FUNCTION
    'END IF
    'IF IsNoun(a$, "JENKINS") THEN
    '    IF INSTR(a$, " HAND") OR INSTR(a$, " HABIT") THEN
    '        AddLine 2, GetResource$(lo, "TALKWOMAN2"), 1
    '        VerbTalk = 1: EXIT FUNCTION
    '    END IF
    '    IF IsNoun(a$, "SQUID") THEN
    '        AddLine 2, GetResource$(lo, "SQUID1"), 1
    '        VerbTalk = 1: EXIT FUNCTION
    '    END IF
    '    AddLine 2, GetResource$(lo, "TALKWOMAN1"), 1
    '    VerbTalk = 1: EXIT FUNCTION
    'END IF
    'IF IsNoun(a$, "GUARD") THEN
    '    AddLine 2, GetResource$(lo, "NOTALK0"), 1
    '    VerbTalk = 1: EXIT FUNCTION
    'END IF
'END IF

VerbTalk = 0: EXIT FUNCTION

GetCol1:
IF x = 1 THEN a1$ = a1$ + "eeuulb"
IF x = 2 THEN a1$ = a1$ + "deer"
IF x = 3 THEN a1$ = a1$ + "neeeerg"
IF x = 4 THEN a1$ = a1$ + "nwoorb"
IF x = 5 THEN a1$ = a1$ + "yaarg"
IF x = 6 THEN a1$ = a1$ + "kcaalb"
RETURN

END FUNCTION

FUNCTION VerbWear (b$)

IF IsVerb(b$, "WEAR") = 0 THEN EXIT FUNCTION 'Wasn't trying to talk after all

a$ = UCASE$(b$)

IF IsItem(a$, 10) AND GetObject(10) = 0 THEN
    IF GetSpecial(13) = 0 THEN
        SetSpecial 13, 1
        AddLine 2, GetResource$(0, "WEARTRAY1"), 1
    ELSE
        AddLine 2, GetResource$(0, "WEARTRAY2"), 1
    END IF
    VerbWear = 1: EXIT FUNCTION
END IF

IF IsItem(a$, 8) AND GetObject(8) = 0 THEN
    IF GetSpecial(12) = 0 THEN
        IF GetObject(9) <> 101 THEN
            AddLine 2, GetResource$(0, "WEARGOG1"), 1
        ELSE
            AddLine 2, GetResource$(0, "WEARGOG2"), 1
            SetSpecial 12, 1
        END IF
    ELSE
        AddLine 2, GetResource$(0, "WEARGOG3"), 1
    END IF
    VerbWear = 1: EXIT FUNCTION
END IF

END FUNCTION

