\ tools.f for advtr.f   Leo Wong 27 June 02003 fyj +
\ Miscellaneous tools for advtr.f Adventure in Forth
FALSE VALUE db?  ( debugging mode? )

: noop  ( -- )  ;

\ Multi-line comment
: ((
   BEGIN BL WORD DUP COUNT S" ))" COMPARE 
      WHILE C@ 0= IF REFILL 0= ABORT" (( needs ))" THEN REPEAT DROP ;

: not  ( flag -- flag' )
   0= ;

\ :: iterated defining
\ parse-word Get next word in input stream
: parse-word  BL WORD COUNT ;

\ preparse Get next word but restore the input pointer
: preparse >IN @ >R parse-word R> >IN ! ;

: ::  ( ... -- ... )   \ Usage: :: <defining-word> ... ;
   ' >R
   BEGIN
     preparse 2DUP S" ;" COMPARE
   WHILE
     2DUP S" (" COMPARE 0= IF 2DROP POSTPONE (  ELSE
     2DUP S" \" COMPARE 0= IF 2DROP POSTPONE \  ELSE
                       NIP IF R@ EXECUTE        ELSE
     REFILL 0= ABORT" ; missing after ::"  THEN THEN THEN
   REPEAT 2DROP
   BL WORD DROP  \ Skip ;
   R> DROP ;

\ parse-n Assume the next word is a number and return it as such
: parse-n  ( -- n )
   parse-word EVALUATE ;

\ ', Attempt to compile the next word as an xt
: ',  ( -- )  \ ', <word>
  ' , ;

\ ,s Compile n's
: ,s  \ :: ,s n ... ;
   parse-n , ;

\ constants Define constants
: constants  \ :: constants n <name> ... ;
   parse-n CONSTANT ;

\ values Define values with a value of n
: values ( n -- n )
   DUP VALUE ;

\ array Define an array of n cells, base 1, initialize to 0
\       n<=0 arrayname returns 0; no upper-bounds checking
: array
   CREATE ( +n -- )  HERE SWAP CELLS DUP ALLOT ERASE
   DOES> ( n -- 0|a )  SWAP 1- DUP 0< IF 2DROP 0 ELSE CELLS + THEN ;

\ arrays Define arrays
: arrays  \ :: arrays +n <name> ... ;
   parse-n array ;

\ narrays Define arrays of n elements
: narrays \ +n :: narrays <name> ... ; DROP
   DUP array ;

\ 2array Define a 2-dimensional array similar to array above
: 2array
   CREATE  ( n1 n2 -- )  DUP , HERE ROT ROT * CELLS DUP ALLOT ERASE
   DOES>  ( n1 n2 -- 0|a )
     >R >R 1- DUP 0< R> 1- DUP 0< ROT OR
     IF R> DROP 2DROP 0 ELSE SWAP R@ @ * + 1+ CELLS R> + THEN ;

\ chars-array Define array in which each element is n2 chars in length
: chars-array
   CREATE ( n1 n2 -- )  DUP C, HERE ROT ROT * CHARS DUP ALLOT BLANK
   DOES>  ( n -- 0|a )
     SWAP 1- TUCK 0< IF 2DROP 0 ELSE COUNT ROT * CHARS + THEN ;

: @+  ( a -- a+ x )
   \ fetch a, bump a
   DUP CELL+ SWAP @ ;

\ c+! Character +!
: c+!  ( c ca -- )
   DUP >R C@ + R> C! ;

\ c!+ Store c; bump ca1
: c!+  ( ca1 c -- ca2 )
   OVER C! CHAR+ ;

\ white? True if c <= space
: white?  ( c -- bool )
   BL 1+ U< ;

\ skip-white Skip leading white characters
: skip-white  ( ca1 u1 -- ca2 u2 )
   BEGIN DUP WHILE OVER C@ white? WHILE 1 /STRING REPEAT THEN ;

\ scan-white Look for first white character
: scan-white  ( ca u -- ca1 u1 )
   BEGIN DUP WHILE OVER C@ white? 0= WHILE 1 /STRING REPEAT THEN ;

\ puts Put ca u as the counted string at s AKA place
: puts  ( ca u s -- )
   2DUP 2>R CHAR+ SWAP CHARS MOVE 2R> C! ;

: append  ( ca u s -- )  \ Add ca u to the counted string s
   2DUP 2>R  COUNT CHARS +  SWAP CMOVE  2R> c+! ;

\ string, \ Compile ca u
: string,  ( ca u -- )
   HERE  OVER 1+ CHARS ALLOT puts ;

\ string Define a named string constant
: string  ( ca u -- )  ( -- ca u )
   CREATE  ( ca u -- )  string, DOES>  ( -- ca u )  COUNT ;

\ word> Get next white-delimited string
: word>  ( ca u -- ca1 u1 ca2 u2 )
   skip-white 2DUP 2>R scan-white DUP 2R> ROT - ;

\ upper? True if c is an uppercase letter
: upper? ( c -- bool )
   [CHAR] A - 26 U< ;

\ lower? True if c is a lowercase letter
: lower? ( c -- bool )
   [CHAR] a - 26 U< ;

\ alpha? True if c is a letter of either case
: alpha?  ( c -- bool )
   DUP upper? SWAP lower? OR ;

\ digit? True if c is a decimal digit
: digit?  ( c -- bool )
   [CHAR] 0 - 10 U< ;

\ upper  If c is lower case, make it upper case
: upper  ( c1 -- c2 )
   DUP lower? BL AND XOR ;

\ supper Make ca u upper case
: supper  ( ca u -- )
   0 ?DO DUP C@ upper C!+  LOOP DROP ;

\ s=  True if ca1 u1 matches ca2 u2 ; case sensitive
: s=  ( ca1 u1 ca2 u2 -- flag )
   COMPARE 0= ;

: s<> ( ca1 u1 ca2 u2 -- flag )
   COMPARE 0<> ;

\ type Type with white space becoming space
: type  ( ca u -- )
   0 ?DO COUNT DUP BL < IF DROP BL THEN EMIT LOOP DROP ;


\ S-dollar
\ Quote with specified delimiter  
\ Authors: Tom Zegub, Jos v.d.Ven, Michael Gassanenko, Ruvim Pinka
\ From: http://forth.sourceforge.net/word/s-dollar/index.html
\ (s-delim) parse-s$ s$
\ Match delimiters for string
: (s-delim) ( c1 -- c2)
   CASE
     [CHAR] < OF [CHAR] > ENDOF
     [CHAR] { OF [CHAR] } ENDOF
     [CHAR] [ OF [CHAR] ] ENDOF
     [CHAR] ( OF [CHAR] ) ENDOF
     DUP    \ use same character for all others
   ENDCASE
;

\ run-time routine for string parsing
: parse-s$ ( <char1>ccc<char2> -- addr u)
   SOURCE >IN @ MIN +  \ address of 1st character
   C@ (s-delim)        \ determine second delimiter
   1 >IN +!            \ bump past first  delimiter
   PARSE               \ parse to  second delimiter
;

\ parse string; if compiling, compile it as a literal.
: s$ ( <char1>ccc<char2> -- addr u)
   PARSE-s$
   STATE @ IF ( compiling)
   POSTPONE SLITERAL  \ include parsed string in definition
   THEN
; IMMEDIATE


\ phrog Hash a string
: bigbase  36 BASE ! ;
bigbase PHROG CONSTANT hasher DECIMAL
: phrog  ( a u -- hash )
   BASE @ >R bigbase
   5 MIN 0 0 2SWAP >NUMBER 2DROP D>S hasher XOR
   R> BASE ! ;

: (.)  ( n -- ca u )
   DUP ABS 0 <#  #S  ROT SIGN  #> ;

\ Rehash a hash
: dephrog  ( hash -- ca u )
   BASE @ >R bigbase hasher XOR (.) R> BASE ! ;


\ Number input by Benjamin Hoyt:
\ A bit of a big definition, but I could see no way to factor it
\ cleanly. Anyway, tries to convert c-addr u to a binary number,
\ returns 1 if double, -1 if single, or 0 if can't convert at all
\ A char - prefixing the number denotes a negative
\ A char $ prefixing the number denotes hex, you can have -$1234 too
\ A char . postfixing the number denotes a double cell number
\ Error checking isn't abundant, 0 length strings will "work" )

: number? ( c-addr u -- d|ud 1 | n|u -1 | 0 )
    BASE @ >R OVER C@ [CHAR] - = IF     \ is there a - minus sign?
        1 /STRING TRUE
    ELSE
        FALSE
    THEN -ROT
    OVER C@ [CHAR] $ = IF               \ $ means hex number
        1 /STRING HEX
    THEN
    0 0 2SWAP >NUMBER ?DUP IF            \ convert to binary
        1 = SWAP C@ [CHAR] . = AND IF   \ . at end means double
            ROT IF DNEGATE THEN 1
        ELSE
            2DROP DROP 0                \ not number at all
        THEN
    ELSE
        2DROP SWAP IF NEGATE THEN -1    \ otherwise single
    THEN
    R> BASE ! ;


\ After Matt Smith
: #eval   ( ca u -- n)  \ In advtr.f, assume single number
   NUMBER? 0= ABORT" failed to find a number" ;

