/* Toasterama - An attempt at toast humor in TADS */



// Files to include



#include <adv.t>

#include "toaststd.t"



// Function declarations



dieRoutine: function;

checkTub: function;

lose: function;

checkwin: function;

win: function;

uberloc: function;



// Class declarations



class faucet: fixeditem

    noun = 'faucet'

    sdesc = "faucet"

    ldesc = "A simple faucet for turning water on or off.  <<self.ison?

             "There is water flowing out of the faucet into the sink." :

             "" >>"

    verDoTurnon( actor ) =

    {

        if ( self.ison )

            "There is already water flowing out of <<self.thedesc>>.";

    }

    doTurnon( actor ) =

    {

        "You turn on <<self.thedesc>> and water flows out of it.";

        self.ison := true;

        water.moveInto( uberloc( self ) );

    }

    verDoTurnoff( actor ) =

    {

        if ( not self.ison )

            "<<self.Thedesc>> is already off.";

    }

    doTurnoff( actor ) =

    {

        "You turn off <<self.thedesc>>.";

        self.ison := nil;

        water.moveInto(nil);

    }

    ison = nil

;



class mirror: fixeditem

    noun = 'mirror'

    sdesc = "mirror"

    ldesc = "You see a very haggard-looking individual staring back at you."

;



class socket: fixeditem

    noun = 'socket' 'outlet'

    sdesc = "socket"

    ldesc = "It's a socket for plugging appliances into."

    verIoPlugIn( actor ) = {}

    ioPlugIn( actor, dobj ) = { dobj.doPlugIn( actor, self ); }

;



// Verbs



xyzzyVerb: deepverb

    verb = 'xyzzy'

    sdesc = "xyzzy"

    action( actor ) =

    {

        "Suddenly you are transported out of your house and never have to eat

         toast again!  Yay!  Well... not really.  Nothing happens.  Nice try,

         though.";

    }

;



flushVerb: deepverb

    verb = 'flush'

    sdesc = "flush"

    doAction = 'Flush'

;



aboutVerb: deepverb

    verb = 'about' 'info' 'credits'

    sdesc = "about"

    action( actor ) =

    {

        "\bThis game is for the toaster competition originated by Mark Musante 

         in August, 2000.  It is loosely based on the Talkie Toaster(tm) in Red

         Dwarf and the character of Bun-Bun in Sluggy Freelance(tm), an online 

         web toon (located at http://www.sluggy.com).  Both of these were big 

         influences for this game.  Many thanks to my betatesters Peter Bergman 

         and Rob Wheeler.  Also, thanks to Dan Shiovitz, Lenny Pitts, 

         Dan Schmidt, Neil DeMause and Stephen Granade for coding tips.  I hope 

         you enjoy playing this game!\b";

    }

;



// Rooms



startroom: room

    sdesc = "Bedroom"

    ldesc = "This is your bedroom.  It has all the typical amenities such as

             a bed, dresser and your closet.  The exit to your bedroom is to 

             the north."

    north = Hallway

;



Hallway: room

    sdesc = "Hallway"

    ldesc = "The hallway stretches from the south, where your bedroom is, to

             the north, where the living room begins.  There is a bathroom to

             the west."

    south = startroom

    north = Living_Room

    west = 

    {

        if ( toaster.location = Bathroom && toaster.isPlugged )

        {

            "The toaster says as you enter, \"Well, jerk-boy, are you ready to

             take me back to the kitchen?\"";

        }

        if ( Bathroom.iswet )

        {

            notify( Bathroom, &slipDaemon, 3 );

        }

        return( Bathroom );

    }

    in = "You'll have to specify a direction"

;



Living_Room: room

    sdesc = "Living Room"

    ldesc = "Your living room is pretty sparse in furniture, since your 

             ex-girlfriend took most of it.  All that's left is the couch.

             The front door to your house lies to the east, and the kitchen

             is to the west."

    south = Hallway

    east = "The front door is closed, besides you don't want to leave without

            having some toast first."

    west = 

    {

        if ( toaster.location = Kitchen && toaster.isPlugged )

            if ( Kitchen.hasVisited )

            {

                "The toaster yells at you, \"Oh, look who decided to return!  

                 Gonna give it another shot, wimp-boy?\"\b";

            }

            else

            {

                "As you enter the kitchen, you hear a foul voice assail you, 

                 \"Well, look who\'s here!  If it isn't the wimp!  Going to try 

                 to make some toast again???  Good luck, pansy!\"\b";

                Kitchen.hasVisited := true;

                notify( toaster, &talkDaemon, 0 );

            }

        return( Kitchen );

    }

    out = east

;



Bathroom: room

    sdesc = "Bathroom"

    ldesc = "The Bathroom has the usual things in it: sink, toilet, bathtub.

             It could use a thorough cleaning, but that's something

             that Kelly used to do, but now that she's gone you've just let

             it go.  << self.iswet? "The floor in here is very wet.  Watch

             your step." : "" >>"

    east = 

    {

        if ( toaster.location = Me && toaster.isPlugged )

        {

            "You're not going anywhere as long as the toaster is plugged in!\b

             The toaster laughs at you cruelly, \"What a stupid idiot.\"\b";

        }

        else

        {

            if ( toaster.location = self && toaster.isPlugged )

            {

                "The toaster cries after you, \"Oh, sure!  Leave me in the 

                 bathroom!  You can't make toast here, jerk!\"";

            }

            return( Hallway );

            unnotify( self, &slipDaemon );

        }

    }

    out = east

    slipDaemon =

    {

        "As you move around the room, you slip in a puddle of water and bang

         your head on the tub.  You are unconscious for several hours and you

         never quite recover.  The men in the white coats haul you away for

         thinking that your toaster talks to you.";

        lose();

    }

;



Kitchen: room

    sdesc = "Kitchen"

    ldesc = "Here it is.  The main goal of your morning routine.  Now to try

             to get that damn toaster to make you some toast.  Oh, there's 

             also a refrigerator, a sink and a stove here in addition to the 

             toaster.  The living room is back to the east."

    east = 

    {

        if ( toaster.location = Me && toaster.isPlugged )

        {

            "You're not going anywhere as long as the toaster is plugged in!\b

             The toaster laughs at you cruelly, \"What a stupid idiot.\"\b";

        }

        else

        {

            if ( toaster.location = self && toaster.isPlugged )

            {

                "As you go to leave, the toaster calls after you, \"Fine!  Run

                 away, wimp!  You won't get any toast from me!\"\b";

            }

            return( Living_Room );

        }

    }

;



// Items



// Bedroom Items



bed: beditem, underHider

    location = startroom

    noun = 'bed'

    sdesc = "bed"

    ldesc = "Your bed.  A nice king-size bed that feels very empty when you

             sleep in it alone."

;



bread: item, hiddenItem

    underLoc = bed

    noun = 'bread'

    sdesc = "bread"

    adesc = "bread"

    ldesc = "The presliced loaf of bread you use to make toast.  You hoped by 

             keeping it under the bed that you would forget about it when you 

             try to make toast.  Anything to not face that toaster again."

    verDoPutIn( actor, iobj ) =

    {

        if  ( iobj = toaster )

        {

            if ( toaster.isPlugged )

            {

                "As you put <<self.thedesc>> in the toaster, it spits it back 

                 out at you.  \"I don't want that in me, wimp-boy!\"";

            }

            else

            {

                "The slots on the toaster are closed.  It must be a safety

                 precaution for when the toaster is unplugged.  (Don't ask me

                 2why!)  It might be a good idea to just get rid of this 

                 toaster.";

            }

        }

        else

        {

            pass verDoPutIn;

        }

    }

;



closet: fixeditem

    location = startroom

    noun = 'closet'

    sdesc = "closet"

    ldesc = "Your closet, which you don't use.  It was the vast storehouse of 

             Kelly's clothing, and since she's no longer here, it now stands

             empty.  "

    verDoOpen(actor) =

    {

        "There's no reason to open it.  There's nothing inside.";

    }

;



dresser: fixeditem, openable

    location = startroom

    noun = 'dresser' 'drawer'

    sdesc = "dresser"

    ldesc = "Your dresser stands about chest-height and has just one drawer in

             it.  There's probably nothing in it, since Kelly took most of your

             clothes.  The dresser is currently << dresser.isopen? "open" : 

             "closed" >>.  Above the dresser is a mirror."

    isopen = nil

;



right_glove: item, clothingItem

    location = dresser

    noun = 'glove'

    adjective = 'right' 'right-hand'

    sdesc = "right glove"

    ldesc = "It is the right hand to a pair of gloves.  Now if you can only

             remember where the left one is."

    verDoTake( actor ) = {}

    doTake( actor ) =

    {

        if ( left_glove.location = Me )

        {

            "Taken.  You now have a pair of gloves.";

            left_glove.moveInto(nil);

            right_glove.moveInto(nil);

            gloves.moveInto(Me);

        }

        else

        {

            pass doTake;

        }

    }

;



br_mirror: mirror

    location = startroom

;



// Hallway Items



// Living Room Items



door: fixeditem

    location = Living_Room

    noun = 'door'

    sdesc = "door"

    ldesc = "The door leads out of your house."

    verDoOpen( actor ) =

    {

        "You can't leave now.  You still have toast to make.";

    }

;



couch: chairitem

    location = Living_Room

    noun = 'couch' 'sofa' 'furniture'

    sdesc = "couch"

    ldesc = "This couch has seen better days.  It's pretty worn and ripped in

             places.  That's probably why Kelly didn't take it, and took other

             things instead, like your $1200 stereo."

;



// Bathroom Items



bath_sink: fixeditem, container

    location = Bathroom

    noun = 'sink' 'basin'

    adjective = 'bathroom' 'wash'

    sdesc = "bathroom sink"

    ldesc = "A white porceleain sink which has rust stains in the bottom of

             it.  It has a faucet, of course and there is a mirror above it.

             There is an electrical outlet located just left of the sink right

             near the tub."

;



bath_sink_faucet: faucet

    location = bath_sink

    adjective = 'sink'

    sdesc = "sink faucet"

    ldesc = "A simple faucet for turning the water on or off.  <<self.ison?

             "There is water flowing out of the faucet into the sink." : "" >>"

    verIoPutIn( actor ) = {}

    ioPutIn( actor, dobj ) =

    {

        "<<dobj.Thedesc>> doesn't fit in <<self.thedesc>>.";

    }

;



stains: fixeditem

    location = bath_sink

    noun = 'stains'

    sdesc = "stains"

    ldesc = "<<self.Thedesc>> are the cover of rust.  They are splotched around 

             the sink."

    isThem = true

;



bath_mirror: mirror

    location = Bathroom

;    



bath_socket: socket

    location = Bathroom

;

    

bathtub: fixeditem,  nestedroom

    location = Bathroom

    reachable = ( [] + self )

    noun = 'tub' 'bathtub'

    adjective = 'bath'

    sdesc = "bathtub"

    ldesc = 

    {

        "Just your regular bathtub.  It has a faucet and a drainstopper,

         which is currently << stopper.isopen? "open" : "closed" >>.  ";

        if ( tub_faucet.ison )

        {

            "There is water flowing into the tub";

            if ( stopper.isopen )

                ".";

            else

                " and filling it up.";

        }

         checkTub();

    }

    fillDaemon =

    {

        self.volume++;

        if ( self.location = Me.location ) 

        {

            checkTub();

        }

        if ( self.volume = 6 )

        {

            unnotify( self, &fillDaemon );

            Bathroom.iswet := true;

            if ( self.location = Me.location )

            {

                notify( Bathroom, &slipDaemon, 3);

            }

        }

    }

    verDoEnter( actor ) = {}

    doEnter( actor ) =

    {

        actor.moveInto( self );

        "You enter <<self.thedesc>><<self.volume > 0?  ", getting your socks

         wet" : "" >>.";

        actor.sockswet := true;

    }

    verDoUnboard( actor ) =

    {

        if( actor.location != self )

        {

            "You are not in <<self.thedesc>>.";

        }

        else

        {

            pass verDoUnboard;

        }

    }

    doUnboard( actor ) =

    {

        actor.moveinto( self.location );

        "You exit << self.thedesc>><<actor.sockswet? ", your socks squishing

         against the floor" : "" >>.";

    }

    verIoPutIn( actor ) = {}

    ioPutIn( actor, dobj ) = { dobj.doPutIn( actor, self ); }

    volume = 0

;



tub_faucet: faucet

    location = bathtub

    adjective = 'bathtub' 'tub' 'bath'

    sdesc = "bathtub faucet"

    ldesc = "Just a simple faucet for turning the water on or off.  << 

             self.ison? "There is water currently flowing out of the faucet

             into the tub" : "" >> << stopper.isopen? "" : " and filling it

             up" >>."

    doTurnon( actor ) =

    {

        inherited.doTurnon( actor );

        if ( not stopper.isopen )

        {

            "\bThe tub begins to fill with water.";

            notify( bathtub, &fillDaemon, 0 );

        }

    }



    doTurnoff( actor ) =

    {

        inherited.doTurnoff( actor );

        if ( not stopper.isopen )

        {

            unnotify( bathtub, &fillDaemon );

            checkTub();

            water.moveInto( uberloc( self ) );

        }

    }

;



stopper: fixeditem, openable

    location = bathtub

    noun = 'stopper'

    verb = 'drain'

    sdesc = "stopper"

    ldesc = "The drain stopper plugs up the drain when it's closed.  It is

             currently << stopper.isopen? "open" : "closed" >>."

    isopen = true

    verDoOpen( actor ) = 

    {

        if ( self.isopen )

            "<<self.Thedesc>> is already open.";

    }

    doOpen( actor ) =

    {

        if ( bathtub.volume > 0 )

        {

            "You open <<self.thedesc>> and the water in the tub flows down the 

             drain.";

            unnotify( bathtub, &fillDaemon );

            bathtub.volume := 0;

            if (  not tub_faucet.ison )

                water.moveInto( nil );

        }

        else

        {

            "You open <<self.thedesc>>.";

        }

        self.isopen := true;

    }

    verDoClose( actor ) = 

    {

        if (  not self.isopen )

            "<<self.Thedesc>> is already closed.";

    }

    doClose( actor ) =

    {

        if ( tub_faucet.ison )

        {

            "You close <<self.thedesc>> and the tub begins filling with 

             water.";

            notify( bathtub, &fillDaemon, 0 );

        }

        else

        {

            "You close <<self.thedesc>>.";

        }

        self.isopen := nil;

    }

;



toilet: fixeditem

    location = Bathroom

    noun = 'toilet' 'john' 'loo'

    sdesc = "toilet"

    ldesc = "Yes, there is a toilet here but you don't even want to think

             what the inside of it looks like."

    verDoOpen( actor ) =

    {

        "You really don't want to open the toilet and see what's in it.";

    }

    verDoFlush( actor ) =

    {

        "You hear the toilet gurgle.  It doesn't sound good.  It might be time

         to call a plumber after you deal with your toaster.";

    }

;



// Kitchen Items



oven: fixeditem, openable

    location = Kitchen

    noun = 'oven' 'stove' 'door'

    sdesc = "oven"

    ldesc = "It's your typical electric stove.  Four burners on top, and a door

             underneath where the actual oven is."

    isopen = nil

;



kitchen_sink: fixeditem, container

    location = Kitchen

    noun = 'sink'

    adjective = 'kitchen'

    sdesc = "kitchen sink"

    ldesc = "It is a good-sized kitchen sink to do your dishes in, since you do

             not have a dishwasher.  It has a faucet, of course, and the

             stopper is missing.  Is there any lengths that Kelly wouldn't go

             to in order to annoy you?  There is a socket just to the right of

             the sink."

    verIoPutIn( actor ) = {}

    ioPutIn( actor, dobj ) =

    {

        if ( dobj = toaster )

        {

            "Well, <<dobj.thedesc>> would fit in there, but that's not a good

             place to put it.  You'd need to find somewhere where water can

             surround <<dobj.thedesc>>.";

        }

        else

        {

            pass ioPutIn;

        }

    }

;



kitchen_sink_faucet: faucet

    location = kitchen_sink

;



kitchen_socket: socket

    location = Kitchen

;



left_glove: item, clothingItem

    location = oven

    noun = 'glove'

    adjective = 'left' 'left-handed'

    sdesc = "left glove"

    ldesc = "It's the left hand to a pair of gloves.  Now if only you can 

             remember where the right one is."

    verDoTake( actor ) = {}

    doTake( actor ) =

    {

        if ( right_glove.location = Me )

            {

                "Taken.  You now have a pair of gloves.";

                left_glove.moveInto(nil);

                right_glove.moveInto(nil);

                gloves.moveInto(Me);

            }

        else

            {

                pass doTake;

            }

    }

;



refrigerator: fixeditem, openable

    location = Kitchen

    noun = 'refrigerator' 'fridge' 'icebox'

    sdesc = "refrigerator"

    ldesc = "It's your refigerator.  There's probably not much in it since you

             haven't had time to restock it after Kelly cleaned you out."

    isopen = nil

;



butter: item

    location = refrigerator

    noun = 'butter' 'margarine'

    adjective = 'stick'

    sdesc = "stick of butter"

    ldesc = "A stick of butter, or maybe it's margarine.  No matter.  Kelly

             probably didn't take it because she thought it would make her fat.

             You like to put it on your toast... that is if Kelly hadn't 

             taken all your silverware."

    verDoPutOn( actor ) = {}

    doPutOn( actor, iobj ) =

    {

        if ( iobj = bread )

            "You can't put butter on <<iobj.thedesc>> until it's toasted!";

        else

            "You can't put butter on the <<iobj.thedesc>>.";

    }

;



toaster: item

    location = Kitchen

    noun = 'toaster'

    sdesc = "toaster"

    ldesc = "The Toasterama(TM) 25.9 is the latest in high-tech gadgetry.  It

             was designed to give you meaningful conversation while eating 

             breakfast.  Kelly thought it was a really cool thing.  However,

             all this one can do is hurl insults.  You secretly think that

             Kelly left it with you to torture you.  There is a dial and a

             lever on it."

    doAskAbout( actor, io ) =

    {

        "\"Figure it out yourself, idiot!\"";

    }

    talkDaemon =

    {

        if (self.location = Me.location && self.isPlugged && not self.Spoken )

        {

            switch(rand(6))

            {

                case 1:

                    "\bThe toaster yells at you, \"Come on, wimp!  Let's see 

                     what you're made of!  Think you have the guts?\"";

                break;



                case 2:

                    "\bThe toaster is silent, thankfully.";

                break;



                case 3:

                    "\bAs you muddle around the kitchen, you accidentially 

                     jostle the toaster.  \"Hey!  Watch where you're going, 

                     jerk!\"";

                break;



                case 4:

                    "\bThe toaster makes a high-pitched scream that makes you 

                     wince.";

                break;



                case 5:

                    "\bThe toaster says to you, \"Let's just see if you can 

                     even try to place bread in me!\"";

                break;



                case 6:

                    "\bThe toaster screams at you, \"I'll bet you're too wimpy 

                     even to get close to me!\"";

                break;

            }

        }

        self.Spoken := nil;

    }

    verDoTake( actor ) = {}

    doTake( actor ) =

    {

        if (gloves.isworn = nil && self.isPlugged)

        {

            if ( self.isTouched )

            {

                dieRoutine();

            }

            else

            {

                self.isTouched := true;

                self.Spoken := true;

                "As you try to pick up <<self.thedesc>>, it gives you an 

                 electric shock.  \"Just go ahead and try that again, 

                 wimp-boy!\"";

            }

        }

        else

        {

            if ( toaster.isPlugged )

            {

                "The toaster screams at you, \"Put me down, wimp, if you

                 know what's good for you!\"";

            }

            self.isListed := true;

            self.Spoken := true;

            pass doTake;

        }

    }

    verDoPlugIn( actor, iobj ) = 

    {

        if ( self.isPlugged )

        {

            "<<self.Thedesc>> is already plugged in!";

        }

    }

    doPlugIn( actor, iobj ) =

    {

        if ( isclass( iobj, socket ) )

        {

            if ( Me.location = bathtub && bathtub.volume >= 3)

            {

                "Suicide is not the answer to this one. (Although you're 

                 close!)";

            }

            else

            {

                "You plug <<self.thedesc>> into the socket.\bThe toaster 

                 screams at you, \"What the hell did you unplug me for, jerk?!

                 \"";

                notify( self, &talkDaemon, 0);

                self.isPlugged := true;

                self.Spoken := true;

            }

        }

        else

        {

            "You cannot plug <<self.thedesc>> into <<iobj.thedesc>>!";

        }

    }

    verDoUnplug( actor ) = 

    {

        if ( not self.isPlugged )

        {

            "<<self.Thedesc>> is already unplugged!";

        }

    }

    doUnplug( actor ) =

    {

        if (not gloves.isworn && self.isPlugged)

        {

            if ( self.isTouched )

            {

                dieRoutine();

            }

            else

            {

                "As you try to unplug the toaster, it gives you an electric 

                 shock.     \"Just try and touch me again, wimp-boy!\"\b";

                 self.isTouched := true;

                 self.Spoken := true;

            }

        }

        else

        {

            "As you reach to unplug <<self.thedesc>>, it lets out an inhuman 

             scream.  It's all you can do to continue to unplug it.";

            self.isPlugged := nil;

            unnotify( toaster, &talkDaemon);

            pass DoUnplug;    

        }

    }

    verDoDrop( actor ) =

    {

        if ( actor.location = bathtub && self.isPlugged )

        {

            "Suicide is not the answer to this one (although you're close).";

        }

        else

        {

            pass verDoDrop;

        }

    }

    verDoPutIn( actor, iobj ) = 

    {

        if ( iobj = bathtub && actor.location = bathtub && self.isPlugged )

        {

            "Suicide is not the answer to this one (although you're close).";

        }

        else

        {

            pass verDoPutIn;

        }

    }

    doPutIn( actor, iobj ) = 

    { 

        inherited.doPutIn( actor, iobj);

        checkwin();

    }

    isListed = nil

    isTouched = nil

    isPlugged = true

;



dial: fixeditem

    location = toaster

    noun = 'dial'

    sdesc = "dial"

    ldesc = "The dial on the toaster is currently set to 'insult'"

    verDoTurn( actor ) = {}

    doTurn( actor ) =

    {

        if ( not gloves.isworn && toaster.isPlugged)

        {

            if (toaster.isTouched)

            {

                dieRoutine();

            }

            else

            {

                "As you try to turn <<self.thedesc>>, the toaster gives you an 

                 electric shock.  \"Don't touch my dial, idiot!\"\b";

                toaster.isTouched := true;

                toaster.Spoken := true;

            }

        }

        else

        {

            "<<self.Thedesc>> seems to be stuck on 'insult.'";

        }

    }

;



lever: fixeditem

    location = toaster

    noun = 'lever'

    sdesc = "lever"

    ldesc = "It's the lever for dropping toast in the toaster."

    verDoPush( actor ) = {}

    doPush( actor ) =

    {

        if ( not gloves.isworn && toaster.isPlugged )

        {

            if ( toaster.isTouched )

            {

                dieRoutine();

            }

            else

            {

                "As you reach for <<self.thedesc>>, the toaster gives you an

                 electric shock.  \"Don't touch my lever, you idiot!\"";

                toaster.isTouched := true;

                toaster.Spoken := true;

            }

        }

        else

        {

            "<<self.Thedesc>> seems to be stuck in place.  It must be there for 

             show only.";

        }

    }

;



slots: fixeditem

    location = toaster

    noun = 'slots'

    sdesc = "slots"

    ldesc = "Two slots are in the top of the toaster.  They are currently

             << toaster.isPlugged? "open" : "closed">>.";



// Items Not Given in a Specific Room



gloves: item, clothingItem

    noun = 'gloves' 'pair'

    sdesc = "pair of gloves"

    ldesc = "It's a pair of gloves."

    verDoUnWear( actor ) =

    {

        if ( toaster.location = actor && toaster.isPlugged )

        {

            "You decide not to remove the gloves while you are holding the

             plugged-in toaster.";

        }

        else

            pass verDoUnWear;

    }

    isThem = true

;



water: fixeditem

    noun = 'water' 'stream'

    sdesc = "water"

    ldesc = "It's water.  Deal with it."

;



// Functions



dieRoutine: function

{

    "The toaster growls at you, \"I warned you, wimp boy!\"\n  You feel

     a big jolt, and that's the last thing you feel.";

    die();

}



checkTub: function

{

    switch(bathtub.volume)

    {

        case 0:

            "\bThe tub is empty.  ";

        break;

        

        case 1:

            "\bThere is a small pool of water at the bottom of the tub.  ";

        break;

        

        case 2: 

            "\bThe tub is a quarter full.  ";

        break;

        

        case 3: 

            "\bThe tub is half full.  ";

        break;

        

        case 4: 

            "\bThe tub is three-quarters full.  ";

        break;

        

        case 5:

            "\bThe water is filled to the rim of the tub.  ";

        break;



        case 6:

            "\bThe tub has overflowed and there is water on the floor.  Watch

             your step.  ";

        break;

    }

    checkwin();

}



lose: function

{

    "\b*** You have lost ***\b";

    "\bYou may restore a saved game, start over, quit, or undo

    the current command.\n";

    while (true)

    {

        local resp;

        "\nPlease enter RESTORE, RESTART, QUIT, or UNDO: >";

        resp := upper(input());

        if (resp = 'RESTORE')

        {

            resp := askfile('File to restore',

            ASKFILE_PROMPT_OPEN, FILE_TYPE_SAVE);

            if (resp = nil)

                "Restore failed. ";

            else if (restore(resp))

                "Restore failed. ";

            else

            {

                parserGetMe().location.lookAround(true);

                scoreStatus(global.score, global.turnsofar);

                abort;

            }

        }

        else if (resp = 'RESTART')

        {

            scoreStatus(0, 0);

            restart();

        }

        else if (resp = 'QUIT')

        {

            terminate();

            quit();

            abort;

        }

        else if (resp = 'UNDO')

        {

            if (undo())

            {

                "(Undoing one command)\b";

                parserGetMe().location.lookAround(true);

                scoreStatus(global.score, global.turnsofar);

                abort;

            }

            else

                "Sorry, no undo information is available. ";

        }

    }

}



checkwin: function

{

    if ( toaster.location = bathtub && toaster.isPlugged && bathtub.volume >= 3)

    {

        if ( Me.loacation = bathtub )

        {

            "The water flows over the top of the toaster and you and the

             toaster die in a shower of sparks.";

            die();

        }

        else

        {

            "\bAs the water flows over the top of the toaster, it lets out a

             bloodcurling scream and sparks fly everywhere.  Finally, you

              are rid of that damn toaster and you decide to go out for 

             waffles.";

             win();

        }

    }

}



win: function

{

    "\bYou win.  Thank you for playing.";

    quit();

    abort;

}



uberloc: function( item )

{

    if ( item.location=nil )

    {

        return(item);

    }

    else 

    {

        return(uberloc(item.location));

    }

}

                

// Function Replacements



replace ScoreStatus: function ( turns )

{

    setscore( cvtstr( turns ) );

}

