! dialog.inf - Frame box at screen centre, and fill with text.

! ZBefunge - a Befunge interpreter for a Z Machine.
! Copyright 1998 Francis Irving.

! This source code is distributed under the GNU general public license,
! version 2 or later (at your option).  See the file copying.txt for
! full information.

Global dialog_origin_x;
Global dialog_origin_y;
Global dialog_width;
Global dialog_height;

[ PositionCentreDialog width height;
  dialog_origin_x=(scr_xmax+1-width)/2;
  dialog_origin_y=(scr_ymax+1-height)/3;
  dialog_width = width;
  dialog_height = height;
];

[ StartCentreDialog width height  y;
  PositionCentreDialog(width, height);
  style reverse;
  for (y=0: y<height: y++) {
    HLine(dialog_origin_x, dialog_origin_x+width-1, dialog_origin_y+y, ' ');
  }
];

[ AtDialog x y str;
  AtScreen (dialog_origin_x+x, dialog_origin_y+y, str);
];

[ AtCentreDialog y str;
  AtDialog((dialog_width - str->0) / 2, y, str);
];

[ EndCentreDialog;
  style roman;
];

