Halothane, An Interactive Restoration
-------------------------------------
Interactive fiction by Quentin.D.Thompson (Ravi.P.Rajkumar), 1999
philip@giasmda.vsnl.net.in                   stupid_q@my-deja.com

=============================================================================
Two ways of solving the game, comments, and miscellaneous items of interest..
=============================================================================

NOTE: I completely realise that most of this information could just as
      easily be put into the game file, halo.z5 (I still get a kick out
      of that file name :-D), but I didn't want it to become halo.z8
      and tempt fate at the hands of the two-hour rule - The Author.

=============================================================================

TABLE OF CONTENTS
-----------------

1. A short walkthrough of Halothane (very few spoilers)
2. A detailed walkthrough of Halothane (PARENTAL ADVISORY: explicit spoilers)
3. Halothane: who, what, why, where, and how?
4. Future releases

=============================================================================

SHORT WALKTHROUGH (in the style of Paul.J.Godfrey)
-----------------

This is the absolute, no-fun, no-Easter Egg walkthrough for Halothane.
(If you want a detailed one, see below.)

(you begin playing this game as Harold Banks, an author)
(you start in your bedroom)

north (Or south, or any other direction...)
(Now you know you need to get to bed)
examine bed
look under bed
look under desk
get fan
put fan on chair
switch on fan
lie on bed
sleep

Chapter 1
---------
(In the operating theatre)
west
turn valve
(This is the shortest solution.)

Chapter 2
---------
(In your study)
get manuscript
throw manuscript in dustbin
(depressing, but there it is..)

Chapter 3
---------
(In the kidnappers' car)
z.z.z.z.z.z.z.z
(In the open field)
north
north

Chapter 4
---------
(Outside the house)
open window
enter window
east
x woman
say hello to Simone
(you can ask Simone about many things here; this is a sample)
ask Simone about Mr. Author
ask Simone about herself
ask Simone about Rosenberg
ask Simone about Edward/Laura/Franklin (all give the same reply)
ask Simone about future
ask Simone about halothane
ask Simone about plan
ask Simone about successors
ask Simone about novel
(you can also ask Simone about other things, including the parallel
dimension, the solution, the house she's staying in, and so on.)
z
(keep on waiting until Simone hands you a pen)

Chapter 5
---------
(Red Lake)
open trapdoor
down
(Floating on Clouds)
north
east
east
east
up
east
get bottle
x it
read it
west
down
west
west
west
open bottle
throw acid at gate (as per the inscription)
("Dissolve gate" and "Pour acid on gate" also work.)

Chapter 6
---------
(in the Saloon)
ask receptionist about saloon
ask receptionist about legend
(Strange, isn't it?)
east
look under table
get device
up
north
get manual
read it
south
south
get black disc
north
west
put disc in computer
switch on computer
read screen
(Note the two dates, and remember the manual inscription.)
east
north
table, the code is 2187
search table
get chip
put chip in machine
south
east
search bed
get letter
read it
yes
(You need to know what the letter says.)
west
down
show letter to receptionist
(the receptionist will now take out a key)
examine key
get key
ask receptionist about key
up
up
north
x vase
put pen in vase
(As suggested by the doggerel verse.)

(You play the rest of the game as Cassandra Anderson, one of Harold's
characters)

Chapter 7
---------
(outside Cassandra's house)
north
knock on door
open door
north
north
east
east
north
look
x bed
search bed
search sheet
search mattress
look
x knife
open wardrobe
x corpse
search it
get cash card
(you have to leave the house now)
south
west
west
south
south
east
put cash card in machine
(an earlier version of the game accepted 'put ID in machine' as well, but
that's a bug.)

Chapter 8
---------
(by the railway tracks)
east
east
(entering Charlestown)
x statue
south
examine black door
(you need to know the name here. Remember it from Chapter Three?)
down
east
east
south
smash bulb
get key
north
west
west
up
north
east
south
east
x woman
ask woman about Sweeney
(search woman. get knife, if you want to kill Sweeney that way.)
west
north
west
south
east
x sweeney
x coffin
put love-letter in coffin
('throw knife at sweeney', 'microphone, any' and just waiting for 17 turns
or so also work, but this is the "optimal" solution).

Chapter 9
---------
(in the hospital)
north
north
east
get gown
wear it
west
north
east
get key
west
south
south
east
up
north
unlock locker with platinum key
get mask
wear mask
south
up
north
east
get cap
wear cap
west
x student
(no points for guessing who this is)
(If you're not wearing the scrub suit by this time, the student will tell
you what to do.)
north
north

Chapter 10
----------
(in the hut)
west
kill troll with pen
("Attack troll" and "Throw pen at troll" also work.)

(At some point in the game, type "help" to call up online help.)

Obviously, if you've used this walkthrough to breeze through the game, you
mightn't have got the entire story pat. (Not to mention that you missed
out on a lot of silly humour scattered in a few of the zones.) But this
is the shortest complete way of finishing Halothane.

[Actually, it's not _the_ shortest method. It's the shortest continuous
method. A stripped-down walkthrough would omit the conversational commands.]

Below this is the verbose, prosy, Easter Egg-riddled Halothane walkthrough.
Use it only if you've got time to spare.

HALOTHANE
Or, "It's A Wonderful Book!"
Verbose Interactive Fiction by Quentin.D.Thompson.

Foreword:
Halothane is a pastiche. Each stage is written in a different style, is
set in a different environment, so be prepared to adapt a little to some
of the more obscure stages. There are no ways (as far as I'm aware) of
shutting oneself out of a win. The game also features three optional
stages, or 'interpositions'. You only get those when you're playing as
Harold (see below about the player characters) because he is the author,
after all. These stages give you a few points, and a few laughs, but they
don't really do much.

Halothane doesn't really mean much. It's a heroic quest (Save the parallel
dimension from a bunch of trolls! Kill an ugly troll! Collect *Treasures*!)
but an immensely silly one, and it was written for two reasons: one was
entertainment, the other was to try different styles of writing and puzzles.
Anything that appears serious is unintentional.

Well, let me give you a little background on the story.

In this game, you play the role of Harold Banks, twenty-odd, published
author. His first book, "Before Our Time" (very complicated SF) sold
precisely 46 copies, but Harold's not the type to get discouraged easily,
so he's writing a second book, "The Decline And Fall Of The Colonial
Empire", which (he hopes) will do better. The game opens in his
bedroom-cum-study, where he's about to call it a day:

[Harold bears little resemblance to the author, who hasn't even published
his very complicated SF novel.]

The Prologue
============

A bedroom. Nothing exciting. Let's see if we can move around first...

        north (or any direction for that matter)

Too sleepy? Let's make do with "les moyens du bord", as Enrico Macias would
put it, and see if there's anything interesting in the bedroom.

        examine bed
        examine desk
        examine bookcase
        examine chair

Since we're sleepy, let's try going to sleep directly..

        lie on bed
        sleep

No ventilation. Now you have a purpose in life - to find ventilation. Since
you can't leave the room - and this isn't Spider and Web - the fan's got to
be nearby...

         look under bed

Interesting....let's do as we're told.

         look under desk

Hmm, a fan. Sounds good. But let's have a look at what's on the desk first.

         x manuscript
         search it

This is the first intimation that something out of the ordinary is going to
happen. Let's look into it a little closer:

         read note
         get flower
         examine it
         sniff it

Strange flower. Let's check the last piece of furniture:

         open bookcase
         get novel
         examine it

The quote boxes in this game are few in number, and this is the first.
You could always

         read the novel

but you're not in need of bedtime stories right now. Let's go to the land
of Nod now.....

         switch on fan

That chair should do the trick.

         put fan on chair
         switch on fan

Now, sweet dreams!

         lie on bed
         sleep

Do you get the feeling that something's going to happen? You're quite right.

CHAPTER ONE: RESPIRATORY DISTRESS
=================================

You wake up in an operating theatre. If you've read the note in your
bedroom, the first puzzle here should be fairly simple. Well, there's
nothing here except the mask, so let's just take it:

         stand (or 'get off table')
         take mask

Anaesthetics can be dangerous (this game is called Halothane after all),
so let's take our precautions:

         wear mask

Now let's explore the next room:

         open door
         west
         examine cylinder

I apologize to anyone who thinks that splitting up Read and Examine is
an AGT dodge, but it's very useful in this game. The cylinder has writing
on it, so....

         read cylinder

Next, examine the rest of the scenery (which isn't much, I admit)..

         examine LCD panel
         read it

Can you detect the seeds of a very, very bad pun? (The idea isn't original;
I pinched it from Maestro Asimov's "The Key", which also relies on a
bilingual pun, albeit a more complex one). Well, the pun is "light-producer
-> halogenos -> halogenated -> halothane". So let's let some halothane out..

         open valve
         (you can also type 'turn valve')

Now some letters have appeared on the panel, so read them:

          read panel

Forget the negative attitude, and just touch the panel (forgive me, Ian
Finley; I wasn't even thinking of Babel when I wrote this....)

          touch panel

(Actually, this is an optional puzzle. The fastest way out is not to wear
the mask, and then open the valve; the halothane knocks you out, and you
leapfrog over the stage below to land up at Chapter Two.)

FIRST INTERPOSITION: INVASION OF PRIVACY
========================================

You're outside a house. First check your bearings:

          examine door
          examine plaque

Now, quotes from your own works could only appear (a) in a fan's house
[and you don't have any] or (b) in a fictitious universe peopled by your
characters. The point first crops up here, but it reappears often
throughout the game. Why you have been transported to the parallel
dimension (that's what I called it myself) becomes evident after Chapter Two.

          open door

No namby-pamby lock and key puzzles here. You're in the hall. There's another
note here if you want:

          get memo
          read memo

Feeling tired?

          sit on sofa

Bummer. Check out that piece of paper. It's irrelevant, but read it anyway:

          get piece of paper
          read it

You could also check out the rest of the room,

          examine sofa
          examine shawl
          wear shawl :-)

or have fun with the shelf:

          open shelf
          read texts
          again
          again
          again

There are four possible texts available. Most of them are bad jokes, though.
[Except the one about highbrow writing, which was a _rant_. Give me
five minutes in a dark alley with Raj Kamal Jha and my grimoire, and I'll
frotz him until he'll never write another excrescence again.] There's nothing
more here, so head north:

          north
          examine arch

The arch is glowing, just like the LCD panel. Could we have an exit here?

          touch arch

This is a Competition '97 joke; the game being alluded to, obviously, is
Ian Finley's fine SF game, "Babel". There's plenty of IF in-joking in the
game, as you'll see. We could go east or west here, but since this is
a detailed walkthrough, head east:

          east
          examine bed
          examine chair
          examine wardrobe
          examine dresser
          get letter
          read it

Relax, this game isn't a Mel Gibson movie, so young Simone hasn't been
kidnapped. (You get to meet her in Chapter Four, by the way.) I tried
to put some (very dumb) atmospherics here; to get them, try

          open window
          look
          close window

and then head west:

          west
          west

Voices?

          Listen
          again
          again
          again
          again
          again
          again
          again

You can listen up to eight times here; please do so, to get as much of the
story as possible. Now there's only one place left to head:

          west

Any Harold could figure out that this was probably the Franklins' room. Well,
you could look around a bit:

          examine bed
          examine table
          examine dresser

But since what you actually need to do is raise the alarm (after all, it's
their daughter, even if she does turn out to be your brainchild) you need to
          
	  switch on the light

Read the piece of text here carefully if you're following the story. Now we're
off to this game's shortest chapter.

CHAPTER TWO: ERRARE HUMANUM EST
===============================

Hmm, we seem to be back to reality again. Read the messages that appear
(they're thoughts coursing through your head), and check out the manuscript
too...

          read novel

At this point (it's a scene from your _possible_ future - read the "What
really happened?" later) you think that you've written a piece of trash.
Actually, you haven't, but - hell - we all are irrational some time. Let's
dispose of the manuscript, then...

          tear novel

Didn't work? Well, let's mutilate it....

          crumple novel

Still not enough? Ah, let's dispose of it....

          throw novel in dustbin

Something attempted, something done.......but before you can even think
of the consequences, you're whisked out of your dimension and back to
the dream-world of Chapter One, headed for....

CHAPTER THREE: DRIVING WITH YOUR EYES CLOSED
============================================

This chapter's title is derived from Don Henley's song about a French
artist, which can be found on the album "Building the Perfect Beast".
(It has nothing much to do with the game, but the first line goes
"I met a Frenchman in a field last night", and most of this stage is
an open field....)

Well, you're tied up. Let's try getting out of this mess.....

         examine bonds
         untie them

Stuck. Let's just listen to what the voices in the front seat have been
saying. Actually, they're discussing you, which should be fairly obvious.

         listen
         again
         (until you're ushered out of the car)

Now you're in an open field. There is nothing to do here, except examining
some scenery:

For example,

         examine wall
         examine grass
         lie on grass
         search grass
         take grass
         examine fence
         climb fence

When you weary of this, just head

         north

Oh, great, more open field, and you without a picnic basket. Forget about
it, though, and continue your pastoral....

         examine tree
         examine sign
         read sign

Sweeney and Stroll? The names come in handy later on, but for the moment
they're not relevant. If you want to leave this place and head for the
village, just head

         north

again, but - that sign looks a bit loose. Let's adjust it a bit:

         turn sign

This is becoming a habit. When you wake up, you now are in the Museum,
ready for the.....

SECOND INTERPOSITION: THINKING ALLOWED
======================================

A word of warning. This is just a silly puzzle. If you find it too annoying,
just get out of here by typing

         omit

However, having got this far, you're probably interested in having a bash.
No fear - this is far simpler than your average Andy Philips Mensa Test.
To get some instructions, head east:

         east
         examine brochure
         take brochure
         read brochure

The brochure basically explains what you need to do to crack the puzzle:
reduce the machine's potential (7mV) to the minimum possible. Using the sheet,
block off the excitatory receptors and occupy the inhibitory receptors
with the relevant models, but if you're feeling lazy, here goes...

         put clonidine in a2. read dial.
         put propranolol in b1. read dial.
         put dopamine in d4. read dial.
         put ondansetron in s3. read dial.
         push button

Simple, wasn't it? Now off we go, to one of the most important chapters in
the game......

CHAPTER FOUR: EVERYTHING CAN CHANGE
===================================

Try moving around; it soon becomes obvious that there's nothing constructive
to do except getting into the building. How does one achieve that?

        tap window

Great, somebody's home.

        again

Yes, it's safer, I agree. Let's be stealthy and _not_ knock this time.

        open window
        east

Scary, isn't it? (There is a potentially more 'scary' episode further
downstream, but so far...)

        east

You can check out the scenery and shadows over here, but at some point you'll
want to see who the woman really is, so head east again.....

        east

Well, at least she seems friendly. Let's accept her invitation, and take
a closer look:

        sit on sofa
        x woman
        x Simone

"It's All Coming Back To Me Now", as Meatloaf's female counterpart would have
it :). Well, this stage has no puzzles. You can ask Simone about quite a few
things, or just wait around: here are some possibilities

        ask Simone about her mother/father/parents (same reply, though)
        ask Simone about Rosenberg
        ask Simone about house :)
        ask Simone about future
        ask Simone about politics/war/government (I put this in for a laugh..)
        ask Simone about halothane
        ask Simone about Mr. Author
        ask Simone about padre
        ask Simone about parallel dimension
        ask Simone about history/her job

When you run out of ideas (there are more; these are just the ones I remember
offhand), just keep on waiting

         z.z.z.....etc.

until she hands you a fountain-pen. Before you can react, though, you're
whisked off to the next zone:

CHAPTER FIVE: THE FAR HORIZON
=============================

Floating in liquid? Let's be venturesome.

         swim

Bummer. Let's be _even_ braver....

         drink liquid

Interesting, but at some point you'll definitely want to get out of the
lake. To do so, just examine that trapdoor:

         x trapdoor
         open it
         down

And curiously enough, you're now floating on clouds. You can look at the
clouds and pathway here, but if you're in a hurry, just head north:

         north
         
Intriguing. Let's see if this is as simple as it looks:

         open gate

Nope. How about force?

         attack gate

Well, we'll just have to get our kicks on some other route. Let's head east
first, up to that tower:

         east. east. east
         x spiral staircase
         climb it
         east

Nice tower, isn't it? The acid and the key represent the two exits from this
stage. Since we're playing it the long, hard way, we'll take the latter:

         get key

and pause to admire alchemy at work.....

         x cauldron
         x liquid
         touch it
         taste it
         take it

Well, time flies when you're having fun. Back down we go now:

         west. down. west. west. west

and then head north to that locked building:

         north
         unlock door with key
         open door
         north

Note that if you have the right key, you don't need to unlock and open it;
just type 'north' and the legwork is done for you automatically. Let's
explore the premises a little:

         north

Intriguing. Well, what lies elsewhere?

         west
         x blackboard
         turn it

(This is an Andy Philips easter egg). If you don't like trolls, you can
always

         erase the blackboard

though you don't get a Last Lousy Point for doing so. Let's check out the
other room:

         east. east
         x box
         search it

Aha!

         get handbag
         open handbag
         get handkerchief
         x it

Marguerite? Wonder who _she_ is.

         get badge
         x it
         read it
         wear it

Now let's try heading north:

         west
         north

Bingo! Under the assumed entity of the faceless Mr. Price, you are now thrown
into one of the most devilish parts of this game:

THIRD INTERPOSITION: A ROMANTIC INTERLUDE
=========================================

Aaah, a boudoir........no fear, this isn't Plundered Hearts, and you're
no pirate anyway. Since there's a bed around, let's make use of it:

         lie on bed
         sleep
         again
         again
         again
         again

The dreams should tell you what to expect in the next room. It takes twenty
turns or so for that door to open; you can't get it done yourself, so just
explore the rest of the room, and see if you can find the two Easter Eggs
here. I'll give you my favourite one as a favour:

         look under bed
         get journal
         x it
         read it

For the rest, just wait till the door opens, then go through it:

         north

Ah, this looks interesting

         x bottle

Remember your dream? Well, it has come true. Giacomo, whoever he is, is
going to croak if he drinks this saturated solution of antimony, so prevent
that simply with

         break bottle

(There's a more aesthetic solution, but I'll leave you to find it out.) For
the moment, though, we're off to....

CHAPTER SIX: THE SAD CAFE
=========================

You're not sure where to go. Just hang around for a few turns, and examine
the scenery.

NOTE: The words in boldface are memories of this place (which actually
exists in your second novel.) They are purely there for continuity and plot,
but offer little help as far as puzzles are concerned.

At some point, the receptionist will start talking about his hotel, so....

         ask receptionist about hotel

What old story?

         ask him about story

Mouthful, isn't it? Well, as this might suggest, your puzzles here are
connected to this story. Explore the dining-room first:

         east

Wonder what that could be?

         look under table

Aha!

         get device

Now head upstairs:

         west
         up

I'm deliberately not going into detail about the following sequence of
puzzles, and I urge you to try and work them out yourself; they're fairly
obvious when you come to think of it. Visit the rooms in the following
order to solve it 'fairly': Four, One, Three, Two, Three, One and Four.
For those of you who want it really bad, the solution is:

         south
         get disc
         north
         west
         put disc in computer
         switch on computer
         read screen

Note down the two dates here. (They never change, don't worry.)

         east
         north
         read manual
         table, the code is 2187
         look in table
         get chip
         put chip in device
         south
         east
         x quilt
         search it
         get letter
         read it
         yes

[Adventurers aren't noted for manners anyway :)]

         west
         down

The old chap might be interested in it, wouldn't he?

         show letter to receptionist

Bingo!

         get key

Now head straight for the gold.

         up
         up
         north

[again, you don't have to unlock and open the door if you have the right key.]

         x vase

Could it possibly be that this is what Simone's fountain-pen was meant for?

         put pen in vase

And enjoy the interlude. The last four chapters are a lot more hectic, with
more puzzles and stuff, and a different PC, Cassandra, who's one of Harold's
characters. You start off in.....

CHAPTER SEVEN: RECALLED FROM LIFE
=================================

You want to get home right now, so let's do just that......

         inventory
         north
         knock on door

Strange.

         open door
         north
         north

Stranger.

         east
         east

Any work to do, Cassie?

         south

G***some, isn't it? :) What you need is a good night's sleep, so......

         north
         sleep

Bummer. Well, let's change into something more comfortable. (Is this what
they mean by m*****s?)

         open wardrobe

In the words of Tintin comics, "EEEEEEEEEEEK!". Let's take a closer look:

         x corpse
         again
         search it

That cash card is your ticket to freedom; this place ain't safe anymore. Let's
leg it from here:

         south
         west
         west
         south
         south

You can go away now, so....

         east

Now let's use the fictitious Ms. Bradbury's card:

         put cash card in machine
         
It's a dramatic finale, perhaps inspired by my memories of writing BASIC
text adventures......but right now, on with the show:

CHAPTER EIGHT: WHERE THE SUN ALWAYS SHINES
==========================================

In the desert? Let's find our bearings:

         x sign
         read it

East sounds more promising.

         east
         east

Whee! A town. A ghost town, even. (The solution below is minimalist. Please
feel free to explore the newspaper archive, the shack, the kitchen, and
any other part of Charlestown.)

         x statue
         south
         examine black door

The same Sweeney as on the statue? Let's see. That cellar looks intriguing.

         down
         east
         east
         south
         x bulb
         north

Oh, dear. It looks like you're trapped. No problem, just.....

         smash bulb

......and see what you've uncovered.

         look
         get key

Now let's find the passage back to de place we were before, mon.

         north
         west
         west
         up
         north

That key unlocks the mansion further down the street.

         east
         south
         east
         x woman

Could Sweeney the mysterious have something to do with this?

         ask woman about Sweeney

R.I.P. Well, let's avenge the poor woman:

         get black key
         west
         north
         west
         south

That key unlocks Sweeney's door.

         east
         x sweeney
         x coffin
         ask sweeney about coffin
         read it

Remember your inventory at the beginning of Chapter Seven? Could Janus's
letter have a purpose?

         put love-letter in coffin

Die Sweeney! Well done, Cassandra, the hardest part is done; the last two
stages are a breeze, and I won't need to help you out here. For the
record, they are:

CHAPTER NINE: BIRTH OF A NOTION
===============================

This level is just a treasure hunt, so I can't give you much detail here.
You just need to find a cap, mask and gown, and enter ward 10. Make sure
to read those medical reports if you can find them! :)

The gown first....

         north. north. east
         get gown
         wear it

Then the mask....

         west. north. east
         get key
         west. south. south. east. up. north
         unlock locker with platinum key
         get mask
         wear mask

And finally the cap.

         south
         up
         north
         east
         get cap
         wear cap
         west
         x student

A cameo. I copied the idea from good old Hitchcock.

         north
         north

And that's it. Now get that adrenaline up, for the final chapter....

ENDGAME: IT TAKES A VILLAGE
===========================

Voices?

         listen. again. again

Not very interesting. What did Laura hand me there, anyway?

         inventory

This is like a boomerang, ain't it? Let's head out of the hut:

         west

Horrors! How g***some can this get?

         x troll
         troll, hello
         troll, go away

Well, they say the pen is mightier than the sword.

         kill troll with pen

And that's it. Enjoy the ending. Be sure to check out the list of AMUSING
options, and to go back as many times as possible to see if you're missing
out on something.

=============================================================================

About the game:
--------------

WHO:
---

"Halothane" was written, in its entirety - excepting the quotes from
Don Henley, Pearl Jam, William.F.Ganong and Agatha Christie - by Ravi
Philip Rajkumar (alias Quentin.D.Thompson.) No pieces of hardware except
a rather fragile power pack were harmed during the making of this game.

Programming, I'm afraid, was rather a different matter. I may be fairly
good at writing, but the last time I coded anything big was when I wrote
a cricket programme in QBASIC :-D, so most of the coding in this game
was done by Graham Nelson, L. Ross Raszewski and Jay Goemmer, and I just
filled in the blanks and wrote some corny routines here and there. So I
can't say, as Adam Cadre honestly can, that this was written and programmed
by myself.

[Translated, the above paragraph means that I've used the Inform library
and compiler, L. Ross Raszewski's Hints and Utilities header files, and
a patch for the hint system that Jay very kindly sent me a few months ago.
The actual coding, slipshod as it is, was done by the author.]

WHAT?:
-----

[The section below contains what might pedantically be considered "spoilers",
though I can't see how a game as low-puzzle as this can have spoilers. :)]

Exactly. What?

This is a slightly stoned game, I admit it - though no mind-expanding
substances were ingested by the author, either during its
production or at any other point in his life. (I have vague memories of
taking a few tabs of pheniramine here and there, but there's a whole lot
of difference between relieving one's stuffy nose and expanding one's mind.)

The philosophy behind _designing_ this game was simple; that behind _writing_ it
leaves me groping for words even now. While designing it, from a purely
"IF" point of view, I had a few clear objectives: to tell a story;
to try and integrate it into a perpetual-motion environment; to include
puzzles, but not to put them anywhere above beginner-to-intermediate level;
to create a game that the player could never make "unwinnable"; and, most
importantly, to create something enjoyable and entertaining. If I've succeeded
in at least one of these objectives, do let me know. The philosophy of
"no shut-outs" is not originally mine; its most famous exponent is
Mike.J.Roberts, the creator of TADS. (It's a little ironic that I'm using a
design system whose author's games shut me out time and again for forgetting
to pick up stuff or unlock doors every now and then, but that's life. :-D)

The writing, however, lacks cohesiveness, and that's because I chopped and
changed innumerable times before arriving at the final version that you're
playing now. I started planning Halothane as a non-stop, 100 per cent
parody, which just took a player character and threw him into a series
of weird, comical and satirical landscapes just for the heck of it. When
exactly I gave this game its underlying plot, I can't remember, but it can
be summarised thus:

           "Unsuccessful author tosses the manuscript of his second
           novel in the trash can, to be abandoned evermore, and is
           immediately abducted by his befuddled and/or irate
           characters, who have been thrown into chaos by his rash
           act, and made to undo the damage he's caused."

           (Cheezy, isn't it? - Ed.)

Of course, there are twists. The game's subtitle is one of them. I billed
this game as "An Interactive Restoration", which, on the surface, makes
sense....after all, the player character's objective is to restore the
balance of things in his own fictitious universe. But it can also be read
otherwise (I promise this occured to me only after I thought up the title;
I don't generally go in much for profundity); it's his characters who have
put the player character back on track; without their intervention, he might
have stopped writing, taken up a slightly more boring career (such as, as
Isaac Asimov would have it, the Presidency of the U.S. or surgery) and
led a life (as Adam Cadre put it) out of Human Resources Stories :)

Another twist occurred to me while I was playing Anchorhead (Michael
Gentry, take a bow.) My original intention was just a riff on the game,
a slightly eerie episode with the same player character, but I soon abandoned
that for an entirely new idea; in the first six chapters, the PC (in
the game, his name is Harold, and I'll just refer to him that way for
brevity's sake from now) has to overcome a series of (not too difficult)
obstacles before confronting the only two people in the parallel dimension
who have greater powers than him: one of them is the local version of
a God (but he's ersatz, purely a fictitious concept, and hence I refer to
him as the Little Tin God), and the other is just a personification of
all the authors whose works live there. After this, his talents are made
use of to create another fictitious character, who will complete the
actual quest without disrupting the separateness (or continuum, or whatever
highbrow term one wants to use) between the two dimensions. Thus, Chapters
One to Six of this game feature Harold, and Seven to Ten feature
Cassandra, his latest character. No points for guessing that Cassandra's
first adventure is heavily and semi-comically Gothic.

But all this sounds mind-bogglingly serious, and it isn't meant to be. It's
just _plot_, for Heaven's sake; it's a convoluted and involved fantasy
plot, but that doesn't mean the game is as complicated as its story. It's
a fairly even-paced game, with lots of detail, several Easter Eggs, a few
IF in-jokes and riffs here and there, and simple puzzles. 

Having said this, I'm still not sure if I'm immune to allegations (my word)
of symbolism and the like. Trust me, there is nothing symbolic in this
game. (There was, but I've pruned it out.) The long tale in Chapter Six,
for example, is not a sort of nostalgic episode, but just a take on the
long, semi-supernatural stories that people in Dickens' "Pickwick Papers"
take turns telling each other. The troll in Chapter Ten doesn't symbolise
Evil (TM), or The End Of The Innocence (R), or even Human Resources
Stories (Copyright 1998, Harry.M.Hardjono), but is just a Zork riff. 
Sweeney in Chapter Eight is just a corny arch-villain (and not a satire
of Jack Canfield _or_ Marshall Appleton, or anyone else) but I will concede
that this whole stage does make fun of New Age a great deal. 

If this game has any message, it's this: it's all too easy to take oneself
(or one's works and concepts) seriously, but taking them a little more
lightly brings us down to earth. The pen is mightier than the
sword (ask the troll) but humour can score over both of them most of the
time. 

WHY?:
-----
(following the lead given by Adam J. Thornton, author of my second favourite
parody game, "In The End 2"....)

THE ARTISTIC REASONS:

1. I sort of had a feeling that there would be at least ten experimental
   games and one Rybread game this year, and wanted to make sure there
   was at least _one_ straight game :)
2. While attracted to the simple-puzzles concept of Photopia, I didn't
   want people to say that they could breeze through this game by
   typing 'z' and pressing Enter repeatedly...
3. Games with women as player characters are so scarce I thought I'd
   put a spin on it, and have both male and female PCs in the same
   game.
4. I wanted to see if it was possible to commit all the nine Crimes
   Against Mimesis in the same game, while not writing an Andy Philips clone.
5. I kind of liked the idea of optional puzzles, though this game isn't
   a patch on Varicella.

THE REAL REASONS:

1. Bad attack of writer's block following the rough draft of my first novel;
   if I couldn't write fiction, it had to be IF.
2. I was tired of seeing Inform 6.15 sleeping in its directory.
3. Having actually learnt how to write Inform without obtaining 97 compile
   errors per compile, I couldn't stay still.
4. None of my other game ideas were working out. They were (for the record):

   "Time Traveller", a parody of historical novels.
   "Tuxedos and Sarongs", a family feud/culture-shock sitcom, with a stuffed
    animal as PC and deus ex machina. (No points for guessing what game
    made me give up on this idea.)
   "Over My Counter", a riff on Arthur Hailey's novel "Strong Medicine".
   "A Summer Romance" (originally titled "Amuse"), an NPC-intensive,
    Wizard-of-Oz meets Kurt Vonnegut, puzzle-heavy adventure. A few ideas
    from here ended up in Halothane, but not too many.

5. It being the summer holidays, I had lots of free time.

WHERE?:
------

The entire game, except for the first scene, takes place in a partially
unshaped parallel dimension, which explains why the settings are so surreal.

HOW?:
----

HARDWARE
--------
1. One slightly dated PC486/100MHz, which scores around 2.3 using Norton
   Benchmark, with a 1.2GB hard disk, a malfunctioning CD-ROM drive and
   a rather creaky mouse (The keyboard's fine, though.)
2. One malfunctioning voltage stabilizer, trashed halfway through the
   filming :)
3. One dysfunctional ceiling fan.
4. A tower fan, which is a sort of poor man's air-conditioner. (And that's
   an understatement.)
5. Ink and paper from various sources.

SOFTWARE
--------
1. Inform version 6.15, library version 8.
2. Library extensions by Ross Raszewski and Jay Goemmer.
3. MS-DOS version 7, MS-DOS Editor 2.0.026.
4. No Windows was used in the making of this game.

BIBLIOGRAPHY
------------

1. The complete Pearl Jam album collection, Sony Music.
2. "The End of The Innocence", Don Henley, Geffen.
3. "The Unforgettable Fire", U2, Island.
4. "Breakfast of Champions", Kurt Vonnegut. [Probably the book that started
   me thinking on the author-character equation, but Kurt's not to be held
   responsible for any harm arising from this game :)]
5. An untitled manuscript by yours truly. No publication date fixed.
6. "Marguerite du Valois", Alexandre Dumas. [This is a great book. No kidding.
   A more complete IFication of this book, and "The Three Musketeers", is
   in the works. See Future Projects, below.]
7. "The Life and Times of $crooge McDuck", Keno Don Rosa.
   (which I read, irony of ironies, in French translation.)

RIFF-O-GRAPHY
-------------
GAGS (Generic Adventure Game System), Softworks.
TADS (Text Adventure Development System), Mike.J.Roberts.
Curses, Graham Nelson.
Spider & Web, Andrew Plotkin.
Muse, Christopher Huang. 
Zork I, Infocom/Activision/whoever it might concern.
Babel, Ian Finley.

IRRITANTS
---------
My ISP, VSNL.
The local Electricity Board.
The weather (And changes in it).
Kattula Dheeraj, self-professed junior preacher, who's firmly convinced that
I will burn in hell for writing computer games and visiting a den of
iniquity called the (shock) Internet :)
=============================================================================

Further releases:
----------------

I've got several Inform projects lined up; at least one of them should hit
freeware stores (read: ftp.gmd.de and its mirrors) by next year, and -
for better or worse - I'll try to push for two. For the record, and so you
can be warned in advance, the games I have in development now are:

Lottery, An Interactive MiSTing
-------------------------------
This is another of those crazy MST games where I have Tom, Crow and the
gang heckle a pretty lame GAGS game by E.V.Cheney. Have a laugh.

CyberCraig: The Case of the Wide-Open Beavers
---------------------------------------------
(An Interactive Action Movie)

This is actually two games in one: the story (which is set in a world of
intelligent animals, humans excluded) is dated 3,000 years in the future,
and you - I mean CyberCraig, Paw Officer Second Class, the greenest
koala bear on old Weller's crime-enforcement panel - are sent to the
bovine planet of Lavache to clear up a series of apparently senseless
killings among the minority beaver population. From this point, based on
the choices you make, the game either becomes a classic detective game
(along the lines of, say, Guilty Bastards) or a historical adventure, along
the lines of Alexandre Dumas. It sounds like a game full of political and
sociological points, but it isn't. It's an action movie in design and
conception, full of absurdly laughable situations. This will probably
end up a .z8 file.

The French Resolution, An Interactive Authorial Responsibility(!)
-----------------------------------------------------------------

[NOTE: Further development of this game depends solely on the response
       to Halothane, as this is set in the same universe; so, if you don't
       want this game to see the light of ftp.gmd.de, just troll
       Halothane as much as you want, give it 3 or less out of 10, etc.,
       etc. :-D]

Set twenty years after Halothane, this game has Harold, in the role of
successful author, writing a book with a lot of untied loose ends. Naturally,
his friends on the other side aren't pleased, and issue him an ultimatum:
come back and clear up the mess you made, or else...:-) If this goes right,
you can choose which of Harold's six characters you play in this game,
and try and set the lives of the other five on course.
-----------------------------------------------------------------------------

Thanks for playing Halothane!
-- Quentin.D.Thompson
