/*
 * Decompiled with CFR 0.152.
 */
package acm.io;

import acm.io.CharacterQueue;
import acm.io.IOConsole;
import acm.program.Program;
import acm.program.ProgramMenuBar;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

class ConsoleModel
implements KeyListener,
FocusListener {
    public static final int OUTPUT_STYLE = 0;
    public static final int INPUT_STYLE = 1;
    public static final int ERROR_STYLE = 2;
    private BufferedReader inputScript;
    private CharacterQueue buffer;
    private SimpleAttributeSet outputAttributes;
    private SimpleAttributeSet inputAttributes;
    private SimpleAttributeSet errorAttributes;
    private JScrollPane scrollPane = new JScrollPane(22, 32);
    private JTextPane textPane = new JTextPane();
    private Document document;
    private String lineSeparator;
    private int base;
    private boolean hasFocus;
    private IOConsole console;
    private Object inputLock;
    private Object outputLock;

    public ConsoleModel() {
        this.textPane.addKeyListener(this);
        this.textPane.addFocusListener(this);
        this.scrollPane.setViewportView(this.textPane);
        this.document = this.textPane.getDocument();
        this.lineSeparator = System.getProperty("line.separator");
        this.outputAttributes = new SimpleAttributeSet();
        this.inputAttributes = new SimpleAttributeSet();
        this.errorAttributes = new SimpleAttributeSet();
        this.buffer = new CharacterQueue();
        this.inputLock = new Object();
        this.outputLock = new Object();
        this.base = 0;
    }

    public void setConsole(IOConsole owner) {
        this.console = owner;
    }

    public IOConsole getConsole() {
        return this.console;
    }

    public void print(String str, int style) {
        Object object = this.outputLock;
        synchronized (object) {
            this.insert(str, this.base, style);
            this.base += str.length();
            this.setCaretPosition(this.base);
        }
    }

    public String readLine() {
        Object object = this.inputLock;
        synchronized (object) {
            char ch;
            this.base = this.getLength();
            if (this.inputScript != null) {
                String line = null;
                try {
                    line = this.inputScript.readLine();
                }
                catch (IOException ex) {
                    throw new ErrorException(ex);
                }
                if (line != null) {
                    this.insert(line, this.base, 1);
                    this.insert("\n", this.base + line.length(), 0);
                    this.base += line.length() + 1;
                    return line;
                }
                try {
                    this.inputScript.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this.inputScript = null;
            }
            this.setCaretPosition(this.base);
            while ((ch = this.buffer.dequeue()) != '\n' && ch != '\r') {
                if (this.getCaretPosition() < this.base) {
                    this.setCaretPosition(this.getLength());
                }
                int dot = this.getSelectionStart();
                switch (ch) {
                    case '\b': 
                    case '\u007f': {
                        if (dot == this.getSelectionEnd()) {
                            if (dot <= this.base) break;
                            this.delete(dot - 1, dot);
                            --dot;
                            break;
                        }
                        dot = this.deleteSelection();
                        break;
                    }
                    case '\u0001': {
                        this.selectAll();
                        dot = -1;
                        break;
                    }
                    case '\u0002': {
                        dot = Math.max(this.getSelectionStart() - 1, this.base);
                        break;
                    }
                    case '\u0003': {
                        this.copy();
                        dot = -1;
                        break;
                    }
                    case '\u0006': {
                        dot = Math.min(this.getSelectionEnd() + 1, this.getLength());
                        break;
                    }
                    case '\u0010': {
                        this.console.printConsole();
                        dot = -1;
                        break;
                    }
                    case '\u0013': {
                        this.console.save();
                        dot = -1;
                        break;
                    }
                    case '\u0016': {
                        this.paste();
                        dot = -1;
                        break;
                    }
                    case '\u0018': {
                        this.cut();
                        dot = -1;
                        break;
                    }
                    default: {
                        if (dot != this.getSelectionEnd()) {
                            dot = this.deleteSelection();
                        }
                        this.insert("" + ch, dot, 1);
                        ++dot;
                    }
                }
                if (dot == -1) continue;
                this.select(dot, dot);
                this.setCaretPosition(dot);
            }
            int len = this.getLength() - this.base;
            String line = this.getText(this.base, this.base + len);
            this.insert("\n", this.base + len, 0);
            this.base += len + 1;
            return line;
        }
    }

    public void setInputScript(BufferedReader rd) {
        this.inputScript = rd;
        if (this.buffer.isWaiting()) {
            try {
                String line = this.inputScript.readLine();
                this.buffer.enqueue(String.valueOf(line) + "\n");
            }
            catch (IOException ex) {
                throw new ErrorException(ex);
            }
        }
    }

    public BufferedReader getInputScript() {
        return this.inputScript;
    }

    public boolean isCommandEnabled(String cmd) {
        if (cmd == cmd) {
            // empty if block
        }
        return this.hasFocus;
    }

    public void clear() {
        this.textPane.setText("");
    }

    public String getText() {
        return this.textPane.getText();
    }

    public String getText(int start, int end) {
        try {
            return this.document.getText(start, end - start);
        }
        catch (BadLocationException ex) {
            throw new ErrorException(ex);
        }
    }

    public int getLength() {
        return this.document.getLength();
    }

    public Component getConsolePane() {
        return this.scrollPane;
    }

    public Component getTextPane() {
        return this.textPane;
    }

    public void cut() {
        this.copy();
        this.deleteSelection();
    }

    public void copy() {
        this.textPane.copy();
    }

    public void paste() {
        if (this.textPane.getSelectionEnd() != this.document.getLength()) {
            return;
        }
        int start = this.deleteSelection();
        this.textPane.setSelectionStart(start);
        this.textPane.paste();
        this.textPane.select(this.document.getLength(), this.document.getLength());
        if (this.document instanceof DefaultStyledDocument) {
            DefaultStyledDocument doc = (DefaultStyledDocument)this.document;
            doc.setCharacterAttributes(start, this.textPane.getSelectionEnd() - start, this.inputAttributes, true);
        }
    }

    public void selectAll() {
        this.textPane.selectAll();
    }

    public boolean isPointSelection() {
        return this.textPane.getSelectionStart() == this.textPane.getSelectionEnd();
    }

    public void print(PrintJob pj) {
        String text = this.getText();
        Dimension pageSize = pj.getPageDimension();
        Graphics g = pj.getGraphics();
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight();
        int linesPerPage = pageSize.height / fontHeight;
        int nLines = this.countLines(text);
        int nPages = 1 + (nLines - 1) / linesPerPage;
        int top = 0;
        int page = 1;
        while (page <= nPages) {
            if (page > 1) {
                g = pj.getGraphics();
            }
            int bottom = this.getLineY(text, 1 + page * linesPerPage);
            g.translate(0, -top);
            g.setClip(0, top, pageSize.width, bottom - top);
            this.textPane.paint(g);
            g.dispose();
            top = bottom;
            ++page;
        }
    }

    public void setInputStyle(int style) {
        if (this.getLength() != 0) {
            throw new ErrorException("Console styles and colors cannot be changed after I/O has started.");
        }
        this.inputAttributes.addAttribute(StyleConstants.Bold, new Boolean((style & 1) != 0));
        this.inputAttributes.addAttribute(StyleConstants.Italic, new Boolean((style & 2) != 0));
    }

    public void setInputColor(Color color) {
        if (this.getLength() != 0) {
            throw new ErrorException("Console styles and colors cannot be changed after I/O has started.");
        }
        this.inputAttributes.addAttribute(StyleConstants.Foreground, color);
    }

    public void setErrorStyle(int style) {
        if (this.getLength() != 0) {
            throw new ErrorException("Console styles and colors cannot be changed after I/O has started.");
        }
        this.errorAttributes.addAttribute(StyleConstants.Bold, new Boolean((style & 1) != 0));
        this.errorAttributes.addAttribute(StyleConstants.Italic, new Boolean((style & 2) != 0));
    }

    public void setErrorColor(Color color) {
        if (this.getLength() != 0) {
            throw new ErrorException("Console styles and colors cannot be changed after I/O has started.");
        }
        this.errorAttributes.addAttribute(StyleConstants.Foreground, color);
    }

    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
        ProgramMenuBar mbar = this.findMenuBar();
        if (mbar != null) {
            mbar.setConsole(this.console);
            mbar.update();
        }
    }

    public void focusLost(FocusEvent e) {
        this.hasFocus = false;
    }

    public void keyTyped(KeyEvent e) {
        this.buffer.enqueue(e.getKeyChar());
        e.consume();
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 37: {
                this.buffer.enqueue('\u0002');
                break;
            }
            case 39: {
                this.buffer.enqueue('\u0006');
            }
        }
        e.consume();
    }

    public void keyReleased(KeyEvent e) {
        e.consume();
    }

    public void requestFocus() {
        if (this.textPane != null) {
            this.textPane.requestFocus();
        }
    }

    private void insert(String str, int dot, int style) {
        try {
            SimpleAttributeSet attributes = this.outputAttributes;
            switch (style) {
                case 1: {
                    attributes = this.inputAttributes;
                    break;
                }
                case 2: {
                    attributes = this.errorAttributes;
                }
            }
            this.document.insertString(dot, str, attributes);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void delete(int p1, int p2) {
        try {
            this.document.remove(p1, p2 - p1);
        }
        catch (BadLocationException ex) {
            throw new ErrorException(ex);
        }
    }

    private void setCaretPosition(int pos) {
        this.textPane.setCaretPosition(pos);
    }

    private int getCaretPosition() {
        return this.textPane.getCaretPosition();
    }

    private void select(int p1, int p2) {
        this.textPane.select(p1, p2);
    }

    private int getSelectionStart() {
        return this.textPane.getSelectionStart();
    }

    private int getSelectionEnd() {
        return this.textPane.getSelectionEnd();
    }

    private int deleteSelection() {
        int start = Math.max(this.base, this.getSelectionStart());
        int end = this.getSelectionEnd();
        if (end <= this.base) {
            return this.getLength();
        }
        this.delete(start, end);
        return start;
    }

    private int countLines(String text) {
        int count = 0;
        int pos = -1;
        while ((pos = text.indexOf(this.lineSeparator, pos + 1)) != -1) {
            ++count;
        }
        if (!text.endsWith(this.lineSeparator)) {
            ++count;
        }
        return count;
    }

    private int getLineY(String text, int lineNumber) {
        if (text.length() == 0) {
            return 0;
        }
        int pos = 0;
        try {
            int i = 1;
            while (i < lineNumber) {
                int eol = text.indexOf(this.lineSeparator, pos);
                if (eol == -1) {
                    Rectangle bounds = this.textPane.modelToView(pos);
                    return bounds.y + bounds.height;
                }
                pos = eol + this.lineSeparator.length();
                ++i;
            }
            return this.textPane.modelToView((int)pos).y;
        }
        catch (Exception ex) {
            throw new ErrorException("Internal error: " + ex);
        }
    }

    private ProgramMenuBar findMenuBar() {
        Container comp = this.console;
        while (comp != null) {
            if (comp instanceof Program) {
                return ((Program)comp).getMenuBar();
            }
            if (comp instanceof JFrame) {
                JMenuBar mbar = ((JFrame)comp).getJMenuBar();
                return mbar instanceof ProgramMenuBar ? (ProgramMenuBar)mbar : null;
            }
            comp = comp.getParent();
        }
        return null;
    }
}

