/*
 * Decompiled with CFR 0.152.
 */
package acm.gui;

import acm.io.IODialog;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Dimension;
import java.text.DecimalFormat;
import javax.swing.JTextField;

public class IntField
extends JTextField {
    private static final int PREFERRED_WIDTH = 60;
    private boolean exceptionOnError;
    private int minValue;
    private int maxValue;
    private String formatString;
    private DecimalFormat formatter;
    private IODialog dialog;

    public IntField() {
        this("", Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntField(int value) {
        this("" + value, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntField(int low, int high) {
        this("", low, high);
    }

    public IntField(int value, int low, int high) {
        this("" + value, low, high);
    }

    private IntField(String str, int low, int high) {
        this.setBackground(Color.white);
        this.setHorizontalAlignment(4);
        this.minValue = low;
        this.maxValue = high;
        this.setText(str);
        this.exceptionOnError = false;
    }

    public int getValue() {
        int value;
        block7: {
            String text = this.getText();
            String msg = null;
            value = 0;
            try {
                value = Integer.parseInt(text.trim());
                if (value >= this.minValue && value <= this.maxValue) break block7;
                msg = "Value is outside the specified range";
            }
            catch (NumberFormatException ex) {
                msg = "Illegal integer format";
            }
            if (this.exceptionOnError) {
                throw new ErrorException(msg);
            }
            String prompt = "Enter an integer";
            if (this.minValue != Integer.MIN_VALUE) {
                prompt = this.maxValue != Integer.MAX_VALUE ? String.valueOf(prompt) + " between " + this.minValue + " and " + this.maxValue : String.valueOf(prompt) + " greater than " + this.minValue;
            } else if (this.maxValue != Integer.MAX_VALUE) {
                prompt = String.valueOf(prompt) + " less than " + this.maxValue;
            }
            if (this.dialog == null) {
                this.dialog = new IODialog(this);
            }
            value = this.dialog.readInt(prompt, this.minValue, this.maxValue);
        }
        this.setValue(value);
        return value;
    }

    public void setValue(int n) {
        String str = "" + n;
        if (this.formatter != null) {
            str = this.formatter.format(n);
        }
        this.setText(str);
    }

    public String getFormat() {
        return this.formatString;
    }

    public void setFormat(String format) {
        this.formatString = format;
        this.formatter = format == null ? null : new DecimalFormat(format);
        try {
            this.setValue(Integer.parseInt(this.getText().trim()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setExceptionOnError(boolean flag) {
        this.exceptionOnError = flag;
    }

    public boolean getExceptionOnError() {
        return this.exceptionOnError;
    }

    public Dimension getPreferredSize() {
        return new Dimension(60, super.getPreferredSize().height);
    }
}

