/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GDimension;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GRectangle;
import acm.graphics.GResizable;
import acm.graphics.GScalable;
import acm.util.MediaTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class GImage
extends GObject
implements GResizable,
GScalable {
    private Image myImage;
    private double myWidth;
    private double myHeight;
    private boolean sizeDetermined;

    public GImage(Image image) {
        this(image, 0.0, 0.0);
    }

    public GImage(String name) {
        this(name, 0.0, 0.0);
    }

    public GImage(Image image, double x, double y) {
        this.setImage(image);
        this.setLocation(x, y);
    }

    public GImage(String name, double x, double y) {
        this(MediaTools.loadImage(name), x, y);
    }

    public void setImage(Image image) {
        this.myImage = MediaTools.loadImage(image);
        this.determineSize();
    }

    public void setImage(String name) {
        this.setImage(MediaTools.loadImage(name));
    }

    public Image getImage() {
        return this.myImage;
    }

    public void paint(Graphics g) {
        Component imageObserver = this.getComponent();
        if (this.myImage != null && imageObserver != null) {
            Rectangle r = this.getAWTBounds();
            Color color = this.getObjectColor();
            if (color == null) {
                g.drawImage(this.myImage, r.x, r.y, r.width, r.height, imageObserver);
            } else {
                g.drawImage(this.myImage, r.x, r.y, r.width, r.height, color, imageObserver);
            }
        }
    }

    public void setSize(double width, double height) {
        this.myWidth = width;
        this.myHeight = height;
        this.repaint();
    }

    public final void setSize(GDimension size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    public GDimension getSize() {
        return new GDimension(this.myWidth, this.myHeight);
    }

    public void setBounds(double x, double y, double width, double height) {
        this.myWidth = width;
        this.myHeight = height;
        this.setLocation(x, y);
    }

    public final void setBounds(GRectangle bounds) {
        this.setBounds(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    public GRectangle getBounds() {
        this.determineSize();
        return new GRectangle(this.getX(), this.getY(), this.myWidth, this.myHeight);
    }

    public void scale(double sx, double sy) {
        this.myWidth *= sx;
        this.myHeight *= sy;
        this.repaint();
    }

    public final void scale(double sf) {
        this.scale(sf, sf);
    }

    protected Rectangle getAWTBounds() {
        this.determineSize();
        return new Rectangle(GMath.round(this.getX()), GMath.round(this.getY()), GMath.round(this.myWidth), GMath.round(this.myHeight));
    }

    private void determineSize() {
        if (this.sizeDetermined) {
            return;
        }
        Component component = this.getComponent();
        if (component == null) {
            component = MediaTools.getImageObserver();
        }
        this.myWidth = this.myImage.getWidth(component);
        this.myHeight = this.myImage.getHeight(component);
        this.sizeDetermined = true;
    }
}

