/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GArc;
import acm.graphics.GFillable;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRoundRect;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;

class ArcRenderer {
    private GObject target;
    private Polygon poly;
    private Rectangle oldBounds;
    private double oldStart;
    private double oldSweep;
    private boolean cacheValid;

    public ArcRenderer(GObject gobj) {
        this.target = gobj;
        this.poly = new Polygon();
        this.cacheValid = false;
    }

    public void draw(Graphics g) {
        this.validateCache();
        if (((GFillable)((Object)this.target)).isFilled()) {
            g.setColor(((GFillable)((Object)this.target)).getFillColor());
            g.fillPolygon(this.poly.xpoints, this.poly.ypoints, this.poly.npoints);
            g.setColor(this.target.getColor());
            g.drawPolygon(this.poly.xpoints, this.poly.ypoints, this.poly.npoints);
        } else if (this.target instanceof GArc) {
            g.drawPolyline(this.poly.xpoints, this.poly.ypoints, this.poly.npoints - 1);
        } else {
            g.drawPolygon(this.poly.xpoints, this.poly.ypoints, this.poly.npoints);
        }
    }

    private void validateCache() {
        GRoundRect rr;
        Rectangle bounds = null;
        double start = 0.0;
        double sweep = 360.0;
        if (this.target instanceof GOval) {
            bounds = ((GOval)this.target).getAWTBounds();
        } else if (this.target instanceof GRoundRect) {
            rr = (GRoundRect)this.target;
            bounds = rr.getAWTBounds();
        } else {
            GArc arc = (GArc)this.target;
            bounds = arc.getAWTBounds();
            start = arc.getStartAngle();
            sweep = arc.getSweepAngle();
            if (start != this.oldStart || sweep != this.oldSweep) {
                this.cacheValid = false;
            }
        }
        if (bounds == null || bounds.width <= 0 || bounds.height <= 0) {
            return;
        }
        if (!this.cacheValid || bounds.width != this.oldBounds.width || bounds.height != this.oldBounds.height) {
            this.poly.npoints = 0;
            if (this.target instanceof GRoundRect) {
                rr = (GRoundRect)this.target;
                int arcWidth = GMath.round(rr.getArcWidth());
                int arcHeight = GMath.round(rr.getArcHeight());
                this.poly.addPoint(bounds.x + arcWidth / 2, bounds.y);
                Rectangle aRect = new Rectangle(bounds.x, bounds.y, arcWidth, arcHeight);
                this.addArc(aRect, 90.0, 90.0);
                aRect.y = bounds.y + bounds.height - arcHeight;
                this.addArc(aRect, 180.0, 90.0);
                aRect.x = bounds.x + bounds.width - arcWidth;
                this.addArc(aRect, 270.0, 90.0);
                aRect.y = bounds.y;
                this.addArc(aRect, 0.0, 90.0);
            } else {
                this.addArc(bounds, start, sweep);
                if (this.target instanceof GArc) {
                    this.poly.addPoint(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
                    this.oldStart = start;
                    this.oldSweep = sweep;
                }
            }
            this.oldBounds = bounds;
        }
        if (bounds.x != this.oldBounds.x || bounds.y != this.oldBounds.y) {
            this.poly.translate(bounds.x - this.oldBounds.x, bounds.y - this.oldBounds.y);
            this.oldBounds = bounds;
        }
        this.cacheValid = true;
    }

    private void addArc(Rectangle bounds, double start, double sweep) {
        double aspectRatio = (double)bounds.height / (double)bounds.width;
        double rx = (double)bounds.width / 2.0;
        double ry = (double)bounds.height / 2.0;
        double x0 = (double)bounds.x + rx;
        double y0 = (double)bounds.y + ry;
        if (sweep < 0.0) {
            start += sweep;
            sweep = -sweep;
        }
        if (sweep > 359.99) {
            sweep = 360.0;
        }
        double dt = Math.atan2(1.0, Math.max(bounds.width, bounds.height));
        int nSteps = (int)(GMath.toRadians(sweep) / dt);
        dt = GMath.toRadians(sweep) / (double)nSteps;
        double theta = GMath.toRadians(start);
        int i = 0;
        while (i <= nSteps) {
            double x = x0 + rx * Math.cos(theta);
            double y = y0 - rx * Math.sin(theta) * aspectRatio;
            this.poly.addPoint(GMath.round(x), GMath.round(y));
            theta += dt;
            ++i;
        }
    }
}

