/* 
 * Mach Operating System
 * Copyright (c) 1992 Carnegie Mellon University
 * Copyright (c) 1992 Helsinki University of Technology
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON AND HELSINKI UNIVERSITY OF TECHNOLOGY ALLOW FREE USE
 * OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  CARNEGIE MELLON AND
 * HELSINKI UNIVERSITY OF TECHNOLOGY DISCLAIM ANY LIABILITY OF ANY KIND
 * FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon 
 * the rights to redistribute these changes.
 */
/*
 * HISTORY
 * 11-May-92  Johannes Helander (jvh) at Helsinki University of Technology
 *	Created.
 *
 * $Log:$
 */
/*
 *	Defines for the DP 8490 (SCSI chip), (almost NCR 5380)
 */

/*
 * Register map
 */

typedef struct {
   volatile u_char sdp_data;    	/* 0 CSD r:  Current data */
#define            sdp_odata sdp_data 	/* 0 ODR w:  Out data */
   volatile u_char sdp_icmd;    	/* 1 ICR rw: Initiator command */
   volatile u_char sdp_mode;    	/* 2 MR2 rw: Mode */
   volatile u_char sdp_tcmd;    	/* 3 TCR rw: Target command */
   volatile u_char sdp_bus_csr; 	/* 4 CSB r:  Bus Status */
#define         sdp_sel_enb sdp_bus_csr	/* 4 SER w:  Select enable */
   volatile u_char sdp_csr;     	/* 5 BSR r:  Status */
#define            sdp_dma_send sdp_csr /* 5 SDS w:  Start dma send data */
   volatile u_char sdp_idata;   	/* 6 IDR r:  Input data */
#define            sdp_trecv sdp_idata 	/* 6 SDR w:  Start dma rec target */
   volatile u_char sdp_emr;	   	/* 7 EMR rw: dp8490 enhanced mode reg */
#define 	   sdp_istatus sdp_emr	/* 7 ISR r:  Interrupt status */
#define 	   sdp_imask sdp_emr	/* 7 IMR w:  Interrupt mask */	
} sdp_regmap_t;


/*
 * ICR(1) Initiator command register
 */

#define SDP_ICMD_DATA		0x01		/* rw: Assert data bus   */
#define SDP_ICMD_ATN		0x02		/* rw: Assert ATN signal */
#define SDP_ICMD_SEL		0x04		/* rw: Assert SEL signal */
#define SDP_ICMD_BSY		0x08		/* rw: Assert BSY signal */
#define SDP_ICMD_ACK		0x10		/* rw: Assert ACK signal */
#define SDP_ICMD_LST		0x20		/* r:  Lost arbitration */
#define SDP_ICMD_DIFF	SDP_ICMD_LST		/* w:  Differential cable */
#define SDP_ICMD_AIP		0x40		/* r:  Arbitrat. in progress */
#define SDP_ICMD_ENHANCED SDP_ICMD_AIP 		/* w:  Enhaced/Normal mode */
#define SDP_ICMD_RST		0x80		/* rw: Assert RST signal */


/*
 * MR2(2) Mode register
 */

#define SDP_MODE_ARB		0x01		/* rw: Start arbitration */
#define SDP_MODE_DMA		0x02		/* rw: Enable DMA xfers */
#define SDP_MODE_MONBSY		0x04		/* rw: Monitor BSY signal */
#define SDP_MODE_DMA_IE		0x08		/* rw: Enable DMA complete interrupt */
#define SDP_MODE_PERR_IE	0x10		/* rw: Interrupt on parity errors */
#define SDP_MODE_PAR_CHK	0x20		/* rw: Check parity */
#define SDP_MODE_TARGET		0x40		/* rw: Target mode (Initiator if 0) */
#define SDP_MODE_BLOCKDMA	0x80		/* rw: Block-mode DMA handshake (MBZ) */


/*
 * TCR(3) Target command register
 */

#define SDP_TCMD_IO		0x01		/* rw: Assert I/O signal */
#define SDP_TCMD_CD		0x02		/* rw: Assert C/D signal */
#define SDP_TCMD_MSG		0x04		/* rw: Assert MSG signal */
#define SDP_TCMD_PHASE_MASK	0x07		/* r:  Mask for current bus phase */
#define SDP_TCMD_REQ		0x08		/* rw: Assert REQ signal */
#define	SDP_TCMD_LAST_SENT	0x80		/* ro: Last byte was xferred
						 *     (not on 5380/1) EDMA */

#define	SDP_PHASE(x)		SCSI_PHASE(x)

/*
 * CSB(4) Current (SCSI) Bus status
 */

#define SDP_BUS_DBP		0x01		/* r:  Data Bus parity */
#define SDP_BUS_SEL		0x02		/* r:  SEL signal */
#define SDP_BUS_IO		0x04		/* r:  I/O signal */
#define SDP_BUS_CD		0x08		/* r:  C/D signal */
#define SDP_BUS_MSG		0x10		/* r:  MSG signal */
#define SDP_BUS_REQ		0x20		/* r:  REQ signal */
#define SDP_BUS_BSY		0x40		/* r:  BSY signal */
#define SDP_BUS_RST		0x80		/* r:  RST signal */

#define	SDP_CUR_PHASE(x)	SCSI_PHASE((x)>>2)
#define SDP_PHASE_MASK (SDP_BUS_IO | SDP_BUS_CD | SDP_BUS_MSG)
#define SDP_CSR_PHASE(x) ((x) << 2 & SDP_PHASE_MASK)

/*
 * BSR(5) Bus and Status register
 */

#define SDP_CSR_ACK		0x01		/* r:  ACK signal */
#define SDP_CSR_ATN		0x02		/* r:  ATN signal */
#define SDP_CSR_DISC		0x04		/* r:  Disconnected (BSY==0) */
#define SDP_CSR_PHASE_MATCH	0x08		/* r:  Bus and SDP_TCMD match*/
#define SDP_CSR_INT		0x10		/* r:  Interrupt request */
#define SDP_CSR_PERR		0x20		/* r:  Parity error */
#define SDP_CSR_DREQ		0x40		/* r:  DMA request */
#define SDP_CSR_DONE		0x80		/* r:  DMA count is zero */

/*
 * EMR(7) Enhanced Mode Register
 */

#define SDP_EMR_ARB		0x01	/* (r)w:  extended arbitration */
#define SDP_EMR_FN_MASK		0x06	/* w: bits 1,2 encode function */
#define SDP_EMR_FN_NOP		0x00	/* no function */
#define SDP_EMR_FN_RPI		0x02	/* reset parity and interrupt latches*/
#define SDP_EMR_FN_SDI		0x04	/* start DMA receive, initiator */
#define SDP_EMR_FN_INT		0x06	/* next read/write of reg 7 (normally
					 * EMR) will access ISR/IMR */
#define SDP_EMR_LOOP		0x08	/* (r)w: loop back mode */
#define SDP_EMR_SPOL		0x10	/* Parity polarity. 0=odd, 1=even */
#define SDP_EMR_MPOL		0x20	/* cpu parity, ???. 0=odd */
#define SDP_EMR_MPEN		0x40	/* cpu bus parity checking */
#define SDP_EMR_PHASE_CHECK	0x80	/* Interrupt on phase mismatch */

/*
 * ISR(7) / IMR(7)
 */
#define SDP_INT_ARB		0x01	/* arbitration complete */
#define SDP_INT_SEL		0x02	/* selection/reselection */
#define SDP_INT_BSY		0x04	/* Busy loss */
#define SDP_INT_PHASE		0x08	/* any phase mismatch */
#define SDP_INT_DMA_PHASE	0x10	/* DMA phase mismatch */
#define SDP_INT_EDMA		0x20	/* end of DMA */
#define SDP_INT_MPE		0x40	/* CPU bus parity error */
#define SDP_INT_PARITY		0x80	/* SCSI bus parity error */
