/*
** This file is part of the alternative 80386 math library and is
** covered by the GNU General Public license with my modification
** as noted in the README file that accompanied this file.
**
** Copyright 1990 G. Geers
**
*/

	.align 4
.globl _max_normalf

_max_normalf:
	pushl %ebp
	movl %esp,%ebp
	subl $8, %esp

	movl $0x7f7fffff, -8(%ebp)

	flds -8(%ebp)
	
	leave
	ret

	.align 4
.globl _min_normalf

_min_normalf:
	pushl %ebp
	movl %esp,%ebp
	subl $8, %esp

	movl $0x00800001, -8(%ebp)

	flds -8(%ebp)
	
	leave
	ret

	.align 4
.globl _min_subnormalf

_min_subnormalf:
	pushl %ebp
	movl %esp,%ebp
	subl $8, %esp

	movl $0x00000001, -8(%ebp)

	flds -8(%ebp)
	
	leave
	ret

	.align 4
.globl _max_subnormalf

_max_subnormalf:
	pushl %ebp
	movl %esp,%ebp
	subl $8, %esp

	movl $0x007fffff, -8(%ebp)

	flds -8(%ebp)
	
	leave
	ret

	.align 4
.globl _quiet_nanf

_quiet_nanf:
	pushl %ebp
	movl %esp,%ebp
	subl $8, %esp

	movl $0x7fffffff, -8(%ebp)

	flds -8(%ebp)
	
	leave
	ret

	.align 4
.globl _signaling_nanf

_signaling_nanf:
	pushl %ebp
	movl %esp,%ebp
	subl $8, %esp

	movl $0x7f800001, -8(%ebp)

	fldl -8(%ebp)
	
	leave
	ret
