/*
** This file is part of the alternative 80386 math library and is
** covered by the GNU General Public license with my modification
** as noted in the README file that accompanied this file.
**
** Copyright 1990 G. Geers
**
*/

	.align 4
.globl _isnanf
_isnanf:
	pushl %ebp
	movl %esp,%ebp

	movl 8(%ebp), %eax
	andl $0x7f800000, %eax
	cmpl $0x7f800000, %eax
	jne .Lnotnan
	movl 8(%ebp), %eax
	andl $0x7ffff, %eax
	cmpl $0x0, %eax
	je .Lnotnan

	movl $1, %eax
	leave 
	ret

.Lnotnan:
	movl $0, %eax

.Ldone:
	leave
	ret

	.align 4
.globl _isinff
_isinff:
	pushl %ebp
	movl %esp,%ebp

	movl 8(%ebp), %eax
	andl $0x7fffffff, %eax
	cmpl $0x7f800000, %eax
	je .Lgotinf

	movl $0, %eax
	leave
	ret

.Lgotinf:
	movl $1, %eax
	leave
	ret

	.align 4
.globl _iszerof
_iszerof:
	pushl %ebp
	movl %esp,%ebp

	movl 8(%ebp), %eax
	cmpl $0x0, %eax
	je .Lgotzero

	movl $0, %eax
	leave
	ret

.Lgotzero:
	movl $1, %eax
	leave
	ret

	.align 4
.globl _signbitf
_signbitf:
	pushl %ebp
	movl %esp,%ebp

	movl 8(%ebp), %eax
	andl $0x80000000, %eax
	cmpl $0x80000000, %eax
	jne .Lpos
	movl $1, %eax
	leave
	ret

.Lpos:
	movl $0, %eax
	leave
	ret

	.align 4
.globl _issubnormalf
_issubnormalf:
	pushl %ebp
	movl %esp,%ebp

	movl 8(%ebp), %eax
	andl $0x7f800000, %eax
	cmpl $0x0, %eax
	je .Lcouldbesub

.Lnotsubnorm:
	movl $0, %eax
	leave
	ret

.Lcouldbesub:
	movl 8(%ebp), %eax
	andl $0x7ffff, %eax
	cmpl $0x0, %eax
	je .Lnotsubnorm

	movl $1, %eax
	leave
	ret

	.align 4
.globl _isnormalf
_isnormalf:
	pushl %ebp
	movl %esp,%ebp

	movl 8(%ebp), %eax
	andl $0x7f800000, %eax /* mask sign bit */
	xorl $0x7f800000, %eax 
	cmpl $0x0, %eax
	je .Lnotnorm
	cmpl $0x7f800000, %eax
	je .Lnotnorm

.Lnorm:
	movl $1, %eax
	leave
	ret

.Lnotnorm:
	movl $0, %eax
	leave
	ret
