/*
** This file is part of the alternative 80386 math library and is
** covered by the GNU General Public license with my modification
** as noted in the README file that accompanied this file.
**
** Copyright 1990 G. Geers
**
*/

	.align 4
.globl _isnan
_isnan:
	pushl %ebp
	movl %esp,%ebp

	movl 12(%ebp), %eax
	andl $0x7ff00000, %eax
	cmpl $0x7ff00000, %eax
	jne .Lnotnan
	movl 12(%ebp), %eax
	andl $0xfffff, %eax
	orl 8(%ebp), %eax
	je .Lnotnan

	movl $1, %eax
	leave 
	ret

.Lnotnan:
	movl $0, %eax

.Ldone:
	leave
	ret

	.align 4
.globl _isinf
_isinf:
	pushl %ebp
	movl %esp,%ebp

	movl 12(%ebp), %eax
	andl $0x7ff00000, %eax
	cmpl $0x7ff00000, %eax
	je .Lcouldbeinf

.Lnotinf:
	movl $0, %eax
	leave
	ret

.Lcouldbeinf:
	movl 12(%ebp), %eax
	andl $0xfffff, %eax
	orl 8(%ebp), %eax
	jne .Lnotinf

	movl $1, %eax
	leave
	ret

	.align 4
.globl _iszero
_iszero:
	pushl %ebp
	movl %esp,%ebp

	movl 12(%ebp), %eax
	cmpl $0x0, %eax
	je .Lcouldbezero
.Lnotzero:
	movl $0, %eax
	leave
	ret

.Lcouldbezero:
	andl $0xfffff, %eax
	orl 8(%ebp), %eax
	jne .Lnotzero

	movl $1, %eax
	leave
	ret

	.align 4
.globl _signbit
_signbit:
	pushl %ebp
	movl %esp,%ebp

	movl 12(%ebp), %eax
	andl $0x80000000, %eax
	cmpl $0x80000000, %eax
	jne .Lpos
	movl $1, %eax
	leave
	ret

.Lpos:
	movl $0, %eax
	leave
	ret

	.align 4
.globl _issubnormal
_issubnormal:
	pushl %ebp
	movl %esp,%ebp

	movl 12(%ebp), %eax
	andl $0x7ff00000, %eax
	cmpl $0x0, %eax
	je .Lcouldbesub

.Lnotsubnorm:
	movl $0, %eax
	leave
	ret

.Lcouldbesub:
	movl 12(%ebp), %eax
	andl $0xfffff, %eax
	orl 8(%ebp), %eax
	je .Lnotsubnorm

	movl $1, %eax
	leave
	ret

	.align 4
.globl _isnormal
_isnormal:
	pushl %ebp
	movl %esp,%ebp

	movl 12(%ebp), %eax
	andl $0x7ff00000, %eax /* mask sign bit */
	xorl $0x7ff00000, %eax 
	cmpl $0x0, %eax
	je .Lnotnorm
	cmpl $0x7ff00000, %eax
	je .Lnotnorm

.Lnorm:
	movl $1, %eax
	leave
	ret

.Lcouldbenorm:
	movl 12(%ebp), %eax
	andl $0xfffff, %eax
	orl 8(%ebp), %eax
	je .Lnorm

.Lnotnorm:
	movl $0, %eax
	leave
	ret
