/*
** This file is part of the alternative 80386 math library and is
** covered by the GNU General Public license with my modification
** as noted in the README file that accompanied this file.
**
** Could use ceil(x) = -floor(-x) but this is quicker.
**
** Copyright 1990 G. Geers
**
*/

	.align 4
.globl _ceilf
_ceilf:
	pushl %ebp
	movl %esp,%ebp
	subl $8, %esp
	
	flds 8(%ebp)    	/* load data */

	fstcw -12(%ebp)		/* store control word */
	fstcw -16(%ebp)		/* store it again */
	orw $0x0800, -16(%ebp)	/* round toward +inf */
	fldcw -16(%ebp)		/* store new control word */
	frndint			/* rounding gives ceil(x) */
	fldcw -12(%ebp)		/* restore original control word */

	leave
	ret
