/*
** This file is part of the alternative 80386 math library and is
** covered by the GNU General Public license with my modification
** as noted in the README file that accompanied this file.
**
** Copyright 1990 G. Geers
**
*/

	.align 4
.Lhalfpi:
	.double 1.57079632679489661923

	.align 4
.globl _acos
_acos:
	pushl %ebp
	movl %esp,%ebp

	fldl 8(%ebp)

	ftst
	fstsw %ax
	sahf
	jz .Lzero

	fst %st(1)
	fmull 8(%ebp)
	fld1
	fsubp
	fsqrt
	fdivp
	fld1
	fpatan
	jnc .Ldone

	fldpi
	faddp
	leave
	ret

.Lzero:
	fldl .Lhalfpi

.Ldone:
	leave
	ret
