# Dialog chapter
# Tk 4.0 now provides this sort of functionality built-in
proc Focus_Setup { toplevel {default none} } {
	global focus
	if {[string compare $default none] != 0} {
		focus $default
	}
	set focus($toplevel) $default
	bind $toplevel <FocusIn> {FocusSet %W}
	bind $toplevel <FocusOut> {FocusSave %W}
}
proc FocusSet { w } {
	global focus
	catch {
		focus $focus($w) ;# could be "none", or empty
	}
}
proc FocusSave { w } {
	global focus
	set old [focus]
	if {[string compare $old none] == 0} {
		return
	}
	# Remember the widget that has focus, but only if
	# it is contained within this toplevel window.
	if {[string compare [winfo toplevel $old] $w] == 0} {
		set focus($w) $old
	}
}

