/*		Our Static DTD for HTML
**		-----------------------
*/

/* Implements:
*/

#include "HTMLDTD.h"

/* 	Entity Names
**	------------
**
**	This table must be matched exactly with ALL the translation tables
*/
static CONST char* entities[] = {
  "AElig",	/* capital AE diphthong (ligature) */ 
  "Aacute",	/* capital A, acute accent */ 
  "Acirc",	/* capital A, circumflex accent */ 
  "Agrave",	/* capital A, grave accent */ 
  "Aring",	/* capital A, ring */ 
  "Atilde",	/* capital A, tilde */ 
  "Auml",	/* capital A, dieresis or umlaut mark */ 
  "Ccedil",	/* capital C, cedilla */ 
  "ETH",	/* capital Eth, Icelandic */ 
  "Eacute",	/* capital E, acute accent */ 
  "Ecirc",	/* capital E, circumflex accent */ 
  "Egrave",	/* capital E, grave accent */ 
  "Euml",	/* capital E, dieresis or umlaut mark */ 
  "Iacute",	/* capital I, acute accent */ 
  "Icirc",	/* capital I, circumflex accent */ 
  "Igrave",	/* capital I, grave accent */ 
  "Iuml",	/* capital I, dieresis or umlaut mark */ 
  "Ntilde",	/* capital N, tilde */ 
  "Oacute",	/* capital O, acute accent */ 
  "Ocirc",	/* capital O, circumflex accent */ 
  "Ograve",	/* capital O, grave accent */ 
  "Oslash",	/* capital O, slash */ 
  "Otilde",	/* capital O, tilde */ 
  "Ouml",	/* capital O, dieresis or umlaut mark */ 
  "THORN",	/* capital THORN, Icelandic */ 
  "Uacute",	/* capital U, acute accent */ 
  "Ucirc",	/* capital U, circumflex accent */ 
  "Ugrave",	/* capital U, grave accent */ 
  "Uuml",	/* capital U, dieresis or umlaut mark */ 
  "Yacute",	/* capital Y, acute accent */ 
  "aacute",	/* small a, acute accent */ 
  "acirc",	/* small a, circumflex accent */ 
  "aelig",	/* small ae diphthong (ligature) */ 
  "agrave",	/* small a, grave accent */ 
  "amp",	/* ampersand */ 
  "aring",	/* small a, ring */ 
  "atilde",	/* small a, tilde */ 
  "auml",	/* small a, dieresis or umlaut mark */ 
  "brvbar",     /* broken vertical bar */
  "ccedil",	/* small c, cedilla */ 
  "cent",	/* cent sign */
  "copy",       /* copyright sign */
  "deg",	/* degree sign */
  "eacute",	/* small e, acute accent */ 
  "ecirc",	/* small e, circumflex accent */ 
  "egrave",	/* small e, grave accent */ 
  "eth",	/* small eth, Icelandic */ 
  "euml",	/* small e, dieresis or umlaut mark */ 
  "frac14",	/* fraction 1/4 */
  "frac12",     /* fraction 1/2 */
  "frac34",     /* fraction 3/4 */
  "gt",		/* greater than */ 
  "iacute",	/* small i, acute accent */ 
  "icirc",	/* small i, circumflex accent */ 
  "iexcl",	/* inverted exclamation mark */
  "igrave",	/* small i, grave accent */ 
  "iquest",     /* inverted question mark */
  "iuml",	/* small i, dieresis or umlaut mark */ 
  "laquo",	/* angle quotation mark, left */
  "lt",		/* less than */ 
  "micro",	/* micro sign */
  "middot",	/* center dot */
  "not",	/* negation sign */
  "ntilde",	/* small n, tilde */ 
  "oacute",	/* small o, acute accent */ 
  "ocirc",	/* small o, circumflex accent */ 
  "ograve",	/* small o, grave accent */ 
  "oslash",	/* small o, slash */ 
  "otilde",	/* small o, tilde */ 
  "ouml",	/* small o, dieresis or umlaut mark */
  "para",	/* paragraph sign */
  "plusmn",	/* plus or minus sign */ 
  "pound",      /* pound sign */
  "raquo",	/* angle quotation mark, right */
  "reg",	/* circled R registered sign */
  "sect",       /* section sign */
  "sup1",	/* superscript 1 */
  "sup2",	/* superscript 2 */
  "sup3",	/* superscript 3 */
  "szlig",	/* small sharp s, German (sz ligature) */ 
  "thorn",	/* small thorn, Icelandic */ 
  "uacute",	/* small u, acute accent */ 
  "ucirc",	/* small u, circumflex accent */ 
  "ugrave",	/* small u, grave accent */ 
  "uuml",	/* small u, dieresis or umlaut mark */ 
  "yacute",	/* small y, acute accent */ 
  "yen",        /* yen sign */
  "yuml",	/* small y, dieresis or umlaut mark */ 
};

#define HTML_ENTITIES 88


/*		Attribute Lists
**		---------------
**
**	Lists must be in alphatbetical order by attribute name
**	The tag elements contain the number of attributes
*/
static attr no_attr[] = 
	{{ 0 }};

static attr a_attr[] = {			/* Anchor attributes */
        { "EFFECT" },
	{ "HREF"},
        { "ID"},
        { "LANG" },
        { "METHODS" },
	{ "NAME" },				/* Should be ID */
        { "PRINT" },
        { "REL" },
        { "REV" },
        { "SHAPE" },
        { "SIZE" },
	{ "TITLE" },
	{ "TYPE" },
	{ "URN" },
	{ 0 }	/* Terminate list */
};	


static attr base_attr[] = {
	{ "HREF" },
	{ 0 }
};

static attr changed_attr[] = {
	{ "ID" },
	{ "IDREF" },
	{ 0 }
};

static attr dl_attr[] = {
	{ "COMPACT" },
	{ "ID" },
	{ "INDEX" },
	{ "LANG" },
	{ 0 }	/* Terminate list */
};

static attr form_attr[]  = {
	{ "ACTION" },
	{ "ID" },
	{ "INDEX" },
	{ "LANG" },
	{ "METHOD" },
	{ 0 }
};

static attr hplus_attr[] = {
	{ "FORMS" },
	{ "VERSION" },
	{ 0 }
};

static attr id_attr[] = {
	{ "ALIGN" },
	{ "AT" },
	{ "BORDER" },
	{ "ID" },
	{ "INDEX" },
	{ "LANG"},
	{ "ROLE" },
	{ "SRC" },
	{ 0 }
};

static attr img_attr[] = {			/* Anchor attributes */
	{ "ISMAP"},
	{ "SRC"},
	{ 0 }	/* Terminate list */
};	

static attr input_attr[] = {
	{ "ALIGN" },
	{ "CHECKED" },
	{ "DISABLED" },
	{ "ERROR" },
	{ "LANG" },
	{ "MIN" },
	{ "MAX" },
	{ "NAME" },
	{ "SIZE" },
	{ "SRC" },
	{ "TYPE" },
	{ "VALUE" },
	{ 0 }
};

static attr list_attr[] = {
	{ "COMPACT"},
	{ 0 }	/* Terminate list */
};

static attr nextid_attr[] = {
	{ "N" }
};

static attr option_attr[] = {
	{ "DISABLED" },
	{ "LANG" },
	{ "SELECTED" },
	{ 0 }
};

static attr render_attr[] = {
	{ "STYLE" },
	{ "TAG	" },
	{ 0 }
};

static attr select_attr[] = {
	{ "ERROR" },
	{ "LANG" },
	{ "NAME" },
	{ "SEVERAL" },
	{ 0 }
};

static attr tbl_attr[] = {
	{ "ALIGN" },
	{ "COLSPAN" },
	{ "LANG" },
	{ "ROWSPAN" },
	{ 0 }
};

static attr tblt_attr[] = {
	{ "COLS" },
	{ "DISABLED" },
	{ "ERROR" },
	{ "LANG" },
	{ "NAME" },
	{ "ROWS" },
	{ 0 }
};


/*	Elements
**	--------
**
**	Must match definitions in HTMLDTD.html!
**	Must be in alphabetical order.
**
**    Name, 	Attributes, 		content
*/
static HTTag tags[HTML_ELEMENTS] = {
  { "A",	a_attr,		HTML_A_ATTRIBUTES,	SGML_MIXED },
  { "ABBREV"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "ABSTRACT" 	, id_attr,	HTML_ID_ATTRIBUTES,     SGML_MIXED },
  { "ACRONYM"	, id_attr,	HTML_ID_ATTRIBUTES,     SGML_MIXED },
  { "ADDED"   	, id_attr,	HTML_ID_ATTRIBUTES,     SGML_MIXED },
  { "ADDRESS"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "ARG"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "B"		, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "BASE"	, base_attr,    HTML_BASE_ATTRIBUTES,   SGML_EMPTY },
  { "BLOCKQUOTE", no_attr,	0,			SGML_MIXED },
  { "BODY"	, no_attr,	0,			SGML_MIXED },
  { "BOX"       , no_attr,      0,			SGML_EMPTY },
  { "BR"        , no_attr,      0,			SGML_EMPTY },
  { "BYLINE"    , id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "CAPTION"   , id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "CHANGED"   , changed_attr,	HTML_CHANGED_ATTRIBUTES,	SGML_MIXED },
  { "CITE"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "CMD"       , id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "CODE"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "COMMENT"	, no_attr,	0,			SGML_MIXED },
  { "DD"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "DFN"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "DIR"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "DL"	, dl_attr,	HTML_DL_ATTRIBUTES,	SGML_MIXED },
  { "DLC"	, dl_attr,	HTML_DL_ATTRIBUTES,	SGML_MIXED },
  { "DT"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "EM"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "FIG" 	, img_attr,	HTML_IMG_ATTRIBUTES,	SGML_EMPTY },
  { "FOOTNOTE"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "FORM"	, form_attr,	HTML_FORM_ATTRIBUTES,	SGML_EMPTY },
  { "H1"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "H2"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "H3"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "H4"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "H5"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "H6"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "H7"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "HEAD"	, no_attr,	0,			SGML_MIXED },
  { "HTML"	, no_attr,	0,			SGML_MIXED },
  { "HTMLPLUS" 	, hplus_attr,	HTML_HPLUS_ATTRIBUTES,	SGML_EMPTY },
  { "I"	 	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "IMAGE" 	, img_attr,	HTML_IMG_ATTRIBUTES,	SGML_EMPTY },
  { "IMG"     	, img_attr,	HTML_IMG_ATTRIBUTES,	SGML_EMPTY },
  { "INPUT" 	, input_attr,	HTML_INPUT_ATTRIBUTES,	SGML_EMPTY },
  { "ISINDEX"	, base_attr,	HTML_BASE_ATTRIBUTES,	SGML_EMPTY },
  { "KBD"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "L" 	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "LI"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "LINK"	, a_attr,	HTML_A_ATTRIBUTES,	SGML_EMPTY },
  { "LISTING"	, no_attr,	0,		SGML_LITTERAL },
  { "LIT"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "MARGIN"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED},
  { "MATH"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "MENU"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "NOTE" 	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "NEXTID" 	, nextid_attr,	1,		SGML_EMPTY },
  { "OL"	, list_attr,	1,		SGML_MIXED },
  { "OPTION" 	, option_attr,	HTML_OPTION_ATTRIBUTES,	SGML_EMPTY},
  { "OVER"	, no_attr,	0,		SGML_MIXED },
  { "P"		, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "PERSON"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "PLAINTEXT" , no_attr,	0,		SGML_LITTERAL },
  { "PRE"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "Q"        	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "QUOTE"    	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "REMOVED"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "RENDER"  	, render_attr,	HTML_RENDER_ATTRIBUTES,	SGML_EMPTY },
  { "S"		, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "SAMP"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "SELECT" 	, select_attr,	HTML_SELECT_ATTRIBUTES,	SGML_EMPTY },
  { "STRONG"	, no_attr,	0,		SGML_MIXED },
  { "SUB" 	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "SUP" 	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "TAB"  	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "TABLE"  	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "TD" 	, tbl_attr,	HTML_TBL_ATTRIBUTES,	SGML_EMPTY },
  { "TEXTAREA" 	, tblt_attr,	HTML_TBLT_ATTRIBUTES,	SGML_EMPTY },
  { "TH" 	, tbl_attr,	HTML_TBL_ATTRIBUTES,	SGML_EMPTY },
  { "TITLE"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "TR" 	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "TT"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "U"	 	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "UL"	, list_attr,	1,			SGML_MIXED },
  { "VAR"	, id_attr,	HTML_ID_ATTRIBUTES,	SGML_MIXED },
  { "XMP"	, no_attr,	0,			SGML_LITTERAL },
};


PUBLIC CONST SGML_dtd HTML_dtd = {
	tags,
	HTML_ELEMENTS,
	entities,
	sizeof(entities)/sizeof(char**)
};

/*	Utility Routine: useful for people building HTML objects */

/*	Start anchor element
**	--------------------
**
**	It is kinda convenient to have a particulr routine for
**	starting an anchor element, as everything else for HTML is
**	simple anyway.
*/
struct _HTStructured {
    HTStructuredClass * isa;
	/* ... */
};

PUBLIC void HTStartAnchor ARGS3(HTStructured *, obj,
		CONST char *,  name,
		CONST char *,  href)
{
    BOOL		present[HTML_A_ATTRIBUTES];
    CONST char*		value[HTML_A_ATTRIBUTES];
    
    {
    	int i;
    	for(i=0; i<HTML_A_ATTRIBUTES; i++)
	    present[i] = NO;
    }
    if (name) {
    	present[HTML_A_NAME] = YES;
	value[HTML_A_NAME] = name;
    }
    if (href) {
        present[HTML_A_HREF] = YES;
        value[HTML_A_HREF] = href;
    }
    
    (*obj->isa->start_element)(obj, HTML_A , present, value);

}

