/*-
 * Copyright (c) 1993 Michael B. Durian.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Michael B. Durian.
 * 4. The name of the the Author may be used to endorse or promote 
 *    products derived from this software without specific prior written 
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * tclm.h,v 1.7 1993/05/06 02:51:12 durian Exp
 */
#ifndef TCLM_H
#define TCLM_H
typedef struct {
	HCHUNK	hchunk;
	TCHUNK	*tchunks;
} MIDI_FILE;

#define MAX_EVENT_SIZE 256

extern int Tclm_MidiConfig _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
    char **));
extern int Tclm_Division _ANSI_ARGS_((Tcl_Interp *, int, char **));
extern int Tclm_MidiFixToVar _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
    char **));
extern int Tclm_Format _ANSI_ARGS_((Tcl_Interp *, int, char **));
extern int Tclm_MidiFree _ANSI_ARGS_((ClientData, Tcl_Interp *, int, char **));
extern int Tclm_MidiGet _ANSI_ARGS_((ClientData, Tcl_Interp *, int, char **));
extern int Tclm_MidiPut _ANSI_ARGS_((ClientData, Tcl_Interp *, int, char **));
extern int Tclm_GetMFile _ANSI_ARGS_((Tcl_Interp *, char *, MIDI_FILE **));
extern void Tclm_InitMidi _ANSI_ARGS_((Tcl_Interp *));
extern int Tclm_MidiMake _ANSI_ARGS_((ClientData, Tcl_Interp *, int, char **));
extern int Tclm_MidiMerge _ANSI_ARGS_((ClientData, Tcl_Interp *, int, char **));
extern int Tclm_NumTracks _ANSI_ARGS_((Tcl_Interp *, int, char **));
extern int Tclm_MidiRead _ANSI_ARGS_((ClientData, Tcl_Interp *, int, char **));
extern int Tclm_MidiRewind _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
    char **));
extern int Tclm_SetMFile _ANSI_ARGS_((Tcl_Interp *, char *, MIDI_FILE *));
extern int Tclm_MidiTiming _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
    char **));
extern int Tclm_MidiVarToFix _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
    char **));
extern int Tclm_MidiWrite _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
    char **));
extern int Tclm_MidiPlayable _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
    char **));
extern int Tclm_TclmVersion _ANSI_ARGS_((ClientData, Tcl_Interp *, int,
    char **));
#endif
