/*
 *-----------------------------------------------------------------------------
 *  Copyright (c) 1993-1995 European Synchrotron Radiation Facility
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the "Terms and Conditions of Distribution", given in the documentation
 *  to this software, are applicable and the above copyright message appears
 *  in each copy.
 *
 *-----------------------------------------------------------------------------
 *
 *
 *  CTAXT:      Combine Tcl/Tk with arbitrary X Toolkits 
 *              (into a single application)
 *
 *  Module:	ctaxtInt.h
 *
 *  Purpose:    Definition of structures internally used by CTAXT
 *              Includes all the system headers needed by modules of CTAXT so
 *              that system-dependent personalizations for the include files
 *              only have to be made in one place.
 *
 */




#ifndef _CTAXTINT
#define _CTAXTINT




/*
 *  CTAXT version
 */

#define CTAXT_VERSION "1.1"




/*============================================================================
 *
 *  Set the following #define to 0, 1 or 2 but don't delete or comment it 
 *  out!!!
 *
 *  DEBUG_LEVEL:
 *
 *    0  No Debug-Information is printed out to stderr
 *    1  Print just the Debug-Information in the GenericEventHandler to stderr
 *    2  Print all Debug-Information to stderr
 *
 *============================================================================
 */

#define CTAXT_DEBUG_LEVEL 0




#include <stdio.h>

/*
 * Definitions that allow this header file to be used either with or
 * without ANSI C features like function prototypes.
 */

#undef _ANSI_ARGS_
#undef CONST
#if ((defined(__STDC__) || defined(SABER)) && !defined(NO_PROTOTYPE)) || defined (__cplusplus)
#   define _USING_PROTOTYPES_ 1
#   define _ANSI_ARGS_(x)       x
#   define CONST const
#   ifdef __cplusplus
#       define VARARGS (...)
#   else
#       define VARARGS ()
#   endif
#else
#   define _ANSI_ARGS_(x)       ()
#   define CONST
#endif

#ifdef __cplusplus
#   define EXTERN extern "C"
#else
#   define EXTERN extern
#endif

/*
 * Macro to use instead of "void" for arguments that must have
 * type "void *" in ANSI C;  maps them to type "char *" in
 * non-ANSI systems.
 */

#ifndef VOID
#   ifdef __STDC__
#       define VOID void
#   else
#       define VOID char
#   endif
#endif

/*
 * Miscellaneous declarations
 */

#ifndef NULL
#define NULL 0
#endif

#ifndef _CLIENTDATA
#   ifdef __STDC__
    typedef void *ClientData;
#   else
    typedef int *ClientData;
#   endif /* __STDC__ */
#define _CLIENTDATA
#endif

/*  
 *  include the headers  
 */

#ifdef NO_STDLIB_H
  extern VOID *malloc();
  extern VOID *calloc();
  extern VOID *realloc();
  extern VOID free();
#else
#include <stdlib.h>
#endif

#ifdef NO_STRING_H
#include <sys/types.h>  /*  for definition of size_t  */
  extern char *memcpy _ANSI_ARGS_((VOID *t, CONST VOID *f, size_t n));
  extern int strcmp _ANSI_ARGS_((const char *s1,const char *s2));
  extern char *strncpy _ANSI_ARGS_((char *s1,const char *s2,size_t n));
  extern char *strtok _ANSI_ARGS_((char *s1,const char *s2));
#else
#include <string.h>
#endif

#ifndef _XLIB_H_
#include <X11/Xlib.h>
#endif
#ifndef _TK
#include <tk.h>
#endif
#ifndef _TCL
#include <tk.h>
#endif



/*
 *  Include ctaxt.h if not already done
 */

#ifndef _CTAXT
#include "ctaxt.h"
#endif




/*
 *  Structure for keeping information about CTAXT-Main-Windows
 */

typedef struct CTAXT_mainwindow {
  Tcl_Interp *interp;              /*  Tcl-Interpreter associated with this
				       Tk-Main-Window  */
  Tk_Window tkWin;                 /*  Token for the Tk-Main-Window  */
  Display *display;                /*  X-Display-Pointer of display on which
				       the window appears  */
  Window mainWinFrame;             /*  X-Window-ID for the parent (frame 
				       created by the Window Manager) of that
				       Application-Main or -Toplevel-Window to
				       which the Tk-Main-Window is a child  */
  Window mainWin;                  /*  X-Window-ID of that Application-Main or
				       -Toplevel-Window to which the Tk-Main-
				       Window is a child  */
  Window window;                   /*  X-Window-ID of the Window to which the 
				       Tk-Main-Window is mapped  */
  int sameMainWin;                 /*  The array keeping information about
				       CTAXT-Main-Windows is ordered by
				       mainWin. Entries with the same mainWin
				       build a column. This field contains the
				       number of windows left in the column,
				       starting at the current entry and 
				       including it. I.e.: the last entry of a
				       column contains a one in this field, 
				       the previous one a two and so on  */
} CTAXT_MainWindow;


/*
 *  Structure for Tcl extensions
 */

typedef struct {
  ClientData  clientData;     /*  ClientData argument to pass to the
				  procedure  */
  CTAXT_TclExtProc *tclExtension;
                              /*  Function which extends the Tcl interpr.  */
  CTAXT_FreeTclExtProc *freeTclExtension;
                              /*  Function which should be called when a
				  Tcl interpreter is destroyed  */
} CTAXT_TclExtension;


/*
 *  Structure needed for hiding the Tcl-related stuff to outside world
 *  and for dealing with multiple Tk-MainWindows and Tcl-Interpreters
 */

typedef struct {
  CTAXT_MainWindow *winList;       /*  Pointer to the dynamic array of
				       CTAXT-Main-Windows  */
  int windows;                     /*  Number of elements in the array  */
  int cache;                       /*  To speed up the generic event handler
				       this field contains the index of the
				       first last accessed CTAXT-Main-Window  
				       in a column of similar windows  */
  CTAXT_ExplEventProc *handleEventExplicit;
                                   /*  Pointer to user defined function for
				       explicit event handling  */
  CTAXT_TclExtension *extension;   /*  Extensions added to each created
				       Tcl interpreter  */
  int extensions;                  /*  Number of Tcl extensions  */
} CTAXT_GlobalData;


/*
 *  Structure for command registering
 */

typedef struct {
  char                 *name;      /*  Tcl-Command-Name  */
  Tcl_CmdProc          *cmdProc;   /*  Pointer to C procedure implementing the
				       command  */
  ClientData           clientData; /*  ClientData to pass to the procedure  */
  Tcl_CmdDeleteProc    *delProc;   /*  Procedure to call when the command is
				       deleted  */
} CTAXT_ApplicationCmd;

typedef struct {
  Window               window;     /*  Window to create the command in  */
  Display              *display  ; /*  Display where motifWin is located  */
  CTAXT_ApplicationCmd *cmdList;   /*  Array containing the commands to
				       register to this window  */
  int                  commands;   /*  Number of commands in array  */
} CTAXT_ApplicationCmds;

#endif /* _CTAXTINT */
