/*
 *-----------------------------------------------------------------------------
 *  Copyright (c) 1993-1995 European Synchrotron Radiation Facility
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the "Terms and Conditions of Distribution", given in the documentation
 *  to this software, are applicable and the above copyright message appears
 *  in each copy.
 *
 *-----------------------------------------------------------------------------
 *
 *
 *  This file contains the application specific explicit event handler for 
 *  the sample application for demonstrating the use of the CTAXT interface
 *
 *  13.12.1993   hp      1st version
 */


#include <stdio.h>
#include <X11/Intrinsic.h>
#include "ctaxt.h"




/*
 *  handleEventExplicit ---
 *
 *  This function implements the explicit event handler. It doesn't really
 *  mask for certain events, just dispatchs them.
 *
 *  Arguments:
 *
 *    See the CTAXT documentation
 *
 *  Result: 
 *
 *    nobody cares for it
 *
 *  Side effects:
 *
 *    depends on the event and the application
 */

int 
handleEventExplicit (event)
  XEvent *event;
{
  switch (event->type) {

    /*  insert here your event masking and filtering  */

    default:
      XtDispatchEvent (event);
  }
  return (0);
}
