/* Bos_TclUtil.c - TCL utilities that come with BOS */

/*
 * /afs/cs/project/edrc/ndim/source/bos/libbos/Bos_TclUtil.c,v 1.1.1.1 1992/05/08 19:45:36 snl Exp
 *
 * Bos_TclUtil.c,v 1.1.1.1 1992/05/08 19:45:36 snl Exp
 *
 * Bos_TclUtil.c,v
 * Revision 1.1.1.1  1992/05/08  19:45:36  snl
 * bos 1.2
 *
 * Revision 1.1  92/03/10  17:34:52  snl
 * Initial revision
 * 
 */

#ifndef lint
static char *_RCSId =
  "/afs/cs/project/edrc/ndim/source/bos/libbos/Bos_TclUtil.c,v 1.1.1.1 1992/05/08 19:45:36 snl Exp";
#endif /* lint */

#include <stdio.h>
#include "bos.h"
#include <pwd.h>
#include <sys/signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

static char digitSet[] = {	/* digit set for radix command */
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
  'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J',
  'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T',
  'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd',
  'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',
  'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x',
  'y', 'z', '@', ',', '%', '!', '&', '<', '>', '/',
  ':', '|', '_', '+', '-', '=', '.', '?', ';', '~'
};
static int maxRadix = sizeof(digitSet);

#define RADIX_DIGIT_BUFSIZ 100

#define TclProc(name) \
int name/**/Cmd (clientData, interp, argc, argv) \
ClientData clientData; \
Tcl_Interp *interp; \
int argc; \
char **argv;

void
Bos_InitUtilities(interp)
  Tcl_Interp *interp;
{
  int GetenvCmd(), NowCmd(), TimeStringCmd(), UsernameCmd(), ToRadixCmd(),
      IPAddressCmd(), IPAddressStringCmd(), HostnameCmd(), UserIDCmd();

  Tcl_CreateCommand(interp, "getenv", GetenvCmd, 0, 0);
  Tcl_CreateCommand(interp, "now", NowCmd, 0, 0);
  Tcl_CreateCommand(interp, "timestring", TimeStringCmd, 0, 0);
  Tcl_CreateCommand(interp, "username", UsernameCmd, 0, 0);
  Tcl_CreateCommand(interp, "userid", UserIDCmd, 0, 0);
  Tcl_CreateCommand(interp, "toradix", ToRadixCmd, 0, 0);
  Tcl_CreateCommand(interp, "ipaddress", IPAddressCmd, 0, 0);
  Tcl_CreateCommand(interp, "ipstring", IPAddressStringCmd, 0, 0);
  Tcl_CreateCommand(interp, "hostname", HostnameCmd, 0, 0);
}

/*
 * Local procedures
 */

static TclProc(Getenv)
{
  char *enval, *ecopy, *getenv();

  if (argc < 2) {
    sprintf(interp->result, "usage: %.50s envar", argv[0]);
    return TCL_ERROR;
  }
  enval = getenv(argv[1]);
  if (enval == (char *)0) {
    sprintf(interp->result, "environment variable \"%.50s\" undefined",
	    argv[1]);
    return TCL_ERROR;
  }
  Tcl_SetResult(interp, enval, TCL_STATIC);
  return TCL_OK;
}

static TclProc(Now)
{
  long t;

  t = time(0);
  sprintf(interp->result, "%d", t);
  return TCL_OK;
}

static TclProc(TimeString)
{
  long clock;
  char *ts, *ctime();
  int tsl;

  if (argc < 2) {
    sprintf(interp->result, "usage: \"%.50s timeval\"", argv[0]);
    return TCL_ERROR;
  }
  if (sscanf(argv[1], "%d", &clock) != 1) {
    sprintf(interp->result, "timeval \"%.50s\" did not scan as integer.",
	    argv[1]);
    return TCL_ERROR;
  }
  ts = ctime(&clock);
  tsl = strlen(ts);
  ts[--tsl] = '\0';
  strcpy(interp->result, ts);
  return TCL_OK;
}

static TclProc(Username)
{
  int uid;
  struct passwd *pw;

  if (argc == 1)
    uid = getuid();
  else if (sscanf(argv[1], "%d", &uid) != 1) {
    sprintf(interp->result,
	    "user ID \"%.50s\" did not scan as integer", argv[1]);
    return TCL_ERROR;
  }
  pw = getpwuid(uid);
  if (pw == (struct passwd *)0) {
    sprintf(interp->result, "Could not get passwd ent for UID %d", uid);
    return TCL_ERROR;
  }
  strcpy(interp->result, pw->pw_name);
  return TCL_OK;
}

static TclProc(UserID)
{
  sprintf(interp->result, "%d", getuid());
  return TCL_OK;
}

static TclProc(ToRadix)
{
  int s;
  unsigned radix, number;

  s = TCL_ERROR;
  if (argc != 3)
    sprintf(interp->result,
	    "wrong # args: \"%.50s radix number\"", argv[0]);
  else if (sscanf(argv[1], "%u", &radix) != 1)
    sprintf(interp->result,
	    "radix \"%.50s\" did not scan as integer", argv[1]);
  else if (sscanf(argv[2], "%u", &number) != 1)
    sprintf(interp->result,
	    "number \"%.50s\" did not scan as integer", argv[2]);
  else if (radix > maxRadix || radix < 2)
    sprintf(interp->result,
	    "radix %d out of bounds; must be >= 2 && <= %d",
	    radix, maxRadix);
  else {
    char digits[RADIX_DIGIT_BUFSIZ];
    int d;

    s = TCL_OK;
    d = sizeof(digits) - 1;
    digits[d] = '\0';
    while (number >= radix) {
      unsigned dval;

      if (--d < 0) {
	sprintf(interp->result,
		"digit buffer too small for %d base %d (%d bytes).",
		number, radix, sizeof(digits));
	s = TCL_ERROR;
	break;
      }
      dval = number % radix;
      number /= radix;
      digits[d] = digitSet[dval];
    }
    if (s == TCL_OK) {
      if (--d < 0) {
	sprintf(interp->result,
		"digit buffer too small for %d base %d (%d bytes).",
		number, radix, sizeof(digits));
	s = TCL_ERROR;
      } else {
	digits[d] = digitSet[number];
	strcpy(interp->result, &digits[d]);
      }
    }
  }
  return s;
}

static TclProc(IPAddress)
{
  sprintf(interp->result, "%u", (unsigned)gethostid());
  return TCL_OK;
}

static TclProc(IPAddressString)
{
  int ip;

  if (argc != 2) {
    sprintf(interp->result,
	    "wrong # args: \"%.50s ipaddress\"", argv[0]);
    return TCL_ERROR;
  } else if (sscanf(argv[1], "%d", &ip) != 1) {
    sprintf(interp->result,
	    "ip address \"%.50s\" did not scan as integer", argv[1]);
    return TCL_ERROR;
  } else {
    char *n;

    n = inet_ntoa(ip);
    if (n != (char *)0)
      strcpy(interp->result, n);
    else {
      sprintf(interp->result,
	      "error converting %d to a.b.c.d format", ip);
      return TCL_ERROR;
    }
  }
  return TCL_OK;
}

static TclProc(Hostname)
{
  gethostname(interp->result, 200);
  return TCL_OK;
}
