#
# Entry.tcl,v 1.2 1992/06/18 21:49:48 snl Exp
#
# /afs/cs/project/edrc/ndim/source/bos/base/Entry.tcl,v 1.2 1992/06/18 21:49:48 snl Exp
#
# HISTORY
#
# Entry.tcl,v
# Revision 1.2  1992/06/18  21:49:48  snl
# Added checkView and binding for middle button
#
# Revision 1.1.1.1  1992/05/08  19:46:03  snl
# bos 1.2
#
# Revision 1.1  92/03/08  23:33:04  snl
# Initial revision
# 
# Revision 1.2  92/01/27  16:05:59  snl
# Port to new TCL
# 
# Revision 1.1  91/12/16  20:11:31  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:41:49  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:34:19  snl
# Initial revision
# 
#
GraphicalObject refineWith Entry

EntryTraits defMethod initialize {parent args} {
  set w [$self [$self graphicalObjectParent]:initialize $parent]
  eval "entry $w $args"
  bind $w <Any-KeyPress> "%W insert cursor \"%A\";$self changed;$self checkView"
  bind $w <space> "%W insert cursor \" \";$self changed;$self checkView"
  bind $w <Delete> "bs %W;$self changed;$self checkView"
  bind $w <BackSpace> "bs %W;$self changed;$self checkView"
  bind $w <Control-h> "bs %W;$self changed;$self checkView"
  bind $w <1> {%W cursor @%x; focus %W; %W select from @%x}
  bind $w <2> {%W insert cursor [selection get]}
  bind $w <B1-Motion> {%W select to @%x}
  bind $w <Shift-1> {%W select adjust @%x}
  bind $w <Shift-B1-Motion> {%W select to @%x}
  bind $w <3> {%W scan mark %x}
  bind $w <B3-Motion> {%W scan dragto %x}
  bind $w <Control-d> "%W delete sel.first sel.last;$self changed"
  bind $w <Control-u> "%W delete 0 end;$self changed;$self checkView"
  return $w
}
EntryTraits defMethod changed {} {
}
EntryTraits defMethod get {} {
  return [[$self window] get]
}
EntryTraits defMethod setCursor {idx} {
  [$self window] cursor $idx
}
EntryTraits defMethod index {what} {
  return [[$self window] index $what]
}
EntryTraits defMethod delete {first {last 0}} {
  [$self window] delete $first $last
}
EntryTraits defMethod insert {index string} {
  [$self window] insert $index $string
}
EntryTraits defMethod checkView {} {
  set w [$self window];
  set pos [$w index cursor];
  set bd [lindex [$w config -bd] 4];
  set cw [lindex [$w config -cursorwidth] 4];
  set first [expr [$w index @[expr $bd+1]]-1];
  set width [winfo width $w];
  set last  [$w index @[expr $width-2*$bd-$cw-1]];
  if {$pos > $first && $pos <= $last} {
    return;
  }
  set val [$w get];
  set font [lindex [$w config -font] 4];
  set text [string range $val 0 $pos];
  set whalf [expr $width/2];
  for {set i $pos} {$i > 0} {incr i -1} {
    set tw [textwidth [string range $text $i 100000] $font];
    if {$tw >= $whalf} {
      $w view $i;
      return;
    }
  }
  $w view 0;
}
