From: ouster@sprite.Berkeley.EDU (John Ousterhout)
Newsgroups: comp.lang.tcl
Subject: Bug fix for arrowheads and "coords" canvas widget command
Date: 21 Dec 1992 18:53:02 GMT
Organization: U.C. Berkeley Sprite Project
Distribution: world
NNTP-Posting-Host: tyranny.berkeley.edu


I believe that someone on this list reported a problem with arrowheads
on lines not moving properly after coordinate changes with the "coords"
widget command.  Here is a patch to tkCanvLine.c that should fix the
problem. Please let me know if problems persist.

*** /tmp/,RCSt1871260	Mon Dec 21 10:50:21 1992
--- tkCanvLine.c	Mon Dec 21 10:47:12 1992
***************
*** 42,48 ****
  				 * to the necks of the arrowheads rather than
  				 * their tips.  The actual endpoints are
  				 * stored in the *firstArrowPtr and
! 				 * *lastArrowPtr. */
      int width;			/* Width of line. */
      XColor *fg;			/* Foreground color for line. */
      Pixmap fillStipple;		/* Stipple bitmap for filling line. */
--- 42,48 ----
  				 * to the necks of the arrowheads rather than
  				 * their tips.  The actual endpoints are
  				 * stored in the *firstArrowPtr and
! 				 * *lastArrowPtr, if they exist. */
      int width;			/* Width of line. */
      XColor *fg;			/* Foreground color for line. */
      Pixmap fillStipple;		/* Stipple bitmap for filling line. */
***************
*** 367,372 ****
--- 367,389 ----
  		    != TCL_OK) {
  		return TCL_ERROR;
  	    }
+ 	}
+ 
+ 	/*
+ 	 * Update arrowheads by throwing away any existing arrow-head
+ 	 * information and calling ConfigureArrows to recompute it.
+ 	 */
+ 
+ 	if (linePtr->firstArrowPtr != NULL) {
+ 	    ckfree((char *) linePtr->firstArrowPtr);
+ 	    linePtr->firstArrowPtr = NULL;
+ 	}
+ 	if (linePtr->lastArrowPtr != NULL) {
+ 	    ckfree((char *) linePtr->lastArrowPtr);
+ 	    linePtr->lastArrowPtr = NULL;
+ 	}
+ 	if (linePtr->arrow != noneUid) {
+ 	    ConfigureArrows(canvasPtr, linePtr);
  	}
  	ComputeLineBbox(canvasPtr, linePtr);
      }


From: ouster@sprite.Berkeley.EDU (John Ousterhout)
Newsgroups: comp.lang.tcl
Subject: Tk 3.0 bug: double-clicks under grabs
Date: 21 Dec 1992 23:04:55 GMT
Organization: U.C. Berkeley Sprite Project
Distribution: world
NNTP-Posting-Host: tyranny.berkeley.edu


Tk 3.0 contains a bug where double-event bindings, such as
	"bind .foo <Double-1> {...}"
don't always trigger correctly when a grab is active.  Believe it or not,
this bug was caused by the change in the focussing code.  Anyhow, below
is a patch to tkBind.c that fixes the problem.

*** /tmp/,RCSt1281434	Mon Dec 21 14:47:50 1992
--- tkBind.c	Mon Dec 21 14:45:53 1992
***************
*** 34,40 ****
   * binding table for associating events with the items in the canvas).
   */
  
! #define EVENT_BUFFER_SIZE 10
  typedef struct BindingTable {
      XEvent eventRing[EVENT_BUFFER_SIZE];/* Circular queue of recent events
  					 * (higher indices are for more recent
--- 34,40 ----
   * binding table for associating events with the items in the canvas).
   */
  
! #define EVENT_BUFFER_SIZE 20
  typedef struct BindingTable {
      XEvent eventRing[EVENT_BUFFER_SIZE];/* Circular queue of recent events
  					 * (higher indices are for more recent
***************
*** 1578,1601 ****
  	    if (ringCount <= 0) {
  		goto nextSequence;
  	    }
- 	    if (eventPtr->xany.window != window) {
- 		goto nextSequence;
- 	    }
  	    if (eventPtr->xany.type != patPtr->eventType) {
  		/*
! 		 * If the event is a mouse motion, button release,
! 		 * or key release event, and it didn't match
! 		 * the pattern, then just skip the event and try
! 		 * the next event against the same pattern.
  		 */
  
! 		if ((eventPtr->xany.type == MotionNotify)
! 			|| (eventPtr->xany.type == ButtonRelease)
! 			|| (eventPtr->xany.type == KeyRelease)
! 			|| (eventPtr->xany.type == NoExpose)
! 			|| (eventPtr->xany.type == GraphicsExpose)) {
! 		    goto nextEvent;
  		}
  		goto nextSequence;
  	    }
  
--- 1578,1599 ----
  	    if (ringCount <= 0) {
  		goto nextSequence;
  	    }
  	    if (eventPtr->xany.type != patPtr->eventType) {
  		/*
! 		 * Most of the event types are considered superfluous
! 		 * in that they are ignored if they occur in the middle
! 		 * of a pattern sequence and have mismatching types.  The
! 		 * only ones that cannot be ignored are ButtonPress and
! 		 * KeyPress events.
  		 */
  
! 		if ((eventPtr->xany.type == ButtonPress)
! 			|| (eventPtr->xany.type == KeyPress)) {
! 		    goto nextSequence;
  		}
+ 		goto nextEvent;
+ 	    }
+ 	    if (eventPtr->xany.window != window) {
  		goto nextSequence;
  	    }

From: ouster@sprite.Berkeley.EDU (John Ousterhout)
Newsgroups: comp.lang.tcl
Subject: Re: Tk3.0 bug?
Date: 22 Dec 92 16:59:18 GMT
Organization: U.C. Berkeley Sprite Project
NNTP-Posting-Host: tyranny.berkeley.edu

Mea culpa.  When I posted a patch yesterday for the bug whereby
"wm withdraw" didn't work correctly, I forgot that I've made
several changes to tkWm.c since the release, and I didn't get them
all in the patch.  Here's a better tkWm.c patch:

*** /tmp/,RCSt1084828	Tue Dec 22 08:57:35 1992
--- tkWm.c	Mon Dec 21 11:43:16 1992
***************
*** 206,211 ****
--- 206,214 ----
   * WM_VROOT_OFFSET_STALE -	non-zero means that (x,y) offset information
   *				about the virtual root window is stale and
   *				needs to be fetched fresh from the X server.
+  * WM_ABOUT_TO_MAP -		non-zero means that the window is about to
+  *				be mapped by TkWmMapWindow.  This is used
+  *				by UpdateGeometryInfo to modify its behavior.
   */
  
  #define WM_NEVER_MAPPED		1
***************
*** 215,220 ****
--- 218,224 ----
  #define WM_UPDATE_SIZE_HINTS	0x10
  #define WM_SYNC_PENDING		0x20
  #define WM_VROOT_OFFSET_STALE	0x40
+ #define WM_ABOUT_TO_MAP		0x100
  
  /*
   * This module keeps a list of all top-level windows, primarily to
***************
*** 382,391 ****
      XTextProperty textProp;
      int savedX, savedY, savedFlags;
  
-     if (wmPtr->hints.initial_state == WithdrawnState) {
- 	return;
-     }
      if (wmPtr->flags & WM_NEVER_MAPPED) {
  	/*
  	 * This is the first time this window has ever been mapped.
  	 * Store all the window-manager-related information for the
--- 386,394 ----
      XTextProperty textProp;
      int savedX, savedY, savedFlags;
  
      if (wmPtr->flags & WM_NEVER_MAPPED) {
+ 	wmPtr->flags &= ~WM_NEVER_MAPPED;
+ 
  	/*
  	 * This is the first time this window has ever been mapped.
  	 * Store all the window-manager-related information for the
***************
*** 427,433 ****
--- 430,441 ----
  	    }
  	}
      }
+     if (wmPtr->hints.initial_state == WithdrawnState) {
+ 	return;
+     }
+     wmPtr->flags |= WM_ABOUT_TO_MAP;
      UpdateGeometryInfo((ClientData) winPtr);
+     wmPtr->flags &= ~WM_ABOUT_TO_MAP;
  
      /*
       * Map the window, wait to be sure that the window manager has
***************
*** 435,441 ****
       * if there were explicit positions asked for.
       */
  
-     wmPtr->flags &= ~WM_NEVER_MAPPED;
      XMapWindow(winPtr->display, winPtr->window);
      savedX = wmPtr->x;
      savedY = wmPtr->y;
--- 443,448 ----
***************
*** 585,590 ****
--- 592,603 ----
      char c;
      int length;
  
+     if (argc < 2) {
+ 	wrongNumArgs:
+ 	Tcl_AppendResult(interp, "wrong # args: should be \"",
+ 		argv[0], " option window ?arg ...?\"", (char *) NULL);
+ 	return TCL_ERROR;
+     }
      c = argv[1][0];
      length = strlen(argv[1]);
      if ((c == 't') && (strncmp(argv[1], "tracing", length) == 0)
***************
*** 602,610 ****
      }
  
      if (argc < 3) {
! 	Tcl_AppendResult(interp, "wrong # args: should be \"",
! 		argv[0], " option window ?arg ...?\"", (char *) NULL);
! 	return TCL_ERROR;
      }
      winPtr = (TkWindow *) Tk_NameToWindow(interp, argv[2], tkwin);
      if (winPtr == NULL) {
--- 615,621 ----
      }
  
      if (argc < 3) {
! 	goto wrongNumArgs;
      }
      winPtr = (TkWindow *) Tk_NameToWindow(interp, argv[2], tkwin);
      if (winPtr == NULL) {
***************
*** 1235,1243 ****
  	    wmPtr->protPtr = protPtr;
  	    protPtr->interp = interp;
  	    strcpy(protPtr->command, argv[4]);
- 	    if (!(wmPtr->flags & WM_NEVER_MAPPED)) {
- 		UpdateWmProtocols(wmPtr);
- 	    }
  	}
  	if (!(wmPtr->flags & WM_NEVER_MAPPED)) {
  	    UpdateWmProtocols(wmPtr);
--- 1246,1251 ----
***************
*** 1970,1976 ****
  	return;
      }
  
!     if (!(wmPtr->flags & WM_NEVER_MAPPED)) {
  	int savedX, savedY, savedFlags;
  
  	savedX = wmPtr->x;
--- 1978,1991 ----
  	return;
      }
  
!     /*
!      * Wait for the configure operation to complete, then verify that the
!      * window was positioned where it was supposed to be and adjust it if
!      * it wasn't.  Don't need to do this, however, if the window is about
!      * to be mapped:  it will be taken care of elsewhere.
!      */
! 
!     if (!(wmPtr->flags & WM_ABOUT_TO_MAP)) {
  	int savedX, savedY, savedFlags;
  
  	savedX = wmPtr->x;

