/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 

/*
 * OT 3.0.2
 */


/*
 *	otQuery.c
 *
 */


/*
#include <stdlib.h>
*/
#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <pwd.h>
#include <tcl.h>
#include <tclInt.h>
#include "ot.h"
#include "otInt.h"


#ifndef LINT
static char RCSid_otQuery[] =
    "$RCSfile: otQuery.c,v $ $Revision: 1.1.6.1 $ $Date: 1993/12/30 23:22:27 $";
#endif


void otPrintCountSummary();
OTErr otGetIDindex();
void otGetNextNum();

OTErr otPrintFullReportToString();
void otPrintFullNamesToString();

bool 	saveNote = FALSE;
bool	doFilterNum = FALSE;
bool	didOne = FALSE;
int 	oloop;
int	iloop;



OTErr
otInitQuery()
{
    register int i;
    OTMetaTemplate *mFilter;
    OTProject   *pStruct;       /* project structure */

    OTErr errCode = OT_SUCCESS;

    pStruct = otCB->cb_pcb->pcb_project; 

/* Create a meta template structure to hold filter values */

    if (errCode = otDupMetaTemplate(pStruct->otmp, &mFilter))
	return errCode;

    otCB->cb_qcb->qcb_filter = mFilter;
    otCB->cb_qcb->qcb_keywordMatchFound = FALSE;

/* Form an array of status names for summary */

    otFormStatusArray();

/* Clear filter values */

    for (i=0;  mFilter[i].field[0];  i++) {  
	mFilter[i].line[0] = 0;
	mFilter[i].list[0] = 0;
	mFilter[i].range[0] = 0;
    }

    if (errCode = otSetCBMember("operation", "QUERY") )
	return errCode;

/* If OT_LAYOUT env. var. is not set, take the project default layout */

    if (!otCB->cb_layout) 
	errCode = otSetCBMember("layout", pStruct->default_layout);

    return errCode;
}



void
otFormStatusArray()
{
    register int i, j, k;
    register char * cp;
    OTMetaTemplate *Filter;

    Filter = otCB->cb_qcb->qcb_filter;

/* Form an array of status names for summary */

    for (i=0;  Filter[i].field[0];  i++) {
	if (!strcmp("Status", Filter[i].field)) {
	    cp = Filter[i].opts;
	    for (i=j=k=0; cp[i] && j<=(MAXNUMSTAT-1) ; i++) {
		if (!strchr(OPT_CHARS, cp[i]) )
		    otCB->cb_pcb->pcb_statName[j][k++] = cp[i];
		if (cp[i] == ',') {
		    otCB->cb_pcb->pcb_statName[j][k] = 0;
		    j++; k = 0;
		}
	    }
	    if (j<(MAXNUMSTAT-1))
		strcpy(otCB->cb_pcb->pcb_statName[++j], "other");
	    break;
	}
    }

    return;
}



OTErr
otSetQlayout(value)
char *value;
{
    OTErr errCode = OT_SUCCESS;

    if (!strcmp(value, "all"))    {
	if (!(errCode = otSetCBMember("layout",
			    otCB->cb_pcb->pcb_project->all_layout))) {
	    if (otCB->cb_qcb->qcb_outwidth == 80)
		errCode = otSetQCBMember("outwidth", "120");
        }
    } else
	    errCode = otSetCBMember("layout", value);

    return errCode;
}


OTErr
otSetQfullText(value)
char *value;
{
    OTErr errCode = OT_SUCCESS;

    if (!strcmp(value, "TRUE")) {
        if (!(errCode = otSetQCBMember("skipHeader", "TRUE")))
	    errCode = otSetQCBMember("fullText", "TRUE");
    }
    else if (!strcmp(value, "FALSE")) {
	errCode = otSetQCBMember("fullText", "FALSE");
    }

    return(errCode);
}


OTErr
otSetQmetrics(value)
char *value;
{
    OTErr errCode = OT_SUCCESS;

    if (!strcmp(value, "TRUE")) {
	if (!(errCode = otSetQCBMember("count", "TRUE")))
	    errCode = otSetQCBMember("summary", "TRUE");
    }
    else if (!strcmp(value, "FALSE")) {
	if (!(errCode = otSetQCBMember("count", "FALSE")))
	    errCode = otSetQCBMember("summary", "FALSE");
    }

    return(errCode);
}



OTErr
otSetQhistory(value)
char *value;
{
    OTErr errCode = OT_SUCCESS;

    if (!strcmp(value, "TRUE")) {
	if ( !(errCode = otSetQCBMember("skipHeader", "TRUE")) && 
	     !(errCode = otSetQCBMember("fullText", "TRUE")) )
	    errCode = otSetQCBMember("historyLines", "TRUE");
    }
    else if (!strcmp(value, "FALSE")) 
	errCode = otSetQCBMember("historyLines", "FALSE");

    return(errCode);
}



OTErr
otSetQCRNumber(value)
char *value;
{
    int i;
    OTMetaTemplate *Filter;

    OTErr errCode = OT_SUCCESS;
    Filter = otCB->cb_qcb->qcb_filter;

/* Locate TYPE_IDNUM field within Filter meta template */
    if (errCode = otGetIDindex(Filter, &i))
	return errCode;

    if (!value || !value[0])       {
        errCode = OT_ARGUMENT_NO_VALUE;
        otPutPostedMessage(OT_ARGUMENT_NO_VALUE, "-n");
    }
    else if ((otCB->cb_pcb->pcb_CRNumber = atol(value)) <= 0)  {
	errCode = OT_CLI_ZERO_NUMBER;
    	otPutPostedMessage(OT_CLI_ZERO_NUMBER, "-n (number)");
    }
    else {                  /* special case of looking for specific CRs */
	strcpy(Filter[i].line, value);

	otCB->cb_pcb->pcb_filterNum[0] = 0;

	if ( Filter[i].line[0] && (errCode = otParseNumFilter(i)) ) 
	    return(errCode);
	
	if (!Filter[i].range[0]) 	{    /* special filter by CR numbers */
	    strcpy(otCB->cb_pcb->pcb_filterNum, Filter[i].list);
	    Filter[i].list[0] = 0;
	}
	else
	    errCode = otSetRange(Filter[i].range, &otCB->cb_qcb->qcb_loRange,
				&otCB->cb_qcb->qcb_hiRange);
    }

    return(errCode);
}



OTErr
otSetQselect(optarg)
char *optarg;
{
    register int i, j, quote;
    char * field, * value;
    OTQueryCB * qcb = otCB->cb_qcb;
    OTErr errCode = OT_SUCCESS;

    field = strdup(optarg);
    value = strdup(optarg);

/* process list of field=value pairs */

    for (i=0;  optarg[i];  i++)    {

	field[0] = value[0] = 0;    /* get next field name */
	quote = 0;		    /* no quotes outstanding */

    /* get field name (before '=') */

        for (j=0;  optarg[i] && (optarg[i] != '=');  i++, j++)
	    field[j] = optarg[i];
	field[j] = 0;

	if (!optarg[i])	{
	    errCode = OT_ILLEGAL_SEARCH_SYNTAX;
	    otPutPostedMessage(OT_ILLEGAL_SEARCH_SYNTAX, field);
	    break;
	}

    /* get value -- watch out for quotes -- stop at next comma */

        for (i++, j=0;  optarg[i];  i++)	{

	    if ((optarg[i] == '"') || (optarg[i] == '\''))	{
	        if (quote == optarg[i])	{
		    quote = 0;	/* end of quoted arg */
		    continue;
		}
		if (quote)
		    value[j++] = optarg[i];	/* diff quote -- pass it */
		else
		    quote = optarg[i];	/* new quote */
		continue;
	    }

	    if (optarg[i] == '\\')    {	/* quote the next character */
		if (optarg[i+1])
		    value[j++] = optarg[++i];
		continue;
	    }

	    if (!quote && optarg[i] == ',')
	        break;			/* end of value */

	    value[j++] = optarg[i];		/* just a regular character */
	}
	value[j] = 0;		/* terminate */

	if (!optarg[i])
	    i--;			/* backup for proper list termination */

 /* got field and value -- now set info in the qcb_filter metatempl structure */

	DBUG_MIN((stderr, "parse -s field '%s' value '%s'\n", field, value));

        if (!strcmp(field, "cby")) {             /* special: comment by */
	    if (errCode = otSetQCBMember("cby", value) )  
	        break;
	}
	else if (!strcmp(field, "cdate")) {	/* special: comment date */
	    if (errCode = otSetQCBMember("cdate", value) )
		break;
	}
	else if (!strcmp(field, "csens")) {	/* special: cmt sensitivity */
	    if (errCode = otSetQCBMember("csens", value) )
		break;
	}
	else if (!strcmp(field, "nsens")) { 	/* special: note sensitivity */
	    if (errCode = otSetQCBMember("nsens", value) )
		break;
	}
	else    {	/* Look through proj-specific info for filter value */
	    if (errCode = otSetFilterValue(field, value, qcb->qcb_filter) )
		break;
	}
    }
    free(field);
    free(value);

    return(errCode);
}



OTErr
otSetTclEvalFile(value)
char *value;
{
    int fd, res;
    Tcl_Interp *interp;

    OTErr errCode = OT_SUCCESS;
    interp = otCB->cb_pcb->pcb_interp;

    if (value) {
	if ( (fd = open(value, 0)) != -1) {
	    if ((res = Tcl_EvalFile(interp, value)) == TCL_ERROR) {
		otPutPostedMessage(OT_TCLCMDFILE, value, interp->errorLine, 
				    interp->result);
		errCode = OT_TCLCMDFILE;
	    }
	}
    }

    return(errCode);
}



OTErr
otSetupQuery()
{
    register char * cp1;

    OTErr errCode = SUCCESS;

/* Set up sort */
    /* Sort of the output doesn't work in full report mode.
     * Only when we get the header out will be actually use
     * the pipe to the sort.
     */
    if ( otCB->cb_qcb->qcb_sortField && (errCode = otSetupSort()) ) {
        cp1 = otGetPostedMessage();
	fprintf(stderr, "otSetupSort: %s\n", cp1);
	errCode = OT_SUCCESS;
    }

    if (otCB->cb_pcb->pcb_imTheServer)
	errCode = otReadTopNumber(otCB->cb_pcb->pcb_project, 
	    &otCB->cb_pcb->pcb_topNumber);

    return(errCode);
}



OTErr
otSetupSort()
{
    register int i, j;
    register char *cp, *cp1;
    char *layout;
    char newwidth[5];
    char field[NAMELEN];
    char command[COMMAND];

    OTErr errCode = SUCCESS;

    if ( !(layout = malloc(strlen(otCB->cb_layout) + 2)) ) {
	otPutPostedMessage(OT_MALLOC_LOCATION, "otSetupSort()");
	otPutPostedMessage(OT_NO_SORT_PIPE);
	return OT_MALLOC_LOCATION;
    }
    strcpy(layout, otCB->cb_layout);

    for (j=0, cp=layout;  cp[0];  ) { 

    /* Get total width up to field of interest */
        for (i=0;  cp[i] && (cp[i] != ',');  i++)
	    field[i] = cp[i];
        field[i] = 0;

	strcpy(newwidth, "");
	if (cp1=strchr(field, ':')) {
	    *cp1 = 0;
	    strcpy(newwidth, ++cp1);
	}

        if (!strcmp(field, otCB->cb_qcb->qcb_sortField))
	    break;
        else if (!cp[i])    {
	    otPutPostedMessage(OT_UNKNOWN_SORT_FLD, 
				otCB->cb_qcb->qcb_sortField, otCB->cb_layout);
	    errCode = OT_UNKNOWN_SORT_FLD;
	    j = -1;
	    break; 
        }

	if (cp[i])
	    cp = &cp[i+1];  /* next item in layout spec */
	else
	    cp = &cp[i];    /* end of list */

	if (newwidth[0])    /* overwrite default width */
	    j += abs(atoi(newwidth)) + 1;
	else {
	    for (i=0;  otCB->cb_qcb->qcb_filter[i].field[0];  i++)  {
	        if (!strcmp(otCB->cb_qcb->qcb_filter[i].abbr, field)) {
		    j += atoi(otCB->cb_qcb->qcb_filter[i].width) + 1;
		    break;
		}
	    }
	}
    }

    /* Now, create a pipe to the sort function */

    if (j >= 0) {
        sprintf(command, "sort +.%d -t\04", j); 
        if ((otCB->cb_pcb->pcb_sortPipe = popen(command, "w")) == NULL) {
	    otPutPostedMessage(OT_NO_SORT_PIPE);
	    errCode = OT_NO_SORT_PIPE;
	    otCB->cb_pcb->pcb_sortPipe = stdout;
	}
    }
    DBUG_MIN((stderr, "otSetupSort: sort pipe = %d\n", otCB->cb_pcb->pcb_sortPipe));

    free(layout);
    return(errCode);
}


/* otProcessCR 
 *   upon successfull return "pcb->pcb_CRmatch" indicator is set to "1" 
 *   if template values match all filter patterns stuffed in qcb_filter 
 *   (of type OTMetaTemplate).
 */
OTErr
otProcessCR(tStruct)
OTTemplate * tStruct;      /* the current template */
{
    register int i, statMatch;
    register char * cp;
    long    num;
    bool    range = FALSE;
    OTQueryCB * qcb = otCB->cb_qcb;
    OTPrivateCB * pcb = otCB->cb_pcb;
    OTMetaTemplate *Filter = qcb->qcb_filter;
    OTErr errCode = OT_SUCCESS;

    if (otCB->cb_tclString) {
	/* User defined a code string for query */
	return otProcessTcl(tStruct);
    }

/* Compare each Filter value to appropriate value(s) in template. */
    for (i=0;  Filter[i].field[0];  i++) {

	if ( ! Filter[i].line[0] ) {

	    /*
	     * Handle null spec's here (e.g., "ot_bugs -code '').
	     */
	    if ( Filter[i].unassigned ) {
		if (cp = otGetHeaderFieldValue(Filter[i].field, tStruct)) {
		    if (*cp != '\000')  /* has a value for an unassigned fld */
			return errCode; 
		}
	    }
	}
	else {

	    if (!(cp = otGetHeaderFieldValue(Filter[i].field, tStruct)))
		return errCode;       /* no value in field */

	    /*
	     * Special filter for the range of CR #'s
	     *
	     * This code will be replaced by generic call for
	     * numeric fields when better field types will be
	     * added to the template structure and Compare
	     * routine will be split by types and caller indicator.
	     */

	    if (Filter[i].type == TYPE_IDNUM) {
		if (Filter[i].range[0]) {
		   num = atol(cp);
		   if ( (num >= qcb->qcb_loRange) && (num <= qcb->qcb_hiRange) )
			range = TRUE;
		}

		if ( !range && (otCompList(cp, Filter[i].list)) )
		    return errCode;
	    }
	    else {
		if (otCompare(cp, Filter[i].type, Filter[i].line))
		    return errCode;   /* do stand-zed test */
	    }
	}
    }


    if (qcb->qcb_keyInText ) {
	char *startp, *nextp, *tp;
	int n;

	if ( tStruct->notep ) {

	    for (n = 0; (tStruct->notep[n].who[0]) && (n < MAXNOTES); n++) {

		if ( qcb->qcb_nsens && 
			    strcmp(qcb->qcb_nsens, tStruct->notep[n].sens) )
		    continue;

		tp = strdup(tStruct->notep[n].text);
		startp = nextp = tp;

		while ( nextp && *nextp && !(pcb->pcb_CRmatch) ) { 
		    startp = nextp;
		    /*
		     * Break into separate lines for strstr().
		     * Actually not necessary but we may need to use regexp()
		     * again.
		     */
		    if (nextp = strchr(startp, '\n') ) {
			*nextp = '\000';
			nextp++;
		    }
    
		    if ( strstr(startp, qcb->qcb_keyInText) ) 
			pcb->pcb_CRmatch = 1;  
		}
		free(tp);
	    }
	}

	if (! pcb->pcb_CRmatch)
	    return errCode;  /* return if no text match */
    }

    /* Passed filtering.. do summary work */

    pcb->pcb_bugCount++;            /* count of matching bugs */

    if (qcb->qcb_summary)    {

	/* Count bugs per priority, severity and status values */

	cp = otGetHeaderFieldValue("Priority", tStruct);
	if (cp && (*cp >= '0') && (*cp <= '4'))
	    pcb->pcb_sumPrior[*cp - '0']++;
	cp = otGetHeaderFieldValue("Severity", tStruct);
	if (cp && (*cp >= 'A') && (*cp <= 'F'))
	    pcb->pcb_sumSever[*cp - 'A']++;

	cp = otGetHeaderFieldValue("Status", tStruct);
	if ( cp ) {
	    statMatch = 0;
	    for (i=0; (pcb->pcb_statName[i][0]) && !statMatch ; i++) {
		if (!strcmp(cp, pcb->pcb_statName[i])) {
		    pcb->pcb_sumStat[i]++;
		    statMatch = 1;
		}
	    }
	    if (!statMatch) {
		for (i=0; pcb->pcb_statName[i][0]; i++) {
		    if (!strcmp(pcb->pcb_statName[i], "other"))
			pcb->pcb_sumStat[i]++;
		}
	    }
	}
    }

    /* Nothing else to do.. */
    pcb->pcb_CRmatch = 1;

    return errCode;
}



/* process_X - Process ot_talk string specified w/ -x flag */
OTErr
otProcessTcl(tStruct)
OTTemplate *tStruct;
{
    int result, res;
    Tcl_Interp *interp;
    OTErr errCode = OT_SUCCESS;
    OTPrivateCB * pcb = otCB->cb_pcb;   /* private control block structure */
    interp = pcb->pcb_interp;

    pcb->pcb_template = tStruct;
    DBUG_MED((stderr, "Tcl_Eval to interpret %s\n", otCB->cb_tclString));    
    res = Tcl_ExprBoolean(interp, otCB->cb_tclString, &result);
    DBUG_MED((stderr, "Tcl_Eval returns %d, interp res is %s\n", res, interp->result));
    pcb->pcb_template = 0;

    if (res != TCL_OK) {
	otPutPostedMessage( OT_TCL, interp->result );
	errCode = OT_TCL;
    }
    else {
        if (result) {
            DBUG_MED((stderr, "returned true...\n"));
	    pcb->pcb_CRmatch = 1;
	}
	else {
            DBUG_MED((stderr, "ott_exec returned FALSE\n"));
        }
    }
    return(errCode);
}



/* otPrintOneCR - Print one CR, or header, as the case may be. */
OTErr
otPrintOneCR(tStruct, mStruct, header)
OTTemplate * tStruct;          /* Ptr to template to print.            */
OTMetaTemplate * mStruct;     /* Ptr to metatemplate information      */
bool header;                    /* If true, print header.           */
{
    OTErr errCode = OT_SUCCESS;
    OTQueryCB * qcb = otCB->cb_qcb;

    if ( !(qcb->qcb_count || qcb->qcb_summary) ) {

        if (qcb->qcb_fullText)
	    /* First method is the full text (eg, complete report) type */
	    errCode = otPrintFullReport(tStruct);
        else
	    errCode = otPrintOneLiner(tStruct, mStruct, header);
    }

    return(errCode);
}



OTErr
otPrintOneLiner(tStruct, mStruct, header)
OTTemplate * tStruct;          /* Ptr to template to print.            */
OTMetaTemplate * mStruct;     /* Ptr to metatemplate information      */
bool header;                    /* If true, print header.           */
{
    register int i, len;
    register char *cp, *tp, *lp, *fn, *crp, *cp1, *fieldname;
    register OTHeaderField *hfp;
    char newwidth[5];
    char field[NAMELEN];
    char format[SHORTSTR];
    char prbuf[MAXWIDTH];
    bool overflow = FALSE;

    bool pseudoField;
    char tclStr[LONGVALUE];
    char width[LONGVALUE];
    char hdrBuf[LONGVALUE];
    int tclRes;
    Tcl_Interp *interp = otCB->cb_pcb->pcb_interp;

    OTErr errCode = OT_SUCCESS;
    OTQueryCB * qcb = otCB->cb_qcb;

    lp = otCB->cb_layout;
    cp = prbuf;
    prbuf[0] = 0;

    while (*lp && !overflow) {

        pseudoField = FALSE;
	width[0] = 0;
	for (i=0;  lp[i] && (lp[i] != ',');  i++)
	    field[i] = lp[i];
	field[i] = 0;

	if (lp[i])
	    lp = &lp[i+1];  /* point at next item in layout spec */
	else
	    lp = &lp[i];    /* end of list */

    /* get new width from the OT_LAYOUT. It will overwrite default value */
	strcpy(newwidth, "");
	if (cp1=strchr(field, ':')) {
	    *cp1 = 0;
	    strcpy(newwidth, ++cp1);
	}

	for (i=0;  mStruct[i].field[0];  i++)
	    if (!strcmp(mStruct[i].abbr, field)) {
		strcpy(width, mStruct[i].width);
		break;
	}
	if ( mStruct[i].field[0] ) {
	    if (header)
		tp = mStruct[i].head;   /* header text */
	    else {
		fieldname = mStruct[i].field;

		tp = 0;
		for (hfp = tStruct->tr; hfp && hfp->field && *hfp->field; hfp++)
		    if ( (*fieldname == *hfp->field) && !strcmp(fieldname,
			hfp->field) )
			tp = hfp->value;
		if (!tp)
		    tp = "";

	    }
	} else {

	    /*
	     * Pseudo-field support.
	     * See if there is a tcl proc by the name 'field'.
	     */
	    sprintf(tclStr, "info commands %s", field);

	    if ( ((tclRes = Tcl_Eval(interp, tclStr)) == TCL_OK) &&
		(!strcmp(interp->result, field)) ) {

		pseudoField = TRUE;

		sprintf(tclStr, "%s info width\n", field);
		if ( (tclRes = Tcl_Eval(interp, tclStr)) != TCL_OK )
		    strcpy(width, "8");
		else
		    strcpy(width, interp->result);

		if ( header ) {
		    sprintf(tclStr, "%s info header\n", field);
		    if ( (tclRes = Tcl_Eval(interp, tclStr)) != TCL_OK )
			tp = "";
		    else {
		        strcpy(hdrBuf, interp->result);
			tp = hdrBuf;
		    }
		} else {
		    sprintf(tclStr, "%s\n", field);
		    if ( (tclRes = Tcl_Eval(interp, tclStr)) == TCL_OK )
			tp = interp->result;
		    else {
			otPutPostedMessage(OT_TCL_CALLER, field,
			    "no such field");
			return OT_TCL_CALLER;
		    }
		}

	    }
	}

	if (newwidth[0])      /* overwrite default value for field's width */
	    strcpy(width, newwidth);

    /* Handle negative width */
	if (atoi(width) < 0 ) {
	    cp1 = &width[1]; 
	    strcpy(width, cp1);  /* make it positive */

	/* Display the rightmost "width" number of charactaers */
	    if (!header && (atoi(width) < strlen(tp)) ) 
		tp = tp + strlen(tp) - atoi(width);
	}

	if (!strcmp(field, "num"))
	    sprintf(format, "%%%s.%ss", width, width);
	else
	    sprintf(format, "%%-%s.%ss", width, width);

	DBUG_MED((stderr, "otPrintOneLiner: format spec: '%s' field '%s' value '%s'\n", format, field, tp));

	if ( *tp && ( mStruct[i].type == TYPE_DATE) && !header && !pseudoField ) {
	    char *tdates = strdup(tp);
	    char *dateBuf, *xp;
	    int plen;

	    *cp = 0;
	    if ( !(dateBuf = malloc(strlen(tp) * 2)) ) {
		otPutPostedMessage( OT_MALLOC_LOCATION, "otPrintOneLiner()" );
		return OT_MALLOC_LOCATION;
	    }
	    *dateBuf = 0;

	    for (xp = strtok(tdates, ", \n"); xp; xp = strtok(NULL, ", \n")) {
		char shortDate[9], *countp;
		int mon,day,year;
		int bs = 2;
            
		for(countp = xp; *countp && bs; countp++)
		    if (*countp == '/') 
			bs--;
               
		if (bs == 0) {
		    if (*countp == '1' && *(countp + 1) == '9' && *(countp+2))
			sscanf(xp, "%d/%d/19%d", &mon, &day, &year);
		    else
			sscanf(xp, "%d/%d/%d", &mon, &day, &year);

	 	    sprintf(shortDate, "%02d/%02d/%02d", mon,day,year);
		    if ( xp != tdates )
			strcat(dateBuf, ", ");
		    strcat(dateBuf, shortDate);
		} else {
		    if ( xp != tdates )
			strcat(dateBuf, ", ");
		    strcat(dateBuf, xp);
		}
	    } /* for */

	    if ((strlen(prbuf) + atoi(width)) < MAXWIDTH)
		sprintf(cp, format, dateBuf); /* value for output */
	    else
		overflow = TRUE;
	    free(tdates);
	    free(dateBuf);
	}
	else {
	    if ((strlen(prbuf) + atoi(width)) < MAXWIDTH)
	        sprintf(cp, format, tp);        /* value for output */
	    else 
	        overflow = TRUE;
	}

	for ( ; *cp; cp++ )
	    if ( (*cp == '\n') || (*cp == '\t') )
		*cp = ' ';

	if (qcb->qcb_tabSeparate) {
	    *cp++ = '\t';
	    *cp = 0;
	}
	else {
	    *cp++ = ' ';
	    *cp = 0;
        }
    }

    len = strlen(prbuf);
    while (--len && isspace(prbuf[len]))    /* nuke trailing white space */
	prbuf[len] = 0;

    len = strlen(prbuf);
    if (qcb->qcb_outwidth < len)
	prbuf[qcb->qcb_outwidth] = 0;        /* truncate to desired len */

    fprintf(qcb->qcb_outputFile, "%s\n", prbuf);        /* output it */

    return(errCode);
}



OTErr
otPrintFullReport(tStruct)
OTTemplate * tStruct;          /* Ptr to template to print.            */
{
    register int i;
    char format[SHORTSTR];

    OTErr errCode = OT_SUCCESS;
    OTQueryCB * qcb = otCB->cb_qcb;

    sprintf(format, "%%-0%ds: %%s\n", FIELDSWIDTH);

    for (i=0;  tStruct->tr[i].field[0];  i++) {

        if ( (tStruct->tr[i].type == TYPE_MAILNAME ) &&
		 	(tStruct->tr[i].value != (char *)0) ) {
	    otPrintFullNames( &(tStruct->tr[i]) );

	} else
	    fprintf(stdout, format, tStruct->tr[i].field,
		    tStruct->tr[i].value ? tStruct->tr[i].value : "");
    }

    fprintf(stdout, "\n");

    for (i = 0; (tStruct->notep[i].who[0]) && (i < MAXNOTES); i++)
	if (tStruct->notep[i].text) {
	   if ( qcb->qcb_nsens && 
			    strcmp(qcb->qcb_nsens, tStruct->notep[i].sens) )
		continue;
	   if (errCode = otPrintNote(stdout, tStruct->notep[i].text, 
			    			    qcb->qcb_historyLines) ) 
		return(errCode);

	   fprintf(stdout, "\n");
	}

    fprintf(stdout, "\f\n");
    return(errCode);
}

OTErr
otPrintOneLinerToString(tStruct, mStruct, header, str)
OTTemplate * tStruct;          /* Ptr to template to print.            */
OTMetaTemplate * mStruct;     /* Ptr to metatemplate information      */
bool header;                    /* If true, print header.           */
char *str;
{
    register int i, len;
    register char *cp, *tp, *lp, *fn, *crp, *cp1;
    char newwidth[5];
    char field[NAMELEN];
    char format[SHORTSTR];
    char prbuf[MAXWIDTH];
    bool overflow = FALSE;

    bool pseudoField;
    char tclStr[LONGVALUE];
    char width[LONGVALUE];
    char hdrBuf[LONGVALUE];
    int tclRes;
    Tcl_Interp *interp = otCB->cb_pcb->pcb_interp;

    OTErr errCode = OT_SUCCESS;
    OTQueryCB * qcb = otCB->cb_qcb;

    str += strlen(str);
    lp = otCB->cb_layout;
    cp = prbuf;
    prbuf[0] = 0;

    while (*lp && !overflow) {

        pseudoField = FALSE;
	for (i=0;  lp[i] && (lp[i] != ',');  i++)
	    field[i] = lp[i];
	field[i] = 0;

	if (lp[i])
	    lp = &lp[i+1];  /* point at next item in layout spec */
	else
	    lp = &lp[i];    /* end of list */

    /* get new width from the OT_LAYOUT. It will overwrite default value */
	strcpy(newwidth, "");
	if (cp1=strchr(field, ':')) {
	    *cp1 = 0;
	    strcpy(newwidth, ++cp1);
	}

	for (i=0;  mStruct[i].field[0];  i++)
	    if (!strcmp(mStruct[i].abbr, field)) {
		strcpy(width, mStruct[i].width);
		break;
	}
	if ( mStruct[i].field[0] ) {
	    if (header)
		tp = mStruct[i].head;   /* header text */
	    else {
		if (!(tp = otGetHeaderFieldValue(mStruct[i].field, tStruct)))
		    tp = "";
	    }
	} else {

	    /*
	     * Pseudo-field support.
	     * See if there is a tcl proc by the name 'field'.
	     */
	    sprintf(tclStr, "info commands %s", field);

	    if ( ((tclRes = Tcl_Eval(interp, tclStr)) == TCL_OK) &&
		(!strcmp(interp->result, field)) ) {

		pseudoField = TRUE;

		sprintf(tclStr, "%s info width", field);
		if ( (tclRes = Tcl_Eval(interp, tclStr)) != TCL_OK )
		    strcpy(width, "8");
		else
		    strcpy(width, interp->result);

		if ( header ) {
		    sprintf(tclStr, "%s info header", field);
		    if ( (tclRes = Tcl_Eval(interp, tclStr)) != TCL_OK )
			tp = "";
		    else {
		        strcpy(hdrBuf, interp->result);
			tp = hdrBuf;
		    }
		} else {
		    sprintf(tclStr, "%s", field);
		    if ( (tclRes = Tcl_Eval(interp, tclStr)) == TCL_OK )
			tp = interp->result;
		    else
			tp = "";
		}

	    }
	}

	if (newwidth[0])      /* overwrite default value for field's width */
	    strcpy(width, newwidth);

    /* Handle negative width */
	if (atoi(width) < 0 ) {
	    cp1 = &width[1]; 
	    strcpy(width, cp1);  /* make it positive */

	/* Display the rightmost "width" number of charactaers */
	    if (!header && (atoi(width) < strlen(tp)) ) 
		tp = tp + strlen(tp) - atoi(width);
	}

	if (!strcmp(field, "num"))
	    sprintf(format, "%%%s.%ss", width, width);
	else
	    sprintf(format, "%%-%s.%ss", width, width);

	DBUG_MED((stderr, "otPrintOneLiner: format spec: '%s' field '%s' value '%s'\n", format, field, tp));

	if ( *tp && ( mStruct[i].type == TYPE_DATE) && !header && !pseudoField ) {
	    char *tdates = strdup(tp);
	    char *dateBuf, *xp;
	    int plen;

	    *cp = 0;
	    if ( !(dateBuf = malloc(strlen(tp) * 2)) ) {
		otPutPostedMessage( OT_MALLOC_LOCATION, "otPrintOneLiner()" );
		return OT_MALLOC_LOCATION;
	    }
	    *dateBuf = 0;

	    for (xp = strtok(tdates, ", \n"); xp; xp = strtok(NULL, ", \n")) {
		char shortDate[9], *countp;
		int mon,day,year;
		int bs = 2;
            
		for(countp = xp; *countp && bs; countp++)
		    if (*countp == '/') 
			bs--;
               
		if (bs == 0) {
		    if (*countp == '1' && *(countp + 1) == '9' && *(countp+2))
			sscanf(xp, "%d/%d/19%d", &mon, &day, &year);
		    else
			sscanf(xp, "%d/%d/%d", &mon, &day, &year);

	 	    sprintf(shortDate, "%02d/%02d/%02d", mon,day,year);
		    if ( xp != tdates )
			strcat(dateBuf, ", ");
		    strcat(dateBuf, shortDate);
		} else {
		    if ( xp != tdates )
			strcat(dateBuf, ", ");
		    strcat(dateBuf, xp);
		}
	    } /* for */

	    if ((strlen(prbuf) + atoi(width)) < MAXWIDTH)
		sprintf(cp, format, dateBuf); /* value for output */
	    else
		overflow = TRUE;
	    free(tdates);
	    free(dateBuf);
	}
	else {
	    if ((strlen(prbuf) + atoi(width)) < MAXWIDTH)
	        sprintf(cp, format, tp);        /* value for output */
	    else 
	        overflow = TRUE;
	}

	for ( ; *cp; cp++ )
	    if ( (*cp == '\n') || (*cp == '\t') )
		*cp = ' ';

	if (qcb->qcb_tabSeparate) {
	    *cp++ = '\t';
	    *cp = 0;
	}
	else {
	    *cp++ = ' ';
	    *cp = 0;
        }
    }

    len = strlen(prbuf);
    while (--len && isspace(prbuf[len]))    /* nuke trailing white space */
	prbuf[len] = 0;

    len = strlen(prbuf);
    if (qcb->qcb_outwidth < len)
	prbuf[qcb->qcb_outwidth] = 0;        /* truncate to desired len */

    sprintf(str, "%s\n", prbuf);        /* output it */

    return(errCode);
}

OTErr
otPrintFullReportToString(tp, str)
OTTemplate * tp;          /* Ptr to template to print.            */
char *str;
{
    register int i;
    register OTHeaderField *hfp;
    register OTNote *notep;
    char format[SHORTSTR];
    char field[NAMELEN];
    OTErr err = OT_SUCCESS;
    OTQueryCB * qcb = otCB->cb_qcb;
    char *cp;

    char *lp = otCB->cb_layout;
    char *np;
    char tclStr[LONGVALUE];
    OTProject *prjp = otCB->cb_pcb->pcb_project;
    Tcl_Interp *interp = otCB->cb_pcb->pcb_interp;
    char *label, *value;
    int tclRes;

    str += strlen(str);
    sprintf(format, "%%-0%ds: %%s\n", FIELDSWIDTH);

    for (hfp = tp->tr; hfp->field && *hfp->field; hfp++)
	if ( hfp->type == TYPE_MAILNAME && hfp->value != 0 ) {
	    otPrintFullNamesToString( hfp, str );
	    str += strlen(str);
	} else {
	    sprintf(str, format, hfp->field, hfp->value ? hfp->value : "");
	    str += strlen(str);
	}

    while ( *lp ) {
	for (i=0;  lp[i] && (lp[i] != ',');  i++)
	    field[i] = lp[i];
	field[i] = 0;

	if (lp[i])
	    lp = &lp[i+1];  /* point at next item in layout spec */
	else
	    lp = &lp[i];    /* end of list */

	if ( !(np = otGetAbbrFieldName(field, prjp)) ) {
	    sprintf(tclStr, "info commands %s", field);
	    if ( ((tclRes = Tcl_Eval(interp, tclStr)) == TCL_OK ) &&
		(!strcmp(interp->result, field)) ) {

		sprintf(tclStr, "%s label", field);
		if ( (tclRes = Tcl_Eval(interp, tclStr)) == TCL_OK )
		    label = strdup(interp->result);
		else
		    label = strdup(field);

		sprintf(tclStr, "%s", field);
		if ( (tclRes = Tcl_Eval(interp, tclStr)) == TCL_OK )
		    value = interp->result;
		else
		    value = strdup(" ");

		sprintf(str, format, label, value);
		str += strlen(str);
		free(label);
		free(value);
	    }
	}

    }

    sprintf(str, "\n");
    str += strlen(str);

    for (notep = tp->notep; !err && notep->who && *notep->who; notep++)
	if (notep->text) {
	    if ( qcb->qcb_nsens && strcmp(qcb->qcb_nsens, notep->sens) )
		continue;
	    sprintf(str, "%s\n\n", notep->text);
	    str += strlen(str);
	}

    if ( !err && qcb->qcb_historyLines ) {
	if ( !(err = otWriteNotedataToString(tp, &cp)) ) {
	    if ( cp ) {
		if ( *cp ) {
		    strcpy(str, cp);
		    str += strlen(str);
		}
		free(cp);
	    }
	}
    }
    sprintf(str, "\f\n");

    return err;
}



void
otPrintCountSummary()
{
    register int i;

    OTProject   *pStruct = otCB->cb_pcb->pcb_project;
    OTPrivateCB * pcb = otCB->cb_pcb;
    OTQueryCB * qcb = otCB->cb_qcb;
    FILE *fp = qcb->qcb_outputFile;

    if (qcb->qcb_count && !pcb->pcb_quiet)
	fprintf(fp, "Total %ss selected:  %d\n", pStruct->object_name, 
							pcb->pcb_bugCount);

    if (qcb->qcb_summary && !pcb->pcb_quiet)   {
	fprintf(fp, "\n");
	for (i=0; i<=4; i++)
	    fprintf(fp, "Priority %d %d\n", i, pcb->pcb_sumPrior[i]);
	fprintf(fp, "\n");
	for (i=0; i<6; i++)
	    fprintf(fp, "Severity %c %d\n", (i+'A'), pcb->pcb_sumSever[i]);
	fprintf(fp, "\n");
	for (i=0; pcb->pcb_statName[i][0]; i++)
	   fprintf(fp, "Status %s\t%d\n", pcb->pcb_statName[i], pcb->pcb_sumStat[i]);
    }
    return;
}



void
otPrintFullNames(tLine)
OTHeaderField *   tLine;      /* Template line with list of names to expand */
{
    bool firstName = TRUE;
    char header[SHORTSTR];
    char tempvalue[LONGVALUE], *tp = tempvalue;
    char *startp, *nextp, *cp;
    struct passwd *pwent;

    sprintf(header, "%%-0%ds: ", FIELDSWIDTH);

    DBUG_MED((stderr, "printFullNames %s\n", tLine->value));

/* Split into an array of strings */

    strcpy(tp, tLine->value);
    startp = nextp = tp;

    if ( cp = strchr(startp, '#') )
        *cp = 0;
    otTrimWs(startp);

    fprintf(stdout, header, tLine->field);

    while ( nextp && *nextp ) {

	startp = nextp;
	if ( nextp = strchr(startp, ',') ) {
	    *nextp = '\000';
	    nextp++;
	    while (isspace(*nextp))
		nextp++;
	}

	if ( (pwent = getpwnam(startp)) != NULL ) {
	    char *cp = pwent->pw_gecos;

	    /*
	     * Just get the first part of the GCOS field (the
	     * name, not phone etc).
	     */
	    for( ; (cp && (*cp != ',') && (*cp != '\000')); cp++);
	    *cp = '\000';

	    if (firstName) {
		firstName = FALSE;
		fprintf(stdout, "%s (%s)", startp,
		    pwent->pw_gecos);
	    }
	    else
		fprintf(stdout, ", %s (%s)", startp,
		    pwent->pw_gecos);
	}
	else {
	    if (firstName) {
		firstName = FALSE;
		fprintf(stdout, "%s", startp);
	    }
	    else
		fprintf(stdout, ", %s", startp);
	}
    }
    fprintf(stdout, "\n");

}


OTErr
otPrintNote(fp, notep, rlog)
FILE *fp;
char *notep;
bool rlog;
{
    char *tmp;
    char *startp, *nextp;

    OTErr errCode = OT_SUCCESS;

    if ( (tmp = startp = nextp = strdup(notep)) == NULL ) {
	otPutPostedMessage( OT_MALLOC_LOCATION, "otPrintNote()" );
	return OT_MALLOC_LOCATION;
    }

    while (nextp && *nextp) {
	startp = nextp;
	if ( nextp = strchr(startp, '\n') ) 
	    *nextp++ = 0;

	if (rlog)
	    fprintf(fp, "%s\n", startp);
	else {
	    if (strncmp(startp, "+HISTORY", 8)) {
		fprintf(fp, "%s\n", startp);
	    }
	}
    }
    free(tmp);
    return errCode;
}


void
otPrintFullNamesToString(tLine,str)
OTHeaderField *   tLine;      /* Template line with list of names to expand */
char * str;
{
    bool firstName = TRUE;
    char header[SHORTSTR];
    char tempvalue[LONGVALUE], *tp = tempvalue;
    char *startp, *nextp, *cp;
    struct passwd *pwent;

    str += strlen(str);

    sprintf(header, "%%-0%ds: ", FIELDSWIDTH);

    DBUG_MED((stderr, "printFullNames %s\n", tLine->value));

/* Split into an array of strings */

    strcpy(tp, tLine->value);
    startp = nextp = tp;

    if ( cp = strchr(startp, '#') )
        *cp = 0;
    otTrimWs(startp);

    sprintf(str, header, tLine->field);
    str += strlen(str);

    while ( nextp && *nextp ) {

	startp = nextp;
	if ( nextp = strchr(startp, ',') ) {
	    *nextp = '\000';
	    nextp++;
	    while (isspace(*nextp))
		nextp++;
	}

	if ( (pwent = getpwnam(startp)) != NULL ) {
	    char *cp = pwent->pw_gecos;

	    /*
	     * Just get the first part of the GCOS field (the
	     * name, not phone etc).
	     */
	    for( ; (cp && (*cp != ',') && (*cp != '\000')); cp++);
	    *cp = '\000';

	    if (firstName) {
		firstName = FALSE;
		sprintf(str, "%s (%s)", startp, pwent->pw_gecos);
		str += strlen(str);
	    }
	    else {
		sprintf(str, ", %s (%s)", startp, pwent->pw_gecos);
		str += strlen(str);
	    }
	}
	else {
	    if (firstName) {
		firstName = FALSE;
		sprintf(str, "%s", startp);
		str += strlen(str);
	    }
	    else {
		sprintf(str, ", %s", startp);
		str += strlen(str);
	    }
	}
    }
    sprintf(str, "\n");

}


#ifdef notdef
OTErr
otPrintNoteToString(notep, rlog, str)
char *notep;
bool rlog;
char *str;
{
    char *tmp;
    char *startp, *nextp;
    OTErr errCode = OT_SUCCESS;

    str += strlen(str);
    if ( (tmp = startp = nextp = strdup(notep)) == NULL ) {
	otPutPostedMessage( OT_MALLOC_LOCATION, "otPrintNote()" );
	return OT_MALLOC_LOCATION;
    }

    while (nextp && *nextp) {
	startp = nextp;
	if ( nextp = strchr(startp, '\n') ) 
	    *nextp++ = 0;

	if (rlog) {
	    sprintf(str, "%s\n", startp);
	    str += strlen(str);
	}
	else {
	    if ( (strncmp(startp, "+HISTORY", 8)) || 
		 (strncmp(startp, "+0HISTORY", 9)) ) {
		sprintf(str, "%s\n", startp);
		str += strlen(str);
	    }
	}
    }
    free(tmp);
    return errCode;
}
#endif


OTErr
otGetIDindex(Filter, index)
OTMetaTemplate *Filter;
int *index;
{
    int i=-1;
    OTErr errCode = OT_SUCCESS;

/* Get TYPE_IDNUM field's index */

    for (i=0;  Filter[i].field[0];  i++)
	if (Filter[i].type == TYPE_IDNUM)
	    break;

    if (!Filter[i].field[0]) {
	otPutPostedMessage(OT_IDNUMFIELD_NOT_FOUND);
	errCode =  OT_IDNUMFIELD_NOT_FOUND;
    }

    if (i >= 0)
	*index = i;

    return errCode;
}



/* 
 * Get next number from filter_num list 
 *
 * Upon return: 
 *     next number from the list is placed into the "num"
 *     remaining list of CRs is copied into the "filter"
 *     "ind" indicator is set to "1" if this is the last number in the list
 */
void
otGetNextNum(filter, num, ind)
char * filter;
char * num;
int * ind;
{
    char * cp;

    strcpy(num, filter);

    if (cp = strchr(num, ',')) {
	*cp++ = 0;
	strcpy(filter,cp);
    }
    else {
	*ind = 1;
	filter[0] = 0;
    }

    DBUG_MIN((stderr, "otGetNextNum: num=%s  filter=%s  ind=%d\n", num, filter, *ind));
    return;
}



/* help messages */

static char *help_msg_1[] = {
  "usage: ot_bugs [option ...] [file]",
  "",
  "  -a <fname>    print entries using an alternate template def. file <fname>",
  "  -c            do not print column headings in a one-line/CR report",
  "  -d            print help details about field names and values",
  "  -e            print CR count (entire count)", 
  "  -f            print full text of selected CRs",
  "  -h            print this help message",
  "  -k <string>   print entries with string <string> in note text",
  "  -l <layout>   print using layout <layout>, where <layout> is a",
  "                comma-separated list of <field> names",
  "  -m            print metrics (count, summary)",
  "  -n <nums>     print CRs from the list of numbers, <nums>",
  "  -o <field>    order (sort) the output on field <field> for one-line/CR", 
  "                reports only",
  "  -p <project>  print entries matching project PROJ",
  "  -r            print OT HISTORY lines during full reports",
  "  -s <spec>     select fields that match the <spec>, where <spec> is a",
  "                comma-separated list of <field>=<value> pairs",
  "  -t            separate columns by tabs instead of spaces",
  "  -x <expr>     select fields with an expression - example: ",
  "                    -x '[stat open]'",
  "  -w <num>      print with width <num> (default 80)",
  "  -             read stdin instead of a project database's content",
  "",
  "please enter 'ot_bugs -d' for detailed help on <field> names and values",
  0
};

static char *help_msg_2[] = {
  "",
  "text is plain text",
  "mailname is an e-mail name",
  "mm/dd/yy is a date;  '>mm/dd/yy' means dates after date,",
  "                     '<mm/dd/yy' means dates before date,",
  "                     'mm/dd/yy-mm/dd/yy'  means range of dates.",
  "",
  0
};

/* otDoHelp - Print help messages. */
void
otDoHelp()
{
    register char ** s;

/* print general help message */

    s = help_msg_1;
    while (*s)
	puts(*s++);
    
    return;
}


/* otDoHelpDetails - print help details about field names and values */
void
otDoHelpDetails()
{
    OTProject   * proj;		/* project structure */
    OTMetaTemplate *Filter;
    register int i, k;
    register char * cp;
    register char ** s;
    char *lp, *pp;
    char value[NAMELEN];
    Tcl_Interp *interp;
    char  *helpMsg = 0;
    OTErr  err = OT_SUCCESS;

    interp = otCB->cb_pcb->pcb_interp;
    proj = otCB->cb_pcb->pcb_project;
    Filter = otCB->cb_qcb->qcb_filter;

    err = otTclEvalProc("detailHelpOverride");

    if (err == OT_SUCCESS && interp->result[0]) {
	printf("\n%s\n", interp->result);
	return;
    }
    else if (err == OT_TCL_NOPROC) {
	err = otTclEvalProc("detailHelpAdd");
	if (err == OT_SUCCESS && interp->result[0]) {
	    err = otCopyString( interp->result, &helpMsg);
	}
    }

    printf("\nThe following table shows legal <field> values for project '%s'\n",
		proj->name);
    printf("and legal values for each field's <value> (note that <field> is used in\n");
    printf("a -l <layout> option, and both <field> and <value> are used in a\n");
    printf("-s <spec> option):\n\n");
    printf("  <field>    <value>                    name of field\n");

    for (i=0;  Filter[i].field[0];  i++) {

      /* Display num, proj also for -l spec purposes */
	if (!strcmp(Filter[i].field, "!"))
	    continue;

	for (cp=Filter[i].opts, k=0;  *cp;  cp++)
	    if ((*cp != '[') && (*cp != ']') && (*cp != '(') &&
				(*cp != ')') && (*cp != '+'))
		if (*cp == ',')
		    value[k++] = '|';
		else
		    value[k++] = *cp;
	value[k] = 0;

	printf("  %-07s    %-025s  %s\n",
		    Filter[i].abbr, value, Filter[i].field);

	if ( pp = otGetEnumtypeList (value, proj) ) {
	    
	    lp = strdup(pp);
	    printf("    where %s is a typename representing one of the following strings: \n", value);
	    for( pp = strtok(lp, ","); pp ; pp = strtok(NULL, ",") ) {
		printf("\t%s\n", pp);
	    }
	    free(lp);
	}
    }

    printf("  %-07s    %-025s  %s\n", "nsens", "public|private",
	"Note Sensitivity Output Filter");

    printf("\nThe default layout is: '%s'\n", proj->default_layout);

    s = help_msg_2;
    while (*s)
	puts(*s++);

    if (helpMsg) {
	printf("\n%s\n", helpMsg);
	free(helpMsg);
	helpMsg = 0;
    }
}
