/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 


/*

 */

/*
 *	otDelete.c
 *
 */


#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <tcl.h>
#include <tclInt.h>
#include "ot.h"
#include "otInt.h"


#ifndef LINT
static char RCSid_otDelete[] =
    "$RCSfile: otDelete.c,v $ $Revision: 1.1.4.1 $ $Date: 1994/01/17 21:29:05 $";

#endif


/*
 *		List of functions defined in the otDelete.c
 *
 *	otDeleteObject()
 *
 *
 */


OTErr
otChkInputForDelete()
{
    long  topNumber;

    OTProject * proj = otCB->cb_pcb->pcb_project;
    OTErr errCode = OT_SUCCESS;

/* DELETE operation requires an object number */

    if (!otCB->cb_CRNumber)  {
	otPutPostedMessage(OT_DELETE_USAGE);
	return OT_DELETE_USAGE;
    }

/* Check that CR number is lower then the value from the "number" file */

    if (errCode = otReadTopNumber(proj, &topNumber))
	return errCode;

    if (otCB->cb_CRNumber >= topNumber) {
	otPutPostedMessage(OT_OBJECT_NOT_FOUND, proj->object_name, otCB->cb_CRNumber);
	return OT_OBJECT_NOT_FOUND;
    }
    
    return errCode;
}


OTErr
otDeleteObject()
{
    register char * result;
    OTFilen * fname;           /* filename */
    OTTemplate * tStruct; 	/* template structure to read CR into */
    char *cp;
    char *subject_line;
    char CRfile[PATHLEN];
    char tname[PATHLEN];
    char name[NAMELEN];
    char request[COMMAND];
    OTFilen tmpfile;

    OTErr errCode = OT_SUCCESS;
    OTProject * proj = otCB->cb_pcb->pcb_project;
    long CRNumber = otCB->cb_CRNumber;


/* Verify an input for conflicts */
    if (errCode = otChkInputForDelete())
	return errCode;


/* Form CR filename */

    fname = 0;
    if (errCode = otFormName(proj, CRNumber, &fname)) {
	if (fname)
	    free(fname);
	return errCode;
    }

    otCB->cb_ecb->ecb_fname = fname;
    sprintf(CRfile, "%s%s", fname->dir, fname->name);


/* Need to read CR into template structure for notification */

    if (errCode = otReadTemplateFromFilename(&tStruct, CRfile, TRUE, TRUE)) 
	return errCode;

    otCB->cb_ecb->ecb_tStruct = tStruct;

#ifdef notdef
/* Copy CR file into tmp area. Notification need to include whole CR after 
   CR itself is removed.  */

    if (errCode = otCopyTemplateFileToTmp(CRfile, tname))
	return errCode;
#endif

/* Form the delete operation request and send it to the server */

    if ((errCode = otDeleteCRFile()) == OT_OBJECT_DELETED) {
	errCode = OT_SUCCESS;
#ifdef notdef
	if (otCB->cb_pcb->pcb_ui == CLI) {
	    cp = otGetPostedMessage();
	    fprintf(stderr, "otDeleteObject: %s\n", cp);
	}
#endif
    }

#ifdef notdef
    if (!errCode) {

    /* Do notification, run otMakeSum */

        otFormFilen(&tmpfile, tname);

        sprintf(name, "deleted %s", proj->object_name);
        subject_line = otGetSubjectLine(NULL, tStruct, *fname, 
					otCB->cb_operation, proj);
        otNotify(proj, tStruct, tmpfile, *fname, otCB->cb_operation, 
    			otCB->cb_pcb->pcb_notify, name, subject_line);
    }
#endif

    return errCode;
}

OTErr otRequestDelete()
{
    int status;
    char *otDbpath;
    char prjCmd[LONGVALUE], deleteCmd[LONGVALUE];
    OTErr err;
    OTPrivateCB *pcp;
    OTProject *pjp;
    OTTemplate *ott_template;
    Tcl_Interp *interp;
    char *newCR;

    newCR = 0;
    pcp = otCB->cb_pcb;
    interp = pcp->pcb_interp;
    ott_template = otCB->cb_ecb->ecb_tStruct;

    if ( pjp = pcp->pcb_project ) {
	sprintf(prjCmd, "project set %s\n", pjp->name);

	if ( status = otRemoteTcl(prjCmd) ) {
	    otPutPostedMessage(OT_GENERAL_ERROR, interp->result);
	    return OT_GENERAL_ERROR;
	}
	DBUG_MIN((stderr, "sent >> %s\n", prjCmd));
    } else {
	otPutPostedMessage(OT_NEED_PROJECT);
	return OT_NEED_PROJECT;
    }

    sprintf(deleteCmd, "delete %ld\n", otCB->cb_CRNumber);
    if (status = otRemoteTcl(deleteCmd)) {
	otPutPostedMessage(OT_GENERAL_ERROR, interp->result);
	return OT_GENERAL_ERROR;
    }
    DBUG_MIN((stderr, "sent >> %s", deleteCmd));

    if (status = otRemoteTcl("tclString\n")) {
	otPutPostedMessage(OT_GENERAL_ERROR, interp->result);
	return OT_TCL_CALLER;
    } else {
        if ( otCopyString(interp->result, &newCR) ) {
	    otPutPostedMessage(OT_MALLOC_LOCATION,
		"otRequestInitiateUpdate()");
	    return OT_MALLOC_LOCATION;
	}

	DBUG_MIN((stderr, "received >> %s\n", newCR));

	err = otTclEval(newCR);
	free(newCR);
	if (err)
	    return err;
    }

    return OT_SUCCESS;

}
