#----dv-----------Menue zum waehlen einer Spalte als Skalierung der X-Achse---

#-----------------------------------------------------------------------------
# diagscxcolget {}  ermittelt den index des aktuell gewahlten Spaltentitels
#                   (call-back fuer den Ok-knopf in diagscxchoosemenu {})
#                  path : Pfad, in den das diagscxchoosemenu eingehaengt wurde
#                  dp   : Pfad des zugehoerigen Diagramms
#-----------------------------------------------------------------------------
#
proc diagscxcolget {path dp} {
 
  # Statusvariablen und Diagrammvariablen sichtbar machen
  #
  global status diagdata
 
  # Index des aktuell gewaehlten Spaltentitels ermitteln
  #
  set colind [$path.choose.frame.listbox curselection]
   
  if {$colind != ""} {

     # Spaltentitel gewaehlt => index abspeichern
     #
     set diagdata($dp.scxcolind) $colind 

     # Spaltentitelindex auf checkbutton im diagprefacemenue sichtbar machen
     #
     $path.colx.switch config -text "ScalesX from Column \
                       #$status($dp.scxcolindbuffer)" 
   } 
}

#-----------------------------------------------------------------------------
# diagscxchoosemenu {} erzeugt Listbox zur Auswahl einer Spalte des gewaehlten 
#                  Datensatzes
#                  path : Pfad, in den die Auswahlbox eingehaengt wird
#                  dp   : Pfad des Diagramms
#                  head : Kopfzeile, die in der Listbox erscheint
#                  cmd  : Kommandos, die auf "OK-gedrueckt" ausgefuehrt werden
#-----------------------------------------------------------------------------
#
proc diagscxchoosemenu {path dp head cmd} {

  # falls toplevel schon existiert, Fenster hervorheben
  #
  if {[winfo exist $path.choose]} {
      myraise $path.choose noclear
      return
  }
  # Diagrammvariablen und Statusvariablen sichtbar machen
  #
  global diagdata status

  # toplevel, in das die Listbox eingehaengt wird erzeugen
  #
  toplevel $path.choose

  # Bitmap fuer icon setzen
  #
  global env
  wm iconbitmap $path.choose @$env(DV_HOME)/bitmaps/statist.xbm
  wm iconname   $path.choose "Choose"

  # alten Focus sichern und focus auf auf dieses Toplevelfenster 
  #
  savefocus
  focus $path.choose

  # Groesse des Toplevels und Position initialisieren
  #
  wm geometry $path.choose 200x300
 
  # minimale Groesse festlegen und damit Fenstergroesse veraenderbar machen
  #
  wm minsize $path.choose 100 100
 
  # Titel setzen
  #
  wm title $path.choose \
      "[string toupper $diagdata($dp.frametitle)] Column Select Box" 

  # Label setzen
  #
  label $path.choose.heading -text $head 
  pack $path.choose.heading  -fill x

  # Frame fuer Listbox und Scrollbar erzeugen
  #
  frame $path.choose.frame -relief raised
  pack $path.choose.frame -fill both -expand true

   # vertikale Skrollbar erzeugen
   #
   scrollbar $path.choose.frame.scroll \
             -command "$path.choose.frame.listbox yview"
   pack $path.choose.frame.scroll -side left -fill y

   # Listbox erzeugen 
   #
   listbox $path.choose.frame.listbox -yscroll "$path.choose.frame.scroll set"\
           -geometry 1x1
   pack $path.choose.frame.listbox -side left -expand true -fill both 

   # Bindings fuer "nur einzelne Eintraege auswaehlen" setzen 
   #
   tk_listboxSingleSelect $path.choose.frame.listbox

   # definiere Refreshroutine fuer dieses Fenster
   #
   proc $path.choose.refresh {path dp} {

     # Diagrammvariablen und Statusvariablen sichtbar machen
     #
     global diagdata status

     $path.frame.listbox delete 0 end

     # aktuelle Spaltentitel setzen
     #
     loop i 0 $diagdata($dp.colnum) {
        $path.frame.listbox insert end $diagdata($dp.coltitle$i)
     }

     # aktuell gewaehlten Titel moeglichst ans untere Ende der Listbox
     #
     update
     set pre [$path.frame.scroll get]
     set windowunits [lindex $pre 1]
     $path.frame.listbox yview\
        [expr $status($dp.scxcolindbuffer)-$windowunits+3]

     # aktuell gewaehlten Titel selectieren
     #
     $path.frame.listbox select from $status($dp.scxcolindbuffer)
   } ; # end refresh

  # Fensterinhalt initialisieren
  #
  $path.choose.refresh $path.choose $dp

  # Auswahl auch per Doppelklick ermoeglichen
  #
  bind $path.choose.frame.listbox <Double-Button-1> \
       "$path.choose.switch.ok invoke"
 
  # Return-Taste wie Ok-Knopf Bestaetigung
  #
  bind $path.choose <Return> "$path.choose.switch.ok invoke"
 
  # Frame fuer Ok, update, Abbruch-Knopf realisieren
  #
  frame $path.choose.switch
  pack $path.choose.switch -fill x
 
   # Ok-Knopf realisieren
   #
   button $path.choose.switch.ok -text "OK" -command \
          "eval $cmd; destroy $path.choose;
           busy {refreshwindows $dp .; setoldfocus}"
   pack $path.choose.switch.ok -side left -padx 5 -pady 5 -expand true \
        -fill both

   # update-Knopf realisieren
   #
   button $path.choose.switch.update -text "update" \
          -command "busy {eval $cmd; refreshwindows $dp .}"
   pack $path.choose.switch.update -side left -padx 5 -pady 5 -expand true \
          -fill both
 
   # Cancel-Knopf realisieren
   #
   button $path.choose.switch.cancel  -text "Cancel" \
          -command "destroy $path.choose; setoldfocus"
   pack $path.choose.switch.cancel -side left -padx 5 -pady 5 -expand true \
        -fill both
}
