## parse_args.tcl - Parse command line arguments
## ==============
## Copyright (C) 1992-1993
## Globewide Network Academy
## Macvicar Institute for Educational Software Development
##
## See the file COPYRIGHT for conditions

set tkW3ParseArgsShowInfo 1

## tkW3ParseArgs: Parse arguments
## ----------
## On entry,
##   argv: command line to parse
## On exit,
##   none
## Side effects,
##   Resets various internal variables 

proc tkW3ParseArgs {argv} {
   global tkW3ConfigStartPage tkW3ConfigHomePage tkW3ConfigFile
   global tkW3ParseArgsImages tkW3ParseArgsShowInfo

   set tkW3ParseArgsImages(anchor) ""
   set tkW3ParseArgsImages(ismap) 0

   set argc [llength $argv]
   set iconic 0
   for {set i 0} {$i < $argc} { incr i 1} {
       set flag [string tolower [lindex $argv $i]]
      case  $flag in {
        {-wwwhome} {
            incr i
            if {$i < $argc} {
               set tkW3ConfigHomePage [lindex $argv $i]
            }
        }
        {-wwwstart} {
            incr i
            if {$i < $argc} {
               set tkW3ConfigStartPage [lindex $argv $i]
            }
        }
	{-wwwnoinfo} {
	    set tkW3ParseArgsShowInfo 0
	}
	{-wwwiconic} {
	    wm iconify .
	}
	{-wwwiconpos} {
	    incr i
	    if {$i < $argc} {
		set x [lindex $argv $i]
		incr i
		wm iconpos . $x [lindex $argv $i]
	    }
	}
	{-wwwgeometry} {
	    incr i
            if {$i < $argc} {
		wm geometry . [lindex $argv $i]
	   }
	}
	{-wwwimageanc} {
	    incr i
	    if {$i < $argc} {
		set tkW3ParseArgsImages(anchor) [lindex $argv $i]
	    }
	}
	{-wwwimageismap} {
	    set tkW3ParseArgsImages(ismap) 1
	}
        {-help} {
            puts stdout "\
Arguments:
   -wwwhome = Set the home page
   -wwwstart = Set the start page
   -wwwconfig = specify alternative config file
   -wwwnoinfo = Start up tkWWW without showing the info window
   -wwwiconic = Start up tkWWW in iconic mode
   -wwwiconpos x y = Set tkWWW icon position
   -wwwgeometry = Set tkWWW geometry
"
            exit
        }
	{-wwwconfig} {
           incr i
           if {$i < $argc} {
               set tkW3ConfigFile [lindex $argv $i]
           }
       }
	{-*} {
	    puts stdout "tkWWW Warning: Unknown command line flag $flag
Type \"tkWWW -help\" for valid flags"
	}
        {default} {
	    set tkW3ConfigStartPage [lindex $argv $i]
       }
    }
  }
}
