


connect(1)               USER COMMANDS                 connect(1)



_________________________________________________________________

NAME
     connect,   shutdown,   accept,   send,   receive,    sendTo,
     receiveFrom, packetSend, packetReceive
       - Tcl-DP network connection management commands
_________________________________________________________________

DESCRIPTION
     Several Tcl/Tk commands for managing basic  network  connec-
     tions  are  described  in this man page.  These commands are
     part of the Tcl-DP (Tcl Distributed  Programming)  extension
     to Tcl/Tk and provide basically the same level of service to
     Tcl/Tk as the UNIX C socket(2) related system calls.

     These connection management  commands  return  and  take  as
     arguments identifiers called _f_i_l_e_I_d's.  (A _f_i_l_e_I_d represents
     a UNIX file  descriptor.   UNIX  uses  file  descriptors  to
     represent  both open files and open sockets.  A socket is an
     endpoint of  network  communication.)   These  _f_i_l_e_I_d's  are
     identical  to the identifiers manipulated by the open, read,
     write, gets, puts, and close  file  management  commands  of
     Tcl.

COMMANDS
     connect _h_o_s_t _p_o_r_t

          This command creates a TCP  protocol  INET  socket  and
          connects  it  to  a  remote server process.  The remote
          server process should be running on the  machine  given
          by the _h_o_s_t network address and should be listening for
          and accepting client  connections  on  the  given  _p_o_r_t
          number.   This  command returns a list of two values: a
          _f_i_l_e_I_d to represent the created, connected  socket  and
          the port number used for the connection.

     connect -_s_e_r_v_e_r _h_o_s_t _p_o_r_t

          If the -_s_e_r_v_e_r flag is specified to  the  connect  com-
          mand,  then  a  listening  (server)  socket is created.
          This listening socket will listen  for  client  connec-
          tions  on  the  specified  _p_o_r_t  number.  The listening
          socket will become readable whenever a  client  process
          attempts  a  connection.   The creator of the listening
          socket may then accept the client connection.  (See the
          accept  command  below.   Also see filehandler man page
          for testing when a socket becomes readable.)

          The _p_o_r_t number argument must be an unused port number.
          If  the _p_o_r_t number argument is empty or 0, the connect
          command  will  automatically  select  an  unused   port
          number.



Sun Release 4.1           Last change:                          1






connect(1)               USER COMMANDS                 connect(1)



          If the _h_o_s_t argument  is  an  empty  string,  then  any
          client  process may attempt to connect to the listening
          socket.   Otherwise,  only  processes  running  on  the
          machine  with  the  _h_o_s_t network address may attempt to
          connect to listening socket.

          This connect command with the -_s_e_r_v_e_r  flag  returns  a
          list of two values.  The first value is the _f_i_l_e_I_d that
          represents the created listening  socket.   The  second
          value  is  the port number that the socket is listening
          to.

     connect -_s_e_r_v_e_r _p_a_t_h

          This command creates up a UNIX domain listening socket.
          This  command is identical to the one above except that
          a UNIX domain socket is created using an address speci-
          fied by _p_a_t_h.

     connect -_u_d_p _p_o_r_t

          If the -_u_d_p flag is specified, then the connect command
          creates  a  UDP  protocol INET socket (a connectionless
          socket).  Since this socket is connectionless, only the
          sendTo  and receiveFrom commands described below may be
          used with this socket to transmit and receive data.

          If the _p_o_r_t argument is empty or 0, the connect command
          will  select  an unused port number for you.  This com-
          mand  returns  a  list  containing   a   _f_i_l_e_I_d   (that
          represents  the  created  socket)  and  the _p_o_r_t number
          (where the socket will receive and transmit data  using
          the UDP protocol).

     accept _f_i_l_e_I_d

          The _f_i_l_e_I_d argument must represent a listening (server)
          socket  (e.g., a _f_i_l_e_I_d returned by the connect command
          that was  called  with  the  -_s_e_r_v_e_r  flag).   If  this
          listening socket is readable (i.e., a client process is
          attempting to connect), the accept  command  creates  a
          new socket that is connected to the client process.  If
          the listening socket is not readable, th accept command
          will  block  until a client process attempts to connect
          to  the  listening  socket.    The   listening   socket
          (represented  by  the  _f_i_l_e_I_d  argument)  will remain a
          listening socket.  This command returns a new _f_i_l_e_I_d to
          represent the newly created socket that is connected to
          the accepted client process.

     send _f_i_l_e_I_d _m_e_s_s_a_g_e




Sun Release 4.1           Last change:                          2






connect(1)               USER COMMANDS                 connect(1)



          Sends the string _m_e_s_s_a_g_e through the socket (_f_i_l_e_I_d) to
          the  connected,  remote  process.  This command is pre-
          ferred to Tcl puts command for sending messages through
          network connections because it is optimized for network
          operations.  If more than one _m_e_s_s_a_g_e  is  sent  before
          the  receiver  process  can  process  (using receive or
          gets) the first sent message,  the  boundaries  between
          messages  is  lost.   If  this  is undesirable, use the
          packetSend and packetReceive commands, instead  of  the
          send and receive commands.  It is recommended that send
          and packetSend not be both  used  on  the  same  _f_i_l_e_I_d
          channel.

     receive _f_i_l_e_I_d

          Receives a message from the socket (_f_i_l_e_I_d)  which  was
          sent from connected, remote process which used the send
          command.  The message received  is  returned.   If  the
          socket is not readable, this command will block.  It is
          recommended that gets and puts not be mixed  with  send
          and receive on the same _f_i_l_e_I_d channel.

     sendTo _f_i_l_e_I_d _m_e_s_s_a_g_e _a_d_d_r

          Sends the string _m_e_s_s_a_g_e to the process at the destina-
          tion  address  specified  by the _a_d_d_r handle.  The _a_d_d_r
          handle must be created using  the  address  command  or
          taken from the return value of the receiveFrom command.
          The _f_i_l_e_I_d argument  must  represent  a  connectionless
          socket  (i.e.,  created using the connect command using
          the -_u_d_p option).  The sendTo command uses the  connec-
          tionless socket, _f_i_l_e_I_d, as the transmitting socket.

     receiveFrom _f_i_l_e_I_d

          Receives a message that was sent from  another  process
          that  used the sendTo command.  A list of two values is
          returned.  The first element is the  address  (an  _a_d_d_r
          handle)  of the sending process, and the second element
          is the message received.  If the socket  is  not  read-
          able,  this  command  will  block.  The _f_i_l_e_I_d argument
          must represent a connectionless socket  (i.e.,  created
          using  the connect command using the -_u_d_p option).  The
          receiveFrom command  uses  the  connectionless  socket,
          _f_i_l_e_I_d, as the reception socket.

     packetSend _f_i_l_e_I_d _m_e_s_s_a_g_e

          Sends the string _m_e_s_s_a_g_e through the socket (_f_i_l_e_I_d) to
          the connected, remote process.  This command is similar
          to send, except that message boundaries  are  preserved
          when  received  at  the  far end with the packetReceive



Sun Release 4.1           Last change:                          3






connect(1)               USER COMMANDS                 connect(1)



          command.  It is recommended that  send  and  packetSend
          not be both used on the same channel.

     packetReceive _f_i_l_e_I_d ?-_n_o_b_l_o_c_k?

          Receives  a  single   message   from   the   connection
          (represented  by  the  _f_i_l_e_I_d).   The connected, remote
          process which sent the message must use the  packetSend
          command.   Message  boundaries  are preserved when more
          than one message is in  the  receive  buffer.   If  the
          argument  -_n_o_b_l_o_c_k  is  supplied,  the  receive is done
          without blocking.  The message received in is returned.
          It is recommended that receive and packetReceive not be
          both used on the same channel.

     shutdown _f_i_l_e_I_d _c_o_d_e

          Shutdown a socket for reading, writing, or both.   This
          command  is not the same as close, which you should use
          for truly closing the socket.  The _f_i_l_e_I_d argument must
          represent  a  file descriptor that represents a socket,
          not an open file.

          If _c_o_d_e is  "0",  "read"  or  "receives"  then  further
          reception of data from _f_i_l_e_I_d will be disabled.

          If _c_o_d_e is "1", "write" or "sends", then further  send-
          ing  of  data using _f_i_l_e_I_d will be disabled (and an EOF
          will be automatically sent down the socket).

          If _c_o_d_e is "2", "all" or "both", then further reception
          and sending of data on _f_i_l_e_I_d will be disabled.

          As a side effect, the appropriate  filehandlers  previ-
          ously  installed  on  the _f_i_l_e_I_d will be deleted.  (See
          the filehandler man page.)

SEE ALSO
     Tcl-DP,   socket(2),   accept(2),   connect(2),   listen(2),
     address(l), Tcl, filehandler(l)

AUTHOR
     Pekka Nikander, Telecom Finland (Pekka.Nikander@ajk.tele.fi)
     Extended by Tim MacKenzie (tym@dibbler.cs.monash.edu.au)
     Further enhancements by Brian Smith (bsmith@cs.berkeley.edu)
     and Steve Yen (syen@cs.berkeley.edu)









Sun Release 4.1           Last change:                          4



